/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.controller;

import com.geoway.drone.controller.base.Result;
import com.geoway.drone.controller.base.ResultGenerator;
import com.geoway.drone.model.dto.DroneDto;
import com.geoway.drone.model.dto.UserInfo;
import com.geoway.drone.model.entity.AppServer;
import com.geoway.drone.model.entity.DroneInfo;
import com.geoway.drone.serface.AppConfigService;
import com.geoway.drone.serface.AppPermissionService;
import com.geoway.drone.serface.AppServerService;
import com.geoway.drone.serface.DroneInfoService;
import com.geoway.drone.serface.ThirdService;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/third"})
public class ThirdController {
    @Autowired
    AppServerService appServerService;
    @Autowired
    AppConfigService appConfigService;
    @Autowired
    AppPermissionService appPermissionService;
    @Autowired
    DroneInfoService droneService;
    @Autowired
    ThirdService thirdService;

    @PostMapping(value={"/login"})
    public Result login(@RequestParam(value="username") String username, @RequestParam(value="password") String password, HttpServletRequest request) throws Exception {
        UserInfo userInfo = this.thirdService.login(username, password);
        return ResultGenerator.genSuccessResult(userInfo);
    }

    @PostMapping(value={"/verifyToken"})
    public Result verifyToken(@RequestParam(value="token") String token, HttpServletRequest request) throws Exception {
        UserInfo userInfo = this.thirdService.verifyToken(token);
        return ResultGenerator.genSuccessResult(userInfo);
    }

    @PostMapping(value={"/loginByPhone.action"})
    public Result loginByPhone(String phone, String verifyCode, String appKey) throws Exception {
        UserInfo userInfo = this.thirdService.loginByPhone(phone, verifyCode);
        return ResultGenerator.genSuccessResult(userInfo);
    }

    @PostMapping(value={"/sendSms.do"})
    public Result sendSms(HttpServletRequest request, String phone) throws IOException {
        boolean suc = this.thirdService.sendSms(phone);
        if (suc) {
            return ResultGenerator.genSuccessResult();
        }
        return ResultGenerator.genFailResult("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25");
    }

    @PostMapping(value={"/register"})
    public Result register(@RequestParam(value="appkey") String appkey, @RequestParam(value="model") String model, @RequestParam(value="sn") String sn, @RequestParam(value="username") String username, @RequestParam(value="userid") String userid, @RequestParam(value="rname", required=false) String rname, @RequestParam(value="phone", required=false) String phone, @RequestParam(value="company", required=false) String company, HttpServletRequest request) {
        DroneDto drone = new DroneDto();
        drone.setCompany(company);
        drone.setModelnum(model);
        drone.setSn(sn);
        drone.setState(Integer.valueOf(1));
        drone.setAppkey(appkey);
        drone.setUserid(userid);
        drone.setUsername(username);
        drone.setRname(rname);
        drone.setPhone(phone);
        drone.setDeviceName(model);
        drone.setDeviceCom(model);
        DroneDto drone1 = this.droneService.addOne(drone);
        if (drone1 == null) {
            return ResultGenerator.genFailResult("\u6ce8\u518c\u5931\u8d25");
        }
        return ResultGenerator.genSuccessResult(drone1);
    }

    @PostMapping(value={"/isreg"})
    public Result isreg(@RequestParam(value="sn") String sn, HttpServletRequest request) {
        DroneInfo droneBySn = this.droneService.getDroneBySn(sn);
        if (droneBySn == null) {
            return ResultGenerator.genSuccessResult();
        }
        return ResultGenerator.genSuccessResult(droneBySn);
    }

    @PostMapping(value={"/hasPermission"})
    public Result hasPermission(@RequestParam(value="appkey") String appkey, @RequestParam(value="appkeySub") String appkeySub, @RequestParam(value="token") String token, HttpServletRequest request) {
        List allowList = this.appPermissionService.getAllowList(appkey, appkeySub);
        if (allowList == null || allowList.isEmpty()) {
            return ResultGenerator.genFailResult("\u65e0\u6743\u9650");
        }
        return ResultGenerator.genSuccessResult();
    }

    @GetMapping(value={"/getWatermark"}, produces={"image/jpeg"})
    @ResponseBody
    public Object GetPhoto(@RequestParam(value="appkey") String appkey) {
        Object getPhoto = this.appServerService.getPhoto(appkey);
        if (getPhoto == null) {
            return null;
        }
        return getPhoto;
    }

    @GetMapping(value={"/getConfig"})
    @ResponseBody
    public String getConfig(@RequestParam(value="appkey") String appkey) {
        AppServer server = this.appServerService.getServer(appkey);
        return server != null ? server.getConfig() : "";
    }

    @PostMapping(value={"/getServerUrl"})
    public Result getServerUrl(@RequestParam(value="appkey") String appkey, HttpServletRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)appkey)) {
            return ResultGenerator.genFailResult("appkey\u4e3a\u7a7a");
        }
        AppServer appServer = this.appServerService.getServer(appkey);
        return ResultGenerator.genSuccessResult(appServer);
    }

    @PostMapping(value={"/getAppNames"})
    public Result getNames(@RequestParam(value="appkeys") String appkeys, HttpServletRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)appkeys)) {
            return ResultGenerator.genFailResult("appkey\u4e3a\u7a7a");
        }
        List<String> appkeyList = Arrays.asList(appkeys.split(","));
        List mapList = this.appServerService.selectNameByAppkeys(appkeyList);
        return ResultGenerator.genSuccessResult(mapList);
    }
}

