/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.controller;

import com.geoway.drone.model.base.PageResultContent;
import com.geoway.drone.model.dto.DroneDto;
import com.geoway.drone.model.entity.DroneApp;
import com.geoway.drone.model.entity.DroneUser;
import com.geoway.drone.serface.DroneInfoService;
import com.gw.base.data.result.GiResult;
import java.text.ParseException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dronecenter/drone"})
public class DroneController {
    @Autowired
    private DroneInfoService droneService;

    @GetMapping(value={"/listByPageWithUser"})
    public GiResult<?> listByPageWithUser(@RequestParam(name="appkey", required=false) String appkey, @RequestParam(name="sn", required=false) String sn, @RequestParam(name="state", required=false) Integer state, @RequestParam(name="online", required=false) Integer online, @RequestParam(value="page") Integer page, @RequestParam(value="rows") Integer rows) {
        PageResultContent pageResultContent = this.droneService.listByPageWithUser(appkey, sn, state, online, page, rows);
        return GiResult.successValue((Object)pageResultContent);
    }

    @GetMapping(value={"/listByPage"})
    public GiResult<?> listByPage(@RequestParam(name="appkey", required=false) String appkey, @RequestParam(name="sn", required=false) String sn, @RequestParam(name="state", required=false) Integer state, @RequestParam(name="online", required=false) Integer online, @RequestParam(value="page") Integer page, @RequestParam(value="rows") Integer rows) {
        PageResultContent pageResultContent = this.droneService.listByPage(appkey, sn, state, online, page, rows);
        return GiResult.successValue((Object)pageResultContent);
    }

    @GetMapping(value={"/getDroneLocation"})
    public GiResult<?> getDroneLocation(@RequestBody List<String> sns) {
        List tracks = this.droneService.getDroneLocation(sns);
        return GiResult.successValue((Object)tracks);
    }

    @PostMapping(value={"/update"})
    public GiResult<?> update(@RequestBody DroneDto drone) {
        this.droneService.update(drone);
        return GiResult.success();
    }

    @PostMapping(value={"/save"})
    public GiResult<?> insert(@RequestBody DroneDto drone) {
        this.droneService.addOne(drone);
        return GiResult.success();
    }

    @PostMapping(value={"/setDroneApp"})
    public GiResult<?> setDroneApp(@ModelAttribute DroneApp drone) {
        this.droneService.setDroneApp(drone);
        return GiResult.success();
    }

    @PostMapping(value={"/deleteDroneApp"})
    public GiResult<?> deleteDroneApp(@ModelAttribute DroneApp drone) {
        this.droneService.deleteDroneApp(drone);
        return GiResult.success();
    }

    @PostMapping(value={"/setDroneUser"})
    public GiResult<?> setDroneUser(@ModelAttribute DroneUser drone) {
        this.droneService.setDroneUser(drone);
        return GiResult.success();
    }

    @PostMapping(value={"/deleteDroneUser"})
    public GiResult<?> deleteDroneUser(@ModelAttribute DroneUser drone) {
        this.droneService.deleteDroneUser(drone);
        return GiResult.success();
    }

    @RequestMapping(value={"/getLiveUrl"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GiResult<?> getLiveUrl(HttpServletRequest request, @RequestParam(value="sn", required=true) String sn, @RequestParam(value="appkey", required=false) String appkey) {
        return GiResult.successValue((Object)this.droneService.getLiveUrl(sn, appkey));
    }

    @RequestMapping(value={"/getNearDrone"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GiResult<?> getNearDrone(HttpServletRequest request, @RequestParam(value="lon", required=true) Double lon, @RequestParam(value="lat", required=true) Double lat, @RequestParam(value="distance", required=true) Double distance, @RequestParam(value="appkey", required=false) String appkey) throws ParseException {
        return GiResult.successValue((Object)this.droneService.getNearDrone(appkey, lon, lat, distance));
    }

    @RequestMapping(value={"/getDroneOnOff"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GiResult<?> getDroneOnOff(HttpServletRequest request, @RequestParam(value="appkey", required=false) String appkey) throws ParseException {
        return GiResult.successValue((Object)this.droneService.getDroneOnOff(appkey));
    }
}

