/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.controller.job.schedule;

import com.geoway.drone.serface.DroneInfoService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@ConditionalOnProperty(prefix="scheduleTask.DroneOnline", name={"enable"}, havingValue="true")
public class ScheduleDroneOnline {
    GiLoger loger = GwLoger.getLoger(ScheduleDroneOnline.class);
    @Resource
    RedisTemplate redisTemplate;
    @Autowired
    DroneInfoService droneService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="${scheduleTask.DroneOnline.cron:* * * * * ?}")
    private void run() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Boolean notExist = this.redisTemplate.opsForHash().putIfAbsent((Object)"drone_project", (Object)"drone_project_online", (Object)true);
        if (notExist.booleanValue()) {
            try {
                this.loger.info("JobRunTask-DroneOnline:" + df.format(new Date()), new Object[0]);
                this.droneService.setDroneOnline();
            }
            catch (Exception ex) {
                try {
                    this.loger.error("JobRunTask-DroneOnline:" + ex.getMessage(), new Object[0]);
                }
                catch (Throwable throwable) {
                    this.redisTemplate.opsForHash().delete((Object)"drone_project", new Object[]{"drone_project_online"});
                    throw throwable;
                }
                this.redisTemplate.opsForHash().delete((Object)"drone_project", new Object[]{"drone_project_online"});
            }
            this.redisTemplate.opsForHash().delete((Object)"drone_project", new Object[]{"drone_project_online"});
        }
    }
}

