/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.api.action.dataset;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.datum.ThumbDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.imagedb.dataset.dto.query.CoverageAnalyseFilterDTO;
import com.geoway.imagedb.dataset.dto.query.CoverageAnalyseResultDTO;
import com.geoway.imagedb.dataset.dto.query.FileDataDownloadCheckResultDTO;
import com.geoway.imagedb.dataset.dto.query.ImageExportFilterDTO;
import com.geoway.imagedb.dataset.dto.query.ImageQueryDataIdFilterDTO;
import com.geoway.imagedb.dataset.dto.query.ImageQueryFilterDTO;
import com.geoway.imagedb.dataset.dto.query.ImageQueryResult;
import com.geoway.imagedb.dataset.dto.query.ImageRangeDTO;
import com.geoway.imagedb.dataset.dto.query.ImageSampleQueryFilterDTO;
import com.geoway.imagedb.dataset.service.ImageQueryService;
import com.geoway.imagedb.dataset.service.ImageSampleQueryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/browse/query"})
@Api(tags={"03.01-\u5f71\u50cf\u67e5\u8be2"})
public class ImageQueryController {
    @Resource
    private ImageQueryService imageQueryService;
    @Resource
    private ImageSampleQueryService imageSampleQueryService;

    @ApiOperation(value="01-\u5f71\u50cf\u67e5\u8be2(\u5206\u9875\u67e5\u8be2)")
    @PostMapping(value={"/image"})
    public Response<ImageQueryResult> query(@RequestBody ImageQueryFilterDTO filterDTO) {
        if (filterDTO.getClassifyArray() != null && filterDTO.getClassifyArray().size() > 0) {
            for (int i = 0; i < filterDTO.getClassifyArray().size(); ++i) {
                filterDTO.getClassifyArray().set(i, ((String)filterDTO.getClassifyArray().get(i)).replace("/", "_"));
            }
        }
        return Response.ok((Object)this.imageQueryService.queryByGeometry(filterDTO));
    }

    @ApiOperation(value="01.01-\u5f71\u50cf\u67e5\u8be2(\u5168\u90e8\u8303\u56f4\u7684dataId)")
    @PostMapping(value={"/image/range"})
    public Response<ImageRangeDTO> queryDataIds(@RequestBody ImageQueryFilterDTO filterDTO) {
        if (filterDTO.getClassifyArray() != null && filterDTO.getClassifyArray().size() > 0) {
            for (int i = 0; i < filterDTO.getClassifyArray().size(); ++i) {
                filterDTO.getClassifyArray().set(i, ((String)filterDTO.getClassifyArray().get(i)).replace("/", "_"));
            }
        }
        return Response.ok((Object)this.imageQueryService.queryDataIds(filterDTO));
    }

    @ApiOperation(value="01.02-\u5f71\u50cf\u67e5\u8be2(\u5f71\u50cf\u6570\u636e\u6e05\u5355)")
    @PostMapping(value={"/image/by/ids"})
    public Response<ImageQueryResult> query(@RequestBody ImageQueryDataIdFilterDTO filterDTO) {
        return Response.ok((Object)this.imageQueryService.queryByDataIds(filterDTO.getDataIdArray(), filterDTO.getThumbSize()));
    }

    @ApiOperation(value="01.03-\u6570\u636e\u540d\u79f0\u6587\u4ef6\u67e5\u8be2\u5f71\u50cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="imageType", value="\u5f71\u50cf\u7c7b\u578b\uff0c11-\u539f\u59cb\u5f71\u50cf\uff0c21-\u6210\u679c\u5f71\u50cf", required=true, paramType="query"), @ApiImplicitParam(name="file", value="\u6570\u636e\u540d\u79f0\u6587\u4ef6(.xls,.xlsx,.txt)", required=true, dataTypeClass=MultipartFile.class), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", example="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", example="10"), @ApiImplicitParam(name="thumbSize", value="\u7f29\u7565\u56fe\u5c3a\u5bf8(64/128/256)", example="64")})
    @UploadFileCheck(supportedSuffixes={".xls", ".xlsx", ".txt"})
    @PostMapping(value={"/image/by/name"})
    public Response<ImageQueryResult> queryByName(@RequestParam Integer imageType, @RequestPart MultipartFile file, @RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false, defaultValue="64") Integer thumbSize) {
        return Response.ok((Object)this.imageQueryService.queryByName(imageType, file, pageIndex, rows, thumbSize));
    }

    @ApiOperation(value="01.04-\u6570\u636e\u540d\u79f0\u6587\u4ef6\u67e5\u8be2\u5f71\u50cf(\u5168\u90e8\u8303\u56f4\u7684dataId)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="imageType", value="\u5f71\u50cf\u7c7b\u578b\uff0c11-\u539f\u59cb\u5f71\u50cf\uff0c21-\u6210\u679c\u5f71\u50cf", required=true, paramType="query"), @ApiImplicitParam(name="file", value="\u6570\u636e\u540d\u79f0\u6587\u4ef6(.xls,.xlsx,.txt)", required=true, dataTypeClass=MultipartFile.class)})
    @UploadFileCheck(supportedSuffixes={".xls", ".xlsx", ".txt"})
    @PostMapping(value={"/image/range/by/name"})
    public Response<ImageRangeDTO> queryDataIdsByName(@RequestParam Integer imageType, @RequestPart MultipartFile file) {
        return Response.ok((Object)this.imageQueryService.queryDataIdsByName(imageType, file));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5f71\u50cf\u7f29\u7565\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataIdArray", value="dataId\u6570\u7ec4", paramType="query"), @ApiImplicitParam(name="size", value="\u5c3a\u5bf8(64/128/256)", paramType="query")})
    @GetMapping(value={"/image/thumb"})
    public Response<List<ThumbDTO>> queryThumb(@RequestParam List<String> dataIdArray, @RequestParam Integer size) {
        return Response.ok((Object)this.imageQueryService.queryThumb(dataIdArray, size));
    }

    @ApiOperation(value="03-\u67e5\u8be2\u5f71\u50cf\u8be6\u60c5(\u6307\u5b9a\u7f29\u7565\u56fe\u5c3a\u5bf8\u7684\u5c5e\u6027\u8868)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasetId", value="\u6570\u636e\u96c6\u6807\u8bc6", paramType="query"), @ApiImplicitParam(name="dataId", value="dataId", paramType="query"), @ApiImplicitParam(name="size", value="\u5c3a\u5bf8(64/128/256)", paramType="query")})
    @GetMapping(value={"/image/detail"})
    public Response<DataQueryResult> imageDetail(@RequestParam String datasetId, @RequestParam String dataId, @RequestParam Integer size) {
        return Response.ok((Object)this.imageQueryService.imageDetail(datasetId, dataId, size));
    }

    @ApiOperation(value="04-\u8986\u76d6\u5206\u6790")
    @PostMapping(value={"/image/coverage/analyse"})
    public Response<CoverageAnalyseResultDTO> coverageAnalyse(@RequestBody ImageQueryFilterDTO filterDTO) {
        if (filterDTO.getClassifyArray() != null && filterDTO.getClassifyArray().size() > 0) {
            for (int i = 0; i < filterDTO.getClassifyArray().size(); ++i) {
                filterDTO.getClassifyArray().set(i, ((String)filterDTO.getClassifyArray().get(i)).replace("/", "_"));
            }
        }
        return Response.ok((Object)this.imageQueryService.coverageAnalyse(filterDTO));
    }

    @ApiOperation(value="04.01-\u8986\u76d6\u5206\u6790(dataId\u6570\u7ec4)")
    @PostMapping(value={"/image/coverage/analyse/by/ids"})
    public Response<CoverageAnalyseResultDTO> coverageAnalyseByDataIds(@RequestBody CoverageAnalyseFilterDTO filterDTO) {
        return Response.ok((Object)this.imageQueryService.coverageAnalyseByDataIds(filterDTO));
    }

    @ApiOperation(value="05-\u5bfc\u51fa\u8986\u76d6\u8303\u56f4", notes="\u5bfc\u51fa\u672a\u8986\u76d6\u8303\u56f4\u65f6intersectionBoundary\u4e3a\u7a7a")
    @PostMapping(value={"/image/coverage/analyse/export"})
    public void exportCoverageRange(@RequestBody CoverageAnalyseResultDTO resultDTO) {
        this.imageQueryService.exportCoverageRange(resultDTO);
    }

    @ApiOperation(value="06-\u5bfc\u51fa\u8bb8\u53ef")
    @PostMapping(value={"/image/export/permit"})
    public Response<String> exportImagePermit(@RequestBody ImageExportFilterDTO filterDTO) {
        return Response.ok((Object)this.imageQueryService.exportImagePermit(filterDTO));
    }

    @ApiOperation(value="06.01-\u5bfc\u51fa")
    @GetMapping(value={"/image/export"})
    public void exportImage(@RequestParam String permit) {
        this.imageQueryService.exportImageByPermit(permit);
    }

    @ApiOperation(value="07.01-\u6837\u672c\u67e5\u8be2(\u5206\u9875\u67e5\u8be2)")
    @PostMapping(value={"/sample"})
    public Response<ImageQueryResult> querySample(@RequestBody ImageSampleQueryFilterDTO filterDTO) {
        return Response.ok((Object)this.imageSampleQueryService.queryByGeometry(filterDTO));
    }

    @ApiOperation(value="07.02-\u6837\u672c\u67e5\u8be2(\u5168\u90e8\u8303\u56f4\u7684dataId)")
    @PostMapping(value={"/sample/range"})
    public Response<ImageRangeDTO> querySampleDataIds(@RequestBody ImageSampleQueryFilterDTO filterDTO) {
        return Response.ok((Object)this.imageSampleQueryService.queryDataIds(filterDTO));
    }

    @ApiOperation(value="07.03-\u68c0\u67e5\u6837\u672c\u6570\u636e\u662f\u5426\u53ef\u4ee5\u4e0b\u8f7d\u3001\u83b7\u53d6\u4e0b\u8f7d\u8bb8\u53ef")
    @ApiImplicitParam(name="dataIdArray", value="\u6570\u636eID\u6570\u7ec4", required=true)
    @PostMapping(value={"/sample/download/check"})
    public Response<List<FileDataDownloadCheckResultDTO>> createDownloadPermit(@RequestParam List<String> dataIdArray) {
        return Response.ok((Object)this.imageSampleQueryService.checkSampleDataCanDownload(dataIdArray));
    }

    @ApiOperation(value="07.04-\u6837\u672c\u4e0b\u8f7d")
    @GetMapping(value={"/sample/download"})
    public void downloadSample(@RequestParam String permit) {
        this.imageSampleQueryService.downloadImageDataByPermit(permit);
    }
}

