--创建自动归档入库业务表

CREATE TABLE tbimg_scheduletask
(
    f_id              varchar(64) NOT NULL PRIMARY KEY,
    f_name            varchar(500) NULL,
    f_interval        int8 NULL,
    f_starttime       timestamp NULL,
    f_endtime         timestamp NULL,
    f_createtime      timestamp NULL,
    f_param           text NULL,
    f_user            varchar(500) NULL,
    f_lastperformtime timestamp NULL,
    f_performtimes    int4 NULL,
    f_enable          int4 NULL,
    f_taskid          int8 NULL
);
COMMENT ON TABLE tbimg_scheduletask IS '自动归档入库任务';

COMMENT ON COLUMN tbimg_scheduletask.f_id IS '标识';
COMMENT ON COLUMN tbimg_scheduletask.f_name IS '名称';
COMMENT ON COLUMN tbimg_scheduletask.f_interval IS '执行间隔';
COMMENT ON COLUMN tbimg_scheduletask.f_starttime IS '开始时间';
COMMENT ON COLUMN tbimg_scheduletask.f_endtime IS '结束时间';
COMMENT ON COLUMN tbimg_scheduletask.f_createtime IS '创建时间';
COMMENT ON COLUMN tbimg_scheduletask.f_param IS '任务参数';
COMMENT ON COLUMN tbimg_scheduletask.f_user IS '用户';
COMMENT ON COLUMN tbimg_scheduletask.f_lastperformtime IS '上次执行时间';
COMMENT ON COLUMN tbimg_scheduletask.f_performtimes IS '执行次数';
COMMENT ON COLUMN tbimg_scheduletask.f_enable IS '是否可用';
COMMENT ON COLUMN tbimg_scheduletask.f_taskid IS '入库任务标识';

ALTER TABLE tbimg_scheduletask ADD CONSTRAINT tbimg_scheduletask_fk FOREIGN KEY (f_taskid) REFERENCES tbimp_task(f_id) ON DELETE CASCADE;

CREATE TABLE tbimg_autoscandatum
(
    f_datapath   varchar(5000) NOT NULL PRIMARY KEY,
    f_datasetid  varchar(2000) NULL,
    f_dataid     int8 NULL,
    f_dataname   varchar(2000) NULL,
    f_serverid   varchar(2000) NULL,
    f_checkstate int4 NULL,
    f_checktime  timestamp NULL,
    f_files      bytea NULL,
    f_md5key     varchar(256) NULL
);
COMMENT ON TABLE tbimg_autoscandatum IS '影像数据自动扫描入库记录';

COMMENT ON COLUMN tbimg_autoscandatum.f_datasetid IS '数据集标识';
COMMENT ON COLUMN tbimg_autoscandatum.f_dataid IS '数据标识';
COMMENT ON COLUMN tbimg_autoscandatum.f_dataname IS '数据名称';
COMMENT ON COLUMN tbimg_autoscandatum.f_datapath IS '数据路径';
COMMENT ON COLUMN tbimg_autoscandatum.f_serverid IS '存储节点标识';
COMMENT ON COLUMN tbimg_autoscandatum.f_checkstate IS '状态';
COMMENT ON COLUMN tbimg_autoscandatum.f_checktime IS '检查时间';
COMMENT ON COLUMN tbimg_autoscandatum.f_files IS '文件';
COMMENT ON COLUMN tbimg_autoscandatum.f_md5key IS '主标识文件的md5';