/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.api.action.config;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.imagedb.apply.entity.ImgSatellite;
import com.geoway.imagedb.apply.service.ImgSatelliteService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/satellite/manage"})
@Api(tags={"01.04-\u536b\u661f\u7ba1\u7406"})
public class ImgSatelliteController {
    @Resource
    private ImgSatelliteService imgSatelliteService;

    @ApiOperation(value="01-\u83b7\u53d6\u536b\u661f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57"), @ApiImplicitParam(name="resolutions", value="\u5206\u8fa8\u7387\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00"), @ApiImplicitParam(name="countries", value="\u56fd\u5bb6\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00"), @ApiImplicitParam(name="types", value="\u7c7b\u578b\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")})
    @GetMapping(value={"/list"})
    public Response<List<ImgSatellite>> list(@RequestParam(required=false) String keyword, @RequestParam(required=false) String resolutions, @RequestParam(required=false) String countries, @RequestParam(required=false) String types) {
        return Response.ok((Object)this.imgSatelliteService.list(keyword, resolutions, countries, types));
    }

    @ApiOperation(value="02-\u65b0\u589e/\u7f16\u8f91\u536b\u661f(id\u4e3a\u7a7a\u65f6\u65b0\u589e)")
    @PostMapping(value={"/add/edit"})
    public Response<String> addOrUpdate(@RequestBody ImgSatellite satellite) {
        return Response.ok((Object)this.imgSatelliteService.addOrUpdate(satellite));
    }

    @ApiOperation(value="03-\u5220\u9664\u536b\u661f")
    @DeleteMapping(value={"/delete"})
    public Response delete(@RequestParam String id) {
        this.imgSatelliteService.delete(id);
        return Response.ok();
    }

    @ApiOperation(value="04-\u5bfc\u5165\u536b\u661f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="json\u6587\u4ef6", required=true, dataTypeClass=MultipartFile.class)})
    @PostMapping(value={"/import"})
    @UploadFileCheck(supportedSuffixes={".json"})
    public Response importSatellite(@RequestPart MultipartFile file) {
        return Response.ok((Object)this.imgSatelliteService.importSatellite(file));
    }

    @ApiOperation(value="05-\u5bfc\u51fa\u536b\u661f")
    @GetMapping(value={"/export"})
    public void exportSatellite(@RequestParam String id) {
        this.imgSatelliteService.exportSatellite(id);
    }
}

