/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.api.action.apply;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.imagedb.apply.dto.apply.DownloadCheckResultDTO;
import com.geoway.imagedb.apply.dto.apply.ImageOrderApprovalDTO;
import com.geoway.imagedb.apply.dto.apply.ImageOrderCreateDTO;
import com.geoway.imagedb.apply.dto.apply.ImageOrderFilterDTO;
import com.geoway.imagedb.apply.dto.apply.ImageOrderResubmitDTO;
import com.geoway.imagedb.apply.dto.apply.ImageOrderVO;
import com.geoway.imagedb.apply.service.ImageOrderService;
import com.geoway.imagedb.dataset.dto.ImgPageList;
import com.geoway.imagedb.dataset.dto.query.ImageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/order"})
@Api(tags={"05.02-\u5f71\u50cf\u6570\u636e\u8ba2\u5355"})
public class ImageOrderController {
    @Resource
    private ImageOrderService imageOrderService;

    @ApiOperation(value="01-\u521b\u5efa\u5f71\u50cf\u6570\u636e\u8ba2\u5355")
    @PostMapping(value={"/create"})
    public Response<String> createImageApply(@RequestBody ImageOrderCreateDTO createDTO) {
        return Response.ok((Object)this.imageOrderService.createImageOrder(createDTO));
    }

    @ApiOperation(value="02-\u67e5\u8be2\u5f71\u50cf\u6570\u636e\u8ba2\u5355\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", required=true, value="\u8ba2\u5355Id", paramType="query")})
    @GetMapping(value={"/detail"})
    public Response<ImageOrderVO> getImageOrderDetail(@RequestParam(required=true) String orderId) {
        return Response.ok((Object)this.imageOrderService.getImageOrder(orderId));
    }

    @ApiOperation(value="03-\u67e5\u8be2\u5f71\u50cf\u6570\u636e\u8ba2\u5355\u4e0b\u7684\u5f71\u50cf\u6570\u636e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", required=true, value="\u8ba2\u5355Id", paramType="query"), @ApiImplicitParam(name="pageIndex", required=false, value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="size", value="\u5c3a\u5bf8(64/128/256),\u4e0d\u63d0\u4ea4\u6b64\u53c2\u6570\uff0c\u5219\u4f7f\u7528\u9ed8\u8ba4\u503c64", paramType="query")})
    @GetMapping(value={"/imageList"})
    public Response<ImgPageList<ImageResult>> getImage(@RequestParam(required=true) String orderId, @RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false, defaultValue="64") Integer size) {
        return Response.ok((Object)this.imageOrderService.getImageList(orderId, pageIndex, rows, size));
    }

    @ApiOperation(value="04-\u67e5\u8be2\u5f71\u50cf\u6570\u636e\u8ba2\u5355\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", required=false, value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", required=false, value="\u8ba2\u5355\u72b6\u6001", paramType="query", allowableValues="com.geoway.imagedb.apply.constant.ImageOrderStatusEnum"), @ApiImplicitParam(name="number", required=false, value="\u8ba2\u5355\u7f16\u53f7", paramType="query"), @ApiImplicitParam(name="startTime", required=false, value="\u7533\u8bf7\u65f6\u95f4\u4e0b\u9650", paramType="query"), @ApiImplicitParam(name="endTime", required=false, value="\u7533\u8bf7\u65f6\u95f4\u4e0a\u9650", paramType="query")})
    @GetMapping(value={"/list"})
    public Response<PageList<ImageOrderVO>> listImageOrder(@RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false) String status, @RequestParam(required=false) String number, @RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd") Date startTime, @RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd") Date endTime) {
        ImageOrderFilterDTO dto = new ImageOrderFilterDTO();
        dto.setNumber(number);
        dto.setStartTime(startTime);
        dto.setEndTime(endTime);
        dto.setStatus(status);
        return Response.ok((Object)this.imageOrderService.listImageOrder(pageIndex, rows, dto));
    }

    @ApiOperation(value="05-\u64a4\u9500\u5f71\u50cf\u6570\u636e\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", required=true, value="\u6570\u636e\u8ba2\u5355id\uff0c\u4ee5\u9017\u53f7\u5206\u9694", paramType="query")})
    @PostMapping(value={"/repeal"})
    public Response repealImageOrder(String ids) {
        this.imageOrderService.repealImageOrder(ids);
        return Response.ok();
    }

    @ApiOperation(value="06-\u518d\u6b21\u63d0\u4ea4\u5f71\u50cf\u6570\u636e\u8ba2\u5355")
    @PostMapping(value={"/resubmit"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", required=true, value="\u8ba2\u5355id", paramType="query")})
    public Response resubmitImageOrder(String orderId, ImageOrderResubmitDTO resubmitDTO) {
        this.imageOrderService.resubmitImageOrder(orderId, resubmitDTO);
        return Response.ok();
    }

    @ApiOperation(value="07-\u5ba1\u6279\u5f71\u50cf\u6570\u636e\u8ba2\u5355")
    @PostMapping(value={"/approve"})
    public Response approveImageOrder(ImageOrderApprovalDTO dto) {
        this.imageOrderService.approveImageOrder(dto);
        return Response.ok();
    }

    @ApiOperation(value="08-\u91cd\u65b0\u51c6\u5907\u8ba2\u5355\u6570\u636e")
    @PostMapping(value={"/reprepare"})
    public Response rePreparingData(@RequestParam String orderId) {
        this.imageOrderService.rePreparingData(orderId);
        return Response.ok();
    }

    @ApiOperation(value="09-\u5220\u9664\u5f71\u50cf\u6570\u636e\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", required=true, value="\u6570\u636e\u8ba2\u5355id\uff0c\u4ee5\u9017\u53f7\u5206\u9694", paramType="query")})
    @PostMapping(value={"/del"})
    public Response delImageOrder(String ids) {
        this.imageOrderService.delImageOrder(ids);
        return Response.ok();
    }

    @ApiOperation(value="10-\u6839\u636e\u5f71\u50cfIDs\u83b7\u53d6\u5f71\u50cf\u6570\u636e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", required=true, value="\u5f71\u50cfIDs", paramType="query"), @ApiImplicitParam(name="pageIndex", required=false, value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="size", value="\u5c3a\u5bf8(64/128/256),\u4e0d\u63d0\u4ea4\u6b64\u53c2\u6570\uff0c\u5219\u4f7f\u7528\u9ed8\u8ba4\u503c64", paramType="query")})
    @PostMapping(value={"/imageListFromIds"})
    public Response<PageList<ImageResult>> getImageFromIDs(@RequestParam(required=true) String ids, @RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false, defaultValue="64") Integer size) {
        return Response.ok((Object)this.imageOrderService.getImageListFromIDs(ids, pageIndex, rows, size));
    }

    @ApiOperation(value="11-\u68c0\u67e5\u5f71\u50cf\u6570\u636e\u662f\u5426\u5141\u8bb8\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355\u6807\u8bc6", required=true), @ApiImplicitParam(name="dataIdArray", value="\u6570\u636eID\u6570\u7ec4", required=true)})
    @PostMapping(value={"/image/data/download/check"})
    public Response<List<DownloadCheckResultDTO>> getFileDataCatalog(@RequestParam String orderId, @RequestParam List<String> dataIdArray) {
        return Response.ok((Object)this.imageOrderService.checkImageDataCanDownload(orderId, dataIdArray));
    }

    @ApiOperation(value="12-\u4e0b\u8f7d\u5f71\u50cf\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355\u6807\u8bc6", required=true), @ApiImplicitParam(name="dataId", value="\u6570\u636eID", required=true)})
    @GetMapping(value={"/image/data/download"})
    public void downloadImageData(@RequestParam String orderId, @RequestParam String dataId) {
        this.imageOrderService.downloadImageData(orderId, dataId);
    }

    @ApiOperation(value="13-\u83b7\u53d6\u5f71\u50cf\u6570\u636e\u4e0b\u8f7d\u8bb8\u53ef")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355\u6807\u8bc6", required=true), @ApiImplicitParam(name="dataIdArray", value="\u6570\u636eID\u6570\u7ec4", required=true)})
    @PostMapping(value={"/image/data/permit"})
    public Response<List<String>> createDownloadPermit(@RequestParam String orderId, @RequestParam List<String> dataIdArray) {
        return Response.ok((Object)this.imageOrderService.createDownloadPermit(orderId, dataIdArray));
    }

    @ApiOperation(value="14-\u4e0b\u8f7d\u5f71\u50cf\u6570\u636e(\u4e0b\u8f7d\u8bb8\u53ef)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="permit", value="\u8bb8\u53ef", required=true)})
    @GetMapping(value={"/image/data/download/permit"})
    public void downloadImageDataByPermit(@RequestParam String permit) {
        this.imageOrderService.downloadImageDataByPermit(permit);
    }

    @ApiOperation(value="15-\u5bfc\u51fa\u6570\u636e\u6e05\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355\u6807\u8bc6", required=true)})
    @GetMapping(value={"/image/data/name/list"})
    public void downloadImageDataNameList(@RequestParam String orderId) {
        this.imageOrderService.downloadImageDataNameList(orderId);
    }
}

