--创建影像数据需求表
CREATE TABLE tbimg_requirement
(
    f_id            varchar(32)  NOT NULL PRIMARY KEY,

    f_name          varchar(255) NULL,
	f_desc          text NULL,

	f_apply_datatype varchar(255) NOT NULL,
	f_apply_datarange varchar(255) NOT NULL,
	f_apply_resolution varchar(255) NOT NULL,
	f_apply_timephase varchar(255) NOT NULL,
	f_apply_purpose text NULL,
	f_apply_desc text NULL,

	f_apply_userid varchar(255) NOT NULL,
	f_apply_username varchar(255) NOT NULL,
	f_apply_userunit varchar(255) NULL,

	f_approve_userid varchar(255)   NULL,
	f_approve_username varchar(255)   NULL,

	f_approve_reply text  NULL,

	f_createtime timestamp(6) NOT NULL,
	f_applytime timestamp(6) NOT NULL,
	f_approvaltime timestamp(6)  NULL,

	f_status varchar(255) NULL,
	f_isdeleted int4 NULL
);
COMMENT ON TABLE tbimg_requirement IS '影像数据需求表';

COMMENT ON COLUMN tbimg_requirement.f_id IS '主键';
COMMENT ON COLUMN tbimg_requirement.f_name IS '需求名称';
COMMENT ON COLUMN tbimg_requirement.f_desc IS '需求描述';

COMMENT ON COLUMN tbimg_requirement.f_apply_datatype IS '数据类型';
COMMENT ON COLUMN tbimg_requirement.f_apply_datarange IS '数据范围';
COMMENT ON COLUMN tbimg_requirement.f_apply_resolution IS '分辨率';
COMMENT ON COLUMN tbimg_requirement.f_apply_timephase IS '数据时相';
COMMENT ON COLUMN tbimg_requirement.f_apply_purpose IS '数据用途';
COMMENT ON COLUMN tbimg_requirement.f_apply_desc IS '数据描述';

COMMENT ON COLUMN tbimg_requirement.f_apply_userid IS '申请用户id';
COMMENT ON COLUMN tbimg_requirement.f_apply_username IS '申请用户名';
COMMENT ON COLUMN tbimg_requirement.f_apply_userunit IS '申请用户单位';

COMMENT ON COLUMN tbimg_requirement.f_approve_userid IS '审批用户id';
COMMENT ON COLUMN tbimg_requirement.f_approve_username IS '审批用户名';
COMMENT ON COLUMN tbimg_requirement.f_approve_reply IS '审批用户回复';

COMMENT ON COLUMN tbimg_requirement.f_createtime IS '创建时间';
COMMENT ON COLUMN tbimg_requirement.f_applytime IS '申请时间';
COMMENT ON COLUMN tbimg_requirement.f_approvaltime IS '审批时间';

COMMENT ON COLUMN tbimg_requirement.f_status IS '订单状态，0/null：未回复；1：已回复';
COMMENT ON COLUMN tbimg_requirement.f_isdeleted IS '订单是否已删除，0/null：未删除，1：已删除';