/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.api.action.apply;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.imagedb.apply.dto.coverage.StatResultItemDTO;
import com.geoway.imagedb.apply.dto.statistic.DistributeStatisticFilterDTO;
import com.geoway.imagedb.apply.dto.statistic.ImageStatisticResultDTO;
import com.geoway.imagedb.apply.dto.statistic.RepertoryStatisticFilterDTO;
import com.geoway.imagedb.apply.service.ImageStatisticService;
import com.geoway.imagedb.dataset.dto.query.CoverageAnalyseResultDTO;
import com.geoway.imagedb.dataset.dto.query.ImageQueryResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/statistic"})
@Api(tags={"05.04-\u7edf\u8ba1"})
public class ImageStatisticController {
    @Resource
    private ImageStatisticService imageStatisticService;

    @ApiOperation(value="01-\u5e93\u5b58\u7edf\u8ba1")
    @PostMapping(value={"/repertory"})
    public Response<ImageStatisticResultDTO> repertoryStatistic(@RequestBody RepertoryStatisticFilterDTO filterDTO) {
        return Response.ok((Object)this.imageStatisticService.repertoryStatistic(filterDTO));
    }

    @ApiOperation(value="02-\u5206\u5e03\u7edf\u8ba1")
    @PostMapping(value={"/distribute"})
    public Response<ImageStatisticResultDTO> distributeStatistic(@RequestBody DistributeStatisticFilterDTO filterDTO) {
        return Response.ok((Object)this.imageStatisticService.distributeStatistic(filterDTO));
    }

    @ApiOperation(value="03-\u5bfc\u51fa\u7edf\u8ba1\u7ed3\u679c")
    @PostMapping(value={"/export"})
    public void exportStatisticResult(@RequestBody ImageStatisticResultDTO resultDTO) {
        this.imageStatisticService.exportStatisticResult(resultDTO);
    }

    @ApiOperation(value="04-\u83b7\u53d6\u8986\u76d6\u5206\u6790\u5e74\u4efd")
    @GetMapping(value={"/coverage/years"})
    public Response<List<Integer>> getCoverageAnalyseYears() {
        return Response.ok((Object)this.imageStatisticService.getCoverageAnalyseYears());
    }

    @ApiOperation(value="05-\u83b7\u53d6\u8986\u76d6\u5206\u6790\u7ed3\u679c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="year", required=true, value="\u5e74\u4efd", paramType="query"), @ApiImplicitParam(name="timeType", required=true, value="\u65f6\u95f4\u7c7b\u578b 1-\u4e00\u5b63\u5ea6 2-\u4e8c\u5b63\u5ea6 3-\u4e09\u5b63\u5ea6 4-\u56db\u5b63\u5ea6 5-\u4e0a\u534a\u5e74 6-\u4e0b\u534a\u5e74 7-\u5168\u5e74", paramType="query")})
    @GetMapping(value={"/coverage"})
    public Response<CoverageAnalyseResultDTO> getCoverageAnalyseResult(@RequestParam Integer year, @RequestParam Integer timeType) {
        return Response.ok((Object)this.imageStatisticService.getCoverageAnalyseResult(year, timeType));
    }

    @ApiOperation(value="06-\u7edf\u8ba1\u5f53\u65e5\u5165\u5e93\u7684\u539f\u59cb\u5f71\u50cf\u6570\u636e")
    @ApiImplicitParam(name="time", required=true, value="\u65f6\u95f4(yyyy/MM/dd)", paramType="query")
    @GetMapping(value={"/original/stat/by/import/day"})
    public Response<List<StatResultItemDTO>> statOriginalImageDataByImportTime(@RequestParam @DateTimeFormat(pattern="yyyy/MM/dd") Date time) {
        return Response.ok((Object)this.imageStatisticService.statOriginalImageDataByImportTime(time));
    }

    @ApiOperation(value="07-\u67e5\u8be2\u5f53\u65e5\u5165\u5e93\u7684\u539f\u59cb\u5f71\u50cf\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="time", required=true, value="\u65f6\u95f4(yyyy/MM/dd)", paramType="query"), @ApiImplicitParam(name="pageIndex", required=true, value="\u9875\u7801", paramType="query"), @ApiImplicitParam(name="rows", required=true, value="\u6bcf\u9875\u884c\u6570", paramType="query")})
    @GetMapping(value={"/original/query/by/import/day"})
    public Response<ImageQueryResult> queryOriginalImageByImportTime(@RequestParam @DateTimeFormat(pattern="yyyy/MM/dd") Date time, @RequestParam Integer pageIndex, @RequestParam Integer rows) {
        return Response.ok((Object)this.imageStatisticService.queryOriginalImageByImportTime(time, pageIndex, rows));
    }
}

