/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.api.action.input;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.properties.UserRightProperties;
import com.geoway.imagedb.apply.user.LoginUserInfoWithDep;
import com.geoway.imagedb.apply.user.UserInfoService;
import com.geoway.imagedb.input.dto.automatic.AutomaticTaskSimpleDTO;
import com.geoway.imagedb.input.dto.automatic.ImageProductAutomaticTaskCreateDTO;
import com.geoway.imagedb.input.dto.automatic.ThematicTaskCreateDTO;
import com.geoway.imagedb.input.service.ImageAutomaticTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@RequestMapping(value={"/image/product"})
@Api(tags={"04.03-\u65e0\u4eba\u503c\u5b88\u5f71\u50cf\u81ea\u52a8\u751f\u4ea7"})
public class ImageAutomaticController {
    @Resource
    private ImageAutomaticTaskService imageAutomaticTaskService;
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private UserRightProperties userRightProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="01-\u5feb\u7ea0\u4ea7\u54c1\u5165\u5e93\u8bf7\u6c42\u63a5\u53e3")
    @PostMapping(value={"/import/task/create"})
    public Response<List<AutomaticTaskSimpleDTO>> createImportTask(@RequestBody ImageProductAutomaticTaskCreateDTO taskCreateDTO) {
        ServletRequestAttributes servletRequestAttributes2 = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes2.getRequest();
        LoginUserInfoWithDep userInfo = this.userInfoService.getUserInfo();
        String token = request.getHeader("Satoken");
        userInfo.setRoleId(this.userRightProperties.getAdminRoleId());
        try {
            this.userInfoService.addFinalUserCache(token, userInfo);
            Response response = Response.ok((Object)this.imageAutomaticTaskService.createImportTask(taskCreateDTO));
            return response;
        }
        finally {
            this.userInfoService.removeFinalUserCache(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="02-\u4e13\u9898\u4ea7\u54c1\u5165\u5e93\u8bf7\u6c42\u63a5\u53e3")
    @PostMapping(value={"/thematic/import/task/create"})
    public Response<List<AutomaticTaskSimpleDTO>> createThematicImportTask(@RequestBody List<ThematicTaskCreateDTO> taskCreateDTO) {
        ServletRequestAttributes servletRequestAttributes2 = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes2.getRequest();
        LoginUserInfoWithDep userInfo = this.userInfoService.getUserInfo();
        String token = request.getHeader("Satoken");
        userInfo.setRoleId(this.userRightProperties.getAdminRoleId());
        try {
            this.userInfoService.addFinalUserCache(token, userInfo);
            Response response = Response.ok((Object)this.imageAutomaticTaskService.createThematicImportTask(taskCreateDTO));
            return response;
        }
        finally {
            this.userInfoService.removeFinalUserCache(token);
        }
    }
}

