/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.api.action.dataset;

import com.geoway.adf.dms.api.action.datasource.ResponseDatasetList;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.DatasetPageList;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dto.ImageDatasetCreateDTO;
import com.geoway.imagedb.dataset.dto.SnapshotPathRepairDTO;
import com.geoway.imagedb.dataset.service.ImageDatabaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/datum/image"})
@Api(tags={"02.01-\u5f71\u50cf\u6570\u636e\u96c6"})
public class ImageDatabaseController {
    @Resource
    private ImageDatabaseService imageDatabaseService;

    @ApiOperation(value="01-\u521b\u5efa\u5f71\u50cf\u6570\u636e\u96c6")
    @PostMapping(value={"/dataset"})
    public Response<String> createDatumDataset(@RequestBody ImageDatasetCreateDTO createDTO) {
        return Response.ok((Object)this.imageDatabaseService.createImageDataset(createDTO));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5f71\u50cf\u6570\u636e\u96c6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="datumTypes", value="\u6587\u4ef6\u6570\u636e\u96c6\u7c7b\u578b", paramType="query", allowableValues="com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query")})
    @GetMapping(value={"/dataset/list"})
    public ResponseDatasetList<SimpleDatasetDTO> listDatumDataset(@RequestParam String dsKey, @RequestParam(required=false) String datumTypes, @RequestParam(required=false) String keyword, @RequestParam(required=false) Integer pageIndex, @RequestParam(required=false) Integer rows) {
        List datasetTypes = new ArrayList();
        if (StringUtil.isNotEmpty((String)datumTypes)) {
            datasetTypes = StringUtil.split((String)datumTypes, (String)",", t -> ImageDatasetTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        return ResponseDatasetList.ok((DatasetPageList)this.imageDatabaseService.listImageDataset(dsKey, datasetTypes, keyword, pageIndex, rows));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u5f71\u50cf\u6570\u636e\u96c6\u5feb\u89c6\u56fe\u8def\u5f84\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasetId", value="\u5f71\u50cf\u6570\u636e\u96c6\u6807\u8bc6", required=true, paramType="query")})
    @GetMapping(value={"/dataset/snapshot/path/list"})
    public Response<List<String>> getSnapshotPathList(@RequestParam String datasetId) {
        return Response.ok((Object)this.imageDatabaseService.getSnapshotPathList(datasetId));
    }

    @ApiOperation(value="04-\u4fee\u590d\u5f71\u50cf\u6570\u636e\u96c6\u5feb\u89c6\u56fe\u8def\u5f84")
    @PostMapping(value={"/dataset/snapshot/path/repair"})
    public Response<Boolean> repairSnapshotPath(@RequestBody List<SnapshotPathRepairDTO> snapshotPathList) {
        this.imageDatabaseService.repairSnapshotPath(snapshotPathList);
        return Response.ok((Object)true);
    }
}

