/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.common.config.OutputPathConfig;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialRelationType;
import com.geoway.adf.gis.raster.RasterProcessFunc;
import com.geoway.adf.gis.raster.info.RasterStorageInfo;
import com.geoway.imagedb.apply.constant.ImageExportTaskStatusEnum;
import com.geoway.imagedb.apply.dto.export.ImageExportCustomTask;
import com.geoway.imagedb.apply.dto.export.ImageExportCustomTaskParams;
import com.geoway.imagedb.apply.service.ImageExportService;
import com.geoway.imagedb.apply.user.UserInfoService;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ImageExportServiceImpl
implements ImageExportService {
    private static final Logger log = LoggerFactory.getLogger(ImageExportServiceImpl.class);
    @Resource
    private AppCatalogNodeService appCatalogNodeService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutor = null;
    private final Map<String, ImageExportCustomTask> taskMap = new HashMap<String, ImageExportCustomTask>();

    @Override
    public String exportImage(ImageExportCustomTaskParams taskParams) {
        AppCatalogNodeDTO catalogNodeDTO;
        this.userInfoService.checkToken();
        if (taskParams == null) {
            throw new RuntimeException("\u4efb\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)taskParams.getNodeId())) {
            throw new RuntimeException("\u76ee\u5f55\u8282\u70b9\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)taskParams.getGeometry())) {
            throw new RuntimeException("\u7a7a\u95f4\u8303\u56f4\u7684wkt\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String outputPath = taskParams.getTargetPath();
        if (StringUtil.isEmptyOrWhiteSpace((String)outputPath)) {
            outputPath = Paths.get(OutputPathConfig.getOutputPath().toString(), UUID.randomUUID().toString().replace("-", "")).toAbsolutePath().toString();
        }
        if ((catalogNodeDTO = this.appCatalogNodeService.getNodeDetail(taskParams.getNodeId())) == null) {
            throw new RuntimeException("\u76ee\u5f55\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        }
        outputPath = this.getTargetRasterPath(outputPath, catalogNodeDTO.getNodeName(), taskParams.getFormat());
        taskParams.setTargetPath(outputPath);
        ImageExportCustomTask customTask = new ImageExportCustomTask();
        customTask.setTaskId(UUID.randomUUID().toString().replace("-", ""));
        customTask.setStatus(ImageExportTaskStatusEnum.PROCESSING.getValue());
        customTask.setResult("");
        customTask.setTargetPath(outputPath);
        this.threadPoolTaskExecutor.execute(() -> this.exportMosaicDataset(catalogNodeDTO, customTask, taskParams));
        return customTask.getTaskId();
    }

    @Override
    public ImageExportCustomTask getTaskDetail(String taskId) {
        this.userInfoService.checkToken();
        if (!this.taskMap.containsKey(taskId)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        return this.taskMap.get(taskId);
    }

    @Override
    public Integer deleteExportData(String taskId) {
        File[] files;
        this.userInfoService.checkToken();
        if (!this.taskMap.containsKey(taskId)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        ImageExportCustomTask customTask = this.taskMap.get(taskId);
        ImageExportTaskStatusEnum taskStatusEnum = ImageExportTaskStatusEnum.getByValue(customTask.getStatus());
        if (taskStatusEnum == ImageExportTaskStatusEnum.PROCESSING) {
            throw new RuntimeException("\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u52ff\u5220\u9664\uff01");
        }
        String targetPath = customTask.getTargetPath();
        File targetFile = new File(targetPath);
        String fileName = FileUtil.getFileNameWithoutExtension((String)targetPath);
        String fileNameWithEx = FileUtil.getFileName((String)targetPath);
        ArrayList<String> deleteFiles = new ArrayList<String>();
        if (targetFile.exists() && (files = targetFile.getParentFile().listFiles()) != null && files.length > 0) {
            for (File file : files) {
                String name = FileUtil.getFileNameWithoutExtension((String)file.getAbsolutePath());
                if (!fileName.equalsIgnoreCase(name) && !name.startsWith(fileNameWithEx)) continue;
                deleteFiles.add(file.getAbsolutePath());
            }
        }
        int deleteCount = 0;
        for (String filePath : deleteFiles) {
            boolean success;
            File deleteFile = new File(filePath);
            if (!deleteFile.isFile() || !(success = deleteFile.delete())) continue;
            ++deleteCount;
        }
        return deleteCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportMosaicDataset(AppCatalogNodeDTO catalogNodeDTO, ImageExportCustomTask customTask, ImageExportCustomTaskParams taskParams) {
        IMosaicDataset srcMosaicDataset = null;
        try (IFeatureWorkspace srcWorkspace = null;){
            String datasetId = ((AppCatalogDataNodeDTO)catalogNodeDTO).getDatasetId();
            DatasetNameInfo srcNameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
            String dsKey = srcNameInfo.getDsKey();
            String mosaicDatasetName = srcNameInfo.getName();
            if (srcNameInfo.getType().intValue() == DatasetTypeEnum.DatumDataset.getValue()) {
                ImgDataset imgDataset = this.imageDatasetService.getImgDataset(datasetId);
                DatasetNameInfo geoDatasetNameInfo = DatasetUtil.getDatasetNameInfo((String)imgDataset.getGeoDatasetId());
                dsKey = geoDatasetNameInfo.getDsKey();
                mosaicDatasetName = geoDatasetNameInfo.getName();
            } else if (srcNameInfo.getType().intValue() == DatasetTypeEnum.MosaicDataset.getValue()) {
                log.info("\u6e90\u6570\u636e\u7c7b\u578b\u4e3aMosaicDataset");
            } else {
                DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)srcNameInfo.getType());
                log.error("\u4e0d\u652f\u6301\u7684\u6570\u636e\u96c6\u7c7b\u578b" + datasetType.getDesc());
                customTask.setStatus(ImageExportTaskStatusEnum.FAILED.getValue());
                customTask.setResult("\u4e0d\u652f\u6301\u7684\u6570\u636e\u96c6\u7c7b\u578b" + datasetType.getDesc());
                this.taskMap.put(customTask.getTaskId(), customTask);
                return;
            }
            srcWorkspace = this.geoDatabaseService.openGeoWorkspace(dsKey);
            srcMosaicDataset = srcWorkspace.openMosaicDataset(mosaicDatasetName);
            if (srcMosaicDataset == null) {
                log.error("\u6e90\u6570\u636e\u6253\u5f00\u5931\u8d25");
                customTask.setStatus(ImageExportTaskStatusEnum.FAILED.getValue());
                customTask.setResult("\u6e90\u6570\u636e\u6253\u5f00\u5931\u8d25");
                this.taskMap.put(customTask.getTaskId(), customTask);
                return;
            }
            this.taskMap.put(customTask.getTaskId(), customTask);
            log.info("\u5f00\u59cb\u6267\u884c\u4efb\u52a1\uff1a{}", (Object)customTask.getTaskId());
            this.exportMosaicDatasetByGeometry(taskParams, srcMosaicDataset, customTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportMosaicDatasetByGeometry(ImageExportCustomTaskParams params, IMosaicDataset mosaicDataset, ImageExportCustomTask customTask) {
        boolean isSuccess;
        ISpatialReferenceSystem targetSrs;
        double targetResolution;
        ISpatialReferenceSystem filterSpatialRef;
        IGeometry filterGeometry = GeometryFunc.createGeometry((String)params.getGeometry());
        log.info("\u5f00\u59cb\u6267\u884c\u8303\u56f4\u63d0\u53d6\uff1a" + params.getGeometry());
        if (filterGeometry == null) {
            log.error("\u51e0\u4f55\u56fe\u5f62\u9519\u8bef" + params.getGeometry());
            customTask.setStatus(ImageExportTaskStatusEnum.FAILED.getValue());
            customTask.setResult("\u51e0\u4f55\u56fe\u5f62\u9519\u8bef");
            return false;
        }
        ISpatialReferenceSystem sourceSpatialRef = mosaicDataset.getSpatialReferenceSystem();
        if (!SpatialReferenceSystemFunc.equals((ISpatialReferenceSystem)sourceSpatialRef, (ISpatialReferenceSystem)(filterSpatialRef = SpatialReferenceSystemFunc.createSpatialReference((int)4326)))) {
            filterGeometry = filterGeometry.projectToCopy(filterSpatialRef, sourceSpatialRef);
        }
        if (filterGeometry == null) {
            log.error("\u63d0\u53d6\u8303\u56f4\u6295\u5f71\u540e\u4e3a\u7a7a" + params.getGeometry());
            customTask.setStatus(ImageExportTaskStatusEnum.FAILED.getValue());
            customTask.setResult("\u63d0\u53d6\u8303\u56f4\u6295\u5f71\u540e\u4e3a\u7a7a");
            return false;
        }
        ArrayList<String> srcRasterFiles = new ArrayList<String>();
        IFeatureCursor searchCursor = null;
        try {
            RasterStorageInfo rasterStorageInfo;
            String type;
            String fieldUri = "urihash";
            SpatialQueryFilter pFilter = new SpatialQueryFilter();
            pFilter.setGeometry(filterGeometry);
            pFilter.setSpatialRel(SpatialRelationType.Intersects);
            pFilter.setSubFields(fieldUri);
            pFilter.setWhereClause("category = 1");
            IFeatureClass catalogClass = mosaicDataset.getCatalog();
            searchCursor = catalogClass.searchFeature((IQueryFilter)pFilter);
            IFeature feature = searchCursor.nextFeature();
            while (feature != null) {
                if (feature.getValue(fieldUri) != null) {
                    srcRasterFiles.add(feature.getValue(fieldUri).toString());
                }
                feature = searchCursor.nextFeature();
            }
            if (srcRasterFiles.size() == 0) {
                log.error("\u672a\u67e5\u8be2\u5230\u6570\u636e");
                customTask.setStatus(ImageExportTaskStatusEnum.FAILED.getValue());
                customTask.setResult("\u672a\u67e5\u8be2\u5230\u6570\u636e");
                boolean bl = false;
                return bl;
            }
            if (mosaicDataset.getRasterInfo().getStorageInfo() != null && (type = (rasterStorageInfo = mosaicDataset.getRasterInfo().getStorageInfo()).getType()) != null) {
                ArrayList<String> rasterFiles = new ArrayList<String>();
                for (String file : srcRasterFiles) {
                    if (type.equals(DataSourceTypeEnum.OSS.name())) {
                        rasterFiles.add(GeoDatabaseUtil.vsiOSSPath((String)file, (String)rasterStorageInfo.getUserName(), (String)rasterStorageInfo.getPassword()));
                        continue;
                    }
                    rasterFiles.add(GeoDatabaseUtil.vsiS3Path((String)file, (String)rasterStorageInfo.getUserName(), (String)rasterStorageInfo.getPassword()));
                }
                srcRasterFiles = rasterFiles;
            }
        }
        catch (Exception ex) {
            log.error("\u6570\u636e\u63d0\u53d6\u5f02\u5e38\uff1a", (Throwable)ex);
            customTask.setStatus(ImageExportTaskStatusEnum.FAILED.getValue());
            customTask.setResult("\u6570\u636e\u63d0\u53d6\u5f02\u5e38" + ex.getMessage());
            boolean pFilter = false;
            return pFilter;
        }
        finally {
            if (searchCursor != null) {
                searchCursor.release();
            }
        }
        String fileFullPath = params.getTargetPath();
        Integer targetSrid = sourceSpatialRef.getSrid();
        IGeometry clipGeometry = filterGeometry;
        if (params.getTargetSrid() != null && params.getTargetSrid() != 0) {
            targetSrid = params.getTargetSrid();
            ISpatialReferenceSystem targetSrs2 = SpatialReferenceSystemFunc.createSpatialReference((int)targetSrid);
            clipGeometry = filterGeometry.projectToCopy(sourceSpatialRef, targetSrs2);
        }
        double d = targetResolution = params.getSampleInterval() == null ? -1.0 : params.getSampleInterval();
        if (targetResolution > 0.0 && (targetSrs = SpatialReferenceSystemFunc.createSpatialReference((int)targetSrid)).getType().equals((Object)SpatialReferenceSystemType.Geographic)) {
            BigDecimal circumference = NumberUtil.mul((Number[])new Number[]{2, Math.PI, 6378137});
            BigDecimal pre = NumberUtil.div((Number)targetResolution, (Number)circumference);
            targetResolution = NumberUtil.mul((Number)pre, (Number)360).doubleValue();
        }
        if (!(isSuccess = RasterProcessFunc.clipRasterFile(srcRasterFiles, (String)fileFullPath, (IGeometry)clipGeometry, (int)targetSrid, (double)targetResolution, mosaicDataset.getRasterInfo().getInvalidValue() == null ? null : mosaicDataset.getRasterInfo().getInvalidValue()[0]))) {
            customTask.setStatus(ImageExportTaskStatusEnum.FAILED.getValue());
            customTask.setResult("\u88c1\u526a\u5931\u8d25\uff0c\u8bf7\u8bbe\u7f6e\u6b63\u786e\u7684\u91c7\u6837\u95f4\u9694\uff01");
        } else {
            customTask.setStatus(ImageExportTaskStatusEnum.SUCCESS.value);
        }
        return isSuccess;
    }

    private String getTargetRasterPath(String exportPath, String name, Integer format) {
        String ext = "";
        switch (format) {
            case 0: {
                ext = ".tif";
                break;
            }
            case 1: {
                ext = ".img";
                break;
            }
        }
        if (!FileUtil.isDirExsit((String)exportPath).booleanValue()) {
            FileUtil.mkdirs((String)exportPath);
        }
        return exportPath + File.separator + name + ext;
    }
}

