/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.IdUtil;
import com.geoway.adf.dms.common.config.OutputPathConfig;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.util.ZipAndRarUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.datasource.service.FileDataService;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.imagedb.apply.constant.ImageOrderStatusEnum;
import com.geoway.imagedb.apply.constant.WatermarkTypeEnum;
import com.geoway.imagedb.apply.dao.ImgOrderDao;
import com.geoway.imagedb.apply.dao.ImgOrderImgDao;
import com.geoway.imagedb.apply.dto.apply.DownloadCheckResultDTO;
import com.geoway.imagedb.apply.dto.apply.ImageOrderApprovalDTO;
import com.geoway.imagedb.apply.dto.apply.ImageOrderCreateDTO;
import com.geoway.imagedb.apply.dto.apply.ImageOrderFilterDTO;
import com.geoway.imagedb.apply.dto.apply.ImageOrderResubmitDTO;
import com.geoway.imagedb.apply.dto.apply.ImageOrderVO;
import com.geoway.imagedb.apply.dto.watermark.EmbedTaskCreateParams;
import com.geoway.imagedb.apply.dto.watermark.EncryptTaskCreateParams;
import com.geoway.imagedb.apply.dto.watermark.WatermarkTask;
import com.geoway.imagedb.apply.entity.ImgOrder;
import com.geoway.imagedb.apply.entity.ImgOrderImg;
import com.geoway.imagedb.apply.service.ImageOrderService;
import com.geoway.imagedb.apply.user.LoginUserInfoWithDep;
import com.geoway.imagedb.apply.user.UserInfoService;
import com.geoway.imagedb.apply.util.WatermarkUtil;
import com.geoway.imagedb.dataset.dto.ImgPageList;
import com.geoway.imagedb.dataset.dto.query.ImageQueryResult;
import com.geoway.imagedb.dataset.dto.query.ImageResult;
import com.geoway.imagedb.dataset.entity.ImgRecycle;
import com.geoway.imagedb.dataset.service.ImageQueryService;
import com.geoway.imagedb.dataset.service.ImageRecycleService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ImageOrderServiceImpl
implements ImageOrderService {
    private static final Logger log = LoggerFactory.getLogger(ImageOrderServiceImpl.class);
    @Resource
    private ImgOrderDao imgOrderDao;
    @Resource
    private ImgOrderImgDao imgOrderImgDao;
    @Resource
    private ImageQueryService imageQueryService;
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private FileDataService fileDataService;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutorData;
    @Resource
    private ImageRecycleService imageRecycleService;
    private Set<String> packagingImageData = new LinkedHashSet<String>();
    private Map<String, Map<String, String>> downloadPermitMap = new HashMap<String, Map<String, String>>();
    private final String orderCacheSuffix = "_watermark";

    @Override
    @Transactional
    public String createImageOrder(ImageOrderCreateDTO createDTO) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        Assert.isTrue((boolean)user.getUserId().equals(createDTO.getApply_userid()), (String)"\u53c2\u6570\u4e2d\u63d0\u4ea4\u7684\u7528\u6237\u4fe1\u606f\u4e0e\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e0d\u7b26");
        ImgOrder io = new ImgOrder();
        io.setFId(IdUtil.getSnowflakeNextIdStr());
        Date newDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String newDateStr = sdf.format(newDate);
        String number = newDateStr + "001";
        ImgOrder maxOrder = this.imgOrderDao.selectMaxNumber(newDateStr);
        if (maxOrder != null) {
            String serial = maxOrder.getFNumber().substring(8);
            Integer currserial = Integer.valueOf(serial) + 1;
            number = currserial > 999 ? newDateStr + String.valueOf(currserial) : newDateStr + String.valueOf(1000 + currserial).substring(1);
        }
        io.setFNumber(number);
        io.setFApplyDesc(createDTO.getApply_desc());
        io.setFApplyPurpose(createDTO.getApply_purpose());
        io.setFApplyUserid(createDTO.getApply_userid());
        io.setFApplyUsername(createDTO.getApply_username());
        io.setFApplyUserunit(createDTO.getApply_userunit());
        io.setFDataNumber(createDTO.getData_number());
        io.setFDataSize(createDTO.getData_size());
        if (!StringUtils.startsWith((CharSequence)createDTO.getData(), (CharSequence)",")) {
            createDTO.setData("," + createDTO.getData());
        }
        if (!StringUtils.endsWith((CharSequence)createDTO.getData(), (CharSequence)",")) {
            createDTO.setData(createDTO.getData() + ",");
        }
        io.setFData(createDTO.getData());
        io.setFCreatetime(new Date());
        io.setFApplytime(new Date());
        io.setFStatus(String.valueOf(ImageOrderStatusEnum.Ready.getValue()));
        io.setWatermarkType(WatermarkTypeEnum.None.getValue());
        io.setFIsdeleted(0);
        this.imgOrderDao.insert(io);
        String[] imgArr = createDTO.getData().split(",");
        List<String> imgList = this.deleteDuplicate(imgArr);
        ImageQueryResult result = this.imageQueryService.queryByDataIds(imgList, Integer.valueOf(64));
        for (int i = 0; i < result.getData().size(); ++i) {
            this.saveOrderImg(io, (ImageResult)result.getData().get(i));
        }
        return io.getFNumber();
    }

    private void saveOrderImg(ImgOrder inio, ImageResult img) {
        ImgOrderImg io = new ImgOrderImg();
        io.setFId(IdUtil.getSnowflakeNextIdStr());
        io.setFOrderid(inio.getFId());
        io.setFDataid(img.getDataId());
        io.setFDataname(String.valueOf(img.getAttributes().get("F_DATANAME")));
        double dataSize = 0.0;
        try {
            dataSize = Double.parseDouble(img.getAttributes().get("F_DATASIZE").toString());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        io.setFDataSize(dataSize);
        Integer cloud = 0;
        try {
            if (img.getAttributes().containsKey("f_cloud")) {
                cloud = (int)Double.parseDouble(img.getAttributes().get("f_cloud").toString());
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        io.setFCloud(cloud);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date productTime = null;
        try {
            if (img.getAttributes().containsKey("f_product_time")) {
                productTime = sdf.parse(String.valueOf(img.getAttributes().get("f_product_time")));
            }
            if (img.getAttributes().containsKey("f_time")) {
                productTime = sdf.parse(String.valueOf(img.getAttributes().get("f_time")));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        io.setFProductTime(productTime);
        io.setImageType(11);
        if (img.getAttributes().containsKey("f_satellite")) {
            io.setFSatellite(String.valueOf(img.getAttributes().get("f_satellite")));
        }
        if (img.getAttributes().containsKey("f_classification")) {
            io.setFSatellite(String.valueOf(img.getAttributes().get("f_classification")));
            io.setImageType(21);
        }
        if (img.getAttributes().containsKey("f_sensor")) {
            io.setFSensor(String.valueOf(img.getAttributes().get("f_sensor")));
        }
        this.imgOrderImgDao.insert(io);
    }

    @Override
    public ImageOrderVO getImageOrder(String orderId) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        ImgOrder one = this.imgOrderDao.selectByPrimaryKey(orderId);
        Assert.notNull((Object)one, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + orderId + "\u7684\u5f71\u50cf\u8ba2\u5355"));
        if (!this.userInfoService.isAdmin(user).booleanValue()) {
            Assert.isTrue((boolean)one.getFApplyUserid().equals(user.getUserId()), (String)("\u6807\u8bc6\u4e3a" + orderId + "\u7684\u5f71\u50cf\u7533\u8bf7\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237"));
        }
        ImageOrderVO vo = new ImageOrderVO();
        vo.setId(one.getFId());
        vo.setNumber(one.getFNumber());
        vo.setApply_desc(one.getFApplyDesc());
        vo.setApply_purpose(one.getFApplyPurpose());
        vo.setApply_time(one.getFApplytime());
        vo.setApply_userid(one.getFApplyUserid());
        vo.setApply_username(one.getFApplyUsername());
        vo.setApply_userunit(one.getFApplyUserunit());
        vo.setApprove_desc(one.getFApproveDesc());
        vo.setApprove_username(one.getFApproveUsername());
        vo.setApprove_opinion(one.getFApproveOpinion());
        vo.setApprove_time(one.getFApprovaltime());
        vo.setData_number(one.getFDataNumber());
        vo.setData_size(one.getFDataSize());
        vo.setStatus(one.getFStatus());
        vo.setWatermark_type(one.getWatermarkType());
        vo.setWatermark_massage(one.getWatermarkMassage());
        vo.setEncryptStartTime(one.getEncryptStartTime());
        vo.setEncryptEndTime(one.getEncryptEndTime());
        vo.setExtraction_mode(one.getFExtractionMode());
        return vo;
    }

    @Override
    public ImgPageList<ImageResult> getImageList(String orderId, Integer pageIndex, Integer rows, Integer size) {
        ImgOrder ig = this.imgOrderDao.selectByPrimaryKey(orderId);
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        Assert.notNull((Object)ig, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + orderId + "\u7684\u5f71\u50cf\u8ba2\u5355"));
        if (!this.userInfoService.isAdmin(user).booleanValue()) {
            Assert.isTrue((boolean)ig.getFApplyUserid().equals(user.getUserId()), (String)("\u6807\u8bc6\u4e3a" + orderId + "\u7684\u5f71\u50cf\u7533\u8bf7\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237"));
        }
        return this.innerGetImageList(ig.getFData(), pageIndex, rows, size, false);
    }

    @Override
    public PageList<ImageResult> getImageListFromIDs(String ids, Integer pageIndex, Integer rows, Integer size) {
        Assert.notNull((Object)ids, (String)"\u5f71\u50cfid\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.hasLength((String)ids, (String)"\u5f71\u50cfid\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        return this.innerGetImageList(ids, pageIndex, rows, size, true);
    }

    private List<String> deleteDuplicate(String[] imgArr) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String str : imgArr) {
            if (str.trim().isEmpty()) continue;
            set.add(str);
        }
        return new ArrayList<String>(set);
    }

    private ImgPageList<ImageResult> innerGetImageList(String ids, Integer pageIndex, Integer rows, Integer size, boolean dd) {
        String[] imgArr = ids.split(",");
        List<String> imgList = this.deleteDuplicate(imgArr);
        ImageQueryResult result = this.imageQueryService.queryByDataIds(imgList, size);
        Double sum = result.getData().size() == 0 ? Double.valueOf(0.0) : result.getData().stream().map(n -> Double.valueOf(n.getAttributes().get("F_DATASIZE").toString())).reduce(Double::sum).get();
        return new ImgPageList(ListUtil.page((int)pageIndex, (int)rows, (List)result.getData()), result.getTotal(), Integer.valueOf(sum.intValue()));
    }

    @Override
    public PageList<ImageOrderVO> listImageOrder(Integer pageIndex, Integer rows, ImageOrderFilterDTO dto) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        List<ImgOrder> list = null;
        if (dto.getStatus() != null && !dto.getStatus().trim().isEmpty()) {
            dto.setStatusList(Arrays.asList(dto.getStatus().split(",")));
        }
        if (this.userInfoService.isAdmin(user).booleanValue()) {
            PageHelper.startPage((int)(pageIndex + 1), (int)rows);
            list = this.imgOrderDao.selectAll(dto);
        } else {
            PageHelper.startPage((int)(pageIndex + 1), (int)rows);
            list = this.imgOrderDao.selectByUser(user.getUserId(), dto);
        }
        PageInfo pageInfo = new PageInfo(list);
        List imangeOrderVo = com.geoway.adf.dms.common.util.ListUtil.convertAll(list, t -> {
            ImageOrderVO vo = new ImageOrderVO();
            vo.setId(t.getFId());
            vo.setNumber(t.getFNumber());
            vo.setData_number(t.getFDataNumber());
            vo.setData_size(t.getFDataSize());
            vo.setStatus(t.getFStatus());
            vo.setWatermark_type(t.getWatermarkType());
            vo.setApply_time(t.getFApplytime());
            vo.setApply_userid(t.getFApplyUserid());
            vo.setApply_username(t.getFApplyUsername());
            vo.setApply_userunit(t.getFApplyUserunit());
            vo.setApprove_time(t.getFApprovaltime());
            vo.setExtraction_mode(t.getFExtractionMode());
            return vo;
        });
        return new PageList(imangeOrderVo, Long.valueOf(pageInfo.getTotal()));
    }

    @Override
    public void repealImageOrder(String ids) {
        Assert.hasLength((String)ids, (String)"\u8bf7\u9009\u62e9\u5f71\u50cf\u8ba2\u5355");
        String[] idArr = ids.split(",");
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        for (int i = 0; i < idArr.length; ++i) {
            ImgOrder io = this.imgOrderDao.selectByPrimaryKey(idArr[i]);
            Assert.notNull((Object)io, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + idArr[i] + "\u7684\u5f71\u50cf\u8ba2\u5355"));
            Assert.isTrue((boolean)io.getFStatus().equals(String.valueOf(ImageOrderStatusEnum.Ready.getValue())), (String)String.format("\u64a4\u9500\u524d\u7684\u8ba2\u5355[%s]\u72b6\u6001\u53ea\u80fd\u662f\u5f85\u5ba1\u6279", idArr[i]));
            Assert.isTrue((boolean)io.getFApplyUserid().equals(user.getUserId()), (String)("\u6807\u8bc6\u4e3a" + idArr[i] + "\u7684\u5f71\u50cf\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237"));
            io.setFStatus(String.valueOf(ImageOrderStatusEnum.Repeal.getValue()));
            this.imgOrderDao.updateByPrimaryKey(io);
        }
    }

    @Override
    public String resubmitImageOrder(String orderId, ImageOrderResubmitDTO createDTO) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        ImgOrder io = this.imgOrderDao.selectByPrimaryKey(orderId);
        Assert.notNull((Object)io, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + orderId + "\u7684\u5f71\u50cf\u8ba2\u5355"));
        Assert.isTrue((io.getFStatus().equals(String.valueOf(ImageOrderStatusEnum.Reject.getValue())) || io.getFStatus().equals(String.valueOf(ImageOrderStatusEnum.Repeal.getValue())) ? 1 : 0) != 0, (String)"\u91cd\u65b0\u63d0\u4ea4\u524d\u7684\u8ba2\u5355\u72b6\u6001\u53ea\u80fd\u662f\u672a\u901a\u8fc7|\u5df2\u64a4\u9500");
        Assert.isTrue((boolean)user.getUserId().equals(io.getFApplyUserid()), (String)"\u8ba2\u5355\u4e2d\u7684\u7528\u6237\u4fe1\u606f\u4e0e\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e0d\u7b26");
        if (!createDTO.getApply_desc().trim().isEmpty()) {
            io.setFApplyDesc(createDTO.getApply_desc());
        }
        if (!createDTO.getApply_purpose().trim().isEmpty()) {
            io.setFApplyPurpose(createDTO.getApply_purpose());
        }
        io.setFApplytime(new Date());
        io.setFStatus(String.valueOf(ImageOrderStatusEnum.Ready.getValue()));
        this.imgOrderDao.updateByPrimaryKey(io);
        return io.getFId();
    }

    @Override
    public String approveImageOrder(ImageOrderApprovalDTO dto) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        Assert.isTrue((boolean)this.userInfoService.isAdmin(user), (String)"\u5f53\u524d\u7528\u6237\u975e\u7ba1\u7406\u5458");
        ImgOrder io = this.imgOrderDao.selectByPrimaryKey(dto.getOrder_id());
        Assert.notNull((Object)io, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + dto.getOrder_id() + "\u7684\u5f71\u50cf\u8ba2\u5355"));
        Assert.isTrue((boolean)io.getFStatus().equals(String.valueOf(ImageOrderStatusEnum.Ready.getValue())), (String)"\u5f53\u524d\u5f71\u50cf\u8ba2\u5355\u975e\u5f85\u5ba1\u6279\u72b6\u6001");
        Assert.isTrue((dto.getStatus().equals(String.valueOf(ImageOrderStatusEnum.Complete.getValue())) || dto.getStatus().equals(String.valueOf(ImageOrderStatusEnum.Reject.getValue())) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u540e\u7684\u8ba2\u5355\u72b6\u6001\u53ea\u80fd\u662f\u672a\u901a\u8fc7|\u5df2\u5b8c\u6210");
        io.setFApproveDesc(dto.getApprove_desc());
        io.setFApproveOpinion(dto.getApprove_opinion());
        io.setFApproveUserid(user.getUserId());
        io.setFApproveUsername(user.getUserName());
        io.setFApprovaltime(new Date());
        io.setFStatus(dto.getStatus());
        WatermarkTypeEnum watermarkType = WatermarkTypeEnum.None;
        if (StringUtil.isNotEmpty((String)dto.getWatermark_type()) && dto.getStatus().equals(String.valueOf(ImageOrderStatusEnum.Complete.getValue()))) {
            watermarkType = WatermarkTypeEnum.getByValue(Integer.valueOf(dto.getWatermark_type()));
            if (watermarkType != WatermarkTypeEnum.None) {
                io.setFStatus(ImageOrderStatusEnum.DataPreparing.getValue() + "");
            }
            if (watermarkType == WatermarkTypeEnum.Encrypt) {
                io.setEncryptStartTime(dto.getEncryptStartTime());
                io.setEncryptEndTime(dto.getEncryptEndTime());
            }
        }
        io.setWatermarkType(watermarkType.getValue());
        io.setFExtractionMode(dto.getExtraction_mode());
        this.imgOrderDao.updateByPrimaryKey(io);
        this.preparingData(io, watermarkType);
        return io.getFId();
    }

    @Override
    public String rePreparingData(String orderId) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        Assert.isTrue((boolean)this.userInfoService.isAdmin(user), (String)"\u5f53\u524d\u7528\u6237\u975e\u7ba1\u7406\u5458");
        ImgOrder io = this.imgOrderDao.selectByPrimaryKey(orderId);
        Assert.notNull((Object)io, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + orderId + "\u7684\u5f71\u50cf\u8ba2\u5355"));
        if (!io.getFStatus().equals(String.valueOf(ImageOrderStatusEnum.Fail.getValue()))) {
            throw new RuntimeException("\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u975e\u5931\u8d25\u72b6\u6001");
        }
        WatermarkTypeEnum watermarkType = WatermarkTypeEnum.getByValue(io.getWatermarkType());
        switch (watermarkType) {
            case None: {
                return io.getFId();
            }
            case Watermark: 
            case Encrypt: {
                String orderNumber = io.getFNumber() + "_watermark";
                Path cachePath = this.getImageDataCacheDir();
                Path packagePath = Paths.get(cachePath.toString(), orderNumber);
                if (!packagePath.toFile().exists()) break;
                FileUtil.deleteDir((String)packagePath.toAbsolutePath().toString());
            }
        }
        this.preparingData(io, watermarkType);
        return io.getFId();
    }

    @Override
    public void delImageOrder(String ids) {
        Assert.hasLength((String)ids, (String)"\u8bf7\u9009\u62e9\u5f71\u50cf\u8ba2\u5355");
        String[] idArr = ids.split(",");
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        for (int i = 0; i < idArr.length; ++i) {
            ImgOrder io = this.imgOrderDao.selectByPrimaryKey(idArr[i]);
            Assert.notNull((Object)io, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + idArr[i] + "\u7684\u5f71\u50cf\u8ba2\u5355"));
            Assert.isTrue((boolean)io.getFApplyUserid().equals(user.getUserId()), (String)("\u6807\u8bc6\u4e3a" + idArr[i] + "\u7684\u5f71\u50cf\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237"));
            io.setFIsdeleted(1);
            this.imgOrderDao.updateByPrimaryKey(io);
        }
    }

    @Override
    public void downloadImageDataNameList(String orderId) {
        ImgOrder order = this.imgOrderDao.selectByPrimaryKey(orderId);
        Assert.notNull((Object)order, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + orderId + "\u7684\u5f71\u50cf\u8ba2\u5355"));
        String[] imgArr = order.getFData().split(",");
        List<String> imgList = this.deleteDuplicate(imgArr);
        ImageQueryResult queryResult = this.imageQueryService.queryByDataIds(imgList, Integer.valueOf(0));
        LinkedList<String> dataNameList = new LinkedList<String>();
        for (ImageResult img : queryResult.getData()) {
            dataNameList.add(img.getAttributes().get("F_DATANAME").toString());
        }
        DownloadUtil.downloadToFile((String)(order.getFNumber() + ".txt"), (String)String.join((CharSequence)",", dataNameList));
    }

    @Override
    public List<DownloadCheckResultDTO> checkImageDataCanDownload(String orderId, List<String> dataIdArray) {
        ImgOrder io = this.imgOrderDao.selectByPrimaryKey(orderId);
        Assert.notNull((Object)io, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + orderId + "\u7684\u5f71\u50cf\u8ba2\u5355"));
        ImageOrderStatusEnum orderStatus = ImageOrderStatusEnum.getByValue(Integer.parseInt(io.getFStatus()));
        Assert.isTrue((boolean)ImageOrderStatusEnum.Complete.equals((Object)orderStatus), (String)("\u5f53\u524d\u5f71\u50cf\u8ba2\u5355\u72b6\u6001\u4e3a\u3010" + orderStatus.getDesc() + "\u3011\uff0c\u4e0d\u5141\u8bb8\u4e0b\u8f7d\uff01"));
        if (dataIdArray == null || dataIdArray.size() == 0) {
            return new ArrayList<DownloadCheckResultDTO>();
        }
        String[] imgArr = io.getFData().split(",");
        List<String> imgList = this.deleteDuplicate(imgArr);
        ArrayList<DownloadCheckResultDTO> result = new ArrayList<DownloadCheckResultDTO>();
        dataIdArray.forEach(dataId -> {
            DownloadCheckResultDTO checkResult;
            block17: {
                checkResult = new DownloadCheckResultDTO();
                checkResult.setDataId((String)dataId);
                if (!imgList.contains(dataId)) {
                    checkResult.setCanDownload(false);
                    checkResult.setMessage(String.format("\u8ba2\u5355\u3010%s\u3011\u4e0d\u5305\u542b\u5f71\u50cf\u6570\u636e\u3010%s\u3011", io.getFNumber(), dataId));
                } else {
                    try {
                        boolean isWatermark;
                        boolean bl = isWatermark = io.getWatermarkType().intValue() == WatermarkTypeEnum.Watermark.getValue() || io.getWatermarkType().intValue() == WatermarkTypeEnum.Encrypt.getValue();
                        if (isWatermark) {
                            DmFileData fileData = this.fileDataService.getFileData(dataId);
                            Path cachePath = this.getImageDataCacheDir();
                            Path cacheDataDir = Paths.get(cachePath.toString(), io.getFNumber() + "_watermark", fileData.getDataName());
                            File[] files = cacheDataDir.toFile().listFiles();
                            if (files != null && files.length > 0) {
                                File[] subFiles = files[0].listFiles();
                                if (subFiles != null && subFiles.length > 0) {
                                    checkResult.setCanDownload(true);
                                } else {
                                    checkResult.setCanDownload(false);
                                    checkResult.setMessage("\u672a\u68c0\u6d4b\u5230\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                                }
                            } else {
                                checkResult.setCanDownload(false);
                                checkResult.setMessage("\u672a\u68c0\u6d4b\u5230\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                            }
                            break block17;
                        }
                        if (this.imageDataCacheByOrder()) {
                            boolean canDownload = true;
                            try {
                                canDownload = this.fileDataService.fileDataUnitDownloadCheck(dataId, null);
                            }
                            catch (Exception e) {
                                canDownload = false;
                                log.error(e.getMessage(), (Throwable)e);
                            }
                            if (!canDownload) {
                                DmFileData fileData = this.fileDataService.getFileData(dataId);
                                Path cachePath = this.getImageDataCacheDir();
                                Path cacheDataDir = Paths.get(cachePath.toString(), io.getFNumber(), fileData.getDataName());
                                File[] files = cacheDataDir.toFile().listFiles();
                                if (files != null && files.length > 0) {
                                    File[] subFiles = files[0].listFiles();
                                    if (subFiles != null && subFiles.length > 0) {
                                        canDownload = true;
                                    } else {
                                        canDownload = false;
                                        checkResult.setMessage("\u672a\u68c0\u6d4b\u5230\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                                    }
                                } else {
                                    canDownload = false;
                                    checkResult.setMessage("\u672a\u68c0\u6d4b\u5230\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                                }
                            }
                            checkResult.setCanDownload(canDownload);
                            break block17;
                        }
                        Boolean canDownload = this.fileDataService.fileDataUnitDownloadCheck(dataId, null);
                        checkResult.setCanDownload(canDownload);
                    }
                    catch (Exception e) {
                        checkResult.setCanDownload(false);
                        checkResult.setMessage(e.getMessage());
                    }
                }
            }
            result.add(checkResult);
        });
        return result;
    }

    @Override
    public void downloadImageData(String orderId, String dataId) {
        String orderNumber;
        ArrayList<String> dataIdArray = new ArrayList<String>();
        dataIdArray.add(dataId);
        List<DownloadCheckResultDTO> checkResults = this.checkImageDataCanDownload(orderId, dataIdArray);
        Path cachePath = this.getImageDataCacheDir();
        DownloadCheckResultDTO checkResult = checkResults.get(0);
        if (Boolean.TRUE.equals(checkResult.getCanDownload())) {
            ImgOrder io = this.imgOrderDao.selectByPrimaryKey(orderId);
            boolean imageDataCacheByOrder = this.imageDataCacheByOrder();
            String string = orderNumber = imageDataCacheByOrder ? io.getFNumber() : "";
            if (io.getWatermarkType().intValue() == WatermarkTypeEnum.Watermark.getValue() || io.getWatermarkType().intValue() == WatermarkTypeEnum.Encrypt.getValue()) {
                orderNumber = io.getFNumber() + "_watermark";
            }
        } else {
            throw new RuntimeException(String.format("\u8ba2\u5355\u3010%s\u3011\u4e0b\u8f7d\u5f71\u50cf\u6570\u636e\u3010%s\u3011\u5931\u8d25\uff01%s", orderId, dataId, checkResult.getMessage()));
        }
        this.downloadImageData(dataId, orderNumber, cachePath);
    }

    @Override
    public List<String> createDownloadPermit(String orderId, List<String> dataIdArray) {
        LinkedList<String> permitList = new LinkedList<String>();
        List<DownloadCheckResultDTO> checkResults = this.checkImageDataCanDownload(orderId, dataIdArray);
        for (DownloadCheckResultDTO checkResult : checkResults) {
            String orderNumber;
            if (!Boolean.TRUE.equals(checkResult.getCanDownload())) continue;
            String permit = UUID.randomUUID().toString().replace("-", "");
            ImgOrder io = this.imgOrderDao.selectByPrimaryKey(orderId);
            boolean imageDataCacheByOrder = this.imageDataCacheByOrder();
            String string = orderNumber = imageDataCacheByOrder ? io.getFNumber() : "";
            if (io.getWatermarkType().intValue() == WatermarkTypeEnum.Watermark.getValue() || io.getWatermarkType().intValue() == WatermarkTypeEnum.Encrypt.getValue()) {
                orderNumber = io.getFNumber() + "_watermark";
            }
            HashMap<String, String> dataIdOrderMap = new HashMap<String, String>(0);
            dataIdOrderMap.put(checkResult.getDataId(), orderNumber);
            this.downloadPermitMap.put(permit, dataIdOrderMap);
            permitList.add(permit);
        }
        return permitList;
    }

    @Override
    public void downloadImageDataByPermit(String permit) {
        if (this.downloadPermitMap.containsKey(permit)) {
            Path cachePath = this.getImageDataCacheDir();
            Map<String, String> dataIdOrderMap = this.downloadPermitMap.get(permit);
            Iterator<String> iterator = dataIdOrderMap.keySet().iterator();
            if (iterator.hasNext()) {
                String dataId = iterator.next();
                this.downloadImageData(dataId, dataIdOrderMap.get(dataId), cachePath);
                this.downloadPermitMap.remove(permit);
            }
        } else {
            throw new RuntimeException("\u65e0\u6548\u7684\u8bb8\u53ef\uff01");
        }
    }

    private void downloadImageData(String dataId, String orderNumber, Path cachePath) {
        ImgRecycle imgRecycle = this.imageRecycleService.queryByDataId(dataId);
        DmFileData fileData = this.fileDataService.getFileData(dataId);
        if (fileData == null) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + dataId + "\u7684\u5f71\u50cf\u6570\u636e\u5305");
        }
        if (imgRecycle != null) {
            String zipName = fileData.getDataName();
            String tempDir = Paths.get(OutputPathConfig.getOutputPath().toString(), UUID.randomUUID().toString()).toString();
            String srcDir = Paths.get(tempDir, zipName).toString();
            File emptyDir = new File(srcDir);
            boolean success = emptyDir.mkdirs();
            ArrayList<File> srcFiles = new ArrayList<File>();
            srcFiles.add(emptyDir);
            String zipFilePath = Paths.get(tempDir, zipName + ".zip").toString();
            File zipFile = new File(zipFilePath);
            ZipAndRarUtil.onlyZipSrcFileList(srcFiles, (File)zipFile, (String)srcDir);
            DownloadUtil.downloadFile((String)zipFilePath);
            return;
        }
        boolean downloadFromCache = orderNumber.endsWith("_watermark");
        if (!downloadFromCache) {
            boolean canDownloadFromOriginal = false;
            try {
                canDownloadFromOriginal = this.fileDataService.fileDataUnitDownloadCheck(dataId, null);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (canDownloadFromOriginal) {
                this.fileDataService.downloadFileDataUnit(dataId, null);
                return;
            }
        }
        Path cacheDataDir = Paths.get(cachePath.toString(), dataId + "");
        if (StringUtil.isNotEmpty((String)orderNumber)) {
            cacheDataDir = Paths.get(cachePath.toString(), orderNumber, fileData.getDataName());
        }
        String downloadPath = "";
        if (cacheDataDir.toFile().exists()) {
            File[] files = cacheDataDir.toFile().listFiles();
            if (StringUtil.isEmptyOrWhiteSpace((String)orderNumber) && files != null && files.length > 0) {
                downloadPath = files[0].getAbsolutePath();
            }
            if (StringUtil.isNotEmpty((String)orderNumber) && files != null && files.length > 0) {
                File[] subFiles;
                int index = 0;
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().equals(dataId + "")) continue;
                    index = i;
                    break;
                }
                if ((subFiles = files[index].listFiles()) != null && subFiles.length > 0) {
                    downloadPath = subFiles[0].getAbsolutePath();
                }
            }
        }
        if (!StringUtil.isNotEmpty((String)downloadPath)) {
            throw new RuntimeException("\u672a\u68c0\u6d4b\u5230\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        DownloadUtil.downloadFile((String)downloadPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean packageImageData(String dataId, String orderId, Path cachePath) {
        File dataIdDir;
        if (this.packagingImageData.contains(dataId + orderId)) {
            return true;
        }
        Path packagePath = Paths.get(cachePath.toString(), dataId + "");
        if (StringUtil.isNotEmpty((String)orderId)) {
            DmFileData fileData;
            packagePath = Paths.get(cachePath.toString(), orderId);
            if (!packagePath.toFile().exists()) {
                boolean bl = packagePath.toFile().mkdirs();
            }
            if ((fileData = this.fileDataService.getFileData(dataId)) == null) {
                return false;
            }
            packagePath = Paths.get(cachePath.toString(), orderId, fileData.getDataName(), dataId + "");
        }
        if ((dataIdDir = packagePath.toFile()).exists()) {
            return true;
        }
        this.packagingImageData.add(dataId + orderId);
        try {
            if (this.fileDataService.fileDataUnitDownloadCheck(dataId, null).booleanValue()) {
                boolean dirCreated = dataIdDir.mkdirs();
                String targetFilePath = this.fileDataService.packageFileDataUnit(dataId, null, packagePath.toString());
                File targetFile = new File(targetFilePath);
                if (!FileUtil.getDirectoryName((String)targetFile.getAbsolutePath()).equals(dataIdDir.getAbsolutePath())) {
                    FileUtil.copyFile((String)targetFile.getAbsolutePath(), (String)Paths.get(dataIdDir.getAbsolutePath(), FileUtil.getFileName((String)targetFile.getAbsolutePath())).toString());
                }
                boolean bl = true;
                return bl;
            }
            boolean dirCreated = false;
            return dirCreated;
        }
        catch (Exception e) {
            log.error(dataId + "\u6253\u5305\u5931\u8d25!" + e.getMessage(), (Throwable)e);
            if (dataIdDir.exists()) {
                FileUtil.deleteDir((String)dataIdDir.getAbsolutePath());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            String[] files;
            this.packagingImageData.remove(dataId + orderId);
            if (dataIdDir.exists() && ((files = dataIdDir.list()) == null || files.length == 0)) {
                FileUtil.deleteDir((String)dataIdDir.getAbsolutePath());
            }
        }
    }

    private void preparingData(ImgOrder io, WatermarkTypeEnum watermarkType) {
        boolean imageDataCacheByOrder = this.imageDataCacheByOrder();
        if (imageDataCacheByOrder && io.getFStatus().equals(String.valueOf(ImageOrderStatusEnum.Complete.getValue())) && StringUtil.isNotEmpty((String)io.getFData())) {
            String orderNumber = io.getFNumber();
            Path cachePath = this.getImageDataCacheDir();
            if (cachePath.toFile().exists()) {
                String[] imgArr = io.getFData().split(",");
                List<String> imgList = this.deleteDuplicate(imgArr);
                for (String dataId : imgList) {
                    this.threadPoolTaskExecutorData.execute(() -> this.packageImageData(dataId, orderNumber, cachePath));
                }
            }
            return;
        }
        if (watermarkType != WatermarkTypeEnum.None) {
            String orderNumber = io.getFNumber() + "_watermark";
            WatermarkTypeEnum watermarkTypeFinal = watermarkType;
            Path cachePath = this.getImageDataCacheDir();
            AtomicInteger count = new AtomicInteger();
            AtomicInteger successCount = new AtomicInteger();
            if (cachePath.toFile().exists()) {
                String[] imgArr = io.getFData().split(",");
                List<String> imgList = this.deleteDuplicate(imgArr);
                for (String dataId : imgList) {
                    this.threadPoolTaskExecutorData.execute(() -> {
                        try {
                            boolean packageSuccess = this.packageImageData(dataId, orderNumber, cachePath);
                            if (packageSuccess) {
                                successCount.getAndIncrement();
                            }
                        }
                        catch (Exception e) {
                            log.error("\u6253\u5305\u5931\u8d25", (Throwable)e);
                        }
                        count.getAndIncrement();
                    });
                }
                this.threadPoolTaskExecutorData.execute(() -> {
                    while (count.get() < imgList.size()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            log.error("\u7b49\u5f85\u6253\u5305\u7684\u7ebf\u7a0b\u5f02\u5e38", (Throwable)e);
                        }
                    }
                    if (successCount.get() < imgList.size()) {
                        io.setFStatus(String.valueOf(ImageOrderStatusEnum.Fail.getValue()));
                        io.setWatermarkMassage(String.format("\u6570\u636e\u6253\u5305\u5931\u8d25\uff01\u5171%d\u4efd\u6570\u636e\uff0c\u6253\u5305\u6210\u529f%d\u4efd\u6570\u636e", count.get(), successCount.get()));
                        this.imgOrderDao.updateByPrimaryKey(io);
                    } else {
                        String taskId = "";
                        String msg = "";
                        String watermarkUrl = EnvironmentConfig.getProperty((String)"project.watermark-url", (String)"");
                        String agentId = EnvironmentConfig.getProperty((String)"project.watermark-agentId", (String)"");
                        String pathReplaceStr = EnvironmentConfig.getProperty((String)"project.watermark-path-replace", (String)"");
                        String inPath = Paths.get(cachePath.toString(), orderNumber).toAbsolutePath().toString();
                        inPath = inPath.replace(cachePath.toAbsolutePath().toString(), pathReplaceStr);
                        inPath = inPath.replace("\\", "/");
                        switch (watermarkTypeFinal) {
                            case Encrypt: {
                                try {
                                    EncryptTaskCreateParams encryptParams = new EncryptTaskCreateParams();
                                    encryptParams.setUserInfor(io.getFApplyUsername());
                                    encryptParams.setCode(io.getFNumber());
                                    encryptParams.setBeginTime(io.getEncryptStartTime());
                                    if (StringUtil.isNotEmpty((String)io.getEncryptEndTime())) {
                                        encryptParams.setEndTime(io.getEncryptEndTime());
                                        encryptParams.setIsEndTimeNoDeadline(false);
                                    }
                                    encryptParams.setInPath(inPath);
                                    encryptParams.setAgentId(agentId);
                                    taskId = WatermarkUtil.addEncryptTask(watermarkUrl, encryptParams);
                                }
                                catch (Exception e) {
                                    msg = "\u521b\u5efa\u52a0\u5bc6\u4efb\u52a1\u5f02\u5e38\uff1a" + e.getMessage();
                                }
                                break;
                            }
                            case Watermark: {
                                try {
                                    EmbedTaskCreateParams watermarkParams = new EmbedTaskCreateParams();
                                    watermarkParams.setUserInfor(io.getFApplyUsername());
                                    watermarkParams.setCode(io.getFNumber());
                                    watermarkParams.setDistributor(io.getFApplyUsername());
                                    watermarkParams.setDistributionOperator(io.getFApproveUsername());
                                    watermarkParams.setInPath(inPath);
                                    watermarkParams.setAgentId(agentId);
                                    taskId = WatermarkUtil.addEmbedTask(watermarkUrl, watermarkParams);
                                }
                                catch (Exception e) {
                                    msg = "\u521b\u5efa\u6c34\u5370\u4efb\u52a1\u5f02\u5e38\uff1a" + e.getMessage();
                                }
                                break;
                            }
                        }
                        if (StringUtil.isEmptyOrWhiteSpace((String)taskId)) {
                            io.setFStatus(String.valueOf(ImageOrderStatusEnum.Fail.getValue()));
                            io.setWatermarkMassage(msg);
                            this.imgOrderDao.updateByPrimaryKey(io);
                        } else {
                            boolean finished = false;
                            while (!finished) {
                                try {
                                    Thread.sleep(1000L);
                                    WatermarkTask task = WatermarkUtil.getWatermarkTask(watermarkUrl, taskId);
                                    if ("success".equalsIgnoreCase(task.getStatus())) {
                                        io.setFStatus(String.valueOf(ImageOrderStatusEnum.Complete.getValue()));
                                        io.setWatermarkMassage(taskId);
                                        this.imgOrderDao.updateByPrimaryKey(io);
                                        finished = true;
                                        continue;
                                    }
                                    if (!"fail".equalsIgnoreCase(task.getStatus())) continue;
                                    io.setFStatus(String.valueOf(ImageOrderStatusEnum.Fail.getValue()));
                                    io.setWatermarkMassage(taskId + ";\u6c34\u5370\u4efb\u52a1\u5931\u8d25\uff1a" + task.getDataResult());
                                    this.imgOrderDao.updateByPrimaryKey(io);
                                    finished = true;
                                }
                                catch (Exception e) {
                                    io.setFStatus(String.valueOf(ImageOrderStatusEnum.Fail.getValue()));
                                    io.setWatermarkMassage(taskId + ";\u83b7\u53d6\u6c34\u5370\u4efb\u52a1\u8be6\u60c5\u5f02\u5e38\uff1a" + e.getMessage());
                                    this.imgOrderDao.updateByPrimaryKey(io);
                                    finished = true;
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    private Path getImageDataCacheDir() {
        Path cachePath = Paths.get(EnvironmentConfig.getProperty((String)"project.image-data-cache-path", (String)"imageDataCache"), new String[0]);
        try {
            File file = cachePath.toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u6570\u636e\u4e0b\u8f7d\u7f13\u5b58\u76ee\u5f55\u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
        return cachePath;
    }

    private boolean imageDataCacheByOrder() {
        return Boolean.parseBoolean(EnvironmentConfig.getProperty((String)"project.image-data-cache-by-order", (String)"false"));
    }
}

