/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.user;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.properties.UserRightProperties;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.adf.gis.geosrv.util.HttpClientUtil;
import com.geoway.imagedb.apply.user.LoginUserInfoWithDep;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Primary
@Service
public class UserInfoService
implements LoginUserService {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Value(value="${project.loginUserUrl}")
    private String userUrl;
    @Resource
    private UserRightProperties userRightProperties;
    private Cache<String, String> departmentCache;
    private Cache<String, LoginUserInfoWithDep> userCache;
    private Cache<String, LoginUserInfoWithDep> tempTokenCache;

    public String getFinalToken() {
        return "b38d703d-7308-4c2b-996c-82932f81744a";
    }

    public void addFinalUserCache(String token, LoginUserInfoWithDep userInfo) {
        this.userCache.put((Object)token, (Object)userInfo);
        this.departmentCache.put((Object)userInfo.getUserId(), (Object)userInfo.getDepartment());
    }

    public void removeTempUserCache(String token) {
        this.userCache.invalidate((Object)token);
    }

    @Autowired
    public void initCache() {
        this.departmentCache = Caffeine.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).maximumSize(10000L).build();
        this.userCache = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(10000L).build();
        String tempTokenTimeout = EnvironmentConfig.getProperty((String)"temp-token-timeout", (String)"1800");
        long tempTokenTimeoutSeconds = Long.parseLong(tempTokenTimeout);
        this.tempTokenCache = Caffeine.newBuilder().expireAfterWrite(tempTokenTimeoutSeconds, TimeUnit.SECONDS).maximumSize(10000L).build();
    }

    public LoginUserInfoWithDep getUserInfo(HttpServletRequest request) {
        String token;
        if (request == null) {
            ServletRequestAttributes servletRequestAttributes2 = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            request = servletRequestAttributes2.getRequest();
        }
        if ((token = request.getHeader("Satoken")) == null || token.isEmpty()) {
            this.log.info("\u8bf7\u6c42\u5934\u672a\u8bbe\u7f6eaccess-token");
            LoginUserInfoWithDep userInfo = new LoginUserInfoWithDep();
            userInfo.setUserId("-1");
            userInfo.setUserName("\u6e38\u5ba2");
            userInfo.setRoleId("-1");
            userInfo.setXzqdm("-1");
            userInfo.setDepartment("\u65e0");
            return userInfo;
        }
        if (!this.userUrl.endsWith("/")) {
            this.userUrl = this.userUrl + "/";
        }
        LoginUserInfoWithDep userInfo = this.getUserInfoWithDep(token);
        userInfo = this.setUserDep(token, userInfo);
        return userInfo;
    }

    private LoginUserInfoWithDep getUserInfoWithDep(String token) {
        LoginUserInfoWithDep cacheUserInfo = (LoginUserInfoWithDep)((Object)this.userCache.getIfPresent((Object)token));
        if (cacheUserInfo != null) {
            return cacheUserInfo;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Satoken", token);
        Date startTime = new Date();
        String result = HttpClientUtil.doGet((String)(this.userUrl + "userinfo"), null, header, (int)5000);
        System.out.println("\u7528\u6237\u4fe1\u606f\u8017\u65f6\uff1a" + DateTimeUtil.getTimeIntervalStr((Date)startTime, (Date)new Date()));
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (!resultJson.getString("status").equals("OK")) {
            String error = resultJson.getString("message");
            RuntimeException re = new RuntimeException(error == null ? "\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25" : error);
            HttpServerErrorException errorException = new HttpServerErrorException(HttpStatus.UNAUTHORIZED, re.getMessage());
            errorException.initCause((Throwable)re);
            throw errorException;
        }
        JSONObject userJson = resultJson.getJSONObject("data");
        LoginUserInfoWithDep userInfo = new LoginUserInfoWithDep();
        String username = userJson.getString("username");
        userInfo.setUserName(username);
        userInfo.setUserId(userJson.getString("id"));
        JSONArray roleObjList = userJson.getJSONArray("roles");
        if (roleObjList != null) {
            ArrayList<String> roleList = new ArrayList<String>();
            for (int i = 0; i < roleObjList.size(); ++i) {
                roleList.add(roleObjList.getJSONObject(i).getString("id"));
            }
            userInfo.setRoleId(String.join((CharSequence)",", roleList));
        }
        this.userCache.put((Object)token, (Object)userInfo);
        return userInfo;
    }

    private LoginUserInfoWithDep setUserDep(String token, LoginUserInfoWithDep userInfo) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Satoken", token);
        userInfo.setDepartment("\u65e0");
        String department = (String)this.departmentCache.getIfPresent((Object)userInfo.getUserId());
        if (department != null) {
            userInfo.setDepartment(department);
            return userInfo;
        }
        String usersUrl = String.format("%ssysAuth/getUsers?key=%s&pageIndex=0&rows=100&state=&orderDirections=desc&orderFields=createTime", this.userUrl, userInfo.getUserName());
        String result = HttpClientUtil.doGet((String)usersUrl, null, header, (int)5000);
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (!resultJson.getString("status").equals("OK")) {
            String error = resultJson.getString("message");
            this.log.error("\u83b7\u53d6\u7528\u6237\u7684\u90e8\u95e8\u673a\u6784\u4fe1\u606f\u5931\u8d25\uff1a" + error);
            return userInfo;
        }
        JSONArray usersObjList = resultJson.getJSONArray("data");
        for (int i = 0; i < usersObjList.size(); ++i) {
            JSONObject currUser = usersObjList.getJSONObject(i);
            JSONArray deps = currUser.getJSONArray("departments");
            String dep = "\u65e0";
            if (deps != null && deps.size() > 0) {
                dep = deps.getJSONObject(0).getString("name");
            }
            this.departmentCache.put((Object)currUser.getString("id"), (Object)dep);
            if (!currUser.getString("name").equals(userInfo.getUserName())) continue;
            userInfo.setDepartment(dep);
            return userInfo;
        }
        return userInfo;
    }

    public LoginUserInfoWithDep getUserInfo() {
        return this.getUserInfo(null);
    }

    public String getTempToken() {
        LoginUserInfoWithDep userInfo = new LoginUserInfoWithDep();
        userInfo.setUserId("-3");
        userInfo.setRoleId(this.userRightProperties.getAdminRoleId());
        userInfo.setDepartment("\u7b2c\u4e09\u65b9");
        String token = UUID.randomUUID().toString();
        this.tempTokenCache.put((Object)token, (Object)userInfo);
        return token;
    }

    public Boolean isAdmin(LoginUserInfo userInfo) {
        if (userInfo == null) {
            this.getUserInfo();
        }
        String currentRoles = userInfo.getRoleId();
        currentRoles = "," + currentRoles + ",";
        String adminRoles = this.userRightProperties.getAdminRoleId();
        if (StringUtils.endsWith((CharSequence)adminRoles, (CharSequence)",")) {
            adminRoles = adminRoles.substring(0, adminRoles.length() - 1);
        }
        String[] adminRoleArr = adminRoles.split(",");
        for (int i = 0; i < adminRoleArr.length; ++i) {
            if (adminRoleArr[i].isEmpty() || currentRoles.indexOf("," + adminRoleArr[i] + ",") <= -1) continue;
            return true;
        }
        return false;
    }

    public String checkTokenWithRequest(HttpServletRequest request, String urlToken) {
        String token = request.getHeader("Satoken");
        if (StringUtil.isEmptyOrWhiteSpace((String)token)) {
            token = urlToken;
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)token)) {
            RuntimeException re = new RuntimeException("\u672a\u6307\u5b9aSatoken");
            HttpServerErrorException errorException = new HttpServerErrorException(HttpStatus.UNAUTHORIZED, re.getMessage());
            errorException.initCause((Throwable)re);
            throw errorException;
        }
        if (this.getFinalToken().equals(token)) {
            LoginUserInfoWithDep userInfo = new LoginUserInfoWithDep();
            userInfo.setUserId("-3");
            userInfo.setUserName("");
            userInfo.setRoleId(this.userRightProperties.getAdminRoleId());
            userInfo.setDepartment("\u7b2c\u4e09\u65b9");
            this.addFinalUserCache(token, userInfo);
            return token;
        }
        LoginUserInfoWithDep cacheUserInfo = (LoginUserInfoWithDep)((Object)this.tempTokenCache.getIfPresent((Object)token));
        if (cacheUserInfo != null) {
            return token;
        }
        if (!this.userUrl.endsWith("/")) {
            this.userUrl = this.userUrl + "/";
        }
        try {
            String result = HttpClientUtil.doGet((String)String.format("%scheckLogin?satoken=%s", this.userUrl, token), null, null, (int)5000);
            JSONObject resultJson = JSONObject.parseObject((String)result);
            if (!resultJson.getString("status").equals("OK")) {
                String error = resultJson.getString("message");
                this.throwUnauthorizedException(error == null ? "\u5f53\u524d\u7528\u6237\u672a\u767b\u5f55\uff01" : error);
            }
            return token;
        }
        catch (Exception e) {
            this.log.error("\u9a8c\u8bc1\u7528\u6237\u767b\u5f55\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
            this.throwUnauthorizedException("\u9a8c\u8bc1\u7528\u6237\u767b\u5f55\u4fe1\u606f\u5931\u8d25\uff01" + e.getMessage());
            return "";
        }
    }

    private void throwUnauthorizedException(String error) {
        RuntimeException re = new RuntimeException(error);
        HttpServerErrorException errorException = new HttpServerErrorException(HttpStatus.UNAUTHORIZED, re.getMessage());
        errorException.initCause((Throwable)re);
        throw errorException;
    }

    public String checkToken() {
        ServletRequestAttributes servletRequestAttributes2 = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes2.getRequest();
        return this.checkTokenWithRequest(request, null);
    }
}

