/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import cn.hutool.core.date.DateUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamGroupDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.datum.ThumbDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.ThumbService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.imagedb.apply.component.IMEServiceHelper;
import com.geoway.imagedb.apply.dto.daily.DailyImageDTO;
import com.geoway.imagedb.apply.dto.daily.DailyImageQueryResult;
import com.geoway.imagedb.apply.dto.daily.DailyImageResult;
import com.geoway.imagedb.apply.service.DailyImageQueryService;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import com.geoway.webstore.datamodel.entity.InputSpatialData;
import com.geoway.webstore.datamodel.service.InputSpatialDataService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DailyImageQueryServiceImpl
implements DailyImageQueryService {
    private static final Logger log = LoggerFactory.getLogger(DailyImageQueryServiceImpl.class);
    @Resource
    private InputSpatialDataService inputSpatialDataService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private SysParamsService sysParamsService;
    @Resource
    private ThumbService thumbService;
    @Resource
    private IMEServiceHelper imeServiceHelper;
    private final String dailyImageService = "DailyImageService";
    private Cache<String, Map<String, Set<String>>> resultCache;

    @Autowired
    public void initCache() {
        this.resultCache = Caffeine.newBuilder().expireAfterWrite(10000L, TimeUnit.MILLISECONDS).maximumSize(10000L).build();
    }

    @Override
    public DailyImageQueryResult query(Double xMin, Double xMax, Double yMin, Double yMax) {
        IEnvelope envelope = GeometryFunc.createEnvelope((double)xMin, (double)yMin, (double)xMax, (double)yMax);
        Assert.notNull((Object)envelope, (String)"\u67e5\u8be2\u8303\u56f4\u5f02\u5e38\uff01");
        String serviceUrl = this.getDailyImageServiceUrl();
        DailyImageQueryResult result = new DailyImageQueryResult();
        DatasetRenderDTO render = new DatasetRenderDTO();
        render.setUrl(serviceUrl);
        render.setServiceType(Integer.valueOf(ServiceType.DTileService.getValue()));
        result.setRender(render);
        String key = "DailyImage";
        Map<String, Set<String>> dbKeyLayerMap = (Map<String, Set<String>>)this.resultCache.getIfPresent((Object)key);
        if (dbKeyLayerMap == null) {
            dbKeyLayerMap = this.imeServiceHelper.getGeoDatabaseLayers(serviceUrl);
            if (dbKeyLayerMap.size() == 0) {
                List inputSpatialDatalist = this.inputSpatialDataService.getInputSpatialDatas(null, null, new ArrayList());
                if (inputSpatialDatalist == null || inputSpatialDatalist.size() == 0) {
                    return result;
                }
                Map<String, List<InputSpatialData>> group = inputSpatialDatalist.stream().collect(Collectors.groupingBy(InputSpatialData::getDbKey));
                for (String dbKey : group.keySet()) {
                    List dataList = ListUtil.findAll(group.get(dbKey), f -> "DOM".equalsIgnoreCase(f.getDataType()) || "DEM".equalsIgnoreCase(f.getDataType()));
                    if (dataList == null || dataList.size() == 0) continue;
                    LinkedHashSet<String> nameList = new LinkedHashSet<String>();
                    for (InputSpatialData data : dataList) {
                        nameList.add(data.getPhysicalDatasetName());
                    }
                    dbKeyLayerMap.put(dbKey, nameList);
                }
            }
            this.resultCache.put((Object)key, dbKeyLayerMap);
        }
        QueryFilterDTO filter = new QueryFilterDTO();
        filter.setGeometry(envelope.toWkt());
        filter.setReturnGeometry(Boolean.valueOf(false));
        filter.setRows(Integer.valueOf(10000));
        ArrayList<DailyImageDTO> imageList = new ArrayList<DailyImageDTO>();
        for (String dsKey : dbKeyLayerMap.keySet()) {
            for (String tableName : dbKeyLayerMap.get(dsKey)) {
                DataQueryResult queryResult = this.geoDatabaseService.queryGeoDataset(dsKey, tableName, filter);
                imageList.addAll(this.convertDailyImage(queryResult));
            }
        }
        if (imageList.size() == 0) {
            return result;
        }
        Map<Date, List<DailyImageDTO>> timeGroup = imageList.stream().collect(Collectors.groupingBy(DailyImageDTO::getTime));
        ArrayList<DailyImageResult> timeline = new ArrayList<DailyImageResult>();
        for (Date time : timeGroup.keySet()) {
            DailyImageResult dailyImageResult = new DailyImageResult();
            dailyImageResult.setTime(time);
            dailyImageResult.setImages(timeGroup.get(time));
            List<DailyImageDTO> list = timeGroup.get(time);
            list.sort(Comparator.comparing(DailyImageDTO::getResolution));
            timeline.add(dailyImageResult);
        }
        timeline.sort(Comparator.comparing(DailyImageResult::getTime));
        result.setTimeline(timeline);
        return result;
    }

    @Override
    public DataQueryResult detail(String geometry, List<String> datasetIdArray, String time) {
        ThumbDTO thumb;
        Date date = ImageDateUtil.parse((String)time);
        String timeStr = DateUtil.format((Date)date, (String)"yyyy-MM-dd");
        List inputDataList = this.inputSpatialDataService.getInputSpatialDataByTime(timeStr);
        if (inputDataList == null || inputDataList.size() == 0) {
            throw new RuntimeException(String.format("[%s]\u65e0\u5f71\u50cf\u6570\u636e\uff01", timeStr));
        }
        QueryFilterDTO filter = new QueryFilterDTO();
        filter.setGeometry(geometry);
        filter.setCondition(String.format("%s = '%s'", "F_TIME", timeStr));
        filter.setReturnGeometry(Boolean.valueOf(false));
        List nameList = ListUtil.convertAll(datasetIdArray, f -> {
            DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)f);
            return nameInfo.getShortName().toLowerCase(Locale.ROOT);
        });
        InputSpatialData targetInputSpatialData = null;
        DailyImageDTO targetDailyImage = null;
        Double resolution = Double.MAX_VALUE;
        for (InputSpatialData inputSpatialData : inputDataList) {
            String dsKey;
            DataQueryResult queryResult;
            List<DailyImageDTO> imageList;
            if (!nameList.contains(inputSpatialData.getPhysicalDatasetName().toLowerCase(Locale.ROOT)) || (imageList = this.convertDailyImage(queryResult = this.geoDatabaseService.queryGeoDataset(dsKey = inputSpatialData.getDbKey(), inputSpatialData.getPhysicalDatasetName(), filter))).size() <= 0 || !(imageList.get(0).getResolution() < resolution)) continue;
            resolution = imageList.get(0).getResolution();
            targetInputSpatialData = inputSpatialData;
            targetDailyImage = imageList.get(0);
        }
        if (targetDailyImage == null) {
            throw new RuntimeException(String.format("[%s]\u65e0\u5f71\u50cf\u6570\u636e\uff01", timeStr));
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)targetInputSpatialData.getMetaTableName())) {
            throw new RuntimeException(String.format("[%s]\u65e0\u5f71\u50cf\u5143\u6570\u636e\uff01", timeStr));
        }
        String metaDataIdFilter = String.format("%s = '%s'", targetInputSpatialData.getOidFieldName(), targetInputSpatialData.getMetaDataId());
        QueryFilterDTO queryFilter = new QueryFilterDTO();
        queryFilter.setCondition(metaDataIdFilter);
        DataQueryResult queryResult = this.geoDatabaseService.queryGeoDataset(targetInputSpatialData.getDbKey(), targetInputSpatialData.getMetaTableName(), queryFilter);
        if (queryResult != null && queryResult.getData() != null && queryResult.getData().size() > 0 && (thumb = this.thumbService.queryThumb(String.format("%s-%s-%s", targetDailyImage.getDatasetId(), targetDailyImage.getObjectId(), 512))) != null) {
            ((FeatureResult)queryResult.getData().get(0)).getAttributes().put("F_THUMB", thumb.getImageBase64());
        }
        return queryResult;
    }

    private List<DailyImageDTO> convertDailyImage(DataQueryResult queryResult) {
        ArrayList<DailyImageDTO> imageList = new ArrayList<DailyImageDTO>();
        if (queryResult != null && queryResult.getData() != null && queryResult.getData().size() > 0) {
            for (FeatureResult featureResult : queryResult.getData()) {
                Object timeObject = featureResult.getAttributes().get("F_TIME");
                Object mapNumberObject = featureResult.getAttributes().get("f_frame");
                Object resolutionObject = featureResult.getAttributes().get("lowps");
                if (timeObject == null || mapNumberObject == null || resolutionObject == null) continue;
                DailyImageDTO dailyImage = new DailyImageDTO();
                try {
                    dailyImage.setTime(ImageDateUtil.parse((String)timeObject.toString()));
                }
                catch (Exception e) {
                    log.error("\u65e0\u6548\u7684\u65f6\u76f8" + e.getMessage(), (Throwable)e);
                    continue;
                }
                dailyImage.setDatasetId(queryResult.getId());
                dailyImage.setDatasetName(queryResult.getName());
                dailyImage.setMapNumber(mapNumberObject.toString());
                dailyImage.setResolution(Double.parseDouble(resolutionObject.toString()));
                dailyImage.setObjectId(featureResult.getObjectId().toString());
                imageList.add(dailyImage);
            }
        }
        return imageList;
    }

    private String getDailyImageServiceUrl() {
        SysParamGroupDTO sysParamGroup = this.sysParamsService.getGroupDetail("DailyImageService");
        Assert.notNull((Object)sysParamGroup, (String)"\u672a\u8bbe\u7f6e\u65e5\u65b0\u56fe\u7cfb\u7edf\u53c2\u6570\uff01");
        if (sysParamGroup.getParams() == null || sysParamGroup.getParams().size() == 0) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u65e5\u65b0\u56fe\u670d\u52a1\u5730\u5740\uff01");
        }
        return ((SysParamDTO)sysParamGroup.getParams().get(0)).getValue();
    }
}

