/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import cn.hutool.core.util.IdUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.imagedb.apply.dao.ImgApplyGroupDao;
import com.geoway.imagedb.apply.dto.apply.ImageApplyCreateDTO;
import com.geoway.imagedb.apply.dto.apply.ImageApplyVO;
import com.geoway.imagedb.apply.entity.ImgApplyGroup;
import com.geoway.imagedb.apply.service.ImageApplyService;
import com.geoway.imagedb.apply.user.LoginUserInfoWithDep;
import com.geoway.imagedb.apply.user.UserInfoService;
import com.geoway.imagedb.dataset.dto.ImgPageList;
import com.geoway.imagedb.dataset.dto.query.ImageQueryResult;
import com.geoway.imagedb.dataset.dto.query.ImageResult;
import com.geoway.imagedb.dataset.service.ImageQueryService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class ImageApplyServiceImpl
implements ImageApplyService {
    @Resource
    private ImgApplyGroupDao imgApplyGroupDao;
    @Resource
    private ImageQueryService imageQueryService;
    @Resource
    private UserInfoService userInfoService;

    @Override
    public String createImageApply(ImageApplyCreateDTO createDTO) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        ImgApplyGroup iag = new ImgApplyGroup();
        iag.setFId(IdUtil.getSnowflakeNextIdStr());
        iag.setFName(createDTO.getName());
        iag.setFDesc(createDTO.getDesc());
        if (!org.apache.commons.lang3.StringUtils.startsWith((CharSequence)createDTO.getData(), (CharSequence)",")) {
            createDTO.setData("," + createDTO.getData());
        }
        if (!org.apache.commons.lang3.StringUtils.endsWith((CharSequence)createDTO.getData(), (CharSequence)",")) {
            createDTO.setData(createDTO.getData() + ",");
        }
        iag.setFData(createDTO.getData());
        iag.setFCreatetime(new Date());
        iag.setFCreateuser(user.getUserId());
        this.imgApplyGroupDao.insert(iag);
        return iag.getFId();
    }

    @Override
    public PageList<ImageApplyVO> getImageApplyList(Integer pageIndex, Integer rows) {
        PageHelper.startPage((int)(pageIndex + 1), (int)rows);
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        List<ImgApplyGroup> list = this.imgApplyGroupDao.selectByUser(user.getUserId());
        PageInfo pageInfo = new PageInfo(list);
        List imangeApplyVo = ListUtil.convertAll(list, t -> {
            ImageApplyVO vo = new ImageApplyVO();
            vo.setId(t.getFId());
            vo.setName(t.getFName());
            vo.setDesc(t.getFDesc());
            vo.setApply_time(t.getFCreatetime());
            return vo;
        });
        return new PageList(imangeApplyVo, Long.valueOf(pageInfo.getTotal()));
    }

    @Override
    public void delImageApply(String ids) {
        Assert.hasLength((String)ids, (String)"\u8bf7\u9009\u62e9\u5f71\u50cf\u7533\u8bf7");
        String[] idArr = ids.split(",");
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        for (int i = 0; i < idArr.length; ++i) {
            ImgApplyGroup ig = this.imgApplyGroupDao.selectByPrimaryKey(idArr[i]);
            Assert.notNull((Object)ig, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + idArr[i] + "\u7684\u5f71\u50cf\u7533\u8bf7"));
            Assert.isTrue((boolean)ig.getFCreateuser().equals(user.getUserId()), (String)("\u6807\u8bc6\u4e3a" + idArr[i] + "\u7684\u5f71\u50cf\u7533\u8bf7\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237"));
            this.imgApplyGroupDao.deleteByPrimaryKey(idArr[i]);
        }
    }

    @Override
    public ImgPageList<ImageResult> getImageList(String applyId, Integer pageIndex, Integer rows, Integer size) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        String[] applyIdArr = applyId.trim().split(",");
        StringBuilder sb = new StringBuilder();
        ImgApplyGroup ig = null;
        String img = "";
        for (int i = 0; i < applyIdArr.length; ++i) {
            if (applyIdArr[i].trim().isEmpty()) continue;
            ig = this.imgApplyGroupDao.selectByPrimaryKey(applyIdArr[i]);
            Assert.notNull((Object)ig, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + applyIdArr[i] + "\u7684\u5f71\u50cf\u7533\u8bf7"));
            Assert.isTrue((boolean)ig.getFCreateuser().equals(user.getUserId()), (String)("\u6807\u8bc6\u4e3a" + applyIdArr[i] + "\u7684\u5f71\u50cf\u7533\u8bf7\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237"));
            img = StringUtils.trimLeadingCharacter((String)ig.getFData(), (char)',');
            img = StringUtils.trimTrailingCharacter((String)img, (char)',');
            sb.append(img).append(",");
        }
        return this.innerGetImageList(sb.toString(), pageIndex, rows, size, true);
    }

    private List<String> deleteDuplicate(String[] imgArr) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String str : imgArr) {
            if (str.trim().isEmpty()) continue;
            set.add(str);
        }
        return new ArrayList<String>(set);
    }

    private ImgPageList<ImageResult> innerGetImageList(String ids, Integer pageIndex, Integer rows, Integer size, boolean dd) {
        String[] imgArr = ids.split(",");
        List<String> imgList = this.deleteDuplicate(imgArr);
        ImageQueryResult result = this.imageQueryService.queryByDataIds(imgList, size);
        Double sum = result.getData().size() == 0 ? Double.valueOf(0.0) : result.getData().stream().map(n -> Double.valueOf(n.getAttributes().get("F_DATASIZE").toString())).reduce(Double::sum).get();
        return new ImgPageList(cn.hutool.core.collection.ListUtil.page((int)pageIndex, (int)rows, (List)result.getData()), result.getTotal(), Integer.valueOf(sum.intValue()));
    }

    private PageList<ImageResult> innerGetImageList2(String ids, Integer pageIndex, Integer rows, Integer size, boolean dd) {
        String img = StringUtils.trimLeadingCharacter((String)ids, (char)',');
        img = StringUtils.trimTrailingCharacter((String)img, (char)',');
        Object imgArr = img.split(",");
        if (dd) {
            // empty if block
        }
        Long imgNumber = ((String[])imgArr).length;
        if (img.isEmpty()) {
            imgNumber = 0L;
        }
        if ((imgArr = ((String[])imgArr).length > pageIndex * rows && !img.isEmpty() ? Arrays.copyOfRange(imgArr, pageIndex * rows, (pageIndex + 1) * rows > ((String[])imgArr).length ? ((String[])imgArr).length : (pageIndex + 1) * rows) : null) != null && ((String[])imgArr).length > 0) {
            List imgList = Arrays.stream(imgArr).collect(Collectors.toList());
            return new PageList(this.imageQueryService.queryByDataIds(imgList, size).getData(), imgNumber);
        }
        return new PageList(new ArrayList(), imgNumber);
    }

    @Override
    public void delImage(String applyId, String ids) {
        Assert.hasLength((String)ids, (String)"\u8bf7\u9009\u62e9\u5f71\u50cf");
        String[] idArr = ids.split(",");
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        ImgApplyGroup ig = this.imgApplyGroupDao.selectByPrimaryKey(applyId);
        Assert.notNull((Object)ig, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + applyId + "\u7684\u5f71\u50cf\u7533\u8bf7"));
        Assert.isTrue((boolean)ig.getFCreateuser().equals(user.getUserId()), (String)("\u6807\u8bc6\u4e3a" + applyId + "\u7684\u5f71\u50cf\u7533\u8bf7\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237"));
        String imgIds = ig.getFData();
        for (int i = 0; i < idArr.length; ++i) {
            imgIds = imgIds.replace("," + idArr[i] + ",", ",");
        }
        ig.setFData(imgIds);
        this.imgApplyGroupDao.updateByPrimaryKey(ig);
    }
}

