/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.listener;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.imagedb.apply.dao.ImgOrderImgDao;
import com.geoway.imagedb.apply.entity.ImgOrderImg;
import com.geoway.imagedb.dataset.event.ImageDatasetFieldValueAfterUpdateEvent;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ImageDatasetFieldValueAfterUpdateEventListener
implements ApplicationListener<ImageDatasetFieldValueAfterUpdateEvent> {
    private static final Logger log = LoggerFactory.getLogger(ImageDatasetFieldValueAfterUpdateEventListener.class);
    @Resource
    private ImgOrderImgDao imgOrderImgDao;

    public void onApplicationEvent(ImageDatasetFieldValueAfterUpdateEvent event) {
        String dataId = event.getDataId();
        Map sysCanEditData = event.getSysCanEditData();
        List<ImgOrderImg> orderImgList = this.imgOrderImgDao.selectByDataId(dataId);
        if (orderImgList != null && orderImgList.size() > 0) {
            ImgOrderImg orderImg = orderImgList.get(0);
            for (String fieldName : sysCanEditData.keySet()) {
                if ("f_satellite".equalsIgnoreCase(fieldName) || "f_classification".equalsIgnoreCase(fieldName)) {
                    orderImg.setFSatellite(sysCanEditData.get(fieldName) == null ? "" : sysCanEditData.get(fieldName).toString());
                }
                if ("f_sensor".equalsIgnoreCase(fieldName)) {
                    orderImg.setFSensor(sysCanEditData.get(fieldName) == null ? "" : sysCanEditData.get(fieldName).toString());
                }
                if ("f_product_time".equalsIgnoreCase(fieldName) || "f_time".equalsIgnoreCase(fieldName)) {
                    String productTime = sysCanEditData.get(fieldName) == null ? null : sysCanEditData.get(fieldName).toString();
                    orderImg.setFProductTime(StringUtil.isEmptyOrWhiteSpace((String)productTime) ? null : ImageDateUtil.parse((String)sysCanEditData.get(fieldName).toString()));
                }
                if (!"f_cloud".equalsIgnoreCase(fieldName)) continue;
                orderImg.setFCloud(sysCanEditData.get(fieldName) == null ? 0 : Integer.parseInt(sysCanEditData.get(fieldName).toString()));
            }
            this.imgOrderImgDao.updateByDataId(orderImg);
        }
    }
}

