/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.imagedb.apply.dto.statistic.DistributeStatisticFilterDTO;
import com.geoway.imagedb.apply.dto.statistic.ImageStatisticResultDTO;
import com.geoway.imagedb.apply.dto.statistic.RepertoryStatisticFilterDTO;
import com.geoway.imagedb.apply.service.ImageStatisticService;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dto.query.TimeFilterDTO;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ImageStatisticServiceImpl
implements ImageStatisticService {
    private static final Logger log = LoggerFactory.getLogger(ImageStatisticServiceImpl.class);
    @Resource
    private ImageDatasetService imageDatasetService;

    @Override
    public ImageStatisticResultDTO repertoryStatistic(RepertoryStatisticFilterDTO filterDTO) {
        ImageDatasetTypeEnum imageType = ImageDatasetTypeEnum.getByValue((Integer)filterDTO.getImageType());
        ImageStatisticResultDTO resultDTO = new ImageStatisticResultDTO();
        ArrayList<ReturnField> displayFields = new ArrayList<ReturnField>();
        if (filterDTO.getStatisticType() == 3 || filterDTO.getStatisticType() == 4) {
            displayFields.add(new ReturnField("name", "\u65f6\u95f4"));
        }
        switch (imageType) {
            case OriginalImageDataset: 
            case ProcessedImageDataset: {
                if (filterDTO.getStatisticType() == 2) {
                    displayFields.add(new ReturnField("name", "\u6570\u636e\u7c7b\u578b"));
                }
                displayFields.add(new ReturnField("count", "\u6570\u636e\u91cf\uff08\u666f\uff09"));
                displayFields.add(new ReturnField("dataSize", "\u6570\u636e\u5927\u5c0f\uff08GB\uff09"));
                displayFields.add(new ReturnField("coverArea", "\u8986\u76d6\u9762\u79ef\uff08KM2\uff09"));
                resultDTO.setStatResults(this.statisticImageBusiness(filterDTO, imageType));
                break;
            }
            case ImageSampleImageDataset: 
            case TileSampleImageDataset: {
                if (filterDTO.getStatisticType() == 2) {
                    displayFields.add(new ReturnField("name", "\u5206\u7c7b\u65b9\u6848"));
                }
                displayFields.add(new ReturnField("count", "\u6837\u672c\u6570\u91cf"));
                displayFields.add(new ReturnField("dataSize", "\u6570\u636e\u5927\u5c0f\uff08GB\uff09"));
                resultDTO.setStatResults(this.statisticSampleTable(filterDTO, imageType));
                break;
            }
            default: {
                if (filterDTO.getStatisticType() == 2) {
                    displayFields.add(new ReturnField("name", "\u4ea7\u54c1\u7c7b\u578b"));
                }
                displayFields.add(new ReturnField("count", "\u4ea7\u54c1\u6570\u91cf"));
                displayFields.add(new ReturnField("dataSize", "\u6570\u636e\u5927\u5c0f\uff08GB\uff09"));
                resultDTO.setStatResults(new ArrayList<Map<String, Object>>());
            }
        }
        resultDTO.setFields(displayFields);
        return resultDTO;
    }

    @Override
    public ImageStatisticResultDTO distributeStatistic(DistributeStatisticFilterDTO filterDTO) {
        ImageDatasetTypeEnum imageType = ImageDatasetTypeEnum.getByValue((Integer)filterDTO.getImageType());
        ImageStatisticResultDTO resultDTO = new ImageStatisticResultDTO();
        ArrayList<ReturnField> displayFields = new ArrayList<ReturnField>();
        if (filterDTO.getStatisticType() == 3 || filterDTO.getStatisticType() == 4) {
            displayFields.add(new ReturnField("name", "\u65f6\u95f4"));
        } else if (filterDTO.getStatisticType() == 1) {
            displayFields.add(new ReturnField("name", "\u5206\u53d1\u5355\u4f4d"));
        }
        switch (imageType) {
            case OriginalImageDataset: 
            case ProcessedImageDataset: {
                if (filterDTO.getStatisticType() == 2) {
                    displayFields.add(new ReturnField("name", "\u6570\u636e\u7c7b\u578b"));
                }
                displayFields.add(new ReturnField("count", "\u6570\u636e\u91cf\uff08\u666f\uff09"));
                displayFields.add(new ReturnField("dataSize", "\u6570\u636e\u5927\u5c0f\uff08GB\uff09"));
                displayFields.add(new ReturnField("coverArea", "\u8986\u76d6\u9762\u79ef\uff08KM2\uff09"));
                resultDTO.setStatResults(this.distributeStatistic(filterDTO, imageType));
                break;
            }
            case ImageSampleImageDataset: 
            case TileSampleImageDataset: {
                if (filterDTO.getStatisticType() == 2) {
                    displayFields.add(new ReturnField("name", "\u5206\u7c7b\u65b9\u6848"));
                }
                displayFields.add(new ReturnField("count", "\u6837\u672c\u6570\u91cf"));
                displayFields.add(new ReturnField("dataSize", "\u6570\u636e\u5927\u5c0f\uff08GB\uff09"));
                resultDTO.setStatResults(new ArrayList<Map<String, Object>>());
                break;
            }
            default: {
                if (filterDTO.getStatisticType() == 2) {
                    displayFields.add(new ReturnField("name", "\u4ea7\u54c1\u7c7b\u578b"));
                }
                displayFields.add(new ReturnField("count", "\u4ea7\u54c1\u6570\u91cf"));
                displayFields.add(new ReturnField("dataSize", "\u6570\u636e\u5927\u5c0f\uff08GB\uff09"));
                resultDTO.setStatResults(new ArrayList<Map<String, Object>>());
            }
        }
        resultDTO.setFields(displayFields);
        return resultDTO;
    }

    @Override
    public void exportStatisticResult(ImageStatisticResultDTO resultDTO) {
        String fileName = ImageDateUtil.format((Date)new Date(), (String)"yyyyMMddHH:mm") + ".xls";
        ArrayList datas = new ArrayList();
        LinkedList<String> title = new LinkedList<String>();
        for (ReturnField returnField : resultDTO.getFields()) {
            title.add(returnField.getAlias());
        }
        datas.add(title);
        for (Map map : resultDTO.getStatResults()) {
            LinkedList data = new LinkedList();
            for (ReturnField returnField : resultDTO.getFields()) {
                Object value = map.get(returnField.getName());
                data.add(value);
            }
            datas.add(data);
        }
        DownloadUtil.downloadExcelFile((String)fileName, datas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> statisticImageBusiness(RepertoryStatisticFilterDTO filterDTO, ImageDatasetTypeEnum imageType) {
        ArrayList<Map<String, Object>> statResults = new ArrayList<Map<String, Object>>();
        SpatialQueryFilter queryFilter = new SpatialQueryFilter();
        String timeFilterFld = 1 == filterDTO.getTimeFilterType() ? "f_product_time" : "f_import_time";
        ArrayList<String> queryFieldList = new ArrayList<String>();
        String groupFld = "f_satellite";
        String queryGroupFld = "f_satellite";
        switch (filterDTO.getStatisticType()) {
            case 2: {
                queryGroupFld = "f_satellite";
                groupFld = "f_satellite";
                break;
            }
            case 3: {
                queryGroupFld = String.format("TO_CHAR(%s, 'YYYY-MM') AS month", timeFilterFld);
                groupFld = "month";
                break;
            }
            case 4: {
                queryGroupFld = String.format("TO_CHAR(%s, 'YYYY') AS year_quarter", timeFilterFld);
                groupFld = "year_quarter";
                break;
            }
        }
        queryFieldList.add(queryGroupFld);
        queryFieldList.add(String.format("Count(distinct %s) as count", "f_dataid"));
        queryFieldList.add(String.format("Sum(%s) as sum", "f_datasize"));
        queryFieldList.add("ST_Area(ST_Union(shape)::geography) AS area_sq");
        String queryFields = String.join((CharSequence)",", queryFieldList);
        queryFilter.setSubFields(queryFields);
        String postfix = String.format(" group by %s order by %s", groupFld, groupFld);
        queryFilter.setPostfixClause(postfix);
        queryFilter.setWhereClause(String.format("%s = %d", "f_image_type", imageType.getValue()));
        if (filterDTO.getTimeFilter() != null) {
            ArrayList<TimeFilterDTO> timeFilterList = new ArrayList<TimeFilterDTO>();
            timeFilterList.add(filterDTO.getTimeFilter());
            List timeFilterStrList = ImageDateUtil.convertTimeFilters(timeFilterList, (String)timeFilterFld);
            String timeFilter = String.join((CharSequence)" or ", timeFilterStrList);
            queryFilter.setWhereClause(queryFilter.getWhereClause() + " and " + timeFilter);
        }
        DataSourceDTO dataSource = this.imageDatasetService.getBusinessSnapshotDataSource();
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSource);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        ICursor cursor = null;
        try {
            IFeatureClass catFc = workspace.openFeatureClass("GWMD_tbimg_businesssnapshot_CAT");
            ITable table = (ITable)catFc;
            cursor = table.searchRow((IQueryFilter)queryFilter);
            IRow row = cursor.nextRow();
            while (row != null) {
                HashMap<String, Object> statResult = new HashMap<String, Object>(0);
                statResult.put("name", row.getValue(groupFld));
                statResult.put("count", row.getValue("count"));
                statResult.put("dataSize", this.convertByte2GB(row.getValue("sum")));
                statResult.put("coverArea", this.convertKM2(row.getValue("area_sq")));
                statResults.add(statResult);
                row = cursor.nextRow();
            }
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
        return statResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> statisticSampleTable(RepertoryStatisticFilterDTO filterDTO, ImageDatasetTypeEnum imageType) {
        ArrayList<Map<String, Object>> statResults = new ArrayList<Map<String, Object>>();
        SpatialQueryFilter queryFilter = new SpatialQueryFilter();
        ArrayList<String> queryFieldList = new ArrayList<String>();
        String timeFilterFld = "f_import_time";
        String groupFld = "samplescheme";
        String queryGroupFld = "samplescheme";
        switch (filterDTO.getStatisticType()) {
            case 2: {
                queryGroupFld = "samplescheme";
                groupFld = "samplescheme";
                break;
            }
            case 3: {
                queryGroupFld = String.format("TO_CHAR(%s, 'YYYY-MM') AS month", timeFilterFld);
                groupFld = "month";
                break;
            }
            case 4: {
                queryGroupFld = String.format("TO_CHAR(%s, 'YYYY') AS year_quarter", timeFilterFld);
                groupFld = "year_quarter";
                break;
            }
        }
        queryFieldList.add(queryGroupFld);
        queryFieldList.add(String.format("Count(distinct %s) as count", "f_dataid"));
        queryFieldList.add(String.format("Sum(%s) as sum", "f_datasize"));
        String queryFields = String.join((CharSequence)",", queryFieldList);
        queryFilter.setSubFields(queryFields);
        String postfix = String.format(" group by %s order by %s", groupFld, groupFld);
        queryFilter.setPostfixClause(postfix);
        queryFilter.setWhereClause(String.format("%s = %d", "f_image_type", imageType.getValue()));
        if (filterDTO.getTimeFilter() != null) {
            ArrayList<TimeFilterDTO> timeFilterList = new ArrayList<TimeFilterDTO>();
            timeFilterList.add(filterDTO.getTimeFilter());
            List timeFilterStrList = ImageDateUtil.convertTimeFilters(timeFilterList, (String)timeFilterFld);
            String timeFilter = String.join((CharSequence)" or ", timeFilterStrList);
            queryFilter.setWhereClause(queryFilter.getWhereClause() + " and " + timeFilter);
        }
        DataSourceDTO dataSource = this.imageDatasetService.getBusinessSnapshotDataSource();
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSource);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        ICursor cursor = null;
        try {
            IFeatureClass catFc = workspace.openFeatureClass("tb_sample_data");
            ITable table = (ITable)catFc;
            cursor = table.searchRow((IQueryFilter)queryFilter);
            IRow row = cursor.nextRow();
            while (row != null) {
                HashMap<String, Object> statResult = new HashMap<String, Object>(0);
                statResult.put("name", row.getValue(groupFld));
                statResult.put("count", row.getValue("count"));
                statResult.put("dataSize", this.convertByte2GB(row.getValue("sum")));
                statResults.add(statResult);
                row = cursor.nextRow();
            }
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
        return statResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> distributeStatistic(DistributeStatisticFilterDTO filterDTO, ImageDatasetTypeEnum imageType) {
        ArrayList<Map<String, Object>> statResults = new ArrayList<Map<String, Object>>();
        String timeFilterFld = "f_approvaltime";
        ArrayList<String> queryFieldList = new ArrayList<String>();
        String groupFld = "f_apply_userunit";
        String queryGroupFld = "f_apply_userunit";
        switch (filterDTO.getStatisticType()) {
            case 1: {
                queryGroupFld = "f_apply_userunit";
                groupFld = "f_apply_userunit";
                break;
            }
            case 2: {
                queryGroupFld = "tbimg_order_img.f_satellite as f_satellite_img";
                groupFld = "f_satellite_img";
                break;
            }
            case 3: {
                queryGroupFld = String.format("TO_CHAR(%s, 'YYYY-MM') AS month", timeFilterFld);
                groupFld = "month";
                break;
            }
            case 4: {
                queryGroupFld = String.format("TO_CHAR(%s, 'YYYY') AS year_quarter", timeFilterFld);
                groupFld = "year_quarter";
                break;
            }
        }
        queryFieldList.add(queryGroupFld);
        queryFieldList.add(String.format("Count(%s) as count", "tbimg_order_img.f_dataid"));
        queryFieldList.add(String.format("Sum(%s) as sum", "tbimg_order_img.f_data_size"));
        queryFieldList.add("ST_Area(ST_Union(gwmd_tbimg_businesssnapshot_cat.shape)::geography) AS area_sq");
        String queryFields = String.join((CharSequence)",", queryFieldList);
        String condition = "";
        if (filterDTO.getTimeFilter() != null) {
            ArrayList<TimeFilterDTO> timeFilterList = new ArrayList<TimeFilterDTO>();
            timeFilterList.add(filterDTO.getTimeFilter());
            List timeFilterStrList = ImageDateUtil.convertTimeFilters(timeFilterList, (String)timeFilterFld);
            String timeFilter = String.join((CharSequence)" or ", timeFilterStrList);
            condition = " and " + timeFilter;
        }
        DataSourceDTO dataSource = this.imageDatasetService.getBusinessSnapshotDataSource();
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSource);){
            String sql = String.format("select %s from tbimg_order_img left join tbimg_order on tbimg_order_img.f_orderid = tbimg_order.f_id left join gwmd_tbimg_businesssnapshot_cat on tbimg_order_img.f_dataid = gwmd_tbimg_businesssnapshot_cat.f_dataid where tbimg_order.f_status='2' and tbimg_order_img.f_image_type = %d %s group by %s order by %s", queryFields, imageType.getValue(), condition, groupFld, groupFld);
            List queryResults = workspace.queryList(sql, new Object[0]);
            for (Map item : queryResults) {
                HashMap statResult = new HashMap(0);
                statResult.put("name", item.get(groupFld));
                statResult.put("count", item.get("count"));
                statResult.put("dataSize", this.convertKb2GB(item.get("sum")));
                statResult.put("coverArea", this.convertKM2(item.get("area_sq")));
                statResults.add(statResult);
            }
        }
        return statResults;
    }

    private String convertByte2GB(Object dataSizeObj) {
        if (dataSizeObj == null) {
            return "0";
        }
        BigDecimal mb = NumberUtil.div((Number)new BigDecimal(dataSizeObj.toString()), (Number)BigDecimal.valueOf(0x100000L));
        BigDecimal gb = NumberUtil.div((Number)mb, (Number)BigDecimal.valueOf(1024L), (int)2);
        return gb + "";
    }

    private String convertKb2GB(Object dataSizeObj) {
        if (dataSizeObj == null) {
            return "0";
        }
        BigDecimal gb = NumberUtil.div((Number)new BigDecimal(dataSizeObj.toString()), (Number)BigDecimal.valueOf(0x100000L), (int)2);
        return gb + "";
    }

    private String convertKM2(Object areaObj) {
        if (areaObj == null) {
            return "0";
        }
        return NumberUtil.div((Number)new BigDecimal(areaObj.toString()), (Number)BigDecimal.valueOf(1000000L), (int)2) + "";
    }
}

