/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.imagedb.apply.dao.ImgSatelliteDao;
import com.geoway.imagedb.apply.entity.ImgSatellite;
import com.geoway.imagedb.apply.service.ImgSatelliteService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImgSatelliteServiceImpl
implements ImgSatelliteService {
    private static final Logger log = LoggerFactory.getLogger(ImgSatelliteServiceImpl.class);
    @Resource
    private ImgSatelliteDao imgSatelliteDao;

    @Override
    public List<ImgSatellite> list(String keyword, String resolutions, String countries, String types) {
        List resolutionList = null;
        if (StringUtil.isNotEmpty((String)resolutions)) {
            resolutionList = StringUtil.split((String)resolutions, (String)",", f -> f);
        }
        List countryList = null;
        if (StringUtil.isNotEmpty((String)countries)) {
            countryList = StringUtil.split((String)countries, (String)",", f -> f);
        }
        List typeList = null;
        if (StringUtil.isNotEmpty((String)types)) {
            typeList = StringUtil.split((String)types, (String)",", f -> f);
        }
        List list = this.imgSatelliteDao.selectAll(resolutionList, countryList, typeList);
        if (StringUtil.isNotEmpty((String)keyword)) {
            list = ListUtil.findAll(list, f -> f.getName().toLowerCase().contains(keyword.toLowerCase()) || f.getAlias().toLowerCase().contains(keyword.toLowerCase()) || f.getNorad_number().toLowerCase().contains(keyword.toLowerCase()) || f.getCountry().toLowerCase().contains(keyword.toLowerCase()) || f.getType().toLowerCase().contains(keyword.toLowerCase()) || f.getResolution().toLowerCase().contains(keyword.toLowerCase()));
        }
        return list;
    }

    @Override
    public String addOrUpdate(ImgSatellite satellite) {
        if (StringUtil.isEmptyOrWhiteSpace((String)satellite.getName())) {
            throw new RuntimeException("\u536b\u661f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)satellite.getType())) {
            throw new RuntimeException("\u4f20\u611f\u5668\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)satellite.getResolution())) {
            throw new RuntimeException("\u5206\u8fa8\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)satellite.getCountry())) {
            throw new RuntimeException("\u56fd\u5bb6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (satellite.getCloth_width() == null) {
            throw new RuntimeException("\u5bbd\u5e45\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)satellite.getLine1()) || StringUtil.isEmptyOrWhiteSpace((String)satellite.getLine2())) {
            throw new RuntimeException("\u8f68\u9053\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)satellite.getId())) {
            List<ImgSatellite> sameNames = this.imgSatelliteDao.selectByName(satellite.getName());
            if (sameNames.size() > 0) {
                throw new RuntimeException("\u536b\u661f\u540d\u79f0\u5df2\u5b58\u5728");
            }
            Integer maxOrder = this.imgSatelliteDao.queryMaxOrder();
            satellite.setOrder(maxOrder == null ? 1 : maxOrder + 1);
            satellite.setId(UUID.randomUUID().toString().replace("-", ""));
            this.imgSatelliteDao.insert(satellite);
        } else {
            List<ImgSatellite> sameNames;
            ImgSatellite old = this.imgSatelliteDao.selectByPrimaryKey(satellite.getId());
            if (old == null) {
                throw new RuntimeException("\u536b\u661f\u4e0d\u5b58\u5728");
            }
            if (!old.getName().equals(satellite.getName()) && (sameNames = this.imgSatelliteDao.selectByName(satellite.getName())).size() > 0) {
                throw new RuntimeException("\u536b\u661f\u540d\u79f0\u5df2\u5b58\u5728");
            }
            this.imgSatelliteDao.updateByPrimaryKeySelective(satellite);
        }
        return satellite.getId();
    }

    @Override
    public void delete(String id) {
        this.imgSatelliteDao.deleteByPrimaryKey(id);
    }

    @Override
    public String importSatellite(MultipartFile file) {
        if (file == null || !Objects.requireNonNull(file.getOriginalFilename()).endsWith(".json")) {
            throw new RuntimeException("\u6587\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        InputStreamReader streamReader = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuffer = new StringBuilder();
        JSONObject jsonObject = null;
        try {
            streamReader = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(streamReader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                stringBuffer.append(line);
            }
            bufferedReader.close();
            streamReader.close();
            jsonObject = JSONObject.parseObject((String)stringBuffer.toString());
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff01" + e.getMessage());
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{streamReader, bufferedReader});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{streamReader, bufferedReader});
        ImgSatellite satellite = (ImgSatellite)JSONObject.parseObject((String)jsonObject.toJSONString(), ImgSatellite.class);
        satellite.setId(null);
        return this.addOrUpdate(satellite);
    }

    @Override
    public void exportSatellite(String id) {
        ImgSatellite satellite = this.imgSatelliteDao.selectByPrimaryKey(id);
        if (satellite != null) {
            String contents = JSONArray.toJSONString((Object)satellite);
            String name = satellite.getName();
            name = name.replaceAll("\\s*", "");
            name = name.replaceAll("[<>:\"/\\\\|?*]", "");
            DownloadUtil.downloadToFile((String)(name + ".json"), (String)contents);
        }
        DownloadUtil.downloadToFile((String)"\u536b\u661f\u4e0d\u5b58\u5728.json", (String)"");
    }
}

