/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import cn.hutool.core.util.IdUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.imagedb.apply.constant.ImageRequirementStatusEnum;
import com.geoway.imagedb.apply.dao.ImgRequirementDao;
import com.geoway.imagedb.apply.dto.RequirementPageList;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementApprovalDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementCreateDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementFilterDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementVO;
import com.geoway.imagedb.apply.entity.ImgRequirement;
import com.geoway.imagedb.apply.service.ImageRequirementService;
import com.geoway.imagedb.apply.user.LoginUserInfoWithDep;
import com.geoway.imagedb.apply.user.UserInfoService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ImageRequirementServiceImpl
implements ImageRequirementService {
    @Resource
    private ImgRequirementDao imgRequirementDao;
    @Resource
    private UserInfoService userInfoService;

    @Override
    public String createImageRequirement(ImageRequirementCreateDTO createDTO) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        Assert.isTrue((boolean)user.getUserId().equals(createDTO.getApply_userid()), (String)"\u53c2\u6570\u4e2d\u63d0\u4ea4\u7684\u7528\u6237\u4fe1\u606f\u4e0e\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e0d\u7b26");
        ImgRequirement ir = new ImgRequirement();
        ir.setFId(IdUtil.getSnowflakeNextIdStr());
        ir.setFApplyDatatype(createDTO.getApply_datatype());
        ir.setFApplyDatarange(createDTO.getApply_datarange());
        ir.setFApplyResolution(createDTO.getApply_resolution());
        ir.setFApplyTimephase(createDTO.getApply_timephase());
        ir.setFApplyPurpose(createDTO.getApply_purpose());
        ir.setFApplyDesc(createDTO.getApply_desc());
        ir.setFApplyUserid(createDTO.getApply_userid());
        ir.setFApplyUsername(createDTO.getApply_username());
        ir.setFApplyUserunit(createDTO.getApply_userunit());
        ir.setFCreatetime(new Date());
        ir.setFApplytime(new Date());
        ir.setFStatus(String.valueOf(ImageRequirementStatusEnum.Ready.getValue()));
        ir.setFIsdeleted(0);
        this.imgRequirementDao.insert(ir);
        return ir.getFId();
    }

    @Override
    public PageList<ImageRequirementVO> listImageRequirement(ImageRequirementFilterDTO dto) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        Integer pageIndex = dto.getPageIndex();
        Integer rows = dto.getRows();
        List<ImgRequirement> list = null;
        List<ImgRequirement> stalist = null;
        if (this.userInfoService.isAdminOrApprove(user).booleanValue()) {
            PageHelper.startPage((int)(pageIndex + 1), (int)rows);
            list = this.imgRequirementDao.selectAll(dto);
            PageHelper.startPage((int)1, (int)100000);
            if (dto.getStatus() == null || dto.getStatus().trim().isEmpty()) {
                dto.setStatus("1");
            } else if (dto.getStatus().equals("0")) {
                dto.setStatus("-1");
            }
            stalist = this.imgRequirementDao.selectAll(dto);
        } else {
            PageHelper.startPage((int)(pageIndex + 1), (int)rows);
            list = this.imgRequirementDao.selectByUser(user.getUserId(), dto);
            PageHelper.startPage((int)1, (int)100000);
            if (dto.getStatus() == null || dto.getStatus().trim().isEmpty()) {
                dto.setStatus("1");
            } else if (dto.getStatus().equals("0")) {
                dto.setStatus("-1");
            }
            stalist = this.imgRequirementDao.selectByUser(user.getUserId(), dto);
        }
        return this.convertPageListImageRequirementVO(list, stalist);
    }

    @Override
    public PageList<ImageRequirementVO> myListImageRequirement(ImageRequirementFilterDTO dto) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        Integer pageIndex = dto.getPageIndex();
        Integer rows = dto.getRows();
        PageHelper.startPage((int)(pageIndex + 1), (int)rows);
        List<ImgRequirement> list = this.imgRequirementDao.selectByUser(user.getUserId(), dto);
        PageHelper.startPage((int)1, (int)100000);
        if (dto.getStatus() == null || dto.getStatus().trim().isEmpty()) {
            dto.setStatus("1");
        } else if (dto.getStatus().equals("0")) {
            dto.setStatus("-1");
        }
        List<ImgRequirement> stalist = this.imgRequirementDao.selectByUser(user.getUserId(), dto);
        return this.convertPageListImageRequirementVO(list, stalist);
    }

    private PageList<ImageRequirementVO> convertPageListImageRequirementVO(List<ImgRequirement> list, List<ImgRequirement> stalist) {
        PageInfo pageInfo = new PageInfo(list);
        PageInfo staPageInfo = new PageInfo(stalist);
        List imangeRequirementVo = ListUtil.convertAll(list, t -> {
            ImageRequirementVO vo = new ImageRequirementVO();
            vo.setId(t.getFId());
            vo.setApply_datatype(t.getFApplyDatatype());
            vo.setApply_datarange(t.getFApplyDatarange());
            vo.setApply_resolution(t.getFApplyResolution());
            vo.setApply_timephase(t.getFApplyTimephase());
            vo.setApply_purpose(t.getFApplyPurpose());
            vo.setApply_desc(t.getFApplyDesc());
            vo.setApply_userid(t.getFApplyUserid());
            vo.setApply_username(t.getFApplyUsername());
            vo.setApply_userunit(t.getFApplyUserunit());
            vo.setApprove_username(t.getFApproveUsername());
            vo.setApprove_reply(t.getFApproveReply());
            vo.setApply_time(t.getFApplytime());
            vo.setApprove_time(t.getFApprovaltime());
            vo.setStatus(t.getFStatus());
            return vo;
        });
        return new RequirementPageList(imangeRequirementVo, pageInfo.getTotal(), staPageInfo.getTotal());
    }

    @Override
    public void repealImageRequirement(String ids) {
        Assert.hasLength((String)ids, (String)"\u8bf7\u9009\u62e9\u5f71\u50cf\u9700\u6c42");
        String[] idArr = ids.split(",");
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        for (int i = 0; i < idArr.length; ++i) {
            ImgRequirement ir = this.imgRequirementDao.selectByPrimaryKey(idArr[i]);
            Assert.notNull((Object)ir, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + idArr[i] + "\u7684\u5f71\u50cf\u9700\u6c42"));
            Assert.isTrue((boolean)ir.getFApplyUserid().equals(user.getUserId()), (String)("\u6807\u8bc6\u4e3a" + idArr[i] + "\u7684\u5f71\u50cf\u9700\u6c42\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237"));
            this.imgRequirementDao.deleteByPrimaryKey(idArr[i]);
        }
    }

    @Override
    public String approveImageRequirement(ImageRequirementApprovalDTO dto) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        ImgRequirement ir = this.imgRequirementDao.selectByPrimaryKey(dto.getId());
        Assert.notNull((Object)ir, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + dto.getId() + "\u7684\u5f71\u50cf\u9700\u6c42"));
        ir.setFApproveUserid(user.getUserId());
        ir.setFApproveUsername(user.getUserName());
        ir.setFApproveReply(dto.getApprove_reply());
        ir.setFApprovaltime(new Date());
        ir.setFStatus(String.valueOf(ImageRequirementStatusEnum.Complete.getValue()));
        this.imgRequirementDao.updateByPrimaryKey(ir);
        return ir.getFId();
    }
}

