/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import cn.hutool.core.date.DateUtil;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamGroupDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.imagedb.apply.component.IMEServiceHelper;
import com.geoway.imagedb.apply.dto.daily.DailyImageDTO;
import com.geoway.imagedb.apply.dto.daily.DailyImageQueryResult;
import com.geoway.imagedb.apply.dto.daily.DailyImageResult;
import com.geoway.imagedb.apply.service.DailyImageQueryService;
import com.geoway.imagedb.dataset.dto.query.TimeFilterDTO;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.service.ImageQueryService;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DailyImageQueryServiceImpl
implements DailyImageQueryService {
    private static final Logger log = LoggerFactory.getLogger(DailyImageQueryServiceImpl.class);
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private SysParamsService sysParamsService;
    @Resource
    private ImageQueryService imageQueryService;
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    private IMEServiceHelper imeServiceHelper;
    private final String dailyImageService = "DailyImageService";
    private Cache<String, Map<String, Set<String>>> resultCache;

    @Autowired
    public void initCache() {
        this.resultCache = Caffeine.newBuilder().expireAfterWrite(10000L, TimeUnit.MILLISECONDS).maximumSize(10000L).build();
    }

    @Override
    public DailyImageQueryResult query(Double xMin, Double xMax, Double yMin, Double yMax) {
        IEnvelope envelope = GeometryFunc.createEnvelope((double)xMin, (double)yMin, (double)xMax, (double)yMax);
        Assert.notNull((Object)envelope, (String)"\u67e5\u8be2\u8303\u56f4\u5f02\u5e38\uff01");
        String serviceUrl = this.getDailyImageServiceUrl();
        DailyImageQueryResult result = new DailyImageQueryResult();
        DatasetRenderDTO render = new DatasetRenderDTO();
        render.setUrl(serviceUrl);
        render.setServiceType(Integer.valueOf(ServiceType.DTileService.getValue()));
        result.setRender(render);
        String key = "DailyImage";
        Map<String, Set<String>> dbKeyLayerMap = (Map<String, Set<String>>)this.resultCache.getIfPresent((Object)key);
        if (dbKeyLayerMap == null) {
            dbKeyLayerMap = this.imeServiceHelper.getGeoDatabaseLayers(serviceUrl);
            this.resultCache.put((Object)key, dbKeyLayerMap);
        }
        QueryFilterDTO filter = new QueryFilterDTO();
        filter.setGeometry(envelope.toWkt());
        filter.setReturnGeometry(Boolean.valueOf(false));
        filter.setRows(Integer.valueOf(10000));
        ArrayList<DailyImageDTO> imageList = new ArrayList<DailyImageDTO>();
        for (String dsKey : dbKeyLayerMap.keySet()) {
            for (String tableName : dbKeyLayerMap.get(dsKey)) {
                DataQueryResult queryResult = this.geoDatabaseService.queryGeoDataset(dsKey, tableName, filter);
                imageList.addAll(this.convertDailyImage(queryResult));
            }
        }
        if (imageList.size() == 0) {
            return result;
        }
        Map<Date, List<DailyImageDTO>> timeGroup = imageList.stream().collect(Collectors.groupingBy(DailyImageDTO::getTime));
        ArrayList<DailyImageResult> timeline = new ArrayList<DailyImageResult>();
        for (Date time : timeGroup.keySet()) {
            DailyImageResult dailyImageResult = new DailyImageResult();
            dailyImageResult.setTime(time);
            dailyImageResult.setImages(timeGroup.get(time));
            List<DailyImageDTO> list = timeGroup.get(time);
            list.sort(Comparator.comparing(DailyImageDTO::getResolution));
            timeline.add(dailyImageResult);
        }
        timeline.sort(Comparator.comparing(DailyImageResult::getTime));
        result.setTimeline(timeline);
        return result;
    }

    @Override
    public DataQueryResult detail(String geometry, List<String> datasetIdArray, String time) {
        Date date = ImageDateUtil.parse((String)time);
        String timeStr = DateUtil.format((Date)date, (String)"yyyy-MM-dd");
        QueryFilterDTO filter = new QueryFilterDTO();
        filter.setGeometry(geometry);
        ArrayList<TimeFilterDTO> timeArray = new ArrayList<TimeFilterDTO>();
        TimeFilterDTO filterDTO = new TimeFilterDTO();
        filterDTO.setStartTime(date);
        filterDTO.setEndTime(date);
        timeArray.add(filterDTO);
        List timeFilters = ImageDateUtil.convertTimeFilters(timeArray, (String)"f_time");
        filter.setCondition((String)timeFilters.get(0));
        filter.setReturnGeometry(Boolean.valueOf(false));
        DailyImageDTO targetDailyImage = null;
        Double resolution = Double.MAX_VALUE;
        for (String datasetId : datasetIdArray) {
            DataQueryResult queryResult = this.geoDatabaseService.queryGeoDataset(datasetId, filter);
            List<DailyImageDTO> imageList = this.convertDailyImage(queryResult);
            if (imageList.size() <= 0 || !(imageList.get(0).getResolution() < resolution)) continue;
            resolution = imageList.get(0).getResolution();
            targetDailyImage = imageList.get(0);
        }
        if (targetDailyImage == null) {
            throw new RuntimeException(String.format("[%s]\u65e0\u5f71\u50cf\u6570\u636e\uff01", timeStr));
        }
        ImgDataset imageDataset = this.imageDatasetService.getImgDatasetByGeoDatasetId(targetDailyImage.getDatasetId());
        if (imageDataset == null) {
            throw new RuntimeException(String.format("[%s]\u4e3a\u53d1\u73b0\u5173\u8054\u7684\u5f71\u50cf\u6570\u636e\u96c6\uff01", targetDailyImage.getDatasetId()));
        }
        return this.imageQueryService.imageDetail(imageDataset.getDatasetId(), targetDailyImage.getObjectId(), Integer.valueOf(256));
    }

    private List<DailyImageDTO> convertDailyImage(DataQueryResult queryResult) {
        ArrayList<DailyImageDTO> imageList = new ArrayList<DailyImageDTO>();
        if (queryResult != null && queryResult.getData() != null && queryResult.getData().size() > 0) {
            for (FeatureResult featureResult : queryResult.getData()) {
                Object timeObject = featureResult.getAttributes().get("f_time");
                Object mapNumberObject = featureResult.getAttributes().get("f_classification");
                Object dataIdObject = featureResult.getAttributes().get("F_DATAID");
                Object resolutionObject = featureResult.getAttributes().get("lowps");
                if (dataIdObject == null || timeObject == null || resolutionObject == null) continue;
                DailyImageDTO dailyImage = new DailyImageDTO();
                try {
                    dailyImage.setTime(ImageDateUtil.parse((String)timeObject.toString()));
                }
                catch (Exception e) {
                    log.error("\u65e0\u6548\u7684\u65f6\u76f8" + e.getMessage(), (Throwable)e);
                    continue;
                }
                dailyImage.setDatasetId(queryResult.getId());
                dailyImage.setDatasetName(queryResult.getName());
                dailyImage.setMapNumber(mapNumberObject == null ? "" : mapNumberObject.toString());
                dailyImage.setResolution(Double.parseDouble(resolutionObject.toString()));
                dailyImage.setObjectId(dataIdObject.toString());
                imageList.add(dailyImage);
            }
        }
        return imageList;
    }

    private String getDailyImageServiceUrl() {
        SysParamGroupDTO sysParamGroup = this.sysParamsService.getGroupDetail("DailyImageService");
        Assert.notNull((Object)sysParamGroup, (String)"\u672a\u8bbe\u7f6e\u65e5\u65b0\u56fe\u7cfb\u7edf\u53c2\u6570\uff01");
        if (sysParamGroup.getParams() == null || sysParamGroup.getParams().size() == 0) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u65e5\u65b0\u56fe\u670d\u52a1\u5730\u5740\uff01");
        }
        return ((SysParamDTO)sysParamGroup.getParams().get(0)).getValue();
    }
}

