/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.util;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.geosrv.util.HttpClientUtil;
import com.geoway.imagedb.apply.dto.watermark.AgentInfo;
import com.geoway.imagedb.apply.dto.watermark.EmbedTaskCreateParams;
import com.geoway.imagedb.apply.dto.watermark.EncryptTaskCreateParams;
import com.geoway.imagedb.apply.dto.watermark.WatermarkTask;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkUtil {
    private static final Logger log = LoggerFactory.getLogger(WatermarkUtil.class);

    public static AgentInfo getAgentInfo(String url) {
        JSONObject resultJson;
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        AgentInfo agentInfo = null;
        String result = HttpClientUtil.doGet((String)(url = String.format("%sapi/v1/gm/agentInfo/get", url)));
        if (StringUtil.isNotEmpty((String)result)) {
            resultJson = JSONObject.parseObject((String)result);
            int code = resultJson.getInteger("code");
            if (code != 0) {
                String msg = resultJson.getString("msg");
                throw new RuntimeException("\u83b7\u53d6\u83b7\u53d6\u4ee3\u7406\u4fe1\u606f\u5931\u8d25:" + msg);
            }
        } else {
            throw new RuntimeException("\u83b7\u53d6\u83b7\u53d6\u4ee3\u7406\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u54cd\u5e94\u53c2\u6570\uff01");
        }
        agentInfo = new AgentInfo();
        JSONObject data = resultJson.getJSONObject("data");
        agentInfo.setAgentId(data.getString("agentId"));
        agentInfo.setHostName(data.getString("hostName"));
        return agentInfo;
    }

    public static String addEmbedTask(String url, EmbedTaskCreateParams params) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = String.format("%sopen-api/v1/task/watermark/addEmbedTask", url);
        HashMap<String, String> param = new HashMap<String, String>(0);
        param.put("userInfor", params.getUserInfor());
        if (params.getCode() != null) {
            param.put("code", params.getCode());
        }
        if (params.getDistributor() != null) {
            param.put("distributor", params.getDistributor());
        }
        if (params.getDistributionOperator() != null) {
            param.put("distributionOperator", params.getDistributionOperator());
        }
        if (params.getRemark() != null) {
            param.put("remark", params.getRemark());
        }
        param.put("inPath", params.getInPath());
        if (params.getOutPath() != null) {
            param.put("outPath", params.getOutPath());
        }
        if (params.getIsCopyData() != null) {
            param.put("isCopyData", params.getIsCopyData() != false ? "true" : "false");
        }
        param.put("agentId", params.getAgentId());
        log.info("\u53d1\u9001\u6c34\u5370\u4efb\u52a1\u8bf7\u6c42\uff1a" + JSONObject.toJSONString(param));
        String result = HttpClientUtil.doPost((String)url, param);
        if (StringUtil.isNotEmpty((String)result)) {
            JSONObject resultJson = JSONObject.parseObject((String)result);
            int code = resultJson.getInteger("code");
            if (code == 0) {
                JSONObject data = resultJson.getJSONObject("data");
                return data.getString("taskId");
            }
            String msg = resultJson.getString("msg");
            throw new RuntimeException("\u6dfb\u52a0\u6c34\u5370\u4efb\u52a1\u5931\u8d25:" + msg);
        }
        throw new RuntimeException("\u6dfb\u52a0\u6c34\u5370\u4efb\u52a1\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u54cd\u5e94\u53c2\u6570\uff01");
    }

    public static String addEncryptTask(String url, EncryptTaskCreateParams params) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = String.format("%sopen-api/v1/task/securityControl/addEncryptTask", url);
        HashMap<String, String> param = new HashMap<String, String>(0);
        if (params.getUserInfor() != null) {
            param.put("userInfor", params.getUserInfor());
        }
        if (params.getIsSpecifyUserUnit() != null) {
            param.put("isSpecifyUserUnit", params.getIsSpecifyUserUnit() != false ? "true" : "false");
        }
        if (params.getCode() != null) {
            param.put("code", params.getCode());
        }
        if (params.getContactsName() != null) {
            param.put("contactsName", params.getContactsName());
        }
        if (params.getContactsPhone() != null) {
            param.put("contactsPhone", params.getContactsPhone());
        }
        param.put("beginTime", params.getBeginTime());
        if (params.getEndTime() != null) {
            param.put("endTime", params.getEndTime());
        }
        if (params.getIsEndTimeNoDeadline() != null) {
            param.put("isEndTimeNoDeadline", params.getIsEndTimeNoDeadline() != false ? "true" : "false");
        }
        if (params.getRemark() != null) {
            param.put("remark", params.getRemark());
        }
        param.put("inPath", params.getInPath());
        if (params.getOutPath() != null) {
            param.put("outPath", params.getOutPath());
        }
        if (params.getIsCopyData() != null) {
            param.put("isCopyData", params.getIsCopyData() != false ? "true" : "false");
        }
        param.put("agentId", params.getAgentId());
        log.info("\u53d1\u9001\u6c34\u5370\u4efb\u52a1\u8bf7\u6c42\uff1a" + JSONObject.toJSONString(param));
        String result = HttpClientUtil.doPost((String)url, param);
        if (StringUtil.isNotEmpty((String)result)) {
            JSONObject resultJson = JSONObject.parseObject((String)result);
            int code = resultJson.getInteger("code");
            if (code == 0) {
                JSONObject data = resultJson.getJSONObject("data");
                return data.getString("taskId");
            }
            String msg = resultJson.getString("msg");
            throw new RuntimeException("\u6dfb\u52a0\u6570\u636e\u52a0\u5bc6\u4efb\u52a1\u5931\u8d25:" + msg);
        }
        throw new RuntimeException("\u6dfb\u52a0\u6570\u636e\u52a0\u5bc6\u4efb\u52a1\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u54cd\u5e94\u53c2\u6570\uff01");
    }

    public static WatermarkTask getWatermarkTask(String url, String taskId) {
        String result;
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (StringUtil.isNotEmpty((String)(result = HttpClientUtil.doGet((String)(url = String.format("%sopen-api/v1/task/getTask?id=%s", url, taskId)))))) {
            JSONObject resultJson = JSONObject.parseObject((String)result);
            int code = resultJson.getInteger("code");
            if (code == 0) {
                JSONObject data = resultJson.getJSONObject("data");
                WatermarkTask task = new WatermarkTask();
                task.setId(data.getString("id"));
                task.setType(data.getString("type"));
                task.setStatus(data.getString("status"));
                task.setBeginTime(data.getString("beginTime"));
                task.setEndTime(data.getString("endTime"));
                task.setTimeElapsed(data.getString("timeElapsed"));
                task.setDataResult(data.getString("dataResult"));
                task.setInPath(data.getString("inPath"));
                task.setOutPath(data.getString("outPath"));
                task.setIsCopyData(data.getString("isCopyData"));
                task.setFileNum(data.getInteger("fileNum"));
                task.setFileSize(data.getLong("fileSize"));
                task.setCreatedAt(data.getString("createdAt"));
                task.setRemark(data.getString("remark"));
                return task;
            }
            String msg = resultJson.getString("msg");
            throw new RuntimeException("\u83b7\u53d6\u6c34\u5370\u4efb\u52a1\u5931\u8d25:" + msg);
        }
        throw new RuntimeException("\u83b7\u53d6\u6c34\u5370\u4efb\u52a1\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u54cd\u5e94\u53c2\u6570\uff01");
    }
}

