/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import com.geoway.adf.dms.catalog.dto.app.AppCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.imagedb.apply.dto.catalog.ImageCatalogDataNodeDTO;
import com.geoway.imagedb.apply.service.ImageCatalogService;
import com.geoway.imagedb.apply.user.LoginUserInfoWithDep;
import com.geoway.imagedb.apply.user.UserInfoService;
import com.geoway.imagedb.dataset.dto.dataset.ImageGeoDatasetDTO;
import com.geoway.imagedb.dataset.dto.dataset.ImageMosaicDatasetDTO;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ImageCatalogServiceImpl
implements ImageCatalogService {
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private AppCatalogNodeService appCatalogNodeService;

    @Override
    public String getFinalToken() {
        LoginUserInfoWithDep userInfo = this.userInfoService.getUserInfo();
        if (userInfo == null || !this.userInfoService.isAdminOrApprove(userInfo).booleanValue()) {
            throw new RuntimeException("\u5f53\u524d\u7528\u6237\u975e\u7ba1\u7406\u5458\uff0c\u65e0\u6cd5\u83b7\u53d6");
        }
        return this.userInfoService.getFinalToken();
    }

    @Override
    public AppCatalogNodeDTO getImageCatalogTree() {
        String appCatalogId = EnvironmentConfig.getProperty((String)"project.image-catalog-id", (String)"");
        if (StringUtil.isEmptyOrWhiteSpace((String)appCatalogId)) {
            throw new RuntimeException("\u672a\u914d\u7f6e project.image-catalog-id\uff0c\u8bf7\u6307\u5b9a\u76ee\u5f55\u6807\u8bc6\uff01");
        }
        String token = this.userInfoService.checkFinalToken();
        AppCatalogNodeDTO appCatalogNodeDTO = this.appCatalogNodeService.getCatalogTree(appCatalogId, null, null, "8", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        if (this.userInfoService.getFinalToken().equals(token)) {
            this.userInfoService.removeFinalUserCache(token);
        }
        this.filterNode(appCatalogNodeDTO);
        return appCatalogNodeDTO;
    }

    @Override
    public ImageCatalogDataNodeDTO getNodeDetail(String nodeId) {
        this.userInfoService.checkFinalToken();
        AppCatalogNodeDTO catalogNode = this.appCatalogNodeService.getNodeDetail(nodeId);
        if (catalogNode == null) {
            throw new RuntimeException(String.format("\u5e94\u7528\u76ee\u5f55\u8282\u70b9\u3010%S\u3011\u4e0d\u5b58\u5728\uff01", nodeId));
        }
        ImageCatalogDataNodeDTO imageCatalogDataNode = new ImageCatalogDataNodeDTO();
        imageCatalogDataNode.setNodeId(catalogNode.getNodeId());
        imageCatalogDataNode.setNodeName(catalogNode.getNodeName());
        if (catalogNode instanceof AppCatalogDataNodeDTO) {
            DatasetDTO datasetDTO = ((AppCatalogDataNodeDTO)catalogNode).getDataset();
            if (datasetDTO instanceof ImageGeoDatasetDTO) {
                imageCatalogDataNode.setRangeRender(((ImageGeoDatasetDTO)datasetDTO).getRender());
                imageCatalogDataNode.setRender(((ImageGeoDatasetDTO)datasetDTO).getSnapshotRender());
            } else if (datasetDTO instanceof ImageMosaicDatasetDTO) {
                imageCatalogDataNode.setRangeRender(((ImageMosaicDatasetDTO)datasetDTO).getRangeRender());
                imageCatalogDataNode.setRender(((ImageMosaicDatasetDTO)datasetDTO).getRender());
            }
        }
        return imageCatalogDataNode;
    }

    private void filterNode(AppCatalogNodeDTO node) {
        if (node.getChildren() != null) {
            node.getChildren().forEach(this::filterNode);
            node.getChildren().removeIf(child -> child.getNodeType() == 1 && ((AppCatalogDataNodeDTO)child).getDatumType() != 21);
        }
    }
}

