/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.component;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.properties.DefaultCoordSchemeProperties;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.dto.district.DmDistrictDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceCreateDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.filter.SpatialRelationType;
import com.geoway.imagedb.apply.constant.CoverageAnalyseTimeEnum;
import com.geoway.imagedb.apply.dao.ImgCoverageAnalyseDao;
import com.geoway.imagedb.apply.dto.coverage.ImgCoverageAnalyseDTO;
import com.geoway.imagedb.apply.entity.ImgCoverageAnalyse;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dto.query.CoverageAnalyseResultDTO;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.service.ImageQueryService;
import com.geoway.imagedb.dataset.util.ImageDatasetRenderUtil;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CoverageAnalyseStatisticSchedule {
    private static final Logger log = LoggerFactory.getLogger(CoverageAnalyseStatisticSchedule.class);
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private ImgCoverageAnalyseDao imgCoverageAnalyseDao;
    @Resource
    private DistrictService districtService;
    @Resource
    private ImageQueryService imageQueryService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private RenderIndexService renderIndexService;
    @Resource
    private DefaultCoordSchemeProperties defaultCoordSchemeProperties;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(5);
    private final RunningScheduler task = new RunningScheduler();

    @PostConstruct
    public void initSchedules() {
        log.info("\u521d\u59cb\u5316\u5f71\u50cf\u8986\u76d6\u7387\u5b9a\u65f6\u7edf\u8ba1\u4efb\u52a1");
        String starTimeStr = "2025-10-01 02:08:00";
        try {
            Date dateNow = new Date();
            Date startDate = ImageDateUtil.parse((String)starTimeStr);
            long period = 86400L;
            Date nextDate = this.getNextDate(dateNow, startDate, period);
            log.info(String.format("\u5f71\u50cf\u8986\u76d6\u7387\u5b9a\u65f6\u7edf\u8ba1\u4efb\u52a1\u4e0b\u6b21\u6267\u884c\u65f6\u95f4\uff1a%s", ImageDateUtil.format((Date)nextDate, (String)"yyyy-MM-dd HH:mm:ss")));
            long initialDelay = DateUtil.between((Date)dateNow, (Date)nextDate, (DateUnit)DateUnit.SECOND);
            this.task.future = this.scheduler.scheduleAtFixedRate(this::executeTask, initialDelay, period, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u8986\u76d6\u7387\u5b9a\u65f6\u7edf\u8ba1\u4efb\u52a1\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    @PreDestroy
    public void stopSchedules() {
        this.shutdownScheduler();
    }

    private Date getNextDate(Date nowDate, Date startDate, long period) {
        long interval = DateUtil.between((Date)nowDate, (Date)startDate, (DateUnit)DateUnit.SECOND);
        if (nowDate.compareTo(startDate) > 0) {
            interval = (long)((int)Math.ceil((double)interval / (double)period)) * period - interval;
        }
        if (interval == 0L) {
            interval = period;
        }
        return DateUtil.offsetSecond((Date)nowDate, (int)((int)interval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask() {
        log.info("\u5f71\u50cf\u8986\u76d6\u7387\u5b9a\u65f6\u7edf\u8ba1\u4efb\u52a1\u5f00\u59cb\u6267\u884c");
        DataSourceDTO targetDatabase = this.imageDatasetService.getBusinessSnapshotDataSource();
        this.synchronizeCoverageAnalyseDataset(targetDatabase);
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);
        if (workspace == null) {
            log.error("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            return;
        }
        DmDictValueDTO originalDictValue = this.dictionaryService.getDictionaryTree("DIC_SensorClassification");
        DmDictValueDTO productDictValue = this.dictionaryService.getDictionaryTree("DIC_DOMClassification");
        if (productDictValue == null && originalDictValue == null) {
            log.error(String.format("\u5b57\u5178%s\u548c%s\u90fd\u4e0d\u5b58\u5728", "DIC_SensorClassification", "DIC_DOMClassification"));
            return;
        }
        ArrayList<ImgCoverageAnalyse> groupDataList = new ArrayList<ImgCoverageAnalyse>();
        ArrayList<ImgCoverageAnalyse> satelliteDataList = new ArrayList<ImgCoverageAnalyse>();
        HashMap<String, List<String>> originalGroup = new HashMap(0);
        if (originalDictValue != null) {
            originalGroup = this.imageQueryService.getSatelliteGroup(originalDictValue, null, new ArrayList());
            groupDataList.addAll(this.addStatGroup(originalDictValue, 11, "-1", ""));
        }
        HashMap<String, List<String>> productGroup = new HashMap(0);
        if (productDictValue != null) {
            productGroup = this.imageQueryService.getSatelliteGroup(productDictValue, null, new ArrayList());
            groupDataList.addAll(this.addStatGroup(productDictValue, 21, "-1", ""));
        }
        IFeatureCursor cursor = null;
        int originalCount = 0;
        long originalDataSize = 0L;
        int productCount = 0;
        long productDataSize = 0L;
        ArrayList<Integer> originalYearList = new ArrayList<Integer>();
        ArrayList<Integer> productYearList = new ArrayList<Integer>();
        Calendar calendar = Calendar.getInstance();
        ISpatialReferenceSystem sp = null;
        try {
            IFeatureClass businessSnapshotFc = workspace.openFeatureClass("GWMD_tbimg_businesssnapshot_CAT");
            cursor = businessSnapshotFc.searchFeature(null);
            IFeature feature = null;
            while ((feature = cursor.nextFeature()) != null) {
                Object imageTypeObj = feature.getValue("f_image_type");
                Integer imageType = imageTypeObj == null ? 11 : Integer.parseInt(imageTypeObj.toString());
                Object satelliteObj = feature.getValue("f_satellite");
                String satellite = satelliteObj == null ? "" : satelliteObj.toString();
                Long dataSize = Long.parseLong(feature.getValue("F_DATASIZE").toString());
                Object productTimeObj = feature.getValue("f_product_time");
                Date productTime = productTimeObj == null ? null : (Date)productTimeObj;
                switch (imageType) {
                    case 11: {
                        if (productTime != null) {
                            calendar.setTime(productTime);
                            if (!originalYearList.contains(calendar.get(1))) {
                                originalYearList.add(calendar.get(1));
                            }
                        }
                        ++originalCount;
                        originalDataSize += dataSize.longValue();
                        this.addStatSatellite(groupDataList, satelliteDataList, satellite, dataSize, originalGroup, 11);
                        break;
                    }
                    case 21: {
                        if (productTime != null) {
                            calendar.setTime(productTime);
                            if (!productYearList.contains(calendar.get(1))) {
                                productYearList.add(calendar.get(1));
                            }
                        }
                        ++productCount;
                        productDataSize += dataSize.longValue();
                        this.addStatSatellite(groupDataList, satelliteDataList, satellite, dataSize, productGroup, 21);
                        break;
                    }
                }
            }
            ArrayList<Integer> timeGroups = new ArrayList<Integer>();
            timeGroups.add(CoverageAnalyseTimeEnum.All.getValue());
            timeGroups.add(CoverageAnalyseTimeEnum.Count.getValue());
            this.imgCoverageAnalyseDao.deleteByTimeGroups(timeGroups, null, 11);
            this.imgCoverageAnalyseDao.deleteByTimeGroups(timeGroups, null, 21);
            this.setDisplayDataSize(groupDataList);
            this.imgCoverageAnalyseDao.batchInsert(groupDataList);
            ArrayList<ImgCoverageAnalyse> countDataList = new ArrayList<ImgCoverageAnalyse>();
            countDataList.add(this.addStatCount("\u539f\u59cb\u5f71\u50cf", originalCount, originalDataSize, 11));
            countDataList.add(this.addStatCount("\u57fa\u7840\u4ea7\u54c1", productCount, productDataSize, 21));
            this.setDisplayDataSize(countDataList);
            this.imgCoverageAnalyseDao.batchInsert(countDataList);
            IFeatureClass coverageAnalyseFc = workspace.openFeatureClass("tbimg_coverageanalyse");
            sp = coverageAnalyseFc.getSpatialReferenceSystem();
            this.coverageAnalyse(originalYearList, originalDictValue, coverageAnalyseFc, 11);
            this.coverageAnalyse(productYearList, productDictValue, coverageAnalyseFc, 21);
            log.info("\u5f71\u50cf\u8986\u76d6\u7387\u5b9a\u65f6\u7edf\u8ba1\u4efb\u52a1\u7ed3\u675f");
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u8986\u76d6\u7387\u5b9a\u65f6\u7edf\u8ba1\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
        try {
            DatasetDTO datasetDTO = this.geoDatabaseService.getDatasetDetail(targetDatabase, DatasetTypeEnum.FeatureClass, "tbimg_coverageanalyse");
            VTileServiceCreateDTO serviceCreateDTO = new VTileServiceCreateDTO();
            serviceCreateDTO.setServiceName("tbimg_coverageanalyse");
            serviceCreateDTO.setDatasetId(datasetDTO.getId());
            DatasetRenderDTO render = this.dataSourceManager.getDatasetRender(serviceCreateDTO.getDatasetId());
            if (render != null) {
                serviceCreateDTO.setServiceName(render.getServiceName());
            }
            if (sp == null) {
                int srid = this.defaultCoordSchemeProperties.getSrid() == null ? 4490 : this.defaultCoordSchemeProperties.getSrid();
                sp = SpatialReferenceSystemFunc.createSpatialReference((int)srid);
            }
            String styleJsonStr = ImageDatasetRenderUtil.getImageDatasetVTileRender((String)serviceCreateDTO.getServiceName(), (Integer)FeatureType.Polygon.getValue(), sp);
            serviceCreateDTO.setStyleJson(styleJsonStr);
            DatasetRenderDTO datasetRenderDTO = this.renderIndexService.createVectorRenderIndex(serviceCreateDTO);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6e32\u67d3\u7d22\u5f15\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void coverageAnalyse(List<Integer> yearList, DmDictValueDTO originalDictValue, IFeatureClass coverageAnalyseFc, Integer imageType) {
        try {
            IGeometry queryGeometry = null;
            String districtItemIdStr = EnvironmentConfig.getProperty((String)"project.original-coverage-area-district-item-id", (String)"");
            if (StringUtil.isEmptyOrWhiteSpace((String)districtItemIdStr)) {
                log.error("\u914d\u7f6e\u9879project.original-coverage-area-district-item-id\u672a\u914d\u7f6e\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u533a\u57df\u5355\u5143");
                List districts = this.districtService.list();
                DmDistrictDTO defaultDistrict = (DmDistrictDTO)ListUtil.find((List)districts, DmDistrictDTO::getIsDefault);
                if (defaultDistrict == null) {
                    log.error("\u5f71\u50cf\u8986\u76d6\u7387\u5b9a\u65f6\u7edf\u8ba1\u4efb\u52a1:\u672a\u627e\u5230\u9ed8\u8ba4\u533a\u57df\u65b9\u6848");
                    return;
                }
                DistrictItemDTO districtItem = this.districtService.getDefaultDistrictItem(defaultDistrict.getId());
                if (districtItem == null) {
                    log.error("\u5f71\u50cf\u8986\u76d6\u7387\u5b9a\u65f6\u7edf\u8ba1\u4efb\u52a1:\u672a\u627e\u5230\u9ed8\u8ba4\u533a\u57df\u5355\u5143");
                    return;
                }
                queryGeometry = this.districtService.getDistrictItemGeometry(districtItem.getId());
            } else {
                queryGeometry = this.districtService.getDistrictItemGeometry(Long.valueOf(Long.parseLong(districtItemIdStr)));
            }
            if (queryGeometry == null) {
                return;
            }
            yearList.sort(Comparator.comparingInt(o -> o));
            QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
            queryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
            queryFilterDTO.setRows(Integer.valueOf(10000));
            ArrayList<String> geometryList = new ArrayList<String>();
            geometryList.add(queryGeometry.toWkt());
            queryFilterDTO.setGeometryList(geometryList);
            queryFilterDTO.setRelation(SpatialRelationType.Intersects);
            ImageDatasetTypeEnum imageTypeEnum = ImageDatasetTypeEnum.getByValue((Integer)imageType);
            for (Integer year : yearList) {
                CoverageAnalyseTimeEnum quarter1 = CoverageAnalyseTimeEnum.Quarter1;
                queryFilterDTO.setCondition(String.format("f_product_time between '%d-01-01 00:00:00' and '%d-03-31 23:59:59' and f_image_type = %d", year, year, imageType));
                this.coverageAnalyseByFilter(year, quarter1, queryFilterDTO, originalDictValue, imageTypeEnum, coverageAnalyseFc);
                CoverageAnalyseTimeEnum quarter2 = CoverageAnalyseTimeEnum.Quarter2;
                queryFilterDTO.setCondition(String.format("f_product_time between '%d-04-01 00:00:00' and '%d-06-30 23:59:59' and f_image_type = %d", year, year, imageType));
                this.coverageAnalyseByFilter(year, quarter2, queryFilterDTO, originalDictValue, imageTypeEnum, coverageAnalyseFc);
                CoverageAnalyseTimeEnum firstHalfYear = CoverageAnalyseTimeEnum.FirstHalfYear;
                queryFilterDTO.setCondition(String.format("f_product_time between '%d-01-01 00:00:00' and '%d-06-30 23:59:59' and f_image_type = %d", year, year, imageType));
                this.coverageAnalyseByFilter(year, firstHalfYear, queryFilterDTO, originalDictValue, imageTypeEnum, coverageAnalyseFc);
                CoverageAnalyseTimeEnum quarter3 = CoverageAnalyseTimeEnum.Quarter3;
                queryFilterDTO.setCondition(String.format("f_product_time between '%d-07-01 00:00:00' and '%d-09-30 23:59:59' and f_image_type = %d", year, year, imageType));
                this.coverageAnalyseByFilter(year, quarter3, queryFilterDTO, originalDictValue, imageTypeEnum, coverageAnalyseFc);
                CoverageAnalyseTimeEnum quarter4 = CoverageAnalyseTimeEnum.Quarter4;
                queryFilterDTO.setCondition(String.format("f_product_time between '%d-10-01 00:00:00' and '%d-12-31 23:59:59' and f_image_type = %d", year, year, imageType));
                this.coverageAnalyseByFilter(year, quarter4, queryFilterDTO, originalDictValue, imageTypeEnum, coverageAnalyseFc);
                CoverageAnalyseTimeEnum latterHalfYear = CoverageAnalyseTimeEnum.LatterHalfYear;
                queryFilterDTO.setCondition(String.format("f_product_time between '%d-07-01 00:00:00' and '%d-12-31 23:59:59' and f_image_type = %d", year, year, imageType));
                this.coverageAnalyseByFilter(year, latterHalfYear, queryFilterDTO, originalDictValue, imageTypeEnum, coverageAnalyseFc);
                CoverageAnalyseTimeEnum yearEnum = CoverageAnalyseTimeEnum.Year;
                queryFilterDTO.setCondition(String.format("f_product_time between '%d-01-01 00:00:00' and '%d-12-31 23:59:59' and f_image_type = %d", year, year, imageType));
                this.coverageAnalyseByFilter(year, yearEnum, queryFilterDTO, originalDictValue, imageTypeEnum, coverageAnalyseFc);
            }
            return;
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u8986\u76d6\u7387\u5b9a\u65f6\u7edf\u8ba1\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void coverageAnalyseByFilter(Integer year, CoverageAnalyseTimeEnum timeEnum, QueryFilterDTO queryFilterDTO, DmDictValueDTO originalDictValue, ImageDatasetTypeEnum imageType, IFeatureClass coverageAnalyseFc) {
        CoverageAnalyseResultDTO analyseResult = this.imageQueryService.coverageAnalyseByFilter(originalDictValue, imageType, queryFilterDTO, (String)queryFilterDTO.getGeometryList().get(0));
        List<ImgCoverageAnalyseDTO> dataList = this.convertAnalyseResult(year, timeEnum, analyseResult, null, "-1", imageType.getValue());
        ArrayList<Integer> timeGroups = new ArrayList<Integer>();
        timeGroups.add(timeEnum.getValue());
        this.imgCoverageAnalyseDao.deleteByTimeGroups(timeGroups, year, imageType.getValue());
        IFeatureCursor insertCursor = coverageAnalyseFc.insertFeature();
        try {
            for (ImgCoverageAnalyseDTO data : dataList) {
                IFeature feature = coverageAnalyseFc.createFeature();
                if (StringUtil.isNotEmpty((String)data.getIntersectionBoundary())) {
                    feature.setGeometry(GeometryFunc.createGeometry((String)data.getIntersectionBoundary()));
                }
                feature.setValue(coverageAnalyseFc.getFields().findFieldIndex("f_item_id"), (Object)data.getItemId());
                feature.setValue(coverageAnalyseFc.getFields().findFieldIndex("f_name"), (Object)data.getName());
                feature.setValue(coverageAnalyseFc.getFields().findFieldIndex("f_group_name"), (Object)data.getGroupName());
                feature.setValue(coverageAnalyseFc.getFields().findFieldIndex("f_group_id"), (Object)data.getGroupId());
                feature.setValue(coverageAnalyseFc.getFields().findFieldIndex("f_data_count"), (Object)data.getDataCount());
                feature.setValue(coverageAnalyseFc.getFields().findFieldIndex("f_data_size"), (Object)data.getDataSize());
                feature.setValue(coverageAnalyseFc.getFields().findFieldIndex("f_display_data_size"), (Object)data.getDisplayDataSize());
                feature.setValue(coverageAnalyseFc.getFields().findFieldIndex("f_coverage_percent"), (Object)data.getCoveragePercent());
                feature.setValue(coverageAnalyseFc.getFields().findFieldIndex("f_year"), (Object)year);
                feature.setValue(coverageAnalyseFc.getFields().findFieldIndex("f_time_group"), (Object)timeEnum.getValue());
                feature.setValue(coverageAnalyseFc.getFields().findFieldIndex("f_image_type"), (Object)data.getImageType());
                insertCursor.insertFeature(feature);
            }
        }
        finally {
            if (insertCursor != null) {
                insertCursor.release();
            }
        }
    }

    private List<ImgCoverageAnalyseDTO> convertAnalyseResult(Integer year, CoverageAnalyseTimeEnum timeEnum, CoverageAnalyseResultDTO currentResult, CoverageAnalyseResultDTO parentResult, String parentId, Integer imageType) {
        ArrayList<ImgCoverageAnalyseDTO> dataList = new ArrayList<ImgCoverageAnalyseDTO>();
        ImgCoverageAnalyseDTO statData = new ImgCoverageAnalyseDTO();
        String currentId = UUID.randomUUID().toString().replace("-", "");
        statData.setItemId(currentId);
        statData.setName(currentResult.getSatellite());
        statData.setGroupName(parentResult == null ? "" : parentResult.getSatellite());
        statData.setGroupId(parentId);
        statData.setDataCount(currentResult.getCount());
        statData.setDataSize(Long.parseLong(currentResult.getDataSize()));
        ArrayList<ImgCoverageAnalyse> list = new ArrayList<ImgCoverageAnalyse>();
        list.add(statData);
        this.setDisplayDataSize(list);
        statData.setCoveragePercent(currentResult.getCoveragePercent());
        statData.setYear(year);
        statData.setTimeGroup(timeEnum.getValue());
        statData.setImageType(imageType);
        statData.setIntersectionBoundary(currentResult.getIntersectionBoundary());
        dataList.add(statData);
        if (currentResult.getChildren() != null && currentResult.getChildren().size() > 0) {
            for (CoverageAnalyseResultDTO child : currentResult.getChildren()) {
                dataList.addAll(this.convertAnalyseResult(year, timeEnum, child, currentResult, currentId, imageType));
            }
        }
        return dataList;
    }

    private List<ImgCoverageAnalyse> addStatGroup(DmDictValueDTO dictValueDTO, Integer imageType, String groupId, String groupName) {
        ArrayList<ImgCoverageAnalyse> statDataList = new ArrayList<ImgCoverageAnalyse>();
        for (DmDictValueDTO child : dictValueDTO.getChildren()) {
            ImgCoverageAnalyse statData = new ImgCoverageAnalyse();
            statData.setItemId(UUID.randomUUID().toString().replace("-", ""));
            statData.setName(child.getCode());
            statData.setGroupName(groupName);
            statData.setGroupId(groupId);
            statData.setDataCount(0);
            statData.setDataSize(0L);
            statData.setDisplayDataSize("0.00KB");
            statData.setCoveragePercent(null);
            statData.setYear(null);
            statData.setTimeGroup(CoverageAnalyseTimeEnum.All.getValue());
            statData.setImageType(imageType);
            statDataList.add(statData);
            if (!"-1".equals(groupId) || child.getChildren() == null || child.getChildren().size() <= 0) continue;
            statDataList.addAll(this.addStatGroup(child, imageType, statData.getItemId(), statData.getName()));
        }
        return statDataList;
    }

    private void addStatSatellite(List<ImgCoverageAnalyse> groupDataList, List<ImgCoverageAnalyse> satelliteDataList, String satellite, Long dataSize, Map<String, List<String>> groupMap, Integer imageType) {
        ImgCoverageAnalyse satelliteData;
        ImgCoverageAnalyse group = null;
        List<String> groupNames = null;
        if (groupMap.containsKey(satellite)) {
            groupNames = groupMap.get(satellite);
            int maxIndex = Math.min(groupNames.size(), 2);
            for (int i = 0; i < maxIndex; ++i) {
                String groupName = groupNames.get(i);
                group = (ImgCoverageAnalyse)ListUtil.find(groupDataList, item -> item.getName().equals(groupName));
                if (group == null) continue;
                group.setDataCount(group.getDataCount() + 1);
                group.setDataSize(group.getDataSize() + dataSize);
            }
        }
        if ((satelliteData = (ImgCoverageAnalyse)ListUtil.find(satelliteDataList, item -> item.getName().equals(satellite))) == null) {
            satelliteData = new ImgCoverageAnalyse();
            satelliteData.setItemId(UUID.randomUUID().toString().replace("-", ""));
            satelliteData.setName(groupNames == null ? satellite : groupNames.get(groupNames.size() - 1));
            satelliteData.setGroupName(group == null ? "\u672a\u77e5" : group.getName());
            satelliteData.setGroupId(group == null ? "" : group.getItemId());
            satelliteData.setDataCount(1);
            satelliteData.setDataSize(dataSize);
            satelliteData.setDisplayDataSize("0.00KB");
            satelliteData.setCoveragePercent(null);
            satelliteData.setYear(null);
            satelliteData.setTimeGroup(CoverageAnalyseTimeEnum.All.getValue());
            satelliteData.setImageType(imageType);
            satelliteDataList.add(satelliteData);
        } else {
            satelliteData.setDataCount(satelliteData.getDataCount() + 1);
            satelliteData.setDataSize(satelliteData.getDataSize() + dataSize);
        }
    }

    private ImgCoverageAnalyse addStatCount(String name, Integer count, Long dataSize, Integer imageType) {
        ImgCoverageAnalyse statData = new ImgCoverageAnalyse();
        statData.setItemId(UUID.randomUUID().toString().replace("-", ""));
        statData.setName(name);
        statData.setGroupName("");
        statData.setGroupId("-1");
        statData.setDataCount(count);
        statData.setDataSize(dataSize);
        statData.setDisplayDataSize("0.00KB");
        statData.setCoveragePercent(null);
        statData.setYear(null);
        statData.setTimeGroup(CoverageAnalyseTimeEnum.Count.getValue());
        statData.setImageType(imageType);
        return statData;
    }

    private void setDisplayDataSize(List<ImgCoverageAnalyse> dataList) {
        for (ImgCoverageAnalyse data : dataList) {
            BigDecimal bigDecimal = new BigDecimal(data.getDataSize() + "");
            String[] unit = new String[]{"B", "KB", "MB", "GB", "TB"};
            int index = 0;
            while (bigDecimal.compareTo(new BigDecimal(1024)) > 0) {
                ++index;
                bigDecimal = bigDecimal.divide(new BigDecimal(1024), 2, RoundingMode.HALF_UP);
            }
            data.setDisplayDataSize(bigDecimal + " " + unit[index]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeCoverageAnalyseDataset(DataSourceDTO targetDatabase) {
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);
        if (workspace == null) {
            log.error("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            return;
        }
        try {
            int srid = this.defaultCoordSchemeProperties.getSrid() == null ? 4490 : this.defaultCoordSchemeProperties.getSrid();
            IFeatureClass coverageAnalyseFc = workspace.openFeatureClass("tbimg_coverageanalyse");
            IFields fields = coverageAnalyseFc.getFields();
            String shapeFieldName = coverageAnalyseFc.getShapeFieldName();
            Fields newFields = new Fields();
            for (int i = 0; i < fields.getFieldCount(); ++i) {
                IField field = fields.getField(i).clone();
                if (field.getFieldType() == FieldType.Shape) {
                    IField shapeField = FieldUtil.buildShapeField((String)shapeFieldName, (String)shapeFieldName, (GeometryType)GeometryType.Polygon, (int)srid);
                    newFields.addField(shapeField);
                    continue;
                }
                newFields.addField(field);
            }
            if (coverageAnalyseFc.getFeatureType() == FeatureType.Unknown || coverageAnalyseFc.getSpatialReferenceSystem().getSrid() != srid) {
                coverageAnalyseFc.delete();
                IFeatureClass featureClass = workspace.createFeatureClass("tbimg_coverageanalyse", (IFields)newFields, FeatureType.Polygon, shapeFieldName, "");
                if (featureClass != null) {
                    featureClass.createSpatialIndex();
                }
            }
        }
        finally {
            workspace.close();
        }
    }

    private void shutdownScheduler() {
        this.scheduler.shutdown();
    }

    static class RunningScheduler {
        public ScheduledFuture<?> future;
        public boolean canceled = false;

        RunningScheduler() {
        }
    }
}

