/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.config.OutputPathConfig;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.ShpfileUtil;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.util.ZipAndRarUtil;
import com.geoway.adf.dms.config.properties.DefaultCoordSchemeProperties;
import com.geoway.adf.dms.datasource.dto.create.FeatureClassCreateDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DatasetInputExportService;
import com.geoway.adf.dms.datasource.service.FeatureClassService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.imagedb.apply.dao.ImgSatelliteDao;
import com.geoway.imagedb.apply.dto.satellite.FeatureExportDTO;
import com.geoway.imagedb.apply.dto.satellite.GeometryExportDTO;
import com.geoway.imagedb.apply.dto.satellite.GeometryProjectDTO;
import com.geoway.imagedb.apply.dto.satellite.SatelliteImageDataDTO;
import com.geoway.imagedb.apply.dto.satellite.SatelliteImageDataFilterDTO;
import com.geoway.imagedb.apply.dto.satellite.SatelliteImageDataResultDTO;
import com.geoway.imagedb.apply.dto.satellite.SatelliteRequirementDTO;
import com.geoway.imagedb.apply.dto.satellite.SatelliteRequirementEditDTO;
import com.geoway.imagedb.apply.entity.ImgSatellite;
import com.geoway.imagedb.apply.service.ImgSatelliteService;
import com.geoway.imagedb.apply.user.LoginUserInfoWithDep;
import com.geoway.imagedb.apply.user.UserInfoService;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dto.query.ImageQueryResult;
import com.geoway.imagedb.dataset.dto.query.ImageResult;
import com.geoway.imagedb.dataset.dto.query.TimeFilterDTO;
import com.geoway.imagedb.dataset.service.ImageQueryService;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImgSatelliteServiceImpl
implements ImgSatelliteService {
    private static final Logger log = LoggerFactory.getLogger(ImgSatelliteServiceImpl.class);
    @Resource
    private ImgSatelliteDao imgSatelliteDao;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private FeatureClassService featureClassService;
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private DatasetInputExportService datasetInputExportService;
    @Resource
    private ImageQueryService imageQueryService;
    @Resource
    private DefaultCoordSchemeProperties defaultCoordSchemeProperties;
    private final String tableName = "tbimg_satellite_requirement";
    private final String filed_objectid = "objectid";
    private final String filed_satellite_id = "f_satellite_id";
    private final String filed_satellite_name = "f_satellite_name";
    private final String filed_enter_time = "f_enter_time";
    private final String filed_exit_time = "f_exit_time";
    private final String filed_xzqhmc = "f_xzqhmc";
    private final String filed_coverage = "f_coverage";
    private final String filed_requirement_time = "f_requirement_time";
    private final String filed_user_id = "f_user_id";
    private final String filed_user_name = "f_user_name";
    private final String filed_department = "f_department";
    private final String filed_planning_status = "f_planning_status";
    private Boolean isCreated = false;

    @Override
    public List<ImgSatellite> list(String keyword, String resolutions, String countries, String types, Integer is_initial_load, Integer is_default_calculate) {
        List resolutionList = null;
        if (StringUtil.isNotEmpty((String)resolutions)) {
            resolutionList = StringUtil.split((String)resolutions, (String)",", f -> f);
        }
        List countryList = null;
        if (StringUtil.isNotEmpty((String)countries)) {
            countryList = StringUtil.split((String)countries, (String)",", f -> f);
        }
        List typeList = null;
        if (StringUtil.isNotEmpty((String)types)) {
            typeList = StringUtil.split((String)types, (String)",", f -> f);
        }
        List list = this.imgSatelliteDao.selectAll(resolutionList, countryList, typeList, is_initial_load, is_default_calculate);
        if (StringUtil.isNotEmpty((String)keyword)) {
            list = ListUtil.findAll(list, f -> f.getName().toLowerCase().contains(keyword.toLowerCase()) || f.getAlias().toLowerCase().contains(keyword.toLowerCase()) || f.getNorad_number().toLowerCase().contains(keyword.toLowerCase()) || f.getCountry().toLowerCase().contains(keyword.toLowerCase()) || f.getType().toLowerCase().contains(keyword.toLowerCase()) || f.getResolution().toLowerCase().contains(keyword.toLowerCase()));
        }
        return list;
    }

    @Override
    public String addOrUpdate(ImgSatellite satellite) {
        if (StringUtil.isEmptyOrWhiteSpace((String)satellite.getName())) {
            throw new RuntimeException("\u536b\u661f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)satellite.getType())) {
            throw new RuntimeException("\u4f20\u611f\u5668\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)satellite.getResolution())) {
            throw new RuntimeException("\u5206\u8fa8\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)satellite.getCountry())) {
            throw new RuntimeException("\u56fd\u5bb6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (satellite.getCloth_width() == null) {
            throw new RuntimeException("\u5bbd\u5e45\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)satellite.getLine1()) || StringUtil.isEmptyOrWhiteSpace((String)satellite.getLine2())) {
            throw new RuntimeException("\u8f68\u9053\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (satellite.getIs_initial_load() == null) {
            satellite.setIs_initial_load(ConstantsValue.FALSE_VALUE);
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)satellite.getId())) {
            List<ImgSatellite> sameNames = this.imgSatelliteDao.selectByName(satellite.getName());
            if (sameNames.size() > 0) {
                throw new RuntimeException("\u536b\u661f\u540d\u79f0\u5df2\u5b58\u5728");
            }
            Integer maxOrder = this.imgSatelliteDao.queryMaxOrder();
            satellite.setOrder(maxOrder == null ? 1 : maxOrder + 1);
            satellite.setId(UUID.randomUUID().toString().replace("-", ""));
            this.imgSatelliteDao.insert(satellite);
        } else {
            List<ImgSatellite> sameNames;
            ImgSatellite old = this.imgSatelliteDao.selectByPrimaryKey(satellite.getId());
            if (old == null) {
                throw new RuntimeException("\u536b\u661f\u4e0d\u5b58\u5728");
            }
            if (!old.getName().equals(satellite.getName()) && (sameNames = this.imgSatelliteDao.selectByName(satellite.getName())).size() > 0) {
                throw new RuntimeException("\u536b\u661f\u540d\u79f0\u5df2\u5b58\u5728");
            }
            this.imgSatelliteDao.updateByPrimaryKeySelective(satellite);
        }
        return satellite.getId();
    }

    @Override
    public void delete(String id) {
        this.imgSatelliteDao.deleteByPrimaryKey(id);
    }

    @Override
    public String importSatellite(MultipartFile file) {
        if (file == null || !Objects.requireNonNull(file.getOriginalFilename()).endsWith(".json")) {
            throw new RuntimeException("\u6587\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        InputStreamReader streamReader = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuffer = new StringBuilder();
        JSONObject jsonObject = null;
        try {
            streamReader = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(streamReader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                stringBuffer.append(line);
            }
            bufferedReader.close();
            streamReader.close();
            jsonObject = JSONObject.parseObject((String)stringBuffer.toString());
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff01" + e.getMessage());
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{streamReader, bufferedReader});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{streamReader, bufferedReader});
        ImgSatellite satellite = (ImgSatellite)JSONObject.parseObject((String)jsonObject.toJSONString(), ImgSatellite.class);
        satellite.setId(null);
        return this.addOrUpdate(satellite);
    }

    @Override
    public void exportSatellite(String id) {
        ImgSatellite satellite = this.imgSatelliteDao.selectByPrimaryKey(id);
        if (satellite != null) {
            String contents = JSONArray.toJSONString((Object)satellite);
            String name = satellite.getName();
            name = name.replaceAll("\\s*", "");
            name = name.replaceAll("[<>:\"/\\\\|?*]", "");
            DownloadUtil.downloadToFile((String)(name + ".json"), (String)contents);
        }
        DownloadUtil.downloadToFile((String)"\u536b\u661f\u4e0d\u5b58\u5728.json", (String)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer addRequirement(List<SatelliteRequirementDTO> requirementList) {
        LoginUserInfoWithDep userInfo = this.userInfoService.getUserInfo();
        this.createSatelliteRequirement();
        DatabaseDTO systemDataSource = this.dataSourceManager.getSystemDataSourceDetail();
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)systemDataSource);
        IFeatureCursor insertCursor = null;
        int count = 0;
        try {
            IFeatureClass featureClass = workspace.openFeatureClass("tbimg_satellite_requirement");
            insertCursor = featureClass.insertFeature();
            for (SatelliteRequirementDTO requirementDTO : requirementList) {
                IFeature feature = featureClass.createFeature();
                if (StringUtil.isNotEmpty((String)requirementDTO.getGeometry())) {
                    feature.setGeometry(GeometryFunc.createGeometry((String)requirementDTO.getGeometry()));
                }
                if (StringUtil.isEmptyOrWhiteSpace((String)requirementDTO.getPlanningStatus())) {
                    requirementDTO.setPlanningStatus("\u53ef\u884c\u6027\u5206\u6790\u4e2d");
                }
                feature.setValue("f_satellite_id", (Object)requirementDTO.getSatelliteId());
                feature.setValue("f_satellite_name", (Object)requirementDTO.getSatelliteName());
                feature.setValue("f_enter_time", (Object)requirementDTO.getEnterTime());
                feature.setValue("f_exit_time", (Object)requirementDTO.getExitTime());
                feature.setValue("f_xzqhmc", (Object)requirementDTO.getXzqhmc());
                feature.setValue("f_coverage", (Object)requirementDTO.getCoverage());
                feature.setValue("f_requirement_time", (Object)new Date());
                feature.setValue("f_user_id", (Object)userInfo.getUserId());
                feature.setValue("f_user_name", (Object)userInfo.getUserName());
                feature.setValue("f_department", (Object)userInfo.getDepartment());
                feature.setValue("f_planning_status", (Object)requirementDTO.getPlanningStatus());
                insertCursor.insertFeature(feature);
                ++count;
            }
            Integer n = count;
            return n;
        }
        finally {
            if (insertCursor != null) {
                insertCursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer updateRequirement(List<SatelliteRequirementEditDTO> requirementList) {
        DatabaseDTO systemDataSource = this.dataSourceManager.getSystemDataSourceDetail();
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)systemDataSource);
        IFeatureCursor updateCursor = null;
        Map<String, List<SatelliteRequirementEditDTO>> map = requirementList.stream().collect(Collectors.groupingBy(SatelliteRequirementEditDTO::getObjectId));
        int count = 0;
        try {
            IFeatureClass featureClass = workspace.openFeatureClass("tbimg_satellite_requirement");
            QueryFilter queryFilter = new QueryFilter();
            queryFilter.setWhereClause("objectid in (" + requirementList.stream().map(SatelliteRequirementEditDTO::getObjectId).collect(Collectors.joining(",")) + ")");
            updateCursor = featureClass.updateFeature((IQueryFilter)queryFilter);
            IFeature feature = null;
            while ((feature = updateCursor.nextFeature()) != null) {
                List<SatelliteRequirementEditDTO> requirementDTOList = map.get(feature.getObjectId().toString());
                feature.setValue("f_planning_status", (Object)requirementDTOList.get(0).getPlanningStatus());
                updateCursor.updateFeature(feature);
                ++count;
            }
            Integer n = count;
            return n;
        }
        finally {
            if (updateCursor != null) {
                updateCursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
        }
    }

    @Override
    public DataQueryResult queryRequirement(Integer pageIndex, Integer rows, Date requirementStartTime, Date requirementEndTime) {
        this.createSatelliteRequirement();
        QueryFilterDTO queryFilterDTO = this.buildQueryFilterDTO(requirementStartTime, requirementEndTime);
        queryFilterDTO.setPageIndex(pageIndex);
        queryFilterDTO.setRows(rows);
        queryFilterDTO.setOrderBy("f_requirement_time desc");
        DatabaseDTO systemDataSource = this.dataSourceManager.getSystemDataSourceDetail();
        DataQueryResult dataQueryResult = this.geoDatabaseService.queryGeoDataset(systemDataSource.getKey(), "tbimg_satellite_requirement", queryFilterDTO);
        dataQueryResult.setFields(this.getReturnFields());
        return dataQueryResult;
    }

    @Override
    public List<String> queryRequirementIds(Date requirementStartTime, Date requirementEndTime) {
        this.createSatelliteRequirement();
        QueryFilterDTO queryFilterDTO = this.buildQueryFilterDTO(requirementStartTime, requirementEndTime);
        long count = 10000L;
        int pageIndex = 0;
        ArrayList<String> ids = new ArrayList<String>();
        queryFilterDTO.setPageIndex(Integer.valueOf(pageIndex));
        queryFilterDTO.setRows(Integer.valueOf(10000));
        queryFilterDTO.setReturnCount(Boolean.valueOf(false));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(false));
        queryFilterDTO.setFields("objectid");
        DatabaseDTO systemDataSource = this.dataSourceManager.getSystemDataSourceDetail();
        while (count == 10000L) {
            queryFilterDTO.setPageIndex(Integer.valueOf(pageIndex));
            DataQueryResult dataQueryResult = this.geoDatabaseService.queryGeoDataset(systemDataSource.getKey(), "tbimg_satellite_requirement", queryFilterDTO);
            if (dataQueryResult.getData() != null && dataQueryResult.getData().size() > 0) {
                count = dataQueryResult.getData().size();
                ++pageIndex;
                for (FeatureResult item : dataQueryResult.getData()) {
                    ids.add(item.getObjectId().toString());
                }
                continue;
            }
            count = 0L;
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportRequirementShp(List<String> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.createSatelliteRequirement();
        String uuid = UUID.randomUUID().toString();
        Path localPath = OutputPathConfig.getOutputPath().resolve(uuid);
        if (!localPath.toFile().exists()) {
            boolean bl = localPath.toFile().mkdirs();
        }
        DatabaseDTO systemDataSource = this.dataSourceManager.getSystemDataSourceDetail();
        IFeatureWorkspace srcWorkspace = null;
        IFeatureWorkspace targetWorkspace = null;
        String shpName = String.format("requirement_%s", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        String targetShpFile = localPath.resolve(String.format("%s", shpName)).toString();
        try {
            srcWorkspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)systemDataSource);
            IFeatureClass srcFc = srcWorkspace.openFeatureClass("tbimg_satellite_requirement");
            targetWorkspace = WorkspaceUtil.createLocalFileGeodatabase((String)targetShpFile);
            Fields fields = new Fields();
            fields.addField(FieldUtil.buildObjectIdField((String)"objectid", (String)"ObjectID"));
            List<ReturnField> returnFields = this.getReturnFields();
            HashMap<String, String> fieldMap = new HashMap<String, String>(0);
            for (ReturnField returnField : returnFields) {
                String fldName = returnField.getName();
                if (returnField.getName().length() > 10) {
                    fldName = fldName.substring(0, 9);
                }
                fields.addField((IField)new Field(fldName, returnField.getAlias(), FieldType.String, 500));
                fieldMap.put(returnField.getName(), fldName);
            }
            fields.addField(FieldUtil.buildShapeField((String)"shape", (String)"ObjectID", (GeometryType)GeometryType.Polygon, (int)(this.defaultCoordSchemeProperties.getSrid() == null ? 4490 : this.defaultCoordSchemeProperties.getSrid())));
            IFeatureClass targetFc = targetWorkspace.createFeatureClass(shpName, (IFields)fields, FeatureType.Polygon, "shape", "");
            if (targetFc == null) {
                throw new RuntimeException("\u8981\u7d20\u7c7b\u521b\u5efa\u5931\u8d25\uff01");
            }
            targetFc.createSpatialIndex();
            VectorDataTransfer vectorDataTransfer = new VectorDataTransfer();
            vectorDataTransfer.setIsErrorContinue(true);
            vectorDataTransfer.setFieldMap(fieldMap);
            QueryFilter srcFilter = new QueryFilter();
            List filters = ListUtil.convertAll(ids, id -> String.format("%s = '%s'", "objectid", id));
            srcFilter.setWhereClause(StringUtil.join((String)" or ", (Iterable)filters));
            TransferResult transferResult = vectorDataTransfer.copyFeature(srcFc, targetFc, (IQueryFilter)srcFilter);
        }
        finally {
            if (srcWorkspace != null) {
                srcWorkspace.close();
            }
            if (targetWorkspace != null) {
                targetWorkspace.close();
            }
        }
        String zipFile = localPath.resolve(shpName + ".zip").toString();
        ZipAndRarUtil.toZip((String)targetShpFile, (String)zipFile, (boolean)true);
        DownloadUtil.downloadFile((String)(localPath.resolve(shpName) + ".zip"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long deleteByIds(List<String> ids) {
        if (ids == null || ids.size() == 0) {
            return 0L;
        }
        this.createSatelliteRequirement();
        DatabaseDTO systemDataSource = this.dataSourceManager.getSystemDataSourceDetail();
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)systemDataSource);){
            IFeatureClass featureClass = workspace.openFeatureClass("tbimg_satellite_requirement");
            QueryFilter srcFilter = new QueryFilter();
            List filters = ListUtil.convertAll(ids, id -> String.format("%s = '%s'", "objectid", id));
            srcFilter.setWhereClause(StringUtil.join((String)" or ", (Iterable)filters));
            long l = featureClass.deleteFeature((IQueryFilter)srcFilter);
            return l;
        }
    }

    @Override
    public String projectGeometry(GeometryProjectDTO projectParam) {
        IGeometry geometry = GeometryFunc.createGeometry((String)projectParam.getGeometry());
        if (geometry != null) {
            ISpatialReferenceSystem srcSystem = SpatialReferenceSystemFunc.createSpatialReference((int)projectParam.getSrcSrid());
            ISpatialReferenceSystem tarSystem = SpatialReferenceSystemFunc.createSpatialReference((int)projectParam.getDstSrid());
            IGeometry projectGeometry = geometry.projectToCopy(srcSystem, tarSystem);
            return projectGeometry.toWkt();
        }
        throw new RuntimeException("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u51e0\u4f55\u5bf9\u8c61\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exportShpFile(GeometryExportDTO geometryExport) {
        ISpatialReferenceSystem srcSrs = SpatialReferenceSystemFunc.createSpatialReference((int)geometryExport.getSrcSrid());
        ISpatialReferenceSystem targetSrs = SpatialReferenceSystemFunc.createSpatialReference((int)geometryExport.getTargetSrid());
        String tempId = "geometry_out_" + UUID.randomUUID();
        Path outputPath = OutputPathConfig.getOutputPath();
        outputPath = outputPath.resolve(tempId);
        File file = outputPath.toFile();
        String outputName = geometryExport.getOutputName();
        FeatureType featureType = FeatureType.getByValue((Integer)geometryExport.getFeatureType());
        IFeatureWorkspace workspace = WorkspaceUtil.createLocalFileGeodatabase((String)file.getAbsolutePath());
        IFeatureClass featureClass = null;
        IFeatureCursor featureCursor = null;
        try {
            Fields fields = new Fields();
            fields.addField(FieldUtil.buildObjectIdField((String)"objectid", (String)"objectid"));
            switch (featureType) {
                case Point: {
                    fields.addField(FieldUtil.buildShapeField((String)"shape", (String)"shape", (GeometryType)GeometryType.Point, (int)geometryExport.getTargetSrid()));
                    break;
                }
                case Polyline: {
                    fields.addField(FieldUtil.buildShapeField((String)"shape", (String)"shape", (GeometryType)GeometryType.Polyline, (int)geometryExport.getTargetSrid()));
                    break;
                }
                case Polygon: {
                    fields.addField(FieldUtil.buildShapeField((String)"shape", (String)"shape", (GeometryType)GeometryType.Polygon, (int)geometryExport.getTargetSrid()));
                    break;
                }
            }
            Map fieldsMap = ShpfileUtil.fieldNameTruncate(geometryExport.getFieldNameList());
            for (String fieldName : fieldsMap.keySet()) {
                fields.addField((IField)new Field((String)fieldsMap.get(fieldName), fieldName, FieldType.String, 500));
            }
            featureClass = workspace.createFeatureClass(outputName, (IFields)fields, featureType, "shape", null);
            featureCursor = featureClass.insertFeature();
            for (FeatureExportDTO item : geometryExport.getFeatures()) {
                IGeometry geometry = GeometryFunc.createGeometry((String)item.getGeometry());
                if (geometry == null) {
                    throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u4e0d\u6b63\u786e");
                }
                if ((geometry = geometry.projectToCopy(srcSrs, targetSrs)) == null) continue;
                IFeature point = featureClass.createFeature();
                point.setGeometry(geometry);
                for (String fieldName : item.getProperties().keySet()) {
                    point.setValue((String)fieldsMap.get(fieldName), (Object)item.getProperties().get(fieldName));
                }
                featureCursor.insertFeature(point);
            }
        }
        finally {
            if (featureCursor != null) {
                featureCursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
        }
        return tempId;
    }

    @Override
    public List<SatelliteImageDataResultDTO> queryImageData(List<SatelliteImageDataFilterDTO> satellites) {
        if (satellites == null || satellites.size() == 0) {
            return new ArrayList<SatelliteImageDataResultDTO>();
        }
        Map<String, List<SatelliteImageDataFilterDTO>> satelliteGroup = satellites.stream().collect(Collectors.groupingBy(SatelliteImageDataFilterDTO::getSatelliteId));
        ArrayList<SatelliteImageDataDTO> imageDataList = new ArrayList<SatelliteImageDataDTO>();
        List<ImgSatellite> list = this.imgSatelliteDao.selectByIds(ListUtil.convertAll(satellites, SatelliteImageDataFilterDTO::getSatelliteId));
        if (list == null || list.size() == 0) {
            return new ArrayList<SatelliteImageDataResultDTO>();
        }
        ArrayList<String> conditions = new ArrayList<String>();
        for (ImgSatellite imgSatellite : list) {
            SatelliteImageDataFilterDTO dataFilterDTO = satelliteGroup.get(imgSatellite.getId()).get(0);
            ArrayList<TimeFilterDTO> timeArray = new ArrayList<TimeFilterDTO>();
            TimeFilterDTO timeFilterDTO = new TimeFilterDTO();
            timeFilterDTO.setStartTime(dataFilterDTO.getStartTime());
            timeFilterDTO.setEndTime(dataFilterDTO.getEndTime());
            timeArray.add(timeFilterDTO);
            List timeFilters = ImageDateUtil.convertTimeFilters(timeArray, (String)"f_product_time");
            conditions.add(String.format("(%s = '%s' and %s)", "f_satellite", imgSatellite.getAlias(), timeFilters.get(0)));
        }
        Map<String, List<ImgSatellite>> map = list.stream().collect(Collectors.groupingBy(ImgSatellite::getAlias));
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setCondition(StringUtil.join((String)" or ", conditions));
        queryFilterDTO.setPageIndex(Integer.valueOf(0));
        queryFilterDTO.setRows(Integer.valueOf(10000));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(false));
        ImageQueryResult imageQueryResult = this.imageQueryService.query(queryFilterDTO, Integer.valueOf(0), ImageDatasetTypeEnum.OriginalImageDataset);
        if (imageQueryResult.getData() != null && imageQueryResult.getData().size() > 0) {
            for (ImageResult imageResult : imageQueryResult.getData()) {
                String satelliteName = imageResult.getAttributes().get("f_satellite").toString();
                String dataId = imageResult.getDataId();
                String dataName = imageResult.getAttributes().get("F_DATANAME").toString();
                List<ImgSatellite> satelliteList = map.get(satelliteName);
                for (ImgSatellite satellite : satelliteList) {
                    SatelliteImageDataDTO imageDataDTO = new SatelliteImageDataDTO();
                    imageDataDTO.setSatelliteId(satellite.getId());
                    imageDataDTO.setImageDataName(dataName);
                    imageDataDTO.setDataId(dataId);
                    imageDataList.add(imageDataDTO);
                }
            }
        }
        if (imageDataList.size() > 0) {
            ArrayList<SatelliteImageDataResultDTO> results = new ArrayList<SatelliteImageDataResultDTO>();
            Map<String, List<SatelliteImageDataDTO>> dataMap = imageDataList.stream().collect(Collectors.groupingBy(SatelliteImageDataDTO::getSatelliteId));
            for (String satelliteId : dataMap.keySet()) {
                List<SatelliteImageDataDTO> dataList = dataMap.get(satelliteId);
                SatelliteImageDataResultDTO result = new SatelliteImageDataResultDTO();
                result.setSatelliteId(satelliteId);
                result.setDataList(dataList);
                results.add(result);
            }
            return results;
        }
        return new ArrayList<SatelliteImageDataResultDTO>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSatelliteRequirement() {
        if (this.isCreated.booleanValue()) {
            return;
        }
        DatabaseDTO systemDataSource = this.dataSourceManager.getSystemDataSourceDetail();
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)systemDataSource);){
            this.isCreated = workspace.datasetExist("tbimg_satellite_requirement");
            if (!this.isCreated.booleanValue()) {
                String dsKey = this.dataSourceManager.getSystemDataSourceDetail().getKey();
                FeatureClassCreateDTO createDTO = new FeatureClassCreateDTO();
                createDTO.setName("tbimg_satellite_requirement");
                createDTO.setAliasName("tbimg_satellite_requirement");
                createDTO.setDsKey(dsKey);
                createDTO.setFeatureType(Integer.valueOf(FeatureType.Polygon.getValue()));
                int srid = this.defaultCoordSchemeProperties.getSrid() == null ? 4490 : this.defaultCoordSchemeProperties.getSrid();
                createDTO.setSrid(Integer.valueOf(srid));
                ArrayList<FieldDTO> fields = new ArrayList<FieldDTO>();
                fields.add(FieldUtil.convertField((IField)new Field("f_satellite_id", "\u536b\u661f\u6807\u8bc6", FieldType.String, 32)));
                fields.add(FieldUtil.convertField((IField)new Field("f_satellite_name", "\u536b\u661f", FieldType.String, 255)));
                fields.add(FieldUtil.convertField((IField)new Field("f_enter_time", "\u5165\u5883\u65f6\u95f4", FieldType.DateTime)));
                fields.add(FieldUtil.convertField((IField)new Field("f_exit_time", "\u51fa\u5883\u65f6\u95f4", FieldType.DateTime)));
                fields.add(FieldUtil.convertField((IField)new Field("f_xzqhmc", "\u8fc7\u5883\u653f\u533a", FieldType.String, 255)));
                fields.add(FieldUtil.convertField((IField)new Field("f_coverage", "\u8986\u76d6\u7387", FieldType.String, 255)));
                fields.add(FieldUtil.convertField((IField)new Field("f_requirement_time", "\u9700\u6c42\u63d0\u4ea4\u65f6\u95f4", FieldType.DateTime)));
                fields.add(FieldUtil.convertField((IField)new Field("f_user_id", "\u63d0\u4ea4\u4eba\u5458\u6807\u8bc6", FieldType.String, 255)));
                fields.add(FieldUtil.convertField((IField)new Field("f_user_name", "\u63d0\u4ea4\u4eba\u5458", FieldType.String, 255)));
                fields.add(FieldUtil.convertField((IField)new Field("f_department", "\u63d0\u4ea4\u5355\u4f4d", FieldType.String, 255)));
                createDTO.setFields(fields);
                String datasetId = this.featureClassService.createFeatureClass(createDTO);
                log.debug("\u521b\u5efa\u4e1a\u52a1\u8981\u7d20\u7c7b\uff1atbimg_satellite_requirement");
            } else {
                IFeatureClass featureClass = workspace.openFeatureClass("tbimg_satellite_requirement");
                if (featureClass.getFields().findFieldIndex("f_planning_status") < 0) {
                    featureClass.addField((IField)new Field("f_planning_status", "\u4efb\u52a1\u89c4\u5212\u72b6\u6001", FieldType.String, 255));
                }
            }
        }
    }

    private QueryFilterDTO buildQueryFilterDTO(Date requirementStartTime, Date requirementEndTime) {
        LoginUserInfoWithDep userInfo = this.userInfoService.getUserInfo();
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnCount(Boolean.valueOf(true));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(false));
        if (requirementStartTime != null && requirementEndTime != null) {
            ArrayList<TimeFilterDTO> timeArray = new ArrayList<TimeFilterDTO>();
            TimeFilterDTO timeFilterDTO = new TimeFilterDTO();
            timeFilterDTO.setStartTime(requirementStartTime);
            timeFilterDTO.setEndTime(requirementEndTime);
            timeArray.add(timeFilterDTO);
            List timeFilters = ImageDateUtil.convertTimeFilters(timeArray, (String)"f_requirement_time");
            queryFilterDTO.setCondition((String)timeFilters.get(0));
        }
        if (this.userInfoService.isAdminOrApprove(userInfo).booleanValue()) {
            if (StringUtil.isNotEmpty((String)queryFilterDTO.getCondition())) {
                queryFilterDTO.setCondition(String.format(" %s = '%s' and (%s)", "f_user_id", userInfo.getUserId(), queryFilterDTO.getCondition()));
            } else {
                queryFilterDTO.setCondition(String.format("%s = '%s'", "f_user_id", userInfo.getUserId()));
            }
        }
        return queryFilterDTO;
    }

    private List<ReturnField> getReturnFields() {
        ArrayList<ReturnField> list = new ArrayList<ReturnField>();
        list.add(new ReturnField("f_satellite_name", "\u536b\u661f", Integer.valueOf(FieldType.String.getValue())));
        list.add(new ReturnField("f_enter_time", "\u5165\u5883\u65f6\u95f4", Integer.valueOf(FieldType.DateTime.getValue())));
        list.add(new ReturnField("f_exit_time", "\u51fa\u5883\u65f6\u95f4", Integer.valueOf(FieldType.DateTime.getValue())));
        list.add(new ReturnField("f_xzqhmc", "\u8fc7\u5883\u653f\u533a", Integer.valueOf(FieldType.String.getValue())));
        list.add(new ReturnField("f_coverage", "\u8986\u76d6\u7387", Integer.valueOf(FieldType.String.getValue())));
        list.add(new ReturnField("f_requirement_time", "\u9700\u6c42\u63d0\u4ea4\u65f6\u95f4", Integer.valueOf(FieldType.DateTime.getValue())));
        list.add(new ReturnField("f_user_name", "\u63d0\u4ea4\u4eba\u5458", Integer.valueOf(FieldType.String.getValue())));
        list.add(new ReturnField("f_department", "\u63d0\u4ea4\u5355\u4f4d", Integer.valueOf(FieldType.String.getValue())));
        list.add(new ReturnField("f_planning_status", "\u4efb\u52a1\u89c4\u5212\u72b6\u6001", Integer.valueOf(FieldType.String.getValue())));
        return list;
    }
}

