/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.util;

import cn.hutool.core.date.DateUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.imagedb.dataset.dto.query.TimeFilterDTO;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class ImageDateUtil {
    public static String format(Date date, String format) {
        if (date == null) {
            return null;
        }
        return DateUtil.format((Date)date, (String)format);
    }

    public static Date parse(String dateStr) {
        if (StringUtil.isEmptyOrWhiteSpace((String)dateStr)) {
            return null;
        }
        if (dateStr.toUpperCase(Locale.ROOT).contains("T") && dateStr.length() == "yyyy-MM-dd HH:mm:ss.SSSSSS".length()) {
            dateStr = dateStr.substring(0, dateStr.length() - 3);
            dateStr = dateStr.replace("T", " ");
            return DateUtil.parse((CharSequence)dateStr);
        }
        if (dateStr.toUpperCase(Locale.ROOT).endsWith("Z")) {
            Instant instant = Instant.parse(dateStr);
            return Date.from(instant);
        }
        return DateUtil.parse((CharSequence)dateStr);
    }

    public static List<String> convertTimeFilters(List<TimeFilterDTO> timeArray, String timeFiField) {
        ArrayList<String> timeFilters = new ArrayList<String>();
        for (TimeFilterDTO timeFilterDTO : timeArray) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timeFilterDTO.getStartTime());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String start = dateFormat.format(calendar.getTime());
            calendar.setTime(timeFilterDTO.getEndTime());
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            String end = dateFormat.format(calendar.getTime());
            String item = String.format("(%s between '%s' and '%s')", timeFiField, start, end);
            timeFilters.add(item);
        }
        return timeFilters;
    }
}

