/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.PinyinUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.config.filemodel.constant.CatalogFileTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.edit.DataBatchDeleteDTO;
import com.geoway.adf.dms.datasource.dto.edit.DataBatchUpdateDTO;
import com.geoway.adf.dms.datasource.dto.edit.GeoDataEditDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.FilterDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceCreateDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DatumDatabaseService;
import com.geoway.adf.dms.datasource.service.FileDataService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseEditService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.service.impl.DatumDatabaseEditServiceImpl;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoTableQueryCheckUtil;
import com.geoway.adf.dms.datasource.util.SpatailQueryUtil;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.imagedb.dataset.dao.ImgDatasetDao;
import com.geoway.imagedb.dataset.dto.ImgDatumTypeDTO;
import com.geoway.imagedb.dataset.dto.ImgDatumTypeFieldDTO;
import com.geoway.imagedb.dataset.dto.dataset.ImageGeoDatasetDTO;
import com.geoway.imagedb.dataset.dto.dataset.ImageMosaicDatasetDTO;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.entity.ImgRecycle;
import com.geoway.imagedb.dataset.event.ImageDataAfterDeleteEvent;
import com.geoway.imagedb.dataset.event.ImageDatasetFieldValueAfterUpdateEvent;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.service.ImageRecycleService;
import com.geoway.imagedb.dataset.util.ImageDatasetRenderUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@Primary
public class ImageDataEditServiceImpl
extends DatumDatabaseEditServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ImageDataEditServiceImpl.class);
    @Resource
    private DatumDatabaseService datumDatabaseService;
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private ImageRecycleService imageRecycleService;
    @Resource
    private FileDataService fileDataService;
    @Resource
    private RenderIndexService renderIndexService;
    @Resource
    private GeoDatabaseEditService geoDatabaseEditService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private ImgDatasetDao imgDatasetDao;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public boolean updateData(GeoDataEditDTO geoDataEditDTO) {
        ImgDataset imgDataset = this.imgDatasetDao.selectByPrimaryKey(geoDataEditDTO.getDatasetId());
        if (imgDataset == null) {
            return super.updateData(geoDataEditDTO);
        }
        DatumDatasetDTO datasetDTO = this.datumDatabaseService.getDatasetDetail(geoDataEditDTO.getDatasetId());
        this.editImageData(datasetDTO, geoDataEditDTO.getObjectId().toString(), geoDataEditDTO.getData());
        return true;
    }

    public boolean deleteData(String datasetId, String objectId, Boolean updateRenderIndex) {
        ImgDataset imgDataset = this.imgDatasetDao.selectByPrimaryKey(datasetId);
        if (imgDataset == null) {
            return super.deleteData(datasetId, objectId, updateRenderIndex);
        }
        this.recycleImageData(datasetId, objectId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long batchUpdateDataByFilter(DataBatchUpdateDTO dataBatchUpdateDTO) {
        long l;
        IFeatureWorkspace workspace;
        block13: {
            Assert.notNull((Object)dataBatchUpdateDTO.getUpdateField(), (String)"\u66f4\u65b0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.notNull((Object)dataBatchUpdateDTO.getUpdateValueScript(), (String)"\u66f4\u65b0\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            ImgDataset imgDataset = this.imgDatasetDao.selectByPrimaryKey(dataBatchUpdateDTO.getDatasetId());
            if (imgDataset == null) {
                return super.batchUpdateDataByFilter(dataBatchUpdateDTO);
            }
            DatumDatasetDTO datasetDTO = this.datumDatabaseService.getDatasetDetail(dataBatchUpdateDTO.getDatasetId());
            Assert.notNull((Object)datasetDTO, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
            String geoDatasetId = datasetDTO.getGeoDatasetId();
            DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)geoDatasetId);
            DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(datasetNameInfo.getDsKey());
            QueryFilterBasicDTO checkFilter = new QueryFilterBasicDTO();
            checkFilter.setCondition(dataBatchUpdateDTO.getCondition());
            checkFilter.setFields(dataBatchUpdateDTO.getUpdateValueScript());
            GeoTableQueryCheckUtil.checkTableSingleQuery((DataSourceTypeEnum)DataSourceTypeEnum.getByValue((Integer)dataSourceDTO.getDataSourceType()), (QueryFilterBasicDTO)checkFilter);
            workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
            Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            ICursor cursor = null;
            try {
                ITable table = null;
                DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)datasetNameInfo.getType());
                switch (datasetType) {
                    case FeatureClass: {
                        table = (ITable)workspace.openFeatureClass(datasetNameInfo.getName());
                        break;
                    }
                    case Table: {
                        table = workspace.openTable(datasetNameInfo.getName());
                        break;
                    }
                    case MosaicDataset: {
                        IMosaicDataset mosaicDataset = workspace.openMosaicDataset(datasetNameInfo.getName());
                        Assert.notNull((Object)mosaicDataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                        table = (ITable)mosaicDataset.getCatalog();
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7f16\u8f91\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + datasetType);
                    }
                }
                Assert.notNull((Object)table, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                SpatialQueryFilter queryFilter = SpatailQueryUtil.buildFilter((FilterDTO)dataBatchUpdateDTO, (IGeoDataset)table);
                queryFilter.setSubFields(String.format("%s,(%s) as value", table.getOidFieldName(), dataBatchUpdateDTO.getUpdateValueScript()));
                cursor = table.searchRow((IQueryFilter)queryFilter);
                IRow row = cursor.nextRow();
                int count = 0;
                while (row != null) {
                    String oid = row.getObjectId().toString();
                    Object value = row.getValue("value");
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put(dataBatchUpdateDTO.getUpdateField(), value);
                    this.editImageData(datasetDTO, oid, data);
                    ++count;
                    row = cursor.nextRow();
                }
                l = count;
                if (cursor == null) break block13;
            }
            catch (Throwable throwable) {
                if (cursor != null) {
                    cursor.release();
                }
                workspace.close();
                throw throwable;
            }
            cursor.release();
        }
        workspace.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long deleteDataByFilter(DataBatchDeleteDTO dataBatchDeleteDTO) {
        ImgDataset imgDataset = this.imgDatasetDao.selectByPrimaryKey(dataBatchDeleteDTO.getDatasetId());
        if (imgDataset == null) {
            return super.deleteDataByFilter(dataBatchDeleteDTO);
        }
        String geoDatasetId = imgDataset.getGeoDatasetId();
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)geoDatasetId);
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(datasetNameInfo.getDsKey());
        QueryFilterBasicDTO checkFilter = new QueryFilterBasicDTO();
        checkFilter.setCondition(dataBatchDeleteDTO.getCondition());
        GeoTableQueryCheckUtil.checkTableSingleQuery((DataSourceTypeEnum)DataSourceTypeEnum.getByValue((Integer)dataSourceDTO.getDataSourceType()), (QueryFilterBasicDTO)checkFilter);
        ArrayList<String> objectIdList = new ArrayList<String>();
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        ICursor cursor = null;
        try {
            ITable table = null;
            DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)datasetNameInfo.getType());
            switch (datasetType) {
                case FeatureClass: {
                    table = (ITable)workspace.openFeatureClass(datasetNameInfo.getName());
                    break;
                }
                case Table: {
                    table = workspace.openTable(datasetNameInfo.getName());
                    break;
                }
                case MosaicDataset: {
                    IMosaicDataset mosaicDataset = workspace.openMosaicDataset(datasetNameInfo.getName());
                    Assert.notNull((Object)mosaicDataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                    table = (ITable)mosaicDataset.getCatalog();
                    break;
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7f16\u8f91\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + datasetType);
                }
            }
            Assert.notNull((Object)table, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            SpatialQueryFilter queryFilter = SpatailQueryUtil.buildFilter((FilterDTO)dataBatchDeleteDTO, (IGeoDataset)table);
            queryFilter.setSubFields(table.getOidFieldName());
            cursor = table.searchRow((IQueryFilter)queryFilter);
            IRow row = cursor.nextRow();
            while (row != null) {
                String oid = row.getObjectId().toString();
                objectIdList.add(oid);
                row = cursor.nextRow();
            }
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
        if (objectIdList.size() > 0) {
            this.updateImageFlag(dataBatchDeleteDTO.getDatasetId(), objectIdList, 1);
        }
        return objectIdList.size();
    }

    public void recycleImageData(String datasetId, String objectId) {
        ArrayList<String> objectIdList = new ArrayList<String>();
        objectIdList.add(objectId);
        this.updateImageFlag(datasetId, objectIdList, 1);
    }

    public void restoreImageData(String datasetId, List<String> objectIdList) {
        if (objectIdList == null || objectIdList.size() == 0) {
            return;
        }
        this.updateImageFlag(datasetId, objectIdList, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteImageData(String datasetId, List<String> objectIdList, Boolean deleteFile) {
        if (objectIdList == null || objectIdList.size() == 0) {
            return;
        }
        List<ImgRecycle> imgRecycleList = this.imageRecycleService.queryByDatasetObjectIdList(datasetId, objectIdList);
        if (imgRecycleList.size() == 0) {
            log.error("\u56de\u6536\u7ad9\u672a\u67e5\u8be2\u5230\u9700\u8981\u5220\u9664\u7684\u6570\u636e\uff1a" + String.join((CharSequence)",", objectIdList));
            return;
        }
        ImgDataset imgDataset = this.imageDatasetService.getImgDataset(datasetId);
        if (imgDataset == null) {
            return;
        }
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)imgDataset.getGeoDatasetId());
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)nameInfo.getType());
        DataSourceDTO targetDatabase = this.dataSourceManager.getGeoDatabaseDetail(nameInfo.getDsKey());
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);
        List dataIdList = ListUtil.convertAll(imgRecycleList, ImgRecycle::getDataId);
        List filters = ListUtil.convertAll((List)dataIdList, f -> String.format("%s = '%s'", "F_DATAID", f));
        String filter = String.join((CharSequence)" or ", filters);
        try {
            String sql;
            if (datasetType == DatasetTypeEnum.MosaicDataset) {
                sql = String.format("delete from GWMD_%s_CAT where %s", nameInfo.getShortName(), filter);
                workspace.excuteSql(sql);
            } else if (datasetType == DatasetTypeEnum.FeatureClass) {
                sql = String.format("delete from %s where %s", nameInfo.getShortName(), filter);
                workspace.excuteSql(sql);
                String snapshotDatasetName = this.imageDatasetService.getSnapshotDatasetName(nameInfo.getShortName());
                sql = String.format("delete from GWMD_%s_CAT where %s", snapshotDatasetName, filter);
                workspace.excuteSql(sql);
            }
        }
        finally {
            workspace.close();
        }
        this.imageDatasetService.deleteBusinessSnapshotByDataId(dataIdList);
        this.imageRecycleService.deleteImageRecycleByDataIdList(dataIdList);
        this.reloadSnapshotRender(datasetId);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ImageDataAfterDeleteEvent((Object)this, dataIdList, null, null));
        for (String dataId : dataIdList) {
            try {
                if (deleteFile.booleanValue()) {
                    DmFileData dmFileData = this.fileDataService.getFileData(dataId);
                    String serviceUrl = "";
                    if (dmFileData.getIsOnServer() != null && dmFileData.getIsOnServer().intValue() == ConstantsValue.TRUE_VALUE.intValue()) {
                        String serverId = dmFileData.getServerId();
                        DataSourceDTO serverDataSource = this.dataSourceManager.getDataSourceDetail(serverId);
                        serviceUrl = serverDataSource.getUrl();
                    }
                    ArrayList<String> emptyDirPathList = new ArrayList<String>();
                    List dataUnitList = JSONArray.parseArray((String)dmFileData.getCatalogFiles(), FileDataUnit.class);
                    for (FileDataUnit dataUnit : dataUnitList) {
                        String filePath = Paths.get(serviceUrl, dataUnit.getFileLocation()).toString().replace("\\", "/");
                        String srcFilePath = dataUnit.getFileSourceLocation().replace("\\", "/");
                        if (!StringUtil.isNotEmpty((String)dataUnit.getServerId())) continue;
                        File file = new File(filePath);
                        if (file.isFile()) {
                            boolean bl = file.delete();
                            continue;
                        }
                        if (dataUnit.getCatalogFileType() == CatalogFileTypeEnum.FolderWithChildren) {
                            FileUtil.deleteDir((String)filePath);
                            continue;
                        }
                        emptyDirPathList.add(filePath);
                    }
                    for (String emptyPath : emptyDirPathList) {
                        File dir = new File(emptyPath);
                        String[] childFiles = dir.list();
                        if (childFiles != null && childFiles.length != 0) continue;
                        boolean bl = dir.delete();
                    }
                }
                this.fileDataService.deleteFileData(dataId);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void editImageData(DatumDatasetDTO datasetDTO, String objectId, Map<String, Object> data) {
        DataQueryResult queryResult;
        ImgDatumTypeDTO datumTypeDTO = null;
        if (datasetDTO instanceof ImageGeoDatasetDTO) {
            datumTypeDTO = ((ImageGeoDatasetDTO)datasetDTO).getDatumTypeModel();
        } else if (datasetDTO instanceof ImageMosaicDatasetDTO) {
            datumTypeDTO = ((ImageMosaicDatasetDTO)datasetDTO).getDatumTypeModel();
        }
        if (datumTypeDTO == null) {
            throw new RuntimeException("\u53ea\u5141\u8bb8\u7f16\u8f91\u5f71\u50cf\u6570\u636e\u96c6\uff01");
        }
        List<ImgDatumTypeFieldDTO> fields = datumTypeDTO.getFields();
        HashMap<String, Object> canEditData = new HashMap<String, Object>(0);
        HashMap<String, Object> sysCanEditData = new HashMap<String, Object>(0);
        for (String fieldName : data.keySet()) {
            String cloud;
            if (fieldName.equalsIgnoreCase("f_cloud") && data.get(fieldName) != null && StringUtil.isNotEmpty((String)data.get(fieldName).toString()) && (Double.parseDouble(cloud = data.get(fieldName).toString()) < 0.0 || Double.parseDouble(cloud) > 100.0)) {
                throw new RuntimeException("\u4e91\u91cf\u503c\u5fc5\u987b\u57280-100\u4e4b\u95f4");
            }
            ImgDatumTypeFieldDTO field = (ImgDatumTypeFieldDTO)((Object)ListUtil.find(fields, f -> f.getName().equalsIgnoreCase(fieldName)));
            if (field == null || !field.getCanEdit().booleanValue() || field.getFieldType().intValue() == FieldType.OID.getValue() || field.getFieldType().intValue() == FieldType.Shape.getValue()) continue;
            Object valueObj = data.get(fieldName);
            if (data.get(fieldName) == null || StringUtil.isEmptyOrWhiteSpace((String)data.get(fieldName).toString())) {
                if (!field.getNullable().booleanValue()) {
                    throw new RuntimeException(String.format("\u5b57\u6bb5\u3010%s\u3011\u4e0d\u5141\u8bb8\u4e3a\u7a7a", fieldName));
                }
                if (field.getFieldType().intValue() == FieldType.DateTime.getValue()) {
                    valueObj = null;
                }
            }
            if (field.getSystemField().booleanValue()) {
                if (!"f_satellite".equalsIgnoreCase(fieldName) && !"f_sensor".equalsIgnoreCase(fieldName) && !"f_product_time".equalsIgnoreCase(fieldName) && !"f_cloud".equalsIgnoreCase(fieldName) && !"f_classification".equalsIgnoreCase(fieldName) && !"f_time".equalsIgnoreCase(fieldName) && !"f_resolution".equalsIgnoreCase(fieldName)) continue;
                sysCanEditData.put(fieldName, valueObj);
            }
            canEditData.put(fieldName, valueObj);
        }
        GeoDataEditDTO editDTO = new GeoDataEditDTO();
        editDTO.setDatasetId(datasetDTO.getGeoDatasetId());
        editDTO.setObjectId((Object)objectId);
        editDTO.setData(canEditData);
        this.geoDatabaseEditService.updateData(editDTO);
        if (sysCanEditData.size() > 0 && (queryResult = this.geoDatabaseService.queryByObjectId(datasetDTO.getGeoDatasetId(), (Object)objectId, "F_DATAID", Boolean.valueOf(false))).getData() != null && queryResult.getData().size() > 0) {
            Map attributes = ((FeatureResult)queryResult.getData().get(0)).getAttributes();
            String dataId = attributes.get("F_DATAID").toString();
            this.updateImageDataSysFields(dataId, sysCanEditData);
        }
    }

    private void updateImageDataSysFields(String dataId, Map<String, Object> sysCanEditData) {
        this.imageDatasetService.updateBusinessSnapshotByDataId(dataId, sysCanEditData);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ImageDatasetFieldValueAfterUpdateEvent((Object)this, dataId, sysCanEditData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImageFlag(String datasetId, List<String> objectIdList, int flag) {
        if (objectIdList == null || objectIdList.size() == 0) {
            return;
        }
        ImgDataset imgDataset = this.imageDatasetService.getImgDataset(datasetId);
        if (imgDataset == null) {
            return;
        }
        int category = 1;
        if (flag == 1) {
            category = 99;
        }
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)imgDataset.getGeoDatasetId());
        DataSourceDTO targetDatabase = this.dataSourceManager.getGeoDatabaseDetail(nameInfo.getDsKey());
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);
        IFeatureCursor updateCursor = null;
        IFeatureCursor snapshotUpdateCursor = null;
        IFeatureClass featureClass = null;
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)nameInfo.getType());
        try {
            if (datasetType == DatasetTypeEnum.MosaicDataset) {
                IMosaicDataset mosaicDataset = workspace.openMosaicDataset(nameInfo.getShortName());
                featureClass = mosaicDataset.getCatalog();
            } else if (datasetType == DatasetTypeEnum.FeatureClass) {
                featureClass = workspace.openFeatureClass(nameInfo.getShortName());
            }
            if (featureClass == null) {
                return;
            }
            int flagFieldIndex = featureClass.getFields().findFieldIndex("f_flag");
            if (flagFieldIndex < 0) {
                featureClass.addField((IField)new Field("f_flag", "\u6807\u5fd7", FieldType.Int, 32, 0, false, (Object)0));
                this.createGeoDatasetIndex((ITable)featureClass, "f_flag");
                this.renderIndexService.deleteDatasetRender(datasetId);
                String serviceName = PinyinUtil.convertToPinYin((String)nameInfo.getShortName());
                if (serviceName.length() > 60) {
                    serviceName = serviceName.substring(0, 60);
                }
                VTileServiceCreateDTO serviceCreateDTO = new VTileServiceCreateDTO();
                serviceCreateDTO.setServiceName(serviceName);
                serviceCreateDTO.setDatasetId(imgDataset.getGeoDatasetId());
                String styleJsonStr = ImageDatasetRenderUtil.getImageDatasetVTileRender(serviceCreateDTO.getServiceName(), featureClass.getFeatureType().getValue());
                serviceCreateDTO.setStyleJson(styleJsonStr);
                this.renderIndexService.createVectorRenderIndex(serviceCreateDTO);
            }
            ArrayList<String> dataIdList = new ArrayList<String>();
            QueryFilter filter = new QueryFilter();
            String oidFiledName = featureClass.getOidFieldName();
            List filterList = ListUtil.convertAll(objectIdList, f -> String.format("%s = '%s'", oidFiledName, f));
            filter.setWhereClause(String.join((CharSequence)" or ", filterList));
            updateCursor = featureClass.updateFeature((IQueryFilter)filter);
            IFeature feature = null;
            while ((feature = updateCursor.nextFeature()) != null) {
                Object dataIdObj;
                feature.setValue("f_flag", (Object)flag);
                if (datasetType == DatasetTypeEnum.MosaicDataset) {
                    feature.setValue("category", (Object)category);
                }
                if ((dataIdObj = feature.getValue("F_DATAID")) != null) {
                    String dataId = dataIdObj.toString();
                    dataIdList.add(dataId);
                    if (flag == 1) {
                        this.imageRecycleService.addImageToRecycle(dataId, feature.getObjectId().toString(), datasetId);
                    } else if (flag == 0) {
                        this.imageRecycleService.deleteImageRecycleByDataId(dataId);
                    }
                }
                updateCursor.updateFeature(feature);
            }
            updateCursor.release();
            if (dataIdList.size() == 0) {
                return;
            }
            if (datasetType == DatasetTypeEnum.FeatureClass) {
                QueryFilter snapshotFilter = new QueryFilter();
                List dataIdFilterList = ListUtil.convertAll(dataIdList, f -> String.format("%s = '%s'", "F_DATAID", f));
                snapshotFilter.setWhereClause(StringUtil.join((String)" or ", (Iterable)dataIdFilterList));
                String snapshotDatasetName = this.imageDatasetService.getSnapshotDatasetName(nameInfo.getShortName());
                IMosaicDataset mosaicDataset = workspace.openMosaicDataset(snapshotDatasetName);
                if (mosaicDataset != null) {
                    snapshotUpdateCursor = mosaicDataset.getCatalog().updateFeature((IQueryFilter)snapshotFilter);
                    IFeature snapshotFeature = null;
                    while ((snapshotFeature = snapshotUpdateCursor.nextFeature()) != null) {
                        snapshotFeature.setValue("category", (Object)category);
                        snapshotUpdateCursor.updateFeature(snapshotFeature);
                    }
                    snapshotUpdateCursor.release();
                }
            }
            this.imageDatasetService.recycleBusinessSnapshotByDataId(dataIdList, category);
        }
        finally {
            if (updateCursor != null) {
                updateCursor.release();
            }
            if (snapshotUpdateCursor != null) {
                snapshotUpdateCursor.release();
            }
            workspace.close();
        }
        this.reloadSnapshotRender(datasetId);
    }

    private void reloadSnapshotRender(String datasetId) {
        try {
            DatasetRenderDTO snapshotDatasetRender;
            ImgDataset imgDataset = this.imageDatasetService.getImgDataset(datasetId);
            DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)imgDataset.getGeoDatasetId());
            DatasetRenderDTO imageDatasetRender = this.dataSourceManager.getDatasetRender(imgDataset.getGeoDatasetId());
            if (imageDatasetRender != null) {
                this.renderIndexService.reloadRenderIndexCache(imageDatasetRender);
            }
            if (nameInfo.getType().intValue() == DatasetTypeEnum.MosaicDataset.getValue()) {
                String catDatasetId = DatasetUtil.getDatasetId((String)nameInfo.getDsKey(), (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)String.format("public.GWMD_%s_CAT", nameInfo.getShortName()));
                DatasetRenderDTO imageCatDatasetRender = this.dataSourceManager.getDatasetRender(catDatasetId);
                if (imageCatDatasetRender != null) {
                    this.renderIndexService.reloadRenderIndexCache(imageCatDatasetRender);
                }
            } else if (nameInfo.getType().intValue() == DatasetTypeEnum.FeatureClass.getValue() && (snapshotDatasetRender = this.dataSourceManager.getDatasetRender(this.imageDatasetService.getSnapshotDatasetId(imgDataset.getGeoDatasetId()))) != null) {
                this.renderIndexService.reloadRenderIndexCache(snapshotDatasetRender);
            }
            DatasetRenderDTO businessSnapshotDatasetRender = this.dataSourceManager.getDatasetRender(this.imageDatasetService.getBusinessSnapshotDatasetId());
            if (businessSnapshotDatasetRender != null) {
                this.renderIndexService.reloadRenderIndexCache(businessSnapshotDatasetRender);
            }
            DatasetRenderDTO businessSnapshotCatDatasetRender = this.dataSourceManager.getDatasetRender(this.imageDatasetService.getBusinessSnapshotCatDatasetId());
            if (businessSnapshotDatasetRender != null) {
                this.renderIndexService.reloadRenderIndexCache(businessSnapshotCatDatasetRender);
            }
        }
        catch (Exception e) {
            log.error("\u91cd\u5efa\u6e32\u67d3\u7d22\u5f15\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    private boolean createGeoDatasetIndex(ITable targetTale, String fieldName) {
        try {
            Map frameIndexResult = targetTale.getWorkspace().queryOne(String.format("select * from pg_indexes where indexname = '%s_%s_idx'", targetTale.getName().toLowerCase(), fieldName.toLowerCase()), new Object[0]);
            if (frameIndexResult == null || frameIndexResult.size() == 0) {
                String frameSql = String.format("create index %s_%s_idx on %s(%s)", targetTale.getName(), fieldName, targetTale.getName(), fieldName);
                targetTale.getWorkspace().excuteSql(frameSql);
            }
            return true;
        }
        catch (Exception e) {
            log.error(targetTale.getName() + "." + fieldName + " \u7d22\u5f15\u521b\u5efa\u5931\u8d25", (Throwable)e);
            return false;
        }
    }
}

