/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geosrv.vtile.VTileServiceStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageDatasetRenderUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageDatasetRenderUtil.class);

    public static String getImageDatasetVTileRender(String dataServiceName, Integer featureType) {
        JSONObject styleJson = ImageDatasetRenderUtil.createStyleJson(dataServiceName, featureType);
        JSONObject layerJson = styleJson.getJSONArray("layers").getJSONObject(0);
        layerJson.remove((Object)"filter");
        layerJson.put("filter", (Object)"fflag=0");
        return styleJson.toJSONString();
    }

    public static String getSnapshotVTileRender(String dataServiceName, Integer featureType) {
        JSONObject styleJson = ImageDatasetRenderUtil.createStyleJson(dataServiceName, featureType);
        JSONObject layerJson = styleJson.getJSONArray("layers").getJSONObject(0);
        layerJson.remove((Object)"filter");
        layerJson.put("filter", (Object)"category=1");
        return styleJson.toJSONString();
    }

    private static JSONObject createStyleJson(String dataServiceName, Integer featureType) {
        String type = "";
        switch (featureType) {
            case 0: {
                type = "point-mark";
                break;
            }
            case 1: {
                type = "line";
                break;
            }
            case 2: {
                type = "polygon";
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + featureType);
            }
        }
        JSONObject styleJson = VTileServiceStyle.getRenderStyle((String)dataServiceName, (String)type);
        if (featureType.intValue() == FeatureType.Polygon.getValue()) {
            JSONObject styleLevelMap = styleJson.getJSONObject("styles");
            for (String key : styleLevelMap.keySet()) {
                JSONArray styles = styleLevelMap.getJSONArray(key).getJSONObject(0).getJSONArray("style");
                JSONObject item = styles.getJSONObject(0);
                item.put("fillOpacity", (Object)0);
                item.put("fill", (Object)false);
            }
        }
        return styleJson;
    }
}

