/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.service.impl;

import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.filepackage.model.FileModelDTO;
import com.geoway.adf.dms.config.service.FileModelService;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dao.ImgDatumTypeDao;
import com.geoway.imagedb.dataset.dao.ImgDatumTypeFieldDao;
import com.geoway.imagedb.dataset.dto.ImgDatumTypeDTO;
import com.geoway.imagedb.dataset.dto.ImgDatumTypeFieldDTO;
import com.geoway.imagedb.dataset.dto.ImgFieldBaseDTO;
import com.geoway.imagedb.dataset.dto.ImgGroupDTO;
import com.geoway.imagedb.dataset.dto.ImgTreeBaseDTO;
import com.geoway.imagedb.dataset.dto.OrderDTO;
import com.geoway.imagedb.dataset.dto.edit.ImgDatumTypeEditDTO;
import com.geoway.imagedb.dataset.dto.edit.ImgDatumTypeFieldEditDTO;
import com.geoway.imagedb.dataset.dto.edit.ImgFieldSimpleDTO;
import com.geoway.imagedb.dataset.entity.ImgDatumType;
import com.geoway.imagedb.dataset.entity.ImgDatumTypeField;
import com.geoway.imagedb.dataset.event.ImgDatumTypeBeforeDeleteEvent;
import com.geoway.imagedb.dataset.event.ImgDatumTypeFieldAfterChangeEvent;
import com.geoway.imagedb.dataset.event.ImgDatumTypeFileModelChangeEvent;
import com.geoway.imagedb.dataset.service.ImgDatumTypeService;
import com.geoway.imagedb.dataset.service.ImgFieldsManageService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional(rollbackFor={Exception.class})
public class ImgDatumTypeServiceImpl
implements ImgDatumTypeService {
    private static final Logger log = LoggerFactory.getLogger(ImgDatumTypeServiceImpl.class);
    @Resource
    private ImgDatumTypeDao imgDatumTypeDao;
    @Resource
    private ImgDatumTypeFieldDao imgDatumTypeFieldDao;
    @Resource
    private FileModelService fileModelService;
    @Resource
    private ImgFieldsManageService imgFieldsManageService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public List<ImgTreeBaseDTO> tree(String keyword) {
        List<ImgDatumType> allDatumTypes = this.imgDatumTypeDao.selectAll();
        Map<String, List<ImgDatumType>> pidGroup = allDatumTypes.stream().collect(Collectors.groupingBy(ImgDatumType::getPid));
        return this.completeChildren(pidGroup, "-1", keyword);
    }

    @Override
    public List<ImgDatumTypeDTO> list(String keyword) {
        List<ImgDatumType> allDatumTypes = this.imgDatumTypeDao.selectAllModel();
        Map<String, ImgDatumType> allDatumTypeMap = allDatumTypes.stream().collect(Collectors.toMap(ImgDatumType::getId, f -> f));
        ArrayList<ImgDatumTypeDTO> results = new ArrayList<ImgDatumTypeDTO>();
        for (ImgDatumType imgDatumType : allDatumTypes) {
            ImgDatumType pType;
            if (StringUtil.isNotEmpty((String)keyword) && !imgDatumType.getName().toLowerCase().contains(keyword.toLowerCase()) || (pType = allDatumTypeMap.get(imgDatumType.getPid())) != null && !ConstantsValue.boolValue((Integer)pType.getIsGroup()).booleanValue()) continue;
            results.add((ImgDatumTypeDTO)this.convertImgDatumType(imgDatumType));
        }
        return results;
    }

    @Override
    public ImgTreeBaseDTO getDetail(String id) {
        List<ImgDatumType> subDatumTypes;
        ImgDatumType imgDatumType = this.imgDatumTypeDao.selectByPrimaryKey(id);
        Assert.notNull((Object)imgDatumType, (String)"\u5f71\u50cf\u7c7b\u578b\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        ImgTreeBaseDTO baseDTO = this.convertImgDatumType(imgDatumType);
        if (baseDTO.getIsGroup().booleanValue()) {
            return baseDTO;
        }
        ImgDatumTypeDTO dto = (ImgDatumTypeDTO)baseDTO;
        List<ImgDatumTypeField> fields = this.imgDatumTypeFieldDao.selectByDatumType(id);
        for (ImgDatumTypeField imgDatumTypeField : fields) {
            ImgDatumTypeFieldDTO fieldDTO = this.convertImgDatumTypeFieldDTO(imgDatumTypeField);
            if (fieldDTO.getDatumName().booleanValue()) {
                dto.setDatumNameField(imgDatumTypeField.getName());
            }
            if (fieldDTO.getIdentify().booleanValue()) {
                dto.getIdentifyFields().add(imgDatumTypeField.getName());
            }
            dto.getFields().add(fieldDTO);
        }
        if (StringUtil.isNotEmpty((String)imgDatumType.getFileModelIds())) {
            String[] fileModelIdArray;
            for (String fileModelId : fileModelIdArray = imgDatumType.getFileModelIds().split(",")) {
                dto.getFileModels().add(this.fileModelService.getFileModelDetail(Long.valueOf(Long.parseLong(fileModelId))));
            }
        }
        if ((subDatumTypes = this.imgDatumTypeDao.selectByPid(id)).size() > 0) {
            ArrayList<ImgDatumTypeDTO> arrayList = new ArrayList<ImgDatumTypeDTO>();
            dto.setSubDatumTypes(arrayList);
            for (ImgDatumType subDatumType : subDatumTypes) {
                ImgTreeBaseDTO subBaseDTO = this.convertImgDatumType(subDatumType);
                if (subBaseDTO.getIsGroup().booleanValue()) continue;
                ImgDatumTypeDTO subDto = (ImgDatumTypeDTO)subBaseDTO;
                List<ImgDatumTypeField> subFields = this.imgDatumTypeFieldDao.selectByDatumType(subDto.getId());
                for (ImgDatumTypeField field : subFields) {
                    ImgDatumTypeFieldDTO fieldDTO = this.convertImgDatumTypeFieldDTO(field);
                    if (fieldDTO.getDatumName().booleanValue()) {
                        subDto.setDatumNameField(field.getName());
                    }
                    if (fieldDTO.getIdentify().booleanValue()) {
                        subDto.getIdentifyFields().add(field.getName());
                    }
                    subDto.getFields().add(fieldDTO);
                }
                arrayList.add(subDto);
            }
        }
        return dto;
    }

    @Override
    public String addOrUpdateGroup(ImgGroupDTO groupDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)groupDTO.getId())) {
            if (StringUtil.isEmptyOrWhiteSpace((String)groupDTO.getPid()) || "-1".equals(groupDTO.getPid())) {
                groupDTO.setPid("-1");
            } else {
                ImgDatumType pGroup = this.imgDatumTypeDao.selectByPrimaryKey(groupDTO.getPid());
                Assert.notNull((Object)pGroup, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
            }
            ImgDatumType addGroup = new ImgDatumType();
            addGroup.setId(UUID.randomUUID().toString().replace("-", ""));
            addGroup.setName(groupDTO.getName());
            addGroup.setIsGroup(ConstantsValue.TRUE_VALUE);
            addGroup.setPid(groupDTO.getPid());
            addGroup.setDesc(groupDTO.getDesc());
            Integer order = this.imgDatumTypeDao.queryMaxOrder(addGroup.getPid());
            if (order == null) {
                order = 0;
            }
            addGroup.setOrder(order + 1);
            this.imgDatumTypeDao.insert(addGroup);
            return addGroup.getId();
        }
        ImgDatumType group = this.imgDatumTypeDao.selectByPrimaryKey(groupDTO.getId());
        Assert.notNull((Object)group, (String)"\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        group.setName(groupDTO.getName());
        group.setDesc(groupDTO.getDesc());
        this.imgDatumTypeDao.updateByPrimaryKey(group);
        return group.getId();
    }

    @Override
    public String addOrUpdateDatumType(ImgDatumTypeEditDTO addDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)addDTO.getId())) {
            Assert.notNull((Object)addDTO.getPid(), (String)"\u8bf7\u6307\u5b9a\u7236\u8282\u70b9\u6807\u8bc6\uff01");
            ImgDatumType pGroup = this.imgDatumTypeDao.selectByPrimaryKey(addDTO.getPid());
            Assert.notNull((Object)pGroup, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
            if (ConstantsValue.FALSE_VALUE.equals(pGroup.getIsGroup())) {
                throw new RuntimeException("\u7236\u8282\u70b9\u5fc5\u987b\u662f\u5206\u7ec4\u8282\u70b9\uff01");
            }
            Assert.notNull((Object)addDTO.getName(), (String)"\u8bf7\u8bbe\u7f6e\u5f71\u50cf\u7c7b\u578b\u6a21\u578b\u540d\u79f0\uff01");
            ImgDatumType sameDatumType = this.imgDatumTypeDao.selectByDatumTypeName(addDTO.getName());
            Assert.isNull((Object)sameDatumType, (String)"\u5f71\u50cf\u7c7b\u578b\u6a21\u578b\u5df2\u5b58\u5728\uff01");
            if (addDTO.getFileModelIdArray() == null || addDTO.getFileModelIdArray().size() == 0) {
                throw new RuntimeException("\u8bf7\u6307\u5b9a\u81f3\u5c11\u4e00\u79cd\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\uff01");
            }
            if (addDTO.getImageType() == null) {
                throw new RuntimeException("\u8bf7\u6307\u5b9a\u5f71\u50cf\u5b58\u50a8\u7c7b\u578b\uff01");
            }
            ImgDatumType datumType = new ImgDatumType();
            datumType.setImageType(addDTO.getImageType());
            datumType.setFeatureType(addDTO.getFeatureType());
            if (addDTO.getFeatureType() == null) {
                datumType.setFeatureType(FeatureType.Polygon.getValue());
            }
            datumType.setId(UUID.randomUUID().toString().replace("-", ""));
            datumType.setName(addDTO.getName());
            datumType.setIsGroup(ConstantsValue.FALSE_VALUE);
            datumType.setPid(addDTO.getPid());
            Integer order = this.imgDatumTypeDao.queryMaxOrder(datumType.getPid());
            if (order == null) {
                order = 0;
            }
            datumType.setOrder(order + 1);
            String fileModelIds = String.join((CharSequence)",", addDTO.getFileModelIdArray());
            datumType.setFileModelIds(fileModelIds + ",");
            this.imgDatumTypeDao.insert(datumType);
            ArrayList<ImgDatumTypeField> fields = new ArrayList<ImgDatumTypeField>(0);
            int fieldOrder = 1;
            List<ImgFieldBaseDTO> allBaseFields = this.imgFieldsManageService.getAllFields();
            List systemFields = ListUtil.findAll(allBaseFields, ImgTreeBaseDTO::getIsSysField);
            for (ImgFieldBaseDTO fieldDTO : systemFields) {
                ImgDatumTypeField field = this.convertImgDatumTypeField(fieldDTO, datumType.getId());
                if ("F_DATANAME".equalsIgnoreCase(field.getName())) {
                    field.setDatumName(ConstantsValue.TRUE_VALUE);
                    field.setIdentify(ConstantsValue.TRUE_VALUE);
                    field.setCanQuery(ConstantsValue.TRUE_VALUE);
                }
                field.setDisplay(ConstantsValue.TRUE_VALUE);
                field.setOrder(fieldOrder);
                ++fieldOrder;
                fields.add(field);
            }
            ArrayList<ImgDatumTypeField> internalFields = new ArrayList<ImgDatumTypeField>();
            ImageDatasetTypeEnum imageDatasetType = ImageDatasetTypeEnum.getByValue(datumType.getImageType());
            Assert.notNull((Object)((Object)imageDatasetType), (String)("\u4e0d\u652f\u6301\u7684\u5f71\u50cf\u7c7b\u578b\uff1a" + datumType.getImageType()));
            switch (imageDatasetType) {
                case OriginalImageDataset: {
                    internalFields.addAll(this.buildOriginalImgFields(datumType.getId()));
                    break;
                }
                case ProcessedImageDataset: {
                    internalFields.addAll(this.buildProcessedImgFields(datumType.getId()));
                    break;
                }
                case ImageSampleImageDataset: {
                    internalFields.addAll(this.buildImageSampleImgFields(datumType.getId()));
                    break;
                }
                case TileSampleImageDataset: {
                    internalFields.addAll(this.buildTileSampleImgFields(datumType.getId()));
                    break;
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5f71\u50cf\u7c7b\u578b\uff1a" + datumType.getImageType());
                }
            }
            for (ImgDatumTypeField field : internalFields) {
                ImgFieldBaseDTO metaFld = (ImgFieldBaseDTO)ListUtil.find(allBaseFields, f -> f.getName().equalsIgnoreCase(field.getName()));
                if (metaFld != null) {
                    field.setFieldId(metaFld.getId());
                    field.setFieldType(metaFld.getFieldType());
                    field.setLength(metaFld.getLength());
                    field.setNullable(ConstantsValue.integerValue((Boolean)metaFld.getNullable()));
                    field.setDefaultValue(metaFld.getDefaultValue());
                    field.setAliasName(metaFld.getAliasName());
                }
                field.setOrder(fieldOrder);
                ++fieldOrder;
                fields.add(field);
            }
            if (addDTO.getFieldArray() != null && addDTO.getFieldArray().size() > 0) {
                for (ImgFieldSimpleDTO simpleDTO : addDTO.getFieldArray()) {
                    ImgFieldBaseDTO baseDTO = (ImgFieldBaseDTO)ListUtil.find(allBaseFields, f -> f.getId().equals(simpleDTO.getFieldId()));
                    if (baseDTO == null) continue;
                    ImgDatumTypeField addField = this.convertImgDatumTypeField(baseDTO, datumType.getId());
                    addField.setAliasName(simpleDTO.getAliasName());
                    addField.setOrder(fieldOrder);
                    ++fieldOrder;
                    fields.add(addField);
                }
            }
            this.imgDatumTypeFieldDao.batchInsert(fields);
            if (datumType.getImageType().intValue() == ImageDatasetTypeEnum.ImageSampleImageDataset.getValue()) {
                this.createImageSampleDatum(datumType.getId());
            }
            return datumType.getId();
        }
        ImgDatumType datumType = this.imgDatumTypeDao.selectByPrimaryKey(addDTO.getId());
        Assert.notNull((Object)datumType, (String)"\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        datumType.setName(addDTO.getName());
        if (addDTO.getFileModelIdArray() != null && addDTO.getFileModelIdArray().size() > 0) {
            String fileModelIds = String.join((CharSequence)",", addDTO.getFileModelIdArray());
            datumType.setFileModelIds(fileModelIds + ",");
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ImgDatumTypeFileModelChangeEvent(this, addDTO.getId(), addDTO.getFileModelIdArray()));
        }
        this.imgDatumTypeDao.updateByPrimaryKey(datumType);
        return datumType.getId();
    }

    @Override
    public void saveDatumTypeFields(ImgDatumTypeFieldEditDTO editDTO) {
        ImgDatumType parentDatumType;
        ImgDatumType datumType = this.imgDatumTypeDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)datumType, (String)"\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        List<ImgDatumTypeField> fields = this.imgDatumTypeFieldDao.selectByDatumType(datumType.getId());
        boolean updateDataset = false;
        if (editDTO.getAddFields() != null) {
            ArrayList addFields = new ArrayList();
            List<ImgFieldBaseDTO> allBaseFields = this.imgFieldsManageService.getAllFields();
            for (ImgDatumTypeFieldDTO addField : editDTO.getAddFields()) {
                ImgFieldBaseDTO baseDTO = (ImgFieldBaseDTO)ListUtil.find(allBaseFields, f -> f.getId().equals(addField.getFieldId()));
                if (baseDTO == null) continue;
                ImgDatumTypeField sameAddField = (ImgDatumTypeField)ListUtil.find((List)addFields, f -> f.getName().equals(addField.getName()));
                ImgDatumTypeField sameField = (ImgDatumTypeField)ListUtil.find(fields, f -> f.getName().equals(addField.getName()));
                if (sameAddField != null || sameField != null) {
                    throw new RuntimeException(String.format("\u5b57\u6bb5[%s]\u91cd\u590d\uff01", addField.getAliasName()));
                }
                ImgDatumTypeField datumTypeField = this.convertImgDatumTypeField(baseDTO, datumType.getId());
                datumTypeField.setDatumName(Boolean.TRUE.equals(addField.getDatumName()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
                datumTypeField.setIdentify(Boolean.TRUE.equals(addField.getIdentify()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
                datumTypeField.setDisplay(Boolean.TRUE.equals(addField.getDisplay()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
                datumTypeField.setCanQuery(Boolean.TRUE.equals(addField.getCanQuery()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
                datumTypeField.setCanEdit(Boolean.TRUE.equals(addField.getCanEdit()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
                datumTypeField.setAliasName(addField.getAliasName());
                addFields.add(datumTypeField);
            }
            if (addFields.size() > 0) {
                this.imgDatumTypeFieldDao.batchInsert(addFields);
                updateDataset = true;
                fields.addAll(addFields);
            }
        }
        if (editDTO.getUpdateFields() != null) {
            for (Object updateField : editDTO.getUpdateFields()) {
                ImgDatumTypeField datumTypeField = (ImgDatumTypeField)ListUtil.find(fields, arg_0 -> ImgDatumTypeServiceImpl.lambda$saveDatumTypeFields$6((ImgDatumTypeFieldDTO)((Object)updateField), arg_0));
                if (datumTypeField == null) continue;
                datumTypeField.setAliasName(updateField.getAliasName());
                datumTypeField.setDatumName(ConstantsValue.integerValue((Boolean)updateField.getDatumName()));
                datumTypeField.setIdentify(ConstantsValue.integerValue((Boolean)updateField.getIdentify()));
                datumTypeField.setDisplay(ConstantsValue.integerValue((Boolean)updateField.getDisplay()));
                datumTypeField.setCanQuery(ConstantsValue.integerValue((Boolean)updateField.getCanQuery()));
                datumTypeField.setCanEdit(ConstantsValue.integerValue((Boolean)updateField.getCanEdit()));
                if (!(ConstantsValue.TRUE_VALUE.intValue() != datumTypeField.getIsSysField().intValue() || "f_satellite".equalsIgnoreCase(datumTypeField.getName()) || "f_sensor".equalsIgnoreCase(datumTypeField.getName()) || "f_product_time".equalsIgnoreCase(datumTypeField.getName()) || "f_cloud".equalsIgnoreCase(datumTypeField.getName()) || "f_time".equalsIgnoreCase(datumTypeField.getName()) || "f_resolution".equalsIgnoreCase(datumTypeField.getName()) || "f_classification".equalsIgnoreCase(datumTypeField.getName()))) {
                    datumTypeField.setCanEdit(ConstantsValue.FALSE_VALUE);
                }
                this.imgDatumTypeFieldDao.updateByPrimaryKey(datumTypeField);
                updateDataset = true;
            }
        }
        if (editDTO.getDeleteFieldIds() != null && editDTO.getDeleteFieldIds().size() > 0) {
            ArrayList<String> deleteNames = new ArrayList<String>();
            for (String deleteFieldId : editDTO.getDeleteFieldIds()) {
                ImgDatumTypeField datumTypeField = (ImgDatumTypeField)ListUtil.find(fields, f -> f.getId().equalsIgnoreCase(deleteFieldId));
                this.imgDatumTypeFieldDao.deleteByPrimaryKey(datumTypeField.getId());
                fields.remove(datumTypeField);
                deleteNames.add(datumTypeField.getName());
                updateDataset = true;
            }
            editDTO.setDeleteFieldNames(deleteNames);
        }
        if ((parentDatumType = this.imgDatumTypeDao.selectByPrimaryKey(datumType.getId())) == null || ConstantsValue.TRUE_VALUE.equals(parentDatumType.getIsGroup())) {
            List nameFields = ListUtil.findAll(fields, f -> ConstantsValue.boolValue((Integer)f.getDatumName()));
            if (nameFields.size() == 0) {
                throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u540d\u79f0\u5b57\u6bb5\uff01");
            }
            if (nameFields.size() > 1) {
                throw new RuntimeException("\u4ec5\u4e00\u4e2a\u5b57\u6bb5\u53ef\u8bbe\u7f6e\u4e3a\u540d\u79f0\u5b57\u6bb5\uff01");
            }
            List identifyFields = ListUtil.findAll(fields, f -> ConstantsValue.boolValue((Integer)f.getIdentify()));
            if (identifyFields == null || identifyFields.size() == 0) {
                throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u6807\u8bc6\u5b57\u6bb5\uff01");
            }
        }
        int order = 1;
        if (editDTO.getFieldsOrder() != null && editDTO.getFieldsOrder().size() > 0) {
            editDTO.getFieldsOrder().sort(Comparator.comparingInt(OrderDTO::getOrder));
            for (OrderDTO orderDTO : editDTO.getFieldsOrder()) {
                ImgDatumTypeField fieldItem = (ImgDatumTypeField)ListUtil.find(fields, f -> f.getName().equalsIgnoreCase(orderDTO.getName()));
                if (fieldItem == null) continue;
                this.imgDatumTypeFieldDao.updateOrderByPrimaryKey(fieldItem.getId(), order);
                ++order;
            }
        }
        if (updateDataset) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ImgDatumTypeFieldAfterChangeEvent(this, editDTO));
        }
    }

    @Override
    public Integer deleteDatumType(String id) {
        List<ImgDatumType> allDatumTypes = this.imgDatumTypeDao.selectAll();
        Map<String, List<ImgDatumType>> pidGroup = allDatumTypes.stream().collect(Collectors.groupingBy(ImgDatumType::getPid));
        List<String> ids = this.getSubFieldIdList(pidGroup, id);
        ids.add(id);
        for (String deleteId : ids) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ImgDatumTypeBeforeDeleteEvent(this, deleteId));
        }
        return this.imgDatumTypeDao.batchDelete(ids);
    }

    @Override
    public void moveDatumType(String id, String pid, Integer order) {
        int i;
        List<ImgDatumType> children;
        if (id == null || order == null) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtil.equals((String)id, (String)pid)) {
            throw new RuntimeException("\u4e0d\u5141\u8bb8\u79fb\u52a8\u5230\u8282\u70b9\u672c\u8eab\u4e0b");
        }
        ImgDatumType imgDatumType = this.imgDatumTypeDao.selectByPrimaryKey(id);
        Assert.notNull((Object)imgDatumType, (String)"\u5f71\u50cf\u7c7b\u578b\u6a21\u578b\u4e0d\u5b58\u5728\uff0c\u6b64\u6b21\u79fb\u52a8\u65e0\u6548");
        if (ConstantsValue.TRUE_VALUE.equals(imgDatumType.getIsGroup()) && StringUtil.isEmptyOrWhiteSpace((String)pid)) {
            throw new RuntimeException("\u4e0d\u5141\u8bb8\u79fb\u52a8\u5230\u6839\u8282\u70b9\u4e0b");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)pid)) {
            pid = null;
        }
        if (!StringUtil.equals((String)imgDatumType.getPid(), (String)pid)) {
            List<ImgDatumType> allDatumTypes = this.imgDatumTypeDao.selectAll();
            Map<String, List<ImgDatumType>> pidGroup = allDatumTypes.stream().collect(Collectors.groupingBy(ImgDatumType::getPid));
            List<String> subNodeIdList = this.getSubFieldIdList(pidGroup, imgDatumType.getId());
            if (subNodeIdList.contains(pid)) {
                throw new RuntimeException("\u4e0d\u5141\u8bb8\u79fb\u52a8\u5230\u5b50\u8282\u70b9\u4e0b");
            }
            imgDatumType.setPid(pid);
            imgDatumType.setOrder(-1);
            this.imgDatumTypeDao.updateByPrimaryKey(imgDatumType);
            children = pidGroup.get(pid);
        } else {
            children = this.imgDatumTypeDao.selectByPid(pid);
            children.removeIf(f -> StringUtil.equals((String)f.getId(), (String)id));
        }
        int preIndex = -1;
        for (i = 0; i < children.size(); ++i) {
            if (!children.get(i).getOrder().equals(order)) continue;
            preIndex = i;
            break;
        }
        if (preIndex == -1 && order > 0) {
            preIndex = order;
        }
        if (preIndex >= children.size()) {
            preIndex = children.size() - 1;
        }
        children.add(preIndex + 1, imgDatumType);
        for (i = 0; i < children.size(); ++i) {
            ImgDatumType child = children.get(i);
            if (child.getOrder() == i + 1) continue;
            child.setOrder(i + 1);
            this.imgDatumTypeDao.updateOrderByPrimaryKey(child.getId(), child.getOrder());
        }
    }

    @Override
    public List<ImgDatumTypeField> getDatumTypeFieldByIds(List<String> ids) {
        return this.imgDatumTypeFieldDao.selectByFieldIds(ids);
    }

    @Override
    public List<ImgDatumTypeDTO> getDatumTypeByFileModelId(Long modelId) {
        List<ImgDatumType> allDatumTypes = this.imgDatumTypeDao.selectByFileModelId(modelId + ",");
        return ListUtil.convertAll(allDatumTypes, f -> (ImgDatumTypeDTO)this.convertImgDatumType((ImgDatumType)f));
    }

    private List<ImgTreeBaseDTO> completeChildren(Map<String, List<ImgDatumType>> pidGroup, String pId, String keyword) {
        ArrayList<ImgTreeBaseDTO> dtoList = new ArrayList<ImgTreeBaseDTO>();
        List<ImgDatumType> subImgDatumTypes = pidGroup.get(pId);
        if (subImgDatumTypes == null) {
            return dtoList;
        }
        for (ImgDatumType imgDatumType : subImgDatumTypes) {
            List<ImgTreeBaseDTO> subList = this.completeChildren(pidGroup, imgDatumType.getId(), keyword);
            ImgTreeBaseDTO imgTypeDTO = this.convertImgDatumType(imgDatumType);
            if (!StringUtil.isEmpty((String)keyword) && !imgTypeDTO.getName().toLowerCase().contains(keyword.toLowerCase()) && !imgTypeDTO.getAliasName().toLowerCase().contains(keyword.toLowerCase()) && !imgTypeDTO.getId().equals(keyword) && subList.size() <= 0) continue;
            dtoList.add(imgTypeDTO);
            if (imgTypeDTO.getIsGroup().booleanValue()) {
                imgTypeDTO.setChildren(subList);
                continue;
            }
            if (!(imgTypeDTO instanceof ImgDatumTypeDTO)) continue;
            ArrayList<ImgDatumTypeDTO> subDatumTypes = new ArrayList<ImgDatumTypeDTO>();
            ((ImgDatumTypeDTO)imgTypeDTO).setSubDatumTypes(subDatumTypes);
            for (ImgTreeBaseDTO subDatumType : subList) {
                if (!(subDatumType instanceof ImgDatumTypeDTO)) continue;
                subDatumTypes.add((ImgDatumTypeDTO)subDatumType);
            }
        }
        return dtoList;
    }

    private ImgTreeBaseDTO convertImgDatumType(ImgDatumType imgDatumType) {
        ImgTreeBaseDTO dto;
        boolean isGroup = ConstantsValue.TRUE_VALUE.equals(imgDatumType.getIsGroup());
        if (isGroup) {
            dto = new ImgTreeBaseDTO();
        } else {
            dto = new ImgDatumTypeDTO();
            ((ImgDatumTypeDTO)dto).setFields(new ArrayList<ImgDatumTypeFieldDTO>());
            ((ImgDatumTypeDTO)dto).setIdentifyFields(new ArrayList<String>());
            ((ImgDatumTypeDTO)dto).setFileModels(new ArrayList<FileModelDTO>());
            ((ImgDatumTypeDTO)dto).setImageType(imgDatumType.getImageType());
            ((ImgDatumTypeDTO)dto).setFeatureType(imgDatumType.getFeatureType());
            if (imgDatumType.getFeatureType() == null) {
                ((ImgDatumTypeDTO)dto).setFeatureType(FeatureType.Polygon.getValue());
            }
        }
        dto.setId(imgDatumType.getId());
        dto.setName(imgDatumType.getName());
        dto.setAliasName(imgDatumType.getName());
        dto.setPid(imgDatumType.getPid());
        dto.setOrder(imgDatumType.getOrder());
        dto.setDesc(imgDatumType.getDesc());
        dto.setIsGroup(isGroup);
        return dto;
    }

    private ImgDatumTypeFieldDTO convertImgDatumTypeFieldDTO(ImgDatumTypeField field) {
        ImgDatumTypeFieldDTO dto = new ImgDatumTypeFieldDTO();
        dto.setId(field.getId());
        dto.setDatumTypeId(field.getDatumTypeId());
        dto.setName(field.getName());
        dto.setAliasName(field.getAliasName());
        dto.setFieldType(field.getFieldType());
        dto.setLength(field.getLength());
        dto.setDefaultValue(field.getDefaultValue());
        dto.setNullable(ConstantsValue.TRUE_VALUE.equals(field.getNullable()));
        dto.setDatumName(ConstantsValue.TRUE_VALUE.equals(field.getDatumName()));
        dto.setIdentify(ConstantsValue.TRUE_VALUE.equals(field.getIdentify()));
        dto.setSystemField(ConstantsValue.TRUE_VALUE.equals(field.getIsSysField()));
        dto.setDisplay(ConstantsValue.TRUE_VALUE.equals(field.getDisplay()));
        dto.setCanQuery(ConstantsValue.TRUE_VALUE.equals(field.getCanQuery()));
        dto.setCanEdit(ConstantsValue.TRUE_VALUE.equals(field.getCanEdit()));
        dto.setFieldId(field.getFieldId());
        dto.setOrder(field.getOrder());
        return dto;
    }

    private ImgDatumTypeField convertImgDatumTypeField(ImgFieldBaseDTO dto, String datumTypeId) {
        ImgDatumTypeField imgDatumTypeField = new ImgDatumTypeField();
        imgDatumTypeField.setId(UUID.randomUUID().toString().replace("-", ""));
        imgDatumTypeField.setDatumTypeId(datumTypeId);
        imgDatumTypeField.setName(dto.getName());
        imgDatumTypeField.setAliasName(dto.getAliasName());
        imgDatumTypeField.setFieldType(dto.getFieldType());
        imgDatumTypeField.setLength(dto.getLength());
        imgDatumTypeField.setDefaultValue(dto.getDefaultValue());
        imgDatumTypeField.setNullable(Boolean.TRUE.equals(dto.getNullable()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        imgDatumTypeField.setDatumName(ConstantsValue.FALSE_VALUE);
        imgDatumTypeField.setIdentify(ConstantsValue.FALSE_VALUE);
        imgDatumTypeField.setIsSysField(Boolean.TRUE.equals(dto.getIsSysField()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        imgDatumTypeField.setDisplay(ConstantsValue.FALSE_VALUE);
        imgDatumTypeField.setCanQuery(ConstantsValue.FALSE_VALUE);
        imgDatumTypeField.setCanEdit(ConstantsValue.FALSE_VALUE);
        imgDatumTypeField.setFieldId(dto.getId());
        return imgDatumTypeField;
    }

    private List<String> getSubFieldIdList(Map<String, List<ImgDatumType>> pidGroup, String id) {
        List<ImgDatumType> children = pidGroup.get(id);
        ArrayList<String> result = new ArrayList<String>();
        if (children == null || children.size() == 0) {
            return result;
        }
        children.forEach(child -> {
            result.add(child.getId());
            result.addAll(this.getSubFieldIdList(pidGroup, child.getId()));
        });
        return result;
    }

    private ImgDatumTypeField buildImgTypeField(String datumTypeId, String name, String alias, Integer fieldType, Integer length) {
        ImgDatumTypeField imgDatumTypeField = new ImgDatumTypeField();
        imgDatumTypeField.setId(UUID.randomUUID().toString().replace("-", ""));
        imgDatumTypeField.setDatumTypeId(datumTypeId);
        imgDatumTypeField.setName(name);
        imgDatumTypeField.setAliasName(alias);
        imgDatumTypeField.setFieldType(fieldType);
        imgDatumTypeField.setLength(length);
        imgDatumTypeField.setDefaultValue(null);
        imgDatumTypeField.setNullable(ConstantsValue.TRUE_VALUE);
        imgDatumTypeField.setDatumName(ConstantsValue.FALSE_VALUE);
        imgDatumTypeField.setIdentify(ConstantsValue.FALSE_VALUE);
        imgDatumTypeField.setIsSysField(ConstantsValue.FALSE_VALUE);
        imgDatumTypeField.setDisplay(ConstantsValue.TRUE_VALUE);
        imgDatumTypeField.setCanQuery(ConstantsValue.TRUE_VALUE);
        imgDatumTypeField.setCanEdit(ConstantsValue.FALSE_VALUE);
        imgDatumTypeField.setFieldId(null);
        return imgDatumTypeField;
    }

    private List<ImgDatumTypeField> buildOriginalImgFields(String datumTypeId) {
        ArrayList<ImgDatumTypeField> systemFields = new ArrayList<ImgDatumTypeField>(0);
        ImgDatumTypeField sysField = this.buildImgTypeField(datumTypeId, "f_satellite", "\u536b\u661f\u540d\u79f0", FieldType.String.getValue(), 50);
        sysField.setIsSysField(ConstantsValue.TRUE_VALUE);
        sysField.setDisplay(ConstantsValue.TRUE_VALUE);
        systemFields.add(sysField);
        sysField = this.buildImgTypeField(datumTypeId, "f_sensor", "\u4f20\u611f\u5668", FieldType.String.getValue(), 50);
        sysField.setIsSysField(ConstantsValue.TRUE_VALUE);
        sysField.setDisplay(ConstantsValue.TRUE_VALUE);
        systemFields.add(sysField);
        sysField = this.buildImgTypeField(datumTypeId, "f_product_time", "\u5f71\u50cf\u91c7\u96c6\u65f6\u95f4", FieldType.DateTime.getValue(), null);
        sysField.setIsSysField(ConstantsValue.TRUE_VALUE);
        sysField.setDisplay(ConstantsValue.TRUE_VALUE);
        systemFields.add(sysField);
        sysField = this.buildImgTypeField(datumTypeId, "f_cloud", "\u4e91\u91cf", FieldType.Double.getValue(), null);
        sysField.setIsSysField(ConstantsValue.TRUE_VALUE);
        sysField.setDisplay(ConstantsValue.TRUE_VALUE);
        systemFields.add(sysField);
        sysField = this.buildImgTypeField(datumTypeId, "f_resolution", "\u5206\u8fa8\u7387", FieldType.Double.getValue(), null);
        sysField.setIsSysField(ConstantsValue.TRUE_VALUE);
        sysField.setDisplay(ConstantsValue.TRUE_VALUE);
        systemFields.add(sysField);
        return systemFields;
    }

    private List<ImgDatumTypeField> buildProcessedImgFields(String datumTypeId) {
        ArrayList<ImgDatumTypeField> systemFields = new ArrayList<ImgDatumTypeField>(0);
        ImgDatumTypeField sysField = this.buildImgTypeField(datumTypeId, "f_classification", "\u5f71\u50cf\u5206\u7c7b", FieldType.String.getValue(), 255);
        sysField.setIsSysField(ConstantsValue.TRUE_VALUE);
        sysField.setDisplay(ConstantsValue.TRUE_VALUE);
        systemFields.add(sysField);
        sysField = this.buildImgTypeField(datumTypeId, "f_time", "\u65f6\u76f8", FieldType.DateTime.getValue(), null);
        sysField.setIsSysField(ConstantsValue.TRUE_VALUE);
        sysField.setDisplay(ConstantsValue.TRUE_VALUE);
        systemFields.add(sysField);
        sysField = this.buildImgTypeField(datumTypeId, "f_resolution", "\u5206\u8fa8\u7387", FieldType.Double.getValue(), null);
        sysField.setIsSysField(ConstantsValue.TRUE_VALUE);
        sysField.setDisplay(ConstantsValue.TRUE_VALUE);
        systemFields.add(sysField);
        return systemFields;
    }

    private List<ImgDatumTypeField> buildImageSampleImgFields(String datumTypeId) {
        ArrayList<ImgDatumTypeField> fields = new ArrayList<ImgDatumTypeField>();
        int fieldOrder = 0;
        ImgDatumTypeField addField = this.buildImgTypeField(datumTypeId, "SceneType", "\u6837\u672c\u7c7b\u578b", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "SampleScheme", "\u6837\u672c\u65b9\u6848", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "imageName", "\u5f71\u50cf\u540d\u79f0", FieldType.String.getValue(), 512);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "satelliteName", "\u5f71\u50cf\u6765\u6e90", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "sensorType", "\u4f20\u611f\u5668", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "imageTime", "\u5f71\u50cf\u65f6\u95f4", FieldType.DateTime.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "pixelSize", "\u5206\u8fa8\u7387", FieldType.Double.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "bandBits", "\u4f4d\u6df1", FieldType.Int.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "bandNum", "\u6ce2\u6bb5\u6570", FieldType.Int.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "imageSource", "\u5f71\u50cf\u7c7b\u578b", FieldType.String.getValue(), 16);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldImageName", "\u524d\u671f\u5f71\u50cf\u540d\u79f0", FieldType.String.getValue(), 512);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldSatelliteName", "\u524d\u671f\u5f71\u50cf\u6765\u6e90", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldSensorType", "\u524d\u671f\u4f20\u611f\u5668", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldImageTime", "\u524d\u671f\u5f71\u50cf\u65f6\u95f4", FieldType.DateTime.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldPixelSize", "\u524d\u671f\u5206\u8fa8\u7387", FieldType.Double.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldBandBits", "\u524d\u671f\u4f4d\u6df1", FieldType.Int.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldBandNum", "\u524d\u671f\u6ce2\u6bb5\u6570", FieldType.Int.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldImageSource", "\u524d\u671f\u5f71\u50cf\u7c7b\u578b", FieldType.String.getValue(), 16);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        return fields;
    }

    private void createImageSampleDatum(String pTypeId) {
        int order = 0;
        ImgDatumType datumType = new ImgDatumType();
        datumType.setId(UUID.randomUUID().toString().replace("-", ""));
        datumType.setImageType(11);
        datumType.setFeatureType(FeatureType.Polygon.getValue());
        datumType.setName("label");
        datumType.setDesc("\u6837\u672c\u6807\u7b7e");
        datumType.setIsGroup(ConstantsValue.FALSE_VALUE);
        datumType.setPid(pTypeId);
        datumType.setOrder(++order);
        datumType.setFileModelIds(null);
        this.imgDatumTypeDao.insert(datumType);
        ArrayList<ImgDatumTypeField> fields = new ArrayList<ImgDatumTypeField>(0);
        int fieldOrder = 1;
        ImgDatumTypeField addField = this.buildImgTypeField(datumType.getId(), "F_DATAID", "\u6570\u636eID", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumType.getId(), "ClassID", "\u6807\u7b7e\u7c7b\u522b\u7f16\u7801", FieldType.String.getValue(), 1000);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumType.getId(), "ClassName", "\u6807\u7b7e\u7c7b\u522b\u540d\u79f0", FieldType.String.getValue(), 16);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        this.imgDatumTypeFieldDao.batchInsert(fields);
        datumType = new ImgDatumType();
        datumType.setId(UUID.randomUUID().toString().replace("-", ""));
        datumType.setImageType(11);
        datumType.setFeatureType(FeatureType.Polygon.getValue());
        datumType.setName("range");
        datumType.setDesc("\u6837\u672c\u533a\u57df");
        datumType.setIsGroup(ConstantsValue.FALSE_VALUE);
        datumType.setPid(pTypeId);
        datumType.setOrder(++order);
        datumType.setFileModelIds(null);
        this.imgDatumTypeDao.insert(datumType);
        fields = new ArrayList(0);
        fieldOrder = 1;
        addField = this.buildImgTypeField(datumType.getId(), "F_DATAID", "\u6570\u636eID", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        this.imgDatumTypeFieldDao.batchInsert(fields);
        datumType = new ImgDatumType();
        datumType.setId(UUID.randomUUID().toString().replace("-", ""));
        datumType.setImageType(21);
        datumType.setFeatureType(FeatureType.Polygon.getValue());
        datumType.setName("img");
        datumType.setDesc("\u6837\u672c\u5f71\u50cf");
        datumType.setIsGroup(ConstantsValue.FALSE_VALUE);
        datumType.setPid(pTypeId);
        datumType.setOrder(++order);
        datumType.setFileModelIds(null);
        this.imgDatumTypeDao.insert(datumType);
        fields = new ArrayList(0);
        fieldOrder = 1;
        addField = this.buildImgTypeField(datumType.getId(), "F_DATAID", "\u6570\u636eID", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumType.getId(), "imageType", "\u7c7b\u578b", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumType.getId(), "imageName", "\u5f71\u50cf\u540d\u79f0", FieldType.String.getValue(), 512);
        addField.setOrder(++fieldOrder);
        addField.setDatumName(ConstantsValue.TRUE_VALUE);
        addField.setIdentify(ConstantsValue.TRUE_VALUE);
        fields.add(addField);
        addField = this.buildImgTypeField(datumType.getId(), "satelliteName", "\u5f71\u50cf\u6765\u6e90", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumType.getId(), "sensorType", "\u4f20\u611f\u5668", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumType.getId(), "imageTime", "\u5f71\u50cf\u65f6\u95f4", FieldType.DateTime.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumType.getId(), "pixelSize", "\u5206\u8fa8\u7387", FieldType.Double.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumType.getId(), "bandBits", "\u4f4d\u6df1", FieldType.Int.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumType.getId(), "bandNum", "\u6ce2\u6bb5\u6570", FieldType.Int.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumType.getId(), "imageSource", "\u5f71\u50cf\u7c7b\u578b", FieldType.String.getValue(), 16);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        this.imgDatumTypeFieldDao.batchInsert(fields);
    }

    private List<ImgDatumTypeField> buildTileSampleImgFields(String datumTypeId) {
        ArrayList<ImgDatumTypeField> fields = new ArrayList<ImgDatumTypeField>(0);
        int fieldOrder = 0;
        ImgDatumTypeField addField = this.buildImgTypeField(datumTypeId, "SceneType", "\u6837\u672c\u7c7b\u578b", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "SampleScheme", "\u6837\u672c\u65b9\u6848", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "tileSize", "\u74e6\u7247\u5927\u5c0f", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "imageName", "\u5f71\u50cf\u540d\u79f0", FieldType.String.getValue(), 512);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "satelliteName", "\u5f71\u50cf\u6765\u6e90", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "sensorType", "\u4f20\u611f\u5668", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "imageTime", "\u5f71\u50cf\u65f6\u95f4", FieldType.DateTime.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "pixelSize", "\u5206\u8fa8\u7387", FieldType.Double.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "bandBits", "\u4f4d\u6df1", FieldType.Int.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "bandNum", "\u6ce2\u6bb5\u6570", FieldType.Int.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "imageSource", "\u5f71\u50cf\u7c7b\u578b", FieldType.String.getValue(), 16);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldTileSize", "\u524d\u671f\u74e6\u7247\u5927\u5c0f", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldImageName", "\u524d\u671f\u5f71\u50cf\u540d\u79f0", FieldType.String.getValue(), 512);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldSatelliteName", "\u524d\u671f\u5f71\u50cf\u6765\u6e90", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldSensorType", "\u524d\u671f\u4f20\u611f\u5668", FieldType.String.getValue(), 32);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldImageTime", "\u524d\u671f\u5f71\u50cf\u65f6\u95f4", FieldType.DateTime.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldPixelSize", "\u524d\u671f\u5206\u8fa8\u7387", FieldType.Double.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldBandBits", "\u524d\u671f\u4f4d\u6df1", FieldType.Int.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldBandNum", "\u524d\u671f\u6ce2\u6bb5\u6570", FieldType.Int.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "OldImageSource", "\u524d\u671f\u5f71\u50cf\u7c7b\u578b", FieldType.String.getValue(), 16);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "x1path", "\u524d\u671f\u5f71\u50cf\u5c0f\u7247\u8def\u5f84", FieldType.Text.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "x2path", "\u540e\u671f\u5f71\u50cf\u5c0f\u7247\u8def\u5f84", FieldType.Text.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "ypath", "\u6837\u672c\u6807\u6ce8\u5c0f\u7247\u8def\u5f84", FieldType.Text.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "y1path", "\u524d\u671f\u5f71\u50cf\u5206\u7c7b\u5c0f\u7247\u8def\u5f84", FieldType.Text.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        addField = this.buildImgTypeField(datumTypeId, "y2path", "\u540e\u671f\u5f71\u50cf\u5206\u7c7b\u5c0f\u7247\u8def\u5f84", FieldType.Text.getValue(), null);
        addField.setOrder(++fieldOrder);
        fields.add(addField);
        return fields;
    }

    private static /* synthetic */ boolean lambda$saveDatumTypeFields$6(ImgDatumTypeFieldDTO updateField, ImgDatumTypeField f) {
        return f.getId().equalsIgnoreCase(updateField.getId());
    }
}

