/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONArray;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.config.filemodel.constant.CatalogFileTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.FileDataService;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.geodb.filter.SpatialRelationType;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dto.query.FileDataDownloadCheckResultDTO;
import com.geoway.imagedb.dataset.dto.query.ImageQueryResult;
import com.geoway.imagedb.dataset.dto.query.ImageRangeDTO;
import com.geoway.imagedb.dataset.dto.query.ImageResult;
import com.geoway.imagedb.dataset.dto.query.ImageSampleFilterDTO;
import com.geoway.imagedb.dataset.dto.query.ImageSampleQueryFilterDTO;
import com.geoway.imagedb.dataset.dto.query.TimeFilterDTO;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.service.ImageSampleQueryService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class ImageSampleQueryServiceImpl
implements ImageSampleQueryService {
    private static final Logger log = LoggerFactory.getLogger(ImageSampleQueryServiceImpl.class);
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private FileDataService fileDataService;
    @Resource
    private FileStorageService fileStorageService;
    private String businessDatasetId = "";

    @Override
    public ImageQueryResult queryByGeometry(ImageSampleQueryFilterDTO filterDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)filterDTO.getSceneType())) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u6837\u672c\u7c7b\u578b");
        }
        ImageQueryResult queryResult = new ImageQueryResult();
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnCount(Boolean.valueOf(true));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
        queryFilterDTO.setRows(filterDTO.getRows());
        queryFilterDTO.setPageIndex(filterDTO.getPageIndex());
        LinkedList<String> geometryList = new LinkedList<String>();
        if (StringUtil.isNotEmpty((String)filterDTO.getGeometry())) {
            geometryList.add(filterDTO.getGeometry());
        }
        queryFilterDTO.setGeometryList(geometryList);
        queryFilterDTO.setRelation(filterDTO.getRelation() == null ? SpatialRelationType.Intersects : filterDTO.getRelation());
        queryFilterDTO.setCondition(this.getImageQueryCondition(filterDTO));
        ImageDatasetTypeEnum imageType = ImageDatasetTypeEnum.getByValue(filterDTO.getImageType());
        DataQueryResult dataQueryResult = this.dataSourceService.queryData(this.getBusinessDatasetId(), queryFilterDTO);
        queryResult.setTotal(dataQueryResult.getTotal());
        queryResult.setData(new ArrayList<ImageResult>());
        if (dataQueryResult.getData() != null && dataQueryResult.getData().size() > 0) {
            for (FeatureResult item : dataQueryResult.getData()) {
                ImageResult imageResult = new ImageResult();
                imageResult.setDatasetId(item.getAttributes().get("f_image_dataset_id").toString());
                imageResult.setDataId(item.getAttributes().get("F_DATAID".toLowerCase(Locale.ROOT)).toString());
                imageResult.setAttributes(this.convertImageQueryResultAttributes(imageType, item, filterDTO.getSceneType()));
                imageResult.setGeometry(item.getGeometry());
                imageResult.setRecycled(false);
                queryResult.getData().add(imageResult);
            }
        }
        queryResult.setRangeRender(this.dataSourceManager.getDatasetRender(this.getBusinessDatasetId()));
        queryResult.setFields(this.getReturnFields(imageType, filterDTO.getSceneType()));
        return queryResult;
    }

    @Override
    public ImageRangeDTO queryDataIds(ImageSampleQueryFilterDTO filterDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)filterDTO.getSceneType())) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u6837\u672c\u7c7b\u578b");
        }
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnCount(Boolean.valueOf(false));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
        queryFilterDTO.setRows(Integer.valueOf(10000));
        LinkedList<String> geometryList = new LinkedList<String>();
        if (StringUtil.isNotEmpty((String)filterDTO.getGeometry())) {
            geometryList.add(filterDTO.getGeometry());
        }
        queryFilterDTO.setGeometryList(geometryList);
        queryFilterDTO.setRelation(filterDTO.getRelation() == null ? SpatialRelationType.Intersects : filterDTO.getRelation());
        queryFilterDTO.setCondition(this.getImageQueryCondition(filterDTO));
        ImageRangeDTO imageRangeDTO = new ImageRangeDTO();
        long count = 10000L;
        int pageIndex = 0;
        ArrayList<String> dataIds = new ArrayList<String>();
        ArrayList<String> objectIds = new ArrayList<String>();
        IGeometry geometry = null;
        while (count == 10000L) {
            queryFilterDTO.setPageIndex(Integer.valueOf(pageIndex));
            DataQueryResult dataQueryResult = this.dataSourceService.queryData(this.getBusinessDatasetId(), queryFilterDTO);
            if (dataQueryResult.getData() != null && dataQueryResult.getData().size() > 0) {
                count = dataQueryResult.getData().size();
                ++pageIndex;
                for (FeatureResult item : dataQueryResult.getData()) {
                    dataIds.add(item.getAttributes().get("F_DATAID".toLowerCase(Locale.ROOT)).toString());
                    objectIds.add(item.getAttributes().get("objectid").toString());
                    if (item.getGeometry() == null) continue;
                    if (geometry == null) {
                        geometry = GeometryFunc.createGeometry((String)item.getGeometry());
                        continue;
                    }
                    geometry = geometry.union(GeometryFunc.createGeometry((String)item.getGeometry()));
                }
                continue;
            }
            count = 0L;
        }
        imageRangeDTO.setDataIdArray(dataIds);
        imageRangeDTO.setObjectIdArray(objectIds);
        imageRangeDTO.setRangeRender(this.dataSourceManager.getDatasetRender(this.getBusinessDatasetId()));
        return imageRangeDTO;
    }

    @Override
    public List<FileDataDownloadCheckResultDTO> checkSampleDataCanDownload(List<String> dataIdArray) {
        if (dataIdArray == null || dataIdArray.size() == 0) {
            return new ArrayList<FileDataDownloadCheckResultDTO>();
        }
        ArrayList<FileDataDownloadCheckResultDTO> checkResultList = new ArrayList<FileDataDownloadCheckResultDTO>();
        for (String dataId : dataIdArray) {
            FileDataDownloadCheckResultDTO checkResult = new FileDataDownloadCheckResultDTO();
            checkResult.setDataId(dataId);
            checkResult.setPermit(dataId + "_p");
            try {
                boolean canDownload = this.fileDataService.fileDataUnitDownloadCheck(dataId, null);
                checkResult.setCanDownload(canDownload);
            }
            catch (Exception e) {
                checkResult.setCanDownload(false);
                log.error(e.getMessage(), (Throwable)e);
                checkResult.setMessage("\u65e0\u6cd5\u4e0b\u8f7d\uff1a" + e.getMessage());
            }
            checkResultList.add(checkResult);
        }
        return checkResultList;
    }

    @Override
    public void downloadImageDataByPermit(String permit) {
        String dataId = permit.substring(0, permit.length() - 2);
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setCondition(String.format("%s = '%s'", "F_DATAID".toLowerCase(Locale.ROOT), dataId));
        DataQueryResult dataQueryResult = this.dataSourceService.queryData(this.getBusinessDatasetId(), queryFilterDTO);
        if (dataQueryResult == null || dataQueryResult.getData() == null || dataQueryResult.getData().size() == 0) {
            throw new RuntimeException("\u6837\u672c\u603b\u96c6\u4e2d\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u6837\u672c\u6570\u636e");
        }
        FeatureResult item = (FeatureResult)dataQueryResult.getData().get(0);
        Object imageTypeObj = item.getAttributes().get("f_image_type");
        if (imageTypeObj == null || StringUtil.isEmptyOrWhiteSpace((String)imageTypeObj.toString())) {
            throw new RuntimeException("\u6837\u672c\u603b\u96c6\u4e2d\u672a\u8bb0\u5f55\u6837\u672c\u6570\u636e\u7684\u5f71\u50cf\u7c7b\u578b");
        }
        String imageDatasetId = item.getAttributes().get("f_image_dataset_id").toString();
        ImageDatasetTypeEnum imageType = ImageDatasetTypeEnum.getByValue(Integer.valueOf(imageTypeObj.toString()));
        switch (imageType) {
            case TileSampleImageDataset: {
                this.fileDataService.downloadFileDataUnit(dataId, null);
                break;
            }
            case ImageSampleImageDataset: {
                boolean needAddImg = false;
                DmFileData fileData = this.fileDataService.getFileData(dataId);
                List files = JSONArray.parseArray((String)fileData.getCatalogFiles(), FileDataUnit.class);
                FileDataUnit imgDataUnit = (FileDataUnit)ListUtil.find((List)files, f -> f.getFileLocation().endsWith("/img") || f.getFileLocation().endsWith("/img/"));
                if (imgDataUnit == null) {
                    needAddImg = true;
                } else {
                    List imgFiles = ListUtil.findAll((List)files, f -> f.getFileLocation().startsWith(imgDataUnit.getFileLocation()));
                    if (imgFiles.size() == 0) {
                        needAddImg = true;
                    }
                }
                if (needAddImg) {
                    ImgDataset imgDataset = this.imageDatasetService.getImgDataset(imageDatasetId);
                    if (imgDataset == null) {
                        throw new RuntimeException("\u5f71\u50cf\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
                    }
                    String serverId = fileData.getServerId();
                    IFileStorage fileStorage = this.fileStorageService.openFileStorage(serverId);
                    if (fileStorage == null) {
                        throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u5b58\u50a8\u8282\u70b9\uff01");
                    }
                    String url = fileStorage.getStorageUrl();
                    ArrayList<IFileset> downloadPaths = new ArrayList<IFileset>();
                    files.forEach(unit -> {
                        String filePath = fileStorage.combinePaths(url, new String[]{unit.getFileLocation()});
                        if (fileStorage.fileExist(filePath)) {
                            downloadPaths.add(fileStorage.getFile(filePath));
                            if (unit.getCatalogFileType() == CatalogFileTypeEnum.FolderWithChildren) {
                                downloadPaths.addAll(this.getWholePath(fileStorage.getFile(filePath)));
                            }
                        }
                    });
                    String downloadPath = fileStorage.combinePaths(url, new String[]{fileData.getMainPath()});
                    String sampleMosaicDatasetId = imgDataset.getSubDatasetIds().get("img");
                    DataQueryResult queryResult = this.geoDatabaseService.queryGeoDataset(sampleMosaicDatasetId, queryFilterDTO);
                    Object sceneTypeObj = item.getAttributes().get("scenetype");
                    HashMap<String, String> insertFileMap = new HashMap<String, String>(0);
                    if (sceneTypeObj != null && ("2".equals(sceneTypeObj.toString()) || sceneTypeObj.toString().contains("\u53d8\u5316"))) {
                        for (FeatureResult featureResult : queryResult.getData()) {
                            this.addImgFile(featureResult, insertFileMap);
                        }
                    } else {
                        this.addImgFile((FeatureResult)queryResult.getData().get(0), insertFileMap);
                    }
                    FileDataUnit keyDataUnit = (FileDataUnit)ListUtil.find((List)files, FileDataUnit::isMainFile);
                    this.downloadSampleData(fileData, keyDataUnit, downloadPaths, insertFileMap, downloadPath);
                    break;
                }
                this.fileDataService.downloadFileDataUnit(dataId, null);
                break;
            }
        }
    }

    private Map<String, Object> convertImageQueryResultAttributes(ImageDatasetTypeEnum imageType, FeatureResult item, String sceneType) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(0);
        if (imageType == ImageDatasetTypeEnum.TileSampleImageDataset) {
            attributes.put("satellitename", item.getAttributes().get("satellitename"));
            attributes.put("bandnum", item.getAttributes().get("bandnum"));
            attributes.put("bandbits", item.getAttributes().get("bandbits"));
        }
        long dataSize = Long.parseLong(item.getAttributes().get("F_DATASIZE".toLowerCase(Locale.ROOT)).toString());
        double size = NumberUtil.div((float)dataSize, (float)1024.0f, (int)2);
        attributes.put("F_DATASIZE".toLowerCase(Locale.ROOT), size + "");
        attributes.put("F_DATANAME".toLowerCase(Locale.ROOT), item.getAttributes().get("F_DATANAME".toLowerCase(Locale.ROOT)));
        attributes.put("imagetime", item.getAttributes().get("imagetime"));
        if ("2".equals(sceneType) || sceneType.contains("\u53d8\u5316")) {
            attributes.put("oldimagetime", item.getAttributes().get("oldimagetime"));
        }
        return attributes;
    }

    private List<ReturnField> getReturnFields(ImageDatasetTypeEnum imageType, String sceneType) {
        ArrayList<ReturnField> list = new ArrayList<ReturnField>();
        if (imageType == ImageDatasetTypeEnum.ImageSampleImageDataset) {
            list.add(new ReturnField("F_DATANAME".toLowerCase(Locale.ROOT), "\u6837\u672c\u540d\u79f0"));
        } else if (imageType == ImageDatasetTypeEnum.TileSampleImageDataset) {
            list.add(new ReturnField("F_DATANAME".toLowerCase(Locale.ROOT), "\u540d\u79f0"));
            list.add(new ReturnField("satelliteName", "\u5f71\u50cf\u6765\u6e90"));
            list.add(new ReturnField("F_DATASIZE".toLowerCase(Locale.ROOT), "\u6570\u636e\u5927\u5c0f"));
            list.add(new ReturnField("bandnum", "\u6ce2\u6bb5\u6570"));
            list.add(new ReturnField("bandbits", "\u4f4d\u6df1"));
        }
        if ("2".equals(sceneType)) {
            list.add(new ReturnField("imagetime", "\u5f71\u50cf\u65f6\u95f4(\u65b0)"));
            list.add(new ReturnField("oldimagetime", "\u5f71\u50cf\u65f6\u95f4(\u65e7)"));
        } else {
            list.add(new ReturnField("imagetime", "\u5f71\u50cf\u65f6\u95f4"));
        }
        return list;
    }

    private String getBusinessDatasetId() {
        if (StringUtil.isEmptyOrWhiteSpace((String)this.businessDatasetId)) {
            DataSourceDTO targetDatabase = this.imageDatasetService.getBusinessSnapshotDataSource();
            DatasetDTO datasetDTO = this.geoDatabaseService.getDatasetDetail(targetDatabase, DatasetTypeEnum.FeatureClass, "tb_sample_data");
            Assert.notNull((Object)datasetDTO, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            this.businessDatasetId = datasetDTO.getId();
        }
        return this.businessDatasetId;
    }

    private String getImageQueryCondition(ImageSampleQueryFilterDTO filterDTO) {
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add(String.format("%s = %d and %s = %d", "f_image_type", filterDTO.getImageType(), "f_flag", 0));
        if (StringUtil.isNotEmpty((String)filterDTO.getSceneType())) {
            conditions.add(String.format("%s = '%s'", "scenetype", filterDTO.getSceneType()));
        }
        if (filterDTO.getSampleSchemeList() != null && filterDTO.getSampleSchemeList().size() > 0) {
            List schemeFilters = ListUtil.convertAll(filterDTO.getSampleSchemeList(), f -> String.format("%s = '%s'", "samplescheme", f));
            String schemeFilter = String.join((CharSequence)" or ", schemeFilters);
            if (schemeFilters.size() == 1) {
                conditions.add(schemeFilter);
            } else {
                conditions.add("(" + schemeFilter + ")");
            }
        }
        if (filterDTO.getClassIdList() != null && filterDTO.getClassIdList().size() > 0) {
            List classIdFilters = ListUtil.convertAll(filterDTO.getClassIdList(), f -> String.format("%s like '%%%s,%%'", "classid", f));
            String classIdFilter = String.join((CharSequence)" or ", classIdFilters);
            if (classIdFilters.size() == 1) {
                conditions.add(classIdFilter);
            } else {
                conditions.add("(" + classIdFilter + ")");
            }
        }
        if (filterDTO.getSample() != null) {
            conditions.addAll(this.convertImageSampleFilter(filterDTO.getSample(), false));
        }
        if (filterDTO.getOldSample() != null) {
            conditions.addAll(this.convertImageSampleFilter(filterDTO.getOldSample(), true));
        }
        if (conditions.size() == 0) {
            return "";
        }
        return String.join((CharSequence)" and ", conditions);
    }

    private List<String> convertImageSampleFilter(ImageSampleFilterDTO sample, boolean old) {
        String fieldName;
        ArrayList<String> conditions = new ArrayList<String>();
        if (sample.getImageSource() != null) {
            fieldName = old ? "oldimagesource" : "imagesource";
            conditions.add(String.format("%s = '%s'", fieldName, sample.getImageSource()));
        }
        if (sample.getBandBits() != null) {
            fieldName = old ? "oldbandbits" : "bandbits";
            conditions.add(String.format("%s = %d", fieldName, sample.getBandBits()));
        }
        if (sample.getBandNum() != null) {
            fieldName = old ? "oldbandnum" : "bandnum";
            conditions.add(String.format("%s = %d", fieldName, sample.getBandNum()));
        }
        if (sample.getTileSize() != null) {
            fieldName = old ? "oldtilesize" : "tilesize";
            conditions.add(String.format("%s = '%s'", fieldName, sample.getTileSize()));
        }
        if (sample.getSensorType() != null) {
            fieldName = old ? "oldsensortype" : "sensortype";
            conditions.add(String.format("%s = '%s'", fieldName, sample.getSensorType()));
        }
        if (sample.getSatelliteName() != null) {
            fieldName = old ? "oldsatellitename" : "satellitename";
            conditions.add(String.format("%s = '%s'", fieldName, sample.getSatelliteName()));
        }
        if (sample.getImageTime() != null) {
            fieldName = old ? "oldimagetime" : "imagetime";
            conditions.add(this.convertTimeFilters(sample.getImageTime(), fieldName));
        }
        if (sample.getPixelSize() != null) {
            fieldName = old ? "oldpixelsize" : "pixelsize";
            conditions.add(String.format("%s = %f", fieldName, sample.getPixelSize()));
        }
        return conditions;
    }

    private String convertTimeFilters(TimeFilterDTO timeFilterDTO, String timeFiField) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timeFilterDTO.getStartTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String start = dateFormat.format(calendar.getTime());
        calendar.setTime(timeFilterDTO.getEndTime());
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        String end = dateFormat.format(calendar.getTime());
        return String.format("(%s between '%s' and '%s')", timeFiField, start, end);
    }

    private List<IFileset> getWholePath(IFileset fileset) {
        ArrayList<IFileset> filePaths = new ArrayList<IFileset>();
        try {
            List subFiles = fileset.listFiles();
            if (subFiles == null || subFiles.size() == 0) {
                return filePaths;
            }
            for (IFileset file : subFiles) {
                filePaths.add(file);
                if (!file.getIsDirectory()) continue;
                filePaths.addAll(this.getWholePath(file));
            }
            return filePaths;
        }
        catch (Exception ex) {
            log.error(fileset.getFullPath() + " \u641c\u7d22\u6587\u4ef6\u5f02\u5e38", (Throwable)ex);
            return filePaths;
        }
    }

    private void downloadSampleData(DmFileData fileData, FileDataUnit keyDataUnit, List<IFileset> downloadPaths, Map<String, String> insertFileMap, String downloadPath) {
        try {
            ArrayList<IFileset> srcFile = new ArrayList<IFileset>();
            for (IFileset fileItem : downloadPaths) {
                if (srcFile.contains(fileItem)) continue;
                if (fileItem != null) {
                    srcFile.add(fileItem);
                    continue;
                }
                log.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u4e0b\u8f7d\uff01");
            }
            if (srcFile.size() == 1) {
                DownloadUtil.downloadFile((InputStream)((IFileset)srcFile.get(0)).openFileStream(), (long)((IFileset)srcFile.get(0)).getSize(), (String)((IFileset)srcFile.get(0)).getName());
            } else {
                String zipName = fileData.getDataName() + ".zip";
                this.onlyZipSrcFileList(srcFile, keyDataUnit, insertFileMap, zipName, downloadPath);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6587\u4ef6\u6570\u636e\u6253\u5305\u5931\u8d25\uff01");
        }
    }

    private void onlyZipSrcFileList(List<IFileset> srcFile, FileDataUnit keyDataUnit, Map<String, String> insertFileMap, String zipFileName, String rootDir) {
        byte[] buf = new byte[1024];
        InputStream in = null;
        ZipOutputStream out = null;
        try {
            out = this.getOutputStream(zipFileName);
            for (IFileset file : srcFile) {
                if (file == null) continue;
                String inZipPath = file.getName();
                if (file.getFullPath().contains(rootDir)) {
                    inZipPath = file.getFullPath().substring(rootDir.length());
                    inZipPath = file.getIsDirectory() ? inZipPath + "/" : inZipPath;
                    inZipPath = StringUtil.trimStart((String)inZipPath.replace("\\", "/"), (String)"/");
                }
                out.putNextEntry(new ZipEntry(inZipPath));
                if (!file.getIsDirectory()) {
                    int len;
                    in = file.openFileStream();
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                out.closeEntry();
                String keyFileLocation = keyDataUnit.getFileLocation().replace("\\", "/");
                String fullPath = file.getFullPath().replace("\\", "/");
                if (!fullPath.endsWith(keyFileLocation)) continue;
                for (String imgFilePath : insertFileMap.keySet()) {
                    int len;
                    String imgInZipPath = inZipPath.substring(0, inZipPath.length() - file.getName().length());
                    String folderName = insertFileMap.get(imgFilePath);
                    File imgFile = new File(imgFilePath);
                    out.putNextEntry(new ZipEntry(imgInZipPath + folderName + "/" + imgFile.getName()));
                    in = new FileInputStream(imgFile);
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                }
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u6587\u4ef6\u538b\u7f29\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{in, out});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{in, out});
    }

    private ZipOutputStream getOutputStream(String zipFileName) {
        try {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = servletRequestAttributes.getRequest();
            HttpServletResponse response = servletRequestAttributes.getResponse();
            response.resetBuffer();
            String userAgent = request.getHeader("User-Agent");
            String[] IE_BROWSERS = new String[]{"MSIE", "Trident", "Edge"};
            zipFileName = Arrays.stream(IE_BROWSERS).anyMatch(userAgent::contains) ? URLEncoder.encode(zipFileName, "UTF-8") : new String(zipFileName.getBytes("UTF-8"), "ISO-8859-1");
            response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", zipFileName));
            response.setHeader("Access-Control-Expose-Headers", "Content-disposition");
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            return new ZipOutputStream((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), Charset.forName("GBK"));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    private void addImgFile(FeatureResult featureResult, Map<String, String> insertFileMap) {
        String folderName = featureResult.getAttributes().get("imageType").toString();
        folderName = "img/" + folderName;
        String imgPath = featureResult.getAttributes().get("urihash").toString();
        File imgFile = new File(imgPath);
        if (imgFile.exists()) {
            String imgName = FileUtil.getFileNameWithoutExtension((String)imgPath);
            for (File file : imgFile.getParentFile().listFiles()) {
                if (!file.getName().startsWith(imgName)) continue;
                insertFileMap.put(file.getAbsolutePath(), folderName);
            }
        } else {
            log.error("\u5f71\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + imgPath);
        }
    }
}

