/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.imagedb.dataset.constant.FilterInputTypeEnum;
import com.geoway.imagedb.dataset.constant.ImageBusinessTypeEnum;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dao.ImgFieldDao;
import com.geoway.imagedb.dataset.dto.ImgFieldBaseDTO;
import com.geoway.imagedb.dataset.dto.ImgGroupDTO;
import com.geoway.imagedb.dataset.dto.ImgTreeBaseDTO;
import com.geoway.imagedb.dataset.dto.edit.ImgFieldEditDTO;
import com.geoway.imagedb.dataset.entity.ImgField;
import com.geoway.imagedb.dataset.event.ImgFieldBeforeDeleteEvent;
import com.geoway.imagedb.dataset.service.ImgFieldsManageService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImgFieldsManageServiceImpl
implements ImgFieldsManageService {
    private static final Logger log = LoggerFactory.getLogger(ImgFieldsManageServiceImpl.class);
    @Resource
    private ImgFieldDao imgFieldDao;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    private Pattern pattern = Pattern.compile("^[0-9a-zA-Z\u4e00-\u9fa5_]+$");

    @Override
    public List<ImgTreeBaseDTO> tree(String keyword) {
        List<ImgField> allFields = this.imgFieldDao.selectAll();
        Map<String, List<ImgField>> pidGroup = allFields.stream().collect(Collectors.groupingBy(ImgField::getPid));
        return this.completeChildren(pidGroup, "-1", keyword, new HashMap<String, Boolean>(0));
    }

    @Override
    public ImgTreeBaseDTO getDetail(String id) {
        ImgField imgField = this.imgFieldDao.selectByPrimaryKey(id);
        Assert.notNull((Object)imgField, (String)"\u5b57\u6bb5\u4e0d\u5b58\u5728\uff01");
        return this.convertImgField(imgField);
    }

    @Override
    public String addOrUpdateGroup(ImgGroupDTO groupDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)groupDTO.getId())) {
            if (StringUtil.isEmptyOrWhiteSpace((String)groupDTO.getPid()) || "-1".equals(groupDTO.getPid())) {
                groupDTO.setPid("-1");
            } else {
                ImgField pGroup = this.imgFieldDao.selectByPrimaryKey(groupDTO.getPid());
                Assert.notNull((Object)pGroup, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
            }
            ImgField addGroup = new ImgField();
            addGroup.setId(UUID.randomUUID().toString().replace("-", ""));
            addGroup.setName(groupDTO.getName());
            addGroup.setIsGroup(ConstantsValue.TRUE_VALUE);
            addGroup.setAliasName(groupDTO.getName());
            addGroup.setPid(groupDTO.getPid());
            addGroup.setIsSysField(ConstantsValue.FALSE_VALUE);
            Integer order = this.imgFieldDao.queryMaxOrder(addGroup.getPid());
            if (order == null) {
                order = 0;
            }
            addGroup.setOrder(order + 1);
            addGroup.setType(ImageBusinessTypeEnum.ExtensionField.getValue());
            this.imgFieldDao.insert(addGroup);
            return addGroup.getId();
        }
        ImgField group = this.imgFieldDao.selectByPrimaryKey(groupDTO.getId());
        Assert.notNull((Object)group, (String)"\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        group.setName(groupDTO.getName());
        group.setAliasName(groupDTO.getName());
        group.setDesc(groupDTO.getDesc());
        this.imgFieldDao.updateByPrimaryKey(group);
        return group.getId();
    }

    @Override
    public String addField(ImgFieldBaseDTO addDTO) {
        Assert.notNull((Object)addDTO.getPid(), (String)"\u8bf7\u6307\u5b9a\u7236\u8282\u70b9\u6807\u8bc6\uff01");
        ImgField pGroup = this.imgFieldDao.selectByPrimaryKey(addDTO.getPid());
        Assert.notNull((Object)pGroup, (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        if (ConstantsValue.FALSE_VALUE.equals(pGroup.getIsGroup())) {
            throw new RuntimeException("\u7236\u8282\u70b9\u5fc5\u987b\u662f\u5206\u7ec4\u8282\u70b9\uff01");
        }
        Assert.notNull((Object)addDTO.getName(), (String)"\u8bf7\u8bbe\u7f6e\u5b57\u6bb5\u540d\u79f0\uff01");
        if ("1234567890".indexOf(addDTO.getName().charAt(0)) > -1 || !this.pattern.matcher(addDTO.getName()).matches()) {
            throw new RuntimeException("\u540d\u79f0\u53ea\u80fd\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934");
        }
        if (addDTO.getName().length() > 60) {
            throw new RuntimeException("\u5b57\u6bb5\u957f\u5ea6\u9700\u5c0f\u4e8e\u7b49\u4e8e60\uff01");
        }
        ImgField sameNameFiled = this.imgFieldDao.selectByFieldName(addDTO.getName());
        if (sameNameFiled != null) {
            return sameNameFiled.getId();
        }
        FieldType fieldType = FieldType.getByValue((Integer)addDTO.getFieldType());
        if (fieldType == FieldType.Unknown) {
            throw new RuntimeException("\u672a\u77e5\u7684\u5b57\u6bb5\u7c7b\u578b\uff01");
        }
        ImgField imgField = new ImgField();
        imgField.setId(UUID.randomUUID().toString().replace("-", ""));
        imgField.setName(addDTO.getName());
        imgField.setAliasName(addDTO.getAliasName());
        imgField.setDesc(addDTO.getDesc());
        imgField.setFieldType(addDTO.getFieldType());
        imgField.setLength(addDTO.getLength());
        imgField.setDomainId(addDTO.getDomainId());
        imgField.setDefaultValue(addDTO.getDefaultValue());
        imgField.setIsSysField(Boolean.TRUE.equals(addDTO.getIsSysField()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        imgField.setNullable(Boolean.TRUE.equals(addDTO.getNullable()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        imgField.setIsGroup(ConstantsValue.FALSE_VALUE);
        imgField.setPid(addDTO.getPid());
        Integer order = this.imgFieldDao.queryMaxOrder(imgField.getPid());
        if (order == null) {
            order = 0;
        }
        imgField.setOrder(order + 1);
        FilterInputTypeEnum filterInputType = FilterInputTypeEnum.getByValue(addDTO.getQueryUiType());
        imgField.setQueryUiType(filterInputType.getValue());
        imgField.setQueryUiParams(addDTO.getQueryUiParams());
        imgField.setType(ImageBusinessTypeEnum.ExtensionField.getValue());
        this.imgFieldDao.insert(imgField);
        return imgField.getId();
    }

    @Override
    public void editField(ImgFieldEditDTO editDTO) {
        ImgField imgField = this.imgFieldDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)imgField, (String)"\u5b57\u6bb5\u4e0d\u5b58\u5728\uff01");
        if (ConstantsValue.TRUE_VALUE.equals(imgField.getIsSysField())) {
            throw new RuntimeException("\u7cfb\u7edf\u5b57\u6bb5\u4e0d\u5141\u8bb8\u7f16\u8f91\uff01");
        }
        if (imgField.getType().intValue() == ImageBusinessTypeEnum.InherentField.getValue()) {
            throw new RuntimeException("\u56fa\u6709\u5b57\u6bb5\u4e0d\u5141\u8bb8\u7f16\u8f91\uff01");
        }
        if (imgField.getUseCount() == null || imgField.getUseCount() == 0) {
            imgField.setName(editDTO.getName());
            FieldType fieldType = FieldType.getByValue((Integer)editDTO.getFieldType());
            if (fieldType == FieldType.Unknown) {
                throw new RuntimeException("\u672a\u77e5\u7684\u5b57\u6bb5\u7c7b\u578b\uff01");
            }
            imgField.setFieldType(fieldType.getValue());
            imgField.setLength(editDTO.getLength());
            imgField.setDomainId(editDTO.getDomainId());
            imgField.setDefaultValue(editDTO.getDefaultValue());
            imgField.setNullable(Boolean.TRUE.equals(editDTO.getNullable()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        }
        imgField.setAliasName(editDTO.getAliasName());
        FilterInputTypeEnum filterInputType = FilterInputTypeEnum.getByValue(editDTO.getQueryUiType());
        imgField.setQueryUiType(filterInputType.getValue());
        imgField.setQueryUiParams(editDTO.getQueryUiParams());
        this.imgFieldDao.updateByPrimaryKey(imgField);
    }

    @Override
    public Integer deleteFields(String ids) {
        if (StringUtil.isEmptyOrWhiteSpace((String)ids)) {
            return 0;
        }
        String[] idArray = ids.split(",");
        List<ImgField> allFields = this.imgFieldDao.selectAll();
        Map<String, List<ImgField>> pidGroup = allFields.stream().collect(Collectors.groupingBy(ImgField::getPid));
        LinkedHashSet<String> subNodeIdSet = new LinkedHashSet<String>();
        for (String id : idArray) {
            if ("-1".equals(id)) continue;
            subNodeIdSet.addAll(this.getSubFieldIdList(pidGroup, id));
            subNodeIdSet.add(id);
        }
        if (subNodeIdSet.size() == 0) {
            return 0;
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ImgFieldBeforeDeleteEvent(this, new ArrayList<String>(subNodeIdSet)));
        return this.imgFieldDao.deleteByIdList(new ArrayList<String>(subNodeIdSet));
    }

    @Override
    public void moveImgField(String id, String pid, Integer order) {
        int i;
        List<ImgField> children;
        if (id == null || order == null) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtil.equals((String)id, (String)pid)) {
            throw new RuntimeException("\u4e0d\u5141\u8bb8\u79fb\u52a8\u5230\u8282\u70b9\u672c\u8eab\u4e0b");
        }
        ImgField imgField = this.imgFieldDao.selectByPrimaryKey(id);
        Assert.notNull((Object)imgField, (String)"\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u6b64\u6b21\u79fb\u52a8\u65e0\u6548");
        if (ConstantsValue.TRUE_VALUE.equals(imgField.getIsGroup()) && StringUtil.isEmptyOrWhiteSpace((String)pid)) {
            throw new RuntimeException("\u4e0d\u5141\u8bb8\u79fb\u52a8\u5230\u6839\u8282\u70b9\u4e0b");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)pid)) {
            pid = null;
        }
        if (!StringUtil.equals((String)imgField.getPid(), (String)pid)) {
            List<ImgField> allFields = this.imgFieldDao.selectAll();
            Map<String, List<ImgField>> pidGroup = allFields.stream().collect(Collectors.groupingBy(ImgField::getPid));
            List<String> subNodeIdList = this.getSubFieldIdList(pidGroup, imgField.getId());
            if (subNodeIdList.contains(pid)) {
                throw new RuntimeException("\u4e0d\u5141\u8bb8\u79fb\u52a8\u5230\u5b50\u8282\u70b9\u4e0b");
            }
            imgField.setPid(pid);
            imgField.setOrder(-1);
            this.imgFieldDao.updateByPrimaryKey(imgField);
            children = pidGroup.get(pid);
        } else {
            children = this.imgFieldDao.selectByPid(pid);
            children.removeIf(f -> StringUtil.equals((String)f.getId(), (String)id));
        }
        int preIndex = -1;
        for (i = 0; i < children.size(); ++i) {
            if (!children.get(i).getOrder().equals(order)) continue;
            preIndex = i;
            break;
        }
        if (preIndex == -1 && order > 0) {
            preIndex = order;
        }
        if (preIndex >= children.size()) {
            preIndex = children.size() - 1;
        }
        children.add(preIndex + 1, imgField);
        for (i = 0; i < children.size(); ++i) {
            ImgField child = children.get(i);
            if (child.getOrder() == i + 1) continue;
            child.setOrder(i + 1);
            this.imgFieldDao.updateOrderByPrimaryKey(child.getId(), child.getOrder());
        }
    }

    @Override
    public void exportFields() {
        List items = this.tree("");
        items = ListUtil.findAll(items, f -> f.getIsSysField() == false);
        String contents = JSONArray.toJSONString((Object)items);
        DownloadUtil.downloadToFile((String)"\u5b57\u6bb5\u914d\u7f6e.json", (String)contents);
    }

    @Override
    public Boolean importFields(MultipartFile file) {
        if (file == null || !Objects.requireNonNull(file.getOriginalFilename()).endsWith(".json")) {
            throw new RuntimeException("\u6587\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        InputStreamReader streamReader = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuffer = new StringBuilder();
        JSONArray jsonArray = null;
        try {
            streamReader = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(streamReader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                stringBuffer.append(line);
            }
            bufferedReader.close();
            streamReader.close();
            jsonArray = JSONArray.parseArray((String)stringBuffer.toString());
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff01" + e.getMessage());
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{streamReader, bufferedReader});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{streamReader, bufferedReader});
        if (jsonArray == null || jsonArray.size() == 0) {
            return true;
        }
        this.addAllFields(jsonArray, "-1");
        return true;
    }

    @Override
    public List<ImgFieldBaseDTO> getSystemFields() {
        List<ImgField> fieldList = this.imgFieldDao.selectSystemFields();
        return ListUtil.convertAll(fieldList, f -> (ImgFieldBaseDTO)this.convertImgField((ImgField)f));
    }

    @Override
    public List<ImgFieldBaseDTO> getAllFields() {
        List<ImgField> fieldList = this.imgFieldDao.selectAllFields();
        return ListUtil.convertAll(fieldList, f -> (ImgFieldBaseDTO)this.convertImgField((ImgField)f));
    }

    private List<ImgTreeBaseDTO> completeChildren(Map<String, List<ImgField>> pidGroup, String pId, String keyword, Map<String, Boolean> inUseGroupMap) {
        ArrayList<ImgTreeBaseDTO> dtoList = new ArrayList<ImgTreeBaseDTO>();
        List<ImgField> subImgFields = pidGroup.get(pId);
        if (subImgFields == null) {
            inUseGroupMap.put(pId, false);
            return dtoList;
        }
        boolean groupInUse = false;
        for (ImgField imgField : subImgFields) {
            if (imgField.getUseCount() != null && imgField.getUseCount() > 0) {
                groupInUse = true;
            }
            List<ImgTreeBaseDTO> subList = this.completeChildren(pidGroup, imgField.getId(), keyword, inUseGroupMap);
            ImgTreeBaseDTO imgFieldDTO = this.convertImgField(imgField);
            if (inUseGroupMap.containsKey(imgField.getId()) && imgFieldDTO.getIsGroup().booleanValue()) {
                imgFieldDTO.setInUse(inUseGroupMap.get(imgField.getId()));
            }
            if (!StringUtil.isEmpty((String)keyword) && !imgFieldDTO.getName().toLowerCase().contains(keyword.toLowerCase()) && !imgFieldDTO.getAliasName().toLowerCase().contains(keyword.toLowerCase()) && !imgFieldDTO.getId().equals(keyword) && subList.size() <= 0) continue;
            imgFieldDTO.setChildren(subList);
            dtoList.add(imgFieldDTO);
        }
        inUseGroupMap.put(pId, groupInUse);
        return dtoList;
    }

    private ImgTreeBaseDTO convertImgField(ImgField imgField) {
        ImgTreeBaseDTO dto;
        boolean isGroup = ConstantsValue.TRUE_VALUE.equals(imgField.getIsGroup());
        if (isGroup) {
            dto = new ImgTreeBaseDTO();
        } else {
            dto = new ImgFieldBaseDTO();
            ((ImgFieldBaseDTO)dto).setFieldType(imgField.getFieldType());
            ((ImgFieldBaseDTO)dto).setLength(imgField.getLength());
            ((ImgFieldBaseDTO)dto).setDefaultValue(imgField.getDefaultValue());
            ((ImgFieldBaseDTO)dto).setNullable(ConstantsValue.TRUE_VALUE.equals(imgField.getNullable()));
            ((ImgFieldBaseDTO)dto).setDomainId(imgField.getDomainId());
            ((ImgFieldBaseDTO)dto).setQueryUiType(imgField.getQueryUiType());
            ((ImgFieldBaseDTO)dto).setQueryUiParams(imgField.getQueryUiParams());
            ((ImgFieldBaseDTO)dto).setType(imgField.getType());
            ((ImgFieldBaseDTO)dto).setImageDatasetTypes(new ArrayList<Integer>());
            if (ConstantsValue.TRUE_VALUE.equals(imgField.getIsSysField())) {
                for (ImageDatasetTypeEnum imageDatasetTypeEnum : ImageDatasetTypeEnum.values()) {
                    ((ImgFieldBaseDTO)dto).getImageDatasetTypes().add(imageDatasetTypeEnum.getValue());
                }
            } else if (imgField.getName().equalsIgnoreCase("f_classification") || imgField.getName().equalsIgnoreCase("f_time")) {
                ((ImgFieldBaseDTO)dto).getImageDatasetTypes().add(ImageDatasetTypeEnum.ProcessedImageDataset.getValue());
            } else if (imgField.getName().equalsIgnoreCase("f_satellite") || imgField.getName().equalsIgnoreCase("f_cloud") || imgField.getName().equalsIgnoreCase("f_product_time")) {
                ((ImgFieldBaseDTO)dto).getImageDatasetTypes().add(ImageDatasetTypeEnum.OriginalImageDataset.getValue());
            } else if (imgField.getName().equalsIgnoreCase("f_resolution") || imgField.getName().equalsIgnoreCase("f_sensor")) {
                ((ImgFieldBaseDTO)dto).getImageDatasetTypes().add(ImageDatasetTypeEnum.ProcessedImageDataset.getValue());
                ((ImgFieldBaseDTO)dto).getImageDatasetTypes().add(ImageDatasetTypeEnum.OriginalImageDataset.getValue());
            }
        }
        dto.setId(imgField.getId());
        dto.setName(imgField.getName());
        dto.setAliasName(imgField.getAliasName());
        dto.setPid(imgField.getPid());
        dto.setOrder(imgField.getOrder());
        dto.setDesc(imgField.getDesc());
        dto.setIsGroup(isGroup);
        dto.setIsSysField(ConstantsValue.TRUE_VALUE.equals(imgField.getIsSysField()));
        dto.setInUse(imgField.getUseCount() != null && imgField.getUseCount() > 0);
        return dto;
    }

    private ImgField convertImgFieldDTO(ImgFieldBaseDTO dto) {
        ImgField imgField = new ImgField();
        imgField.setName(dto.getName());
        imgField.setAliasName(dto.getAliasName());
        imgField.setDesc(dto.getDesc());
        imgField.setIsGroup(Boolean.TRUE.equals(dto.getIsGroup()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        imgField.setIsSysField(Boolean.TRUE.equals(dto.getIsSysField()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        if (imgField.getIsGroup().equals(ConstantsValue.FALSE_VALUE)) {
            imgField.setFieldType(dto.getFieldType());
            imgField.setLength(dto.getLength());
            imgField.setDefaultValue(dto.getDefaultValue());
            imgField.setNullable(Boolean.TRUE.equals(dto.getNullable()) ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
            imgField.setDomainId(dto.getDomainId());
            imgField.setQueryUiType(dto.getQueryUiType());
            imgField.setQueryUiParams(dto.getQueryUiParams());
        }
        return imgField;
    }

    private void addAllFields(JSONArray jsonArray, String pid) {
        if (jsonArray == null || jsonArray.size() == 0) {
            return;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            ImgFieldBaseDTO dto = (ImgFieldBaseDTO)jsonArray.getObject(i, ImgFieldBaseDTO.class);
            if (Boolean.TRUE.equals(dto.getIsGroup())) {
                ImgGroupDTO group = new ImgGroupDTO();
                group.setName(dto.getName());
                group.setDesc(dto.getDesc());
                group.setPid(pid);
                String id = this.addOrUpdateGroup(group);
                JSONArray children = jsonArray.getJSONObject(i).getJSONArray("children");
                this.addAllFields(children, id);
                continue;
            }
            dto.setPid(pid);
            this.addField(dto);
        }
    }

    private List<String> getSubFieldIdList(Map<String, List<ImgField>> pidGroup, String id) {
        List<ImgField> children = pidGroup.get(id);
        ArrayList<String> result = new ArrayList<String>();
        if (children == null || children.size() == 0) {
            return result;
        }
        children.forEach(child -> {
            result.add(child.getId());
            result.addAll(this.getSubFieldIdList(pidGroup, child.getId()));
        });
        return result;
    }

    private List<String> getSubFieldNameList(Map<String, List<ImgField>> pidGroup, String id) {
        List<ImgField> children = pidGroup.get(id);
        ArrayList<String> result = new ArrayList<String>();
        if (children == null || children.size() == 0) {
            return result;
        }
        children.forEach(child -> {
            result.add(child.getName());
            result.addAll(this.getSubFieldIdList(pidGroup, child.getId()));
        });
        return result;
    }
}

