/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.listener;

import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.imagedb.dataset.event.ImgDatumTypeBeforeDeleteEvent;
import com.geoway.imagedb.dataset.service.ImageDatabaseService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ImgDatumTypeBeforeDeleteEventListener
implements ApplicationListener<ImgDatumTypeBeforeDeleteEvent> {
    private static final Logger log = LoggerFactory.getLogger(ImgDatumTypeBeforeDeleteEventListener.class);
    @Resource
    private ImageDatabaseService imageDatabaseService;

    public void onApplicationEvent(ImgDatumTypeBeforeDeleteEvent event) {
        List<String> datasetNames = this.imageDatabaseService.getDatasetByDatumTypeModel(event.getDatumTypeModelId());
        if (datasetNames.size() > 0) {
            String names = String.join((CharSequence)",", ListUtil.convertAll(datasetNames, f -> "[" + f + "]"));
            throw new RuntimeException("\u5f71\u50cf\u7c7b\u578b\u6a21\u578b\u5df2\u88ab\u6570\u636e\u96c6" + names + "\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
    }
}

