/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.listener;

import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.config.filemodel.event.FileModelBeforeDeleteEvent;
import com.geoway.imagedb.dataset.dto.ImgDatumTypeDTO;
import com.geoway.imagedb.dataset.service.ImgDatumTypeService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class FileModelBeforeDeleteEventListener
implements ApplicationListener<FileModelBeforeDeleteEvent> {
    private static final Logger log = LoggerFactory.getLogger(FileModelBeforeDeleteEventListener.class);
    @Resource
    private ImgDatumTypeService imgDatumTypeService;

    public void onApplicationEvent(FileModelBeforeDeleteEvent event) {
        List<ImgDatumTypeDTO> datumTypes = this.imgDatumTypeService.getDatumTypeByFileModelId(event.getModelId());
        if (datumTypes != null && datumTypes.size() > 0) {
            String names = String.join((CharSequence)",", ListUtil.convertAll(datumTypes, f -> "[" + f.getName() + "]"));
            throw new RuntimeException("\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u5df2\u88ab\u5f71\u50cf\u7c7b\u578b\u6a21\u578b" + names + "\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
    }
}

