/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.service.impl;

import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.filepackage.model.FileModelDTO;
import com.geoway.adf.dms.config.properties.DefaultCoordSchemeProperties;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatumDatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.DatasetPageList;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.create.FeatureClassCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.FeatureClassEditDTO;
import com.geoway.adf.dms.datasource.dto.create.FieldsEditDTO;
import com.geoway.adf.dms.datasource.dto.create.MosaicDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.MosaicDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumFieldsEditDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DatumDatabaseService;
import com.geoway.adf.dms.datasource.service.FeatureClassService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.MosaicDatasetService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dto.ImageDatasetCreateDTO;
import com.geoway.imagedb.dataset.dto.ImgDatumTypeDTO;
import com.geoway.imagedb.dataset.dto.ImgDatumTypeFieldDTO;
import com.geoway.imagedb.dataset.dto.ImgTreeBaseDTO;
import com.geoway.imagedb.dataset.dto.SnapshotPathRepairDTO;
import com.geoway.imagedb.dataset.dto.edit.ImgDatumTypeFieldEditDTO;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.service.ImageDatabaseService;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.service.ImgDatumTypeService;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ImageDatabaseServiceImpl
implements ImageDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(ImageDatabaseServiceImpl.class);
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    private DatumDatabaseService datumDatabaseService;
    @Resource
    private ImgDatumTypeService imgDatumTypeService;
    @Resource
    private MosaicDatasetService mosaicDatasetService;
    @Resource
    private FeatureClassService featureClassService;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private DefaultCoordSchemeProperties defaultCoordSchemeProperties;

    @Override
    public DatasetPageList<SimpleDatasetDTO> listImageDataset(String dsKey, List<ImageDatasetTypeEnum> datumTypes, String keyword, Integer pageIndex, Integer rows) {
        List datasets = this.datumDatabaseService.listDatasets((DataSourceDTO)this.datumDatabaseService.getDatumDatabaseDetail(dsKey));
        if (datumTypes != null && datumTypes.size() > 0) {
            datasets = ListUtil.findAll((List)datasets, dsDatum -> datumTypes.contains((Object)ImageDatasetTypeEnum.getByValue(dsDatum.getDatumType())));
        }
        if (StringUtil.isNotEmpty((String)keyword)) {
            datasets = ListUtil.findAll((List)datasets, dsDatum -> dsDatum.getName().toLowerCase(Locale.ROOT).contains(keyword.toLowerCase(Locale.ROOT)) || dsDatum.getAliasName().toLowerCase(Locale.ROOT).contains(keyword.toLowerCase(Locale.ROOT)));
        }
        HashMap<Integer, Integer> typeCount = new HashMap<Integer, Integer>();
        typeCount.put(DatumDatasetTypeEnum.DatumDataset.getValue(), 0);
        typeCount.put(DatumDatasetTypeEnum.GeoDatumDataset.getValue(), 0);
        typeCount.put(DatumDatasetTypeEnum.GeoMosaicDatumDataset.getValue(), 0);
        for (SimpleDatasetDTO simpleDatasetDTO : datasets) {
            int type = simpleDatasetDTO.getDatumType();
            if (simpleDatasetDTO.getDatumType().intValue() == ImageDatasetTypeEnum.OriginalImageDataset.getValue()) {
                DatasetNameInfo name;
                ImgDataset imgDataset = this.imageDatasetService.getImgDataset(simpleDatasetDTO.getId());
                type = imgDataset != null ? ((name = new DatasetNameInfo(imgDataset.getGeoDatasetId())).getType().intValue() == DatasetTypeEnum.MosaicDataset.getValue() ? DatumDatasetTypeEnum.GeoMosaicDatumDataset.getValue() : DatumDatasetTypeEnum.GeoDatumDataset.getValue()) : DatumDatasetTypeEnum.GeoDatumDataset.getValue();
            } else if (simpleDatasetDTO.getDatumType().intValue() == ImageDatasetTypeEnum.ProcessedImageDataset.getValue()) {
                type = DatumDatasetTypeEnum.GeoMosaicDatumDataset.getValue();
            } else if (simpleDatasetDTO.getDatumType().intValue() == ImageDatasetTypeEnum.ImageSampleImageDataset.getValue()) {
                type = DatumDatasetTypeEnum.GeoDatumDataset.getValue();
            } else if (simpleDatasetDTO.getDatumType().intValue() == ImageDatasetTypeEnum.TileSampleImageDataset.getValue()) {
                type = DatumDatasetTypeEnum.GeoDatumDataset.getValue();
            }
            typeCount.put(type, typeCount.get(type) == null ? 1 : (Integer)typeCount.get(type) + 1);
        }
        DatasetPageList datasetPageList = new DatasetPageList(datasets, pageIndex, rows);
        datasetPageList.setTypeCounts(typeCount);
        return datasetPageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createImageDataset(ImageDatasetCreateDTO createDTO) {
        this.createBusinessSnapshotDataset();
        ImgDatumTypeDTO datumType = (ImgDatumTypeDTO)this.imgDatumTypeService.getDetail(createDTO.getDatumTypeModelId());
        Assert.notNull((Object)datumType, (String)"\u5f71\u50cf\u7c7b\u578b\u6a21\u578b\u4e0d\u5b58\u5728\uff01");
        ImageDatasetTypeEnum imageDatasetTypeEnum = ImageDatasetTypeEnum.getByValue(datumType.getImageType());
        Assert.notNull((Object)((Object)imageDatasetTypeEnum), (String)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u6570\u636e\u96c6\u7c7b\u578b\uff01");
        DatumDatasetCreateDTO datumDatasetCreateDTO = new DatumDatasetCreateDTO();
        datumDatasetCreateDTO.setDsKey(createDTO.getDsKey());
        datumDatasetCreateDTO.setName(createDTO.getName());
        datumDatasetCreateDTO.setAliasName(createDTO.getAliasName());
        datumDatasetCreateDTO.setFileModelIds(ListUtil.convertAll(datumType.getFileModels(), FileModelDTO::getModelId));
        datumDatasetCreateDTO.setDataPhase(createDTO.getDataPhase());
        switch (imageDatasetTypeEnum) {
            case OriginalImageDataset: {
                datumDatasetCreateDTO.setDatumDatasetType(Integer.valueOf(DatumDatasetTypeEnum.GeoMosaicDatumDataset.getValue()));
                break;
            }
            case ProcessedImageDataset: {
                datumDatasetCreateDTO.setDatumDatasetType(Integer.valueOf(DatumDatasetTypeEnum.GeoMosaicDatumDataset.getValue()));
                break;
            }
            case ImageSampleImageDataset: 
            case TileSampleImageDataset: {
                datumDatasetCreateDTO.setDatumDatasetType(Integer.valueOf(DatumDatasetTypeEnum.GeoDatumDataset.getValue()));
                datumDatasetCreateDTO.setFeatureType(datumType.getFeatureType());
                break;
            }
        }
        datumDatasetCreateDTO.setSrid(createDTO.getSrid());
        datumDatasetCreateDTO.setFields(ListUtil.convertAll(datumType.getFields(), f -> this.imageDatasetService.convertDatumFieldDTO((ImgDatumTypeFieldDTO)((Object)f))));
        String datumDatasetId = this.datumDatabaseService.createDatumDataset(datumDatasetCreateDTO);
        String geoDatasetId = this.datumDatabaseService.getGeoDatasetId(datumDatasetId);
        ImgDataset imgDataset = new ImgDataset();
        imgDataset.setGeoDatasetId(geoDatasetId);
        imgDataset.setDatumTypeModelId(createDTO.getDatumTypeModelId());
        imgDataset.setDatasetId(datumDatasetId);
        imgDataset.setImageDatasetType(imageDatasetTypeEnum.getValue());
        this.imageDatasetService.addImageDataset(imgDataset);
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)geoDatasetId);
        DataSourceDTO targetDatabase = this.dataSourceManager.getGeoDatabaseDetail(nameInfo.getDsKey());
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);){
            IGeoDataset geoDataset = workspace.openGeoDataset(nameInfo.getName());
            ITable table = null;
            if (geoDataset instanceof IMosaicDataset) {
                table = (ITable)((IMosaicDataset)geoDataset).getCatalog();
            } else if (geoDataset instanceof ITable) {
                table = (ITable)geoDataset;
            }
            int flagFieldIndex = table.getFields().findFieldIndex("f_flag");
            if (flagFieldIndex >= 0) {
                ImgDatumTypeFieldEditDTO editDTO = new ImgDatumTypeFieldEditDTO();
                ArrayList<String> deleteNames = new ArrayList<String>();
                deleteNames.add("f_flag");
                editDTO.setDeleteFieldNames(deleteNames);
                this.updateImageDatasetField(editDTO);
            }
            table.addField((IField)new Field("f_flag", "\u6807\u5fd7", FieldType.Int, 32, 0, false, (Object)0));
            this.createGeoDatasetIndex(table, "f_flag");
        }
        if (datumType.getSubDatumTypes() != null) {
            String geoDsKey = DatasetUtil.getDatasetNameInfo((String)imgDataset.getGeoDatasetId()).getDsKey();
            HashMap<String, String> subDatasetIds = new HashMap<String, String>();
            for (ImgDatumTypeDTO subDatumType : datumType.getSubDatumTypes()) {
                String subsetId;
                List fields;
                MosaicDatasetCreateDTO subDatasetCreateDTO;
                if (subDatumType.getImageType().intValue() == ImageDatasetTypeEnum.ProcessedImageDataset.getValue()) {
                    subDatasetCreateDTO = new MosaicDatasetCreateDTO();
                    subDatasetCreateDTO.setName(createDTO.getName() + "_" + subDatumType.getName());
                    subDatasetCreateDTO.setAliasName(subDatasetCreateDTO.getName());
                    subDatasetCreateDTO.setDsKey(geoDsKey);
                    subDatasetCreateDTO.setSrid(createDTO.getSrid());
                    subDatasetCreateDTO.setPixelDataType(Integer.valueOf(0));
                    subDatasetCreateDTO.setInvalidValue(Double.valueOf(0.0));
                    subDatasetCreateDTO.setBandCount(Integer.valueOf(-1));
                    fields = ListUtil.convertAll(subDatumType.getFields(), f -> this.imageDatasetService.convertDatumFieldDTO((ImgDatumTypeFieldDTO)((Object)f)));
                    subDatasetCreateDTO.setFields(fields);
                    subsetId = this.mosaicDatasetService.createMosaicDataset(subDatasetCreateDTO);
                    subDatasetIds.put(subDatumType.getName(), subsetId);
                    continue;
                }
                subDatasetCreateDTO = new FeatureClassCreateDTO();
                subDatasetCreateDTO.setName(createDTO.getName() + "_" + subDatumType.getName());
                subDatasetCreateDTO.setAliasName(subDatasetCreateDTO.getName());
                subDatasetCreateDTO.setDsKey(geoDsKey);
                subDatasetCreateDTO.setFeatureType(subDatumType.getFeatureType());
                subDatasetCreateDTO.setSrid(createDTO.getSrid());
                fields = ListUtil.convertAll(subDatumType.getFields(), f -> this.imageDatasetService.convertDatumFieldDTO((ImgDatumTypeFieldDTO)((Object)f)));
                subDatasetCreateDTO.setFields(fields);
                subsetId = this.featureClassService.createFeatureClass((FeatureClassCreateDTO)subDatasetCreateDTO);
                subDatasetIds.put(subDatumType.getName(), subsetId);
            }
            imgDataset.setSubDatasetIds(subDatasetIds);
            this.imageDatasetService.updateImageDataset(imgDataset);
        }
        return datumDatasetId;
    }

    @Override
    public List<String> getDatasetByDatumTypeModel(String datumTypeModelId) {
        List<ImgDataset> list = this.imageDatasetService.getImageDatasetByDatumTypeModelId(datumTypeModelId);
        List<String> names = new ArrayList<String>();
        if (list != null && list.size() > 0) {
            names = ListUtil.convertAll(list, f -> {
                String geoDatasetId = f.getGeoDatasetId();
                DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)geoDatasetId);
                return nameInfo.getShortName();
            });
        }
        return names;
    }

    @Override
    public void updateImageDatasetField(ImgDatumTypeFieldEditDTO fieldEditDTO) {
        ImgTreeBaseDTO datumType = this.imgDatumTypeService.getDetail(fieldEditDTO.getId());
        if (!(datumType instanceof ImgDatumTypeDTO)) {
            return;
        }
        ImgTreeBaseDTO parentDatumType = this.imgDatumTypeService.getDetail(datumType.getPid());
        if (parentDatumType == null || parentDatumType.getIsGroup().booleanValue()) {
            List<ImgDataset> list = this.imageDatasetService.getImageDatasetByDatumTypeModelId(fieldEditDTO.getId());
            if (list != null && list.size() > 0) {
                list.forEach(item -> {
                    DatumDatasetEditDTO editDTO = new DatumDatasetEditDTO();
                    editDTO.setId(item.getDatasetId());
                    DatumDatasetDTO datasetDTO = this.datumDatabaseService.getDatasetDetail(item.getDatasetId());
                    editDTO.setAliasName(datasetDTO.getAliasName());
                    editDTO.setFileModelIds(ListUtil.convertAll((List)datasetDTO.getFileModels(), FileModelDTO::getModelId));
                    editDTO.setDataPhase(datasetDTO.getDataPhase());
                    DatumFieldsEditDTO datumFieldsEditDTO = new DatumFieldsEditDTO();
                    if (fieldEditDTO.getAddFields() != null && fieldEditDTO.getAddFields().size() > 0) {
                        datumFieldsEditDTO.setAddFields(ListUtil.convertAll(fieldEditDTO.getAddFields(), f -> this.imageDatasetService.convertDatumFieldDTO((ImgDatumTypeFieldDTO)((Object)((Object)f)))));
                    } else {
                        datumFieldsEditDTO.setAddFields(new ArrayList());
                    }
                    if (fieldEditDTO.getUpdateFields() != null && fieldEditDTO.getUpdateFields().size() > 0) {
                        datumFieldsEditDTO.setUpdateFields(ListUtil.convertAll(fieldEditDTO.getUpdateFields(), f -> this.imageDatasetService.convertDatumFieldDTO((ImgDatumTypeFieldDTO)((Object)((Object)f)))));
                    } else {
                        datumFieldsEditDTO.setUpdateFields(new ArrayList());
                    }
                    if (fieldEditDTO.getDeleteFieldNames() != null && fieldEditDTO.getDeleteFieldNames().size() > 0) {
                        datumFieldsEditDTO.setDeleteFields(fieldEditDTO.getDeleteFieldNames());
                    } else {
                        datumFieldsEditDTO.setDeleteFields(new ArrayList());
                    }
                    editDTO.setFields(datumFieldsEditDTO);
                    this.datumDatabaseService.updateDatumDataset(editDTO);
                });
            }
        } else {
            List<ImgDataset> list = this.imageDatasetService.getImageDatasetByDatumTypeModelId(parentDatumType.getId());
            if (list != null && list.size() > 0) {
                list.forEach(item -> {
                    if (item.getSubDatasetIds() != null) {
                        FieldsEditDTO updateFields = new FieldsEditDTO();
                        if (fieldEditDTO.getAddFields() != null && fieldEditDTO.getAddFields().size() > 0) {
                            updateFields.setAddFields(ListUtil.convertAll(fieldEditDTO.getAddFields(), f -> this.imageDatasetService.convertDatumFieldDTO((ImgDatumTypeFieldDTO)((Object)((Object)f)))));
                        } else {
                            updateFields.setAddFields(new ArrayList());
                        }
                        if (fieldEditDTO.getUpdateFields() != null && fieldEditDTO.getUpdateFields().size() > 0) {
                            updateFields.setUpdateFields(ListUtil.convertAll(fieldEditDTO.getUpdateFields(), f -> this.imageDatasetService.convertDatumFieldDTO((ImgDatumTypeFieldDTO)((Object)((Object)f)))));
                        } else {
                            updateFields.setUpdateFields(new ArrayList());
                        }
                        if (fieldEditDTO.getDeleteFieldNames() != null && fieldEditDTO.getDeleteFieldNames().size() > 0) {
                            updateFields.setDeleteFields(fieldEditDTO.getDeleteFieldNames());
                        } else {
                            updateFields.setDeleteFields(new ArrayList());
                        }
                        for (String subDatasetId : item.getSubDatasetIds().values()) {
                            MosaicDatasetEditDTO subDatasetCreateDTO;
                            DatasetDTO datasetDTO = this.geoDatabaseService.getDatasetDetail(subDatasetId);
                            if (datasetDTO.getType().intValue() == DatasetTypeEnum.MosaicDataset.getValue()) {
                                subDatasetCreateDTO = new MosaicDatasetEditDTO();
                                subDatasetCreateDTO.setId(datasetDTO.getId());
                                subDatasetCreateDTO.setAliasName(datasetDTO.getAliasName());
                                subDatasetCreateDTO.setDataPhase(datasetDTO.getDataPhase());
                                subDatasetCreateDTO.setFields(updateFields);
                                this.mosaicDatasetService.updateMosaicDataset(subDatasetCreateDTO);
                                continue;
                            }
                            subDatasetCreateDTO = new FeatureClassEditDTO();
                            subDatasetCreateDTO.setId(datasetDTO.getId());
                            subDatasetCreateDTO.setAliasName(datasetDTO.getAliasName());
                            subDatasetCreateDTO.setDataPhase(datasetDTO.getDataPhase());
                            subDatasetCreateDTO.setFields(updateFields);
                            this.featureClassService.updateFeatureClass((FeatureClassEditDTO)subDatasetCreateDTO);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void updateImageDatasetFileModel(String datumTypeModelId, List<String> fileModelIds) {
        List<ImgDataset> list = this.imageDatasetService.getImageDatasetByDatumTypeModelId(datumTypeModelId);
        if (list != null && list.size() > 0) {
            list.forEach(item -> {
                DatumDatasetEditDTO editDTO = new DatumDatasetEditDTO();
                editDTO.setId(item.getDatasetId());
                DatumDatasetDTO datasetDTO = this.datumDatabaseService.getDatasetDetail(item.getDatasetId());
                editDTO.setAliasName(datasetDTO.getAliasName());
                editDTO.setFileModelIds(ListUtil.convertAll((List)fileModelIds, Long::parseLong));
                editDTO.setDataPhase(datasetDTO.getDataPhase());
                this.datumDatabaseService.updateDatumDataset(editDTO);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSnapshotPathList(String datasetId) {
        QueryFilter filter = new QueryFilter();
        filter.setWhereClause(String.format("%s = '%s'", "f_image_dataset_id", datasetId));
        ArrayList<String> snapshotPathList = new ArrayList<String>();
        DataSourceDTO dataSourceDTO = this.imageDatasetService.getBusinessSnapshotDataSource();
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u6253\u5f00\u5931\u8d25");
        IMosaicDataset mosaicDataset = workspace.openMosaicDataset(this.imageDatasetService.getBusinessSnapshotDatasetName());
        IFeatureClass catFc = mosaicDataset.getCatalog();
        IFeatureCursor cursor = null;
        try {
            cursor = catFc.searchFeature((IQueryFilter)filter);
            IFeature feature = null;
            while ((feature = cursor.nextFeature()) != null) {
                String filePath = feature.getValue("urihash").toString();
                File file = new File(filePath);
                String dir = file.getParentFile().getParent();
                if (snapshotPathList.contains(dir)) continue;
                snapshotPathList.add(dir);
            }
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
        return snapshotPathList;
    }

    @Override
    public void repairSnapshotPath(List<SnapshotPathRepairDTO> snapshotPathList) {
        Map<String, List<SnapshotPathRepairDTO>> datasetGroup = snapshotPathList.stream().collect(Collectors.groupingBy(SnapshotPathRepairDTO::getDatasetId));
        for (String datasetId : datasetGroup.keySet()) {
            ImgDataset imgDataset = this.imageDatasetService.getImgDataset(datasetId);
            if (imgDataset.getImageDatasetType().intValue() == ImageDatasetTypeEnum.OriginalImageDataset.getValue()) {
                String geoDatasetId;
                String snapshotDatasetId = geoDatasetId = imgDataset.getGeoDatasetId();
                DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)geoDatasetId);
                if (nameInfo.getType().intValue() == DatasetTypeEnum.FeatureClass.getValue()) {
                    snapshotDatasetId = this.imageDatasetService.getSnapshotDatasetId(datasetId);
                }
                this.repairSnapshotPathByDatasetId(snapshotDatasetId, datasetGroup.get(datasetId), null);
            }
            QueryFilter filter = new QueryFilter();
            filter.setWhereClause(String.format("%s = '%s'", "f_image_dataset_id", datasetId));
            this.repairSnapshotPathByDatasetId(this.imageDatasetService.getBusinessSnapshotDatasetId(), datasetGroup.get(datasetId), (IQueryFilter)filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairSnapshotPathByDatasetId(String datasetId, List<SnapshotPathRepairDTO> snapshotPathList, IQueryFilter filter) {
        DatasetNameInfo snapshotNameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(snapshotNameInfo.getDsKey());
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u6253\u5f00\u5931\u8d25");
        IMosaicDataset mosaicDataset = workspace.openMosaicDataset(snapshotNameInfo.getName());
        IFeatureClass catFc = mosaicDataset.getCatalog();
        IFeatureCursor updateCursor = null;
        try {
            updateCursor = catFc.updateFeature(filter);
            IFeature feature = null;
            block3: while ((feature = updateCursor.nextFeature()) != null) {
                String filePath = feature.getValue("urihash").toString();
                File file = new File(filePath);
                String uuidDir = file.getParentFile().getName();
                String dir = file.getParentFile().getParent();
                for (SnapshotPathRepairDTO item : snapshotPathList) {
                    if (StringUtil.isEmptyOrWhiteSpace((String)item.getNewSnapshotPath()) || !dir.equals(item.getOldSnapshotPath())) continue;
                    feature.setValue("urihash", (Object)Paths.get(item.getNewSnapshotPath(), uuidDir, file.getName()));
                    updateCursor.updateFeature(feature);
                    continue block3;
                }
            }
        }
        finally {
            if (updateCursor != null) {
                updateCursor.release();
            }
            workspace.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBusinessSnapshotDataset() {
        DataSourceDTO targetDatabase = this.imageDatasetService.getBusinessSnapshotDataSource();
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);){
            IFeatureClass sampleFc;
            int srid;
            if (!workspace.datasetExist(this.imageDatasetService.getBusinessSnapshotDatasetName())) {
                MosaicDatasetCreateDTO mosaicDatasetCreateDTO = new MosaicDatasetCreateDTO();
                String datasetName = this.imageDatasetService.getBusinessSnapshotDatasetName();
                mosaicDatasetCreateDTO.setName(datasetName);
                mosaicDatasetCreateDTO.setAliasName("\u5feb\u89c6\u56fe");
                mosaicDatasetCreateDTO.setDsKey(targetDatabase.getKey());
                mosaicDatasetCreateDTO.setSrid(Integer.valueOf(this.defaultCoordSchemeProperties.getSrid() == null ? 4490 : this.defaultCoordSchemeProperties.getSrid()));
                mosaicDatasetCreateDTO.setPixelDataType(Integer.valueOf(0));
                mosaicDatasetCreateDTO.setInvalidValue(Double.valueOf(0.0));
                mosaicDatasetCreateDTO.setBandCount(Integer.valueOf(-1));
                mosaicDatasetCreateDTO.setSchemaName("public");
                String snapshotDatasetId = this.mosaicDatasetService.createMosaicDataset(mosaicDatasetCreateDTO);
                MosaicDatasetEditDTO editDTO = new MosaicDatasetEditDTO();
                editDTO.setId(snapshotDatasetId);
                editDTO.setAliasName("\u5feb\u89c6\u56fe");
                editDTO.setInvalidValue(Double.valueOf(0.0));
                FieldsEditDTO fieldsEditDTO = new FieldsEditDTO();
                fieldsEditDTO.setAddFields(this.getBusinessSnapshotDatasetFields());
                editDTO.setFields(fieldsEditDTO);
                this.mosaicDatasetService.updateMosaicDataset(editDTO);
            }
            int n = srid = this.defaultCoordSchemeProperties.getSrid() == null ? 4490 : this.defaultCoordSchemeProperties.getSrid();
            if (srid != 4490 && (sampleFc = workspace.openFeatureClass("tb_sample_data")).getSpatialReferenceSystem() != null && sampleFc.getSpatialReferenceSystem().getSrid() != srid) {
                workspace.queryOne(String.format("select UpdateGeometrySRID('%s', 'shape', %d);", "tb_sample_data", srid), new Object[0]);
            }
        }
    }

    private List<FieldDTO> getBusinessSnapshotDatasetFields() {
        ArrayList<FieldDTO> addFields = new ArrayList<FieldDTO>();
        FieldDTO dataIdFld = new FieldDTO();
        dataIdFld.setName("F_DATAID");
        dataIdFld.setAliasName("\u6570\u636eID");
        dataIdFld.setFieldType(Integer.valueOf(FieldType.Long.getValue()));
        addFields.add(dataIdFld);
        FieldDTO dataSizeFld = new FieldDTO();
        dataSizeFld.setName("F_DATASIZE");
        dataSizeFld.setAliasName("\u6570\u636e\u5927\u5c0f");
        dataSizeFld.setFieldType(Integer.valueOf(FieldType.Long.getValue()));
        addFields.add(dataSizeFld);
        FieldDTO dataNameFld = new FieldDTO();
        dataNameFld.setName("F_DATANAME");
        dataNameFld.setAliasName("\u6570\u636e\u540d\u79f0");
        dataNameFld.setFieldType(Integer.valueOf(FieldType.String.getValue()));
        dataNameFld.setLength(Integer.valueOf(500));
        addFields.add(dataNameFld);
        FieldDTO importTimeFld = new FieldDTO();
        importTimeFld.setName("f_import_time");
        importTimeFld.setAliasName("\u5165\u5e93\u65f6\u95f4");
        importTimeFld.setFieldType(Integer.valueOf(FieldType.DateTime.getValue()));
        addFields.add(importTimeFld);
        FieldDTO importUserFld = new FieldDTO();
        importUserFld.setName("f_import_user");
        importUserFld.setAliasName("\u5165\u5e93\u4eba");
        importUserFld.setFieldType(Integer.valueOf(FieldType.String.getValue()));
        importUserFld.setLength(Integer.valueOf(200));
        addFields.add(importUserFld);
        FieldDTO satelliteFld = new FieldDTO();
        satelliteFld.setName("f_satellite");
        satelliteFld.setAliasName("\u536b\u661f\u540d\u79f0");
        satelliteFld.setFieldType(Integer.valueOf(FieldType.String.getValue()));
        satelliteFld.setLength(Integer.valueOf(200));
        addFields.add(satelliteFld);
        FieldDTO sensorFld = new FieldDTO();
        sensorFld.setName("f_sensor");
        sensorFld.setAliasName("\u4f20\u611f\u5668");
        sensorFld.setFieldType(Integer.valueOf(FieldType.String.getValue()));
        sensorFld.setLength(Integer.valueOf(200));
        addFields.add(sensorFld);
        FieldDTO productTimeFld = new FieldDTO();
        productTimeFld.setName("f_product_time");
        productTimeFld.setAliasName("\u5f71\u50cf\u91c7\u96c6\u65f6\u95f4");
        productTimeFld.setFieldType(Integer.valueOf(FieldType.DateTime.getValue()));
        addFields.add(productTimeFld);
        FieldDTO cloudFld = new FieldDTO();
        cloudFld.setName("f_cloud");
        cloudFld.setAliasName("\u4e91\u91cf");
        cloudFld.setFieldType(Integer.valueOf(FieldType.Double.getValue()));
        addFields.add(cloudFld);
        FieldDTO resolutionFld = new FieldDTO();
        resolutionFld.setName("f_resolution");
        resolutionFld.setAliasName("\u5206\u8fa8\u7387");
        resolutionFld.setFieldType(Integer.valueOf(FieldType.Double.getValue()));
        addFields.add(resolutionFld);
        FieldDTO imageTypeFld = new FieldDTO();
        imageTypeFld.setName("f_image_type");
        imageTypeFld.setAliasName("\u5f71\u50cf\u7c7b\u578b");
        imageTypeFld.setFieldType(Integer.valueOf(FieldType.Int.getValue()));
        addFields.add(imageTypeFld);
        FieldDTO imageDatasetIdFld = new FieldDTO();
        imageDatasetIdFld.setName("f_image_dataset_id");
        imageDatasetIdFld.setAliasName("\u5f71\u50cf\u6570\u636e\u96c6\u6807\u8bc6");
        imageDatasetIdFld.setFieldType(Integer.valueOf(FieldType.String.getValue()));
        imageDatasetIdFld.setLength(Integer.valueOf(200));
        addFields.add(imageDatasetIdFld);
        return addFields;
    }

    private boolean createGeoDatasetIndex(ITable targetTale, String fieldName) {
        try {
            Map frameIndexResult = targetTale.getWorkspace().queryOne(String.format("select * from pg_indexes where indexname = '%s_%s_idx'", targetTale.getName().toLowerCase(), fieldName.toLowerCase()), new Object[0]);
            if (frameIndexResult == null || frameIndexResult.size() == 0) {
                String frameSql = String.format("create index %s_%s_idx on %s(%s)", targetTale.getName(), fieldName, targetTale.getName(), fieldName);
                targetTale.getWorkspace().excuteSql(frameSql);
            }
            return true;
        }
        catch (Exception e) {
            log.error(targetTale.getName() + "." + fieldName + " \u7d22\u5f15\u521b\u5efa\u5931\u8d25", (Throwable)e);
            return false;
        }
    }
}

