/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.util;

import java.util.Locale;

public class ImageDataMatchUtil {
    public static final String[] ZY_SATELLITE = new String[]{"ZY3-1", "ZY3-2", "ZY3-3", "ZY3-01", "ZY3-02", "ZY3-03"};
    public static final String[] GF7_SATELLITE = new String[]{"GF7", "GF-7", "GF7-1"};

    public static String getDataNamePrefix(String dataName, String satellite) {
        for (String s : ZY_SATELLITE) {
            if (!satellite.equalsIgnoreCase(s)) continue;
            return ImageDataMatchUtil.getZYDataNamePrefix(dataName);
        }
        for (String s : GF7_SATELLITE) {
            if (!satellite.equalsIgnoreCase(s)) continue;
            return ImageDataMatchUtil.getGF7DataNamePrefix(dataName);
        }
        return dataName;
    }

    private static String getZYDataNamePrefix(String dataName) {
        String[] array = dataName.split("_");
        String sensor = array[1];
        if ("mux".equalsIgnoreCase(sensor)) {
            sensor = "nad";
        } else if ("nad".equalsIgnoreCase(sensor)) {
            sensor = "mux";
        }
        String dataNamePrefix = array[0] + "_" + sensor + "_" + array[2] + "_" + array[3] + "_" + array[4];
        return dataNamePrefix.toLowerCase(Locale.ROOT);
    }

    private static String getGF7DataNamePrefix(String dataName) {
        String[] array = dataName.split("_");
        String sensor = array[5];
        if ("MUX".equalsIgnoreCase(sensor)) {
            sensor = "BWD";
        } else if ("BWD".equalsIgnoreCase(sensor)) {
            sensor = "MUX";
        }
        String dataNamePrefix = array[0] + "_" + array[1] + "_" + array[2] + "_" + array[3] + "_" + array[4] + "_" + sensor;
        return dataNamePrefix.toLowerCase(Locale.ROOT);
    }
}

