/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.util;

import com.geoway.imagedb.dataset.dto.hanlp.TimeRange;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeNormalizerUtil {
    private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("(\\d{4})\u5e74(\\d{1,2})\u6708(\\d{1,2})\u65e5"), Pattern.compile("(\\d{4})\u5e74(\\d{1,2})\u6708"), Pattern.compile("(\\d{4})\u5e74(\u7b2c[\u4e00\u4e8c\u4e09\u56db1-4])\u5b63\u5ea6"), Pattern.compile("(\\d{1,2})\u6708(\\d{1,2})\u65e5"), Pattern.compile("(\\d{4})\u5e74"), Pattern.compile("(\\d{1,2})\u6708"), Pattern.compile("(\u7b2c[\u4e00\u4e8c\u4e09\u56db1-4])\u5b63\u5ea6"), Pattern.compile("\u8fd1(\\d+)\u5929"), Pattern.compile("\u8fd1(\\d+)\u4e2a?\u661f\u671f"), Pattern.compile("\u8fd1(\\d+)\u4e2a?\u5468"), Pattern.compile("\u8fd1(\\d+)\u4e2a?\u6708"), Pattern.compile("\u8fd1(\\d+)\u5e74"), Pattern.compile("\u8fd1\u4e00\u5468"), Pattern.compile("\u4e0a\u5468"), Pattern.compile("\u4e0a\u4e2a\u6708"), Pattern.compile("\u6628\u5929"), Pattern.compile("\u4eca\u5929"), Pattern.compile("\u524d\u5929"), Pattern.compile("\u672c\u5468"), Pattern.compile("\u8fd9\u5468"), Pattern.compile("\u672c\u6708"), Pattern.compile("\u8fd9\u4e2a\u6708"), Pattern.compile("\u672c\u5b63\u5ea6"), Pattern.compile("\u5f53\u524d\u5b63\u5ea6"), Pattern.compile("\u8fd9\u4e2a\u5b63\u5ea6"), Pattern.compile("\u53bb\u5e74"), Pattern.compile("\u4eca\u5e74"), Pattern.compile("\u524d\u5e74")};

    public static TimeRange timeNormalizer(String text) {
        ArrayList<TimeRange> timeRanges = new ArrayList<TimeRange>();
        for (Pattern pattern : PATTERNS) {
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                text = text.replace(matcher.group(), "#TIME#");
                TimeRange timeRange = TimeNormalizerUtil.parseTimeRange(matcher);
                if (timeRange == null) continue;
                timeRanges.add(timeRange);
            }
        }
        if (timeRanges.size() == 1) {
            return (TimeRange)timeRanges.get(0);
        }
        if (timeRanges.size() > 1) {
            return new TimeRange(((TimeRange)timeRanges.get(0)).getOriginalText() + " " + ((TimeRange)timeRanges.get(1)).getOriginalText(), ((TimeRange)timeRanges.get(0)).getStartDate(), ((TimeRange)timeRanges.get(1)).getEndDate());
        }
        return null;
    }

    private static TimeRange parseTimeRange(Matcher matcher) {
        String matchedText = matcher.group();
        LocalDateTime now = LocalDateTime.now();
        try {
            if (matchedText.matches("\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5")) {
                int year = Integer.parseInt(matcher.group(1));
                int month = Integer.parseInt(matcher.group(2));
                int day = Integer.parseInt(matcher.group(3));
                LocalDate date = LocalDate.of(year, month, day);
                return new TimeRange(matchedText, date, date);
            }
            if (matchedText.matches("\\d{4}\u5e74\\d{1,2}\u6708")) {
                int year = Integer.parseInt(matcher.group(1));
                int month = Integer.parseInt(matcher.group(2));
                YearMonth yearMonth = YearMonth.of(year, month);
                LocalDate start = yearMonth.atDay(1);
                LocalDate end = yearMonth.atEndOfMonth();
                return new TimeRange(matchedText, start, end);
            }
            if (matchedText.matches("\\d{1,2}\u6708\\d{1,2}\u65e5")) {
                int month = Integer.parseInt(matcher.group(1));
                int day = Integer.parseInt(matcher.group(2));
                int year = now.getYear();
                LocalDate date = LocalDate.of(year, month, day);
                return new TimeRange(matchedText, date, date);
            }
            if (matchedText.matches("\\d{4}\u5e74")) {
                int year = Integer.parseInt(matcher.group(1));
                LocalDate start = LocalDate.of(year, 1, 1);
                LocalDate end = LocalDate.of(year, 12, 31);
                return new TimeRange(matchedText, start, end);
            }
            if (matchedText.matches("\\d{1,2}\u6708")) {
                int month = Integer.parseInt(matcher.group(1));
                int year = now.getYear();
                YearMonth yearMonth = YearMonth.of(year, month);
                LocalDate start = yearMonth.atDay(1);
                LocalDate end = yearMonth.atEndOfMonth();
                return new TimeRange(matchedText, start, end);
            }
            if (matchedText.matches("\\d{4}\u5e74\u7b2c[\u4e00\u4e8c\u4e09\u56db1-4]\u5b63\u5ea6")) {
                int year = Integer.parseInt(matcher.group(1));
                String quarterStr = matcher.group(2);
                int quarter = TimeNormalizerUtil.parseQuarter(quarterStr);
                return TimeNormalizerUtil.createQuarterRange(year, quarter, matchedText);
            }
            if (matchedText.matches("\u7b2c[\u4e00\u4e8c\u4e09\u56db1-4]\u5b63\u5ea6")) {
                String quarterStr = matcher.group(1);
                int quarter = TimeNormalizerUtil.parseQuarter(quarterStr);
                int year = now.getYear();
                return TimeNormalizerUtil.createQuarterRange(year, quarter, matchedText);
            }
            if (matchedText.equals("\u8fd1\u4e00\u5468")) {
                LocalDate today = now.toLocalDate();
                return new TimeRange(matchedText, today.minusWeeks(1L), today);
            }
            if (matchedText.startsWith("\u8fd1")) {
                return TimeNormalizerUtil.parseRelativeTime(matchedText, matcher, now);
            }
            if (matchedText.equals("\u4e0a\u5468")) {
                LocalDate today = now.toLocalDate();
                LocalDate lastWeek = today.minusWeeks(1L);
                LocalDate start = lastWeek.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                LocalDate end = lastWeek.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
                return new TimeRange(matchedText, start, end);
            }
            if (matchedText.equals("\u4e0a\u4e2a\u6708")) {
                YearMonth lastMonth = YearMonth.now().minusMonths(1L);
                LocalDate start = lastMonth.atDay(1);
                LocalDate end = lastMonth.atEndOfMonth();
                return new TimeRange(matchedText, start, end);
            }
            if (matchedText.startsWith("\u6628\u5929")) {
                return new TimeRange(matchedText, LocalDate.now().minusDays(1L), LocalDate.now().minusDays(1L));
            }
            if (matchedText.startsWith("\u4eca\u5929")) {
                return new TimeRange(matchedText, LocalDate.now(), LocalDate.now());
            }
            if (matchedText.startsWith("\u524d\u5929")) {
                return new TimeRange(matchedText, LocalDate.now().minusDays(2L), LocalDate.now().minusDays(2L));
            }
            if (matchedText.startsWith("\u672c\u5468") || matchedText.startsWith("\u8fd9\u5468")) {
                LocalDate today = now.toLocalDate();
                LocalDate start = today.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                LocalDate end = today.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
                return new TimeRange(matchedText, start, end);
            }
            if (matchedText.startsWith("\u672c\u6708") || matchedText.startsWith("\u8fd9\u4e2a\u6708")) {
                int month = now.getMonthValue();
                int year = now.getYear();
                YearMonth yearMonth = YearMonth.of(year, month);
                LocalDate start = yearMonth.atDay(1);
                LocalDate end = yearMonth.atEndOfMonth();
                return new TimeRange(matchedText, start, end);
            }
            if (matchedText.startsWith("\u672c\u5b63\u5ea6") || matchedText.startsWith("\u8fd9\u4e2a\u5b63\u5ea6")) {
                int quarter = TimeNormalizerUtil.getCurrentQuarter(now);
                return TimeNormalizerUtil.createQuarterRange(now.getYear(), quarter, matchedText);
            }
            if (matchedText.startsWith("\u53bb\u5e74")) {
                int year = now.getYear() - 1;
                LocalDate start = LocalDate.of(year, 1, 1);
                LocalDate end = LocalDate.of(year, 12, 31);
                return new TimeRange(matchedText, start, end);
            }
            if (matchedText.startsWith("\u4eca\u5e74") || matchedText.startsWith("\u672c\u5e74")) {
                int year = now.getYear();
                LocalDate start = LocalDate.of(year, 1, 1);
                LocalDate end = LocalDate.of(year, 12, 31);
                return new TimeRange(matchedText, start, end);
            }
            if (matchedText.startsWith("\u524d\u5e74")) {
                int year = now.getYear() - 2;
                LocalDate start = LocalDate.of(year, 1, 1);
                LocalDate end = LocalDate.of(year, 12, 31);
                return new TimeRange(matchedText, start, end);
            }
        }
        catch (Exception e) {
            System.err.println("\u89e3\u6790\u65f6\u95f4\u63cf\u8ff0\u5931\u8d25: " + matchedText + ", \u9519\u8bef: " + e.getMessage());
        }
        return null;
    }

    private static int parseQuarter(String quarterStr) {
        if (quarterStr.contains("\u4e00") || quarterStr.contains("1")) {
            return 1;
        }
        if (quarterStr.contains("\u4e8c") || quarterStr.contains("2")) {
            return 2;
        }
        if (quarterStr.contains("\u4e09") || quarterStr.contains("3")) {
            return 3;
        }
        if (quarterStr.contains("\u56db") || quarterStr.contains("4")) {
            return 4;
        }
        return 1;
    }

    private static int getCurrentQuarter(LocalDateTime now) {
        int month = now.getMonthValue();
        return (month - 1) / 3 + 1;
    }

    private static TimeRange createQuarterRange(int year, int quarter, String originalText) {
        int startMonth = (quarter - 1) * 3 + 1;
        int endMonth = quarter * 3;
        LocalDate start = LocalDate.of(year, startMonth, 1);
        LocalDate end = LocalDate.of(year, endMonth, 1).with(TemporalAdjusters.lastDayOfMonth());
        return new TimeRange(originalText, start, end);
    }

    private static TimeRange parseRelativeTime(String matchedText, Matcher matcher, LocalDateTime now) {
        if (matchedText.matches("\u8fd1\\d+\u5929")) {
            int days = Integer.parseInt(matcher.group(1));
            LocalDate end = now.toLocalDate();
            LocalDate start = end.minusDays(days - 1);
            return new TimeRange(matchedText, start, end);
        }
        if (matchedText.matches("\u8fd1\\d+\u4e2a?\u661f\u671f") || matchedText.matches("\u8fd1\\d+\u5468")) {
            int weeks = Integer.parseInt(matcher.group(1));
            LocalDate end = now.toLocalDate();
            LocalDate start = end.minusWeeks(weeks).plusDays(1L);
            return new TimeRange(matchedText, start, end);
        }
        if (matchedText.matches("\u8fd1\\d+\u4e2a?\u6708")) {
            int months = Integer.parseInt(matcher.group(1));
            LocalDate end = now.toLocalDate();
            LocalDate start = end.minusMonths(months).plusDays(1L);
            return new TimeRange(matchedText, start, end);
        }
        return null;
    }
}

