/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.util;

import cn.hutool.core.io.resource.ResourceUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.imagedb.dataset.dto.hanlp.QueryWord;
import com.geoway.imagedb.dataset.dto.hanlp.QueryWordsFilter;
import com.geoway.imagedb.dataset.dto.hanlp.TimeRange;
import com.geoway.imagedb.dataset.dto.query.SatelliteFilterDTO;
import com.geoway.imagedb.dataset.dto.query.TimeFilterDTO;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import com.geoway.imagedb.dataset.util.TimeNormalizerUtil;
import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.hankcs.hanlp.seg.common.Term;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanLPUtil {
    private static final Logger log = LoggerFactory.getLogger(HanLPUtil.class);
    private static Map<String, List<QueryWord>> wordsMap = new HashMap<String, List<QueryWord>>(0);
    private static Map<String, List<QueryWord>> groupsMap = new HashMap<String, List<QueryWord>>(0);
    private static Map<String, List<QueryWord>> wordsGroupMap = new HashMap<String, List<QueryWord>>(0);

    public static void loadCustomMachineDictionary(DmDictValueDTO originalDictValue, DmDictValueDTO productDictValue) {
        HanLPUtil.loadCustomDictionaryFromTxt();
        ArrayList<QueryWord> queryWordList = new ArrayList<QueryWord>();
        if (originalDictValue != null) {
            queryWordList.addAll(HanLPUtil.getSatelliteWords(originalDictValue, null, 11, ""));
        }
        if (productDictValue != null) {
            queryWordList.addAll(HanLPUtil.getSatelliteWords(productDictValue, null, 21, ""));
        }
        for (QueryWord queryWord : queryWordList) {
            CustomDictionary.add((String)queryWord.getWord(), (String)queryWord.getNature());
        }
        ArrayList<QueryWord> satelliteSensorWords = new ArrayList<QueryWord>();
        ArrayList<QueryWord> groupWords = new ArrayList<QueryWord>();
        for (QueryWord item : queryWordList) {
            if (item.getWordType() == 0 || item.getWordType() == 1) {
                satelliteSensorWords.add(item);
                continue;
            }
            groupWords.add(item);
        }
        wordsMap = satelliteSensorWords.stream().collect(Collectors.groupingBy(QueryWord::getNature));
        groupsMap = groupWords.stream().collect(Collectors.groupingBy(QueryWord::getWord));
        wordsGroupMap = queryWordList.stream().collect(Collectors.groupingBy(QueryWord::getGroupId));
    }

    public static QueryWordsFilter segment(String text) {
        QueryWordsFilter filter = new QueryWordsFilter();
        if (text.contains("\u89e3\u8bd1") || text.contains("\u56fe\u6591") || text.contains("\u4e13\u9898") || text.contains("\u63d0\u53d6") || text.contains("\u53d8\u5316") || text.contains("\u76ee\u6807") || text.contains("\u8c03\u67e5") || text.contains("\u56fd\u60c5") || text.contains("\u76d1\u6d4b") || text.contains("\u68c0\u6d4b") || text.contains("\u56fe\u5c42")) {
            return HanLPUtil.segmentThematic(text);
        }
        TimeRange timeRange = TimeNormalizerUtil.timeNormalizer(text);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
        if (timeRange == null) {
            TimeFilterDTO productTime = new TimeFilterDTO();
            productTime.setStartTime(ImageDateUtil.parse(LocalDate.now().minusWeeks(1L).format(dateFormatter)));
            productTime.setEndTime(ImageDateUtil.parse(LocalDate.now().format(dateFormatter)));
            filter.setProductTime(productTime);
        } else {
            TimeFilterDTO timeFilter = new TimeFilterDTO();
            timeFilter.setStartTime(ImageDateUtil.parse(timeRange.getStartDate().format(dateFormatter)));
            timeFilter.setEndTime(ImageDateUtil.parse(timeRange.getEndDate().format(dateFormatter)));
            if (text.contains("\u63a5\u6536") || text.contains("\u5165\u5e93")) {
                filter.setImportTime(timeFilter);
            } else {
                filter.setProductTime(timeFilter);
            }
        }
        ArrayList<String> satelliteNatures = new ArrayList<String>();
        String place = "";
        ArrayList<SatelliteFilterDTO> satelliteArray = new ArrayList<SatelliteFilterDTO>();
        ArrayList<String> groupIds = new ArrayList<String>();
        Integer imageType = 21;
        boolean allOriginal = true;
        List termList = HanLP.segment((String)text);
        for (Term term : termList) {
            QueryWord queryWord2;
            Iterator<QueryWord> iterator;
            Object queryWordList;
            if (wordsMap.containsKey(term.nature.toString())) {
                queryWordList = wordsMap.get(term.nature.toString());
                iterator = queryWordList.iterator();
                while (iterator.hasNext()) {
                    SatelliteFilterDTO satellite;
                    queryWord2 = iterator.next();
                    if (queryWord2.getWordType() == 0 && ListUtil.find(satelliteArray, f -> f.getName().equals(queryWord2.getWord())) == null) {
                        if (!satelliteNatures.contains(queryWord2.getNature())) {
                            satelliteNatures.add(queryWord2.getNature());
                        }
                        satellite = new SatelliteFilterDTO();
                        satellite.setName(queryWord2.getWord());
                        satellite.setSensorArray(new ArrayList<String>());
                        satelliteArray.add(satellite);
                        if (queryWord2.getImageType() != 21) continue;
                        allOriginal = false;
                        continue;
                    }
                    if (queryWord2.getWordType() != 1 || ListUtil.find(satelliteArray, f -> f.getName().equals(queryWord2.getWord())) == null) continue;
                    satellite = (SatelliteFilterDTO)ListUtil.find(satelliteArray, f -> f.getName().equals(queryWord2.getWord()));
                    satellite.getSensorArray().add(queryWord2.getWord());
                    if (queryWord2.getImageType() != 21) continue;
                    allOriginal = false;
                }
                continue;
            }
            if (groupsMap.containsKey(term.word)) {
                queryWordList = groupsMap.get(term.word);
                iterator = queryWordList.iterator();
                while (iterator.hasNext()) {
                    queryWord2 = iterator.next();
                    if (groupIds.contains(queryWord2.getNature())) continue;
                    if (queryWord2.getImageType() == 21) {
                        allOriginal = false;
                    }
                    groupIds.add(queryWord2.getNature());
                }
                continue;
            }
            if (term.nature.toString().startsWith("ns")) {
                place = term.word;
                continue;
            }
            System.out.println(term.word + " -> " + term.nature);
        }
        if (satelliteArray.size() == 0 && groupIds.size() == 0) {
            allOriginal = false;
        }
        if (text.contains("\u539f\u59cb") || allOriginal) {
            imageType = 11;
        }
        if (satelliteArray.size() == 0) {
            if (groupIds.size() == 0) {
                int imageTypeFinal = imageType;
                List groupList = ListUtil.findAll(wordsGroupMap.get("-1"), queryWord -> queryWord.getWordType() == 2 && queryWord.getImageType() == imageTypeFinal);
                for (QueryWord item : groupList) {
                    if (groupIds.contains(item.getNature())) continue;
                    groupIds.add(item.getNature());
                }
            }
            List<QueryWord> satelliteWordsList = HanLPUtil.getChildSatelliteWords(groupIds, imageType);
            for (QueryWord queryWord3 : satelliteWordsList) {
                if (!satelliteNatures.contains(queryWord3.getNature())) {
                    satelliteNatures.add(queryWord3.getNature());
                }
                SatelliteFilterDTO satellite = new SatelliteFilterDTO();
                satellite.setName(queryWord3.getWord());
                satellite.setSensorArray(new ArrayList<String>());
                satelliteArray.add(satellite);
            }
        }
        filter.setImageType(imageType);
        filter.setPlace(place);
        filter.setSatelliteArray(satelliteArray);
        filter.setSatelliteNatures(satelliteNatures);
        return filter;
    }

    public static QueryWordsFilter segmentThematic(String text) {
        QueryWordsFilter filter = new QueryWordsFilter();
        filter.setImageType(71);
        List termList = HanLP.segment((String)text);
        String place = "";
        String layer = "";
        for (Term term : termList) {
            if (term.nature.toString().startsWith("ns")) {
                place = term.word;
                continue;
            }
            if (term.nature.toString().startsWith("layer")) {
                layer = term.word;
                continue;
            }
            System.out.println(term.word + " -> " + term.nature);
        }
        filter.setPlace(place);
        filter.setLayer(layer);
        return filter;
    }

    public static List<QueryWord> getSatelliteWords(DmDictValueDTO currentDictValue, DmDictValueDTO parentDictValue, Integer imageType, String parentGroupId) {
        String groupId;
        ArrayList<QueryWord> wordsList = new ArrayList<QueryWord>();
        String string = groupId = parentDictValue == null ? "-1" : parentDictValue.getId().toString();
        if (StringUtil.isNotEmpty((String)currentDictValue.getRemark()) && currentDictValue.getRemark().contains("\u536b\u661f") && parentDictValue != null) {
            QueryWord queryWordName = new QueryWord(currentDictValue.getName(), currentDictValue.getCode(), imageType, 0, currentDictValue.getCode(), groupId);
            wordsList.add(queryWordName);
            if (!currentDictValue.getName().equals(currentDictValue.getCode())) {
                QueryWord queryWordCode = new QueryWord(currentDictValue.getCode(), currentDictValue.getCode(), imageType, 0, currentDictValue.getCode(), groupId);
                wordsList.add(queryWordCode);
            }
            wordsList.addAll(HanLPUtil.getFromRemark(currentDictValue, queryWordName.getNature(), imageType, 0, currentDictValue.getCode(), groupId));
            return wordsList;
        }
        if (currentDictValue.getChildren() == null || currentDictValue.getChildren().size() == 0) {
            if (parentDictValue != null) {
                QueryWord sensorWordName = new QueryWord(currentDictValue.getName(), currentDictValue.getCode(), imageType, 1, parentDictValue.getCode(), "");
                wordsList.add(sensorWordName);
                if (currentDictValue.getName().equals(currentDictValue.getCode())) {
                    QueryWord sensorWordCode = new QueryWord(currentDictValue.getCode(), currentDictValue.getCode(), imageType, 1, parentDictValue.getCode(), "");
                    wordsList.add(sensorWordCode);
                }
                if (StringUtil.isNotEmpty((String)currentDictValue.getRemark())) {
                    wordsList.addAll(HanLPUtil.getFromRemark(currentDictValue, sensorWordName.getNature(), imageType, 1, parentDictValue.getCode(), ""));
                }
                return wordsList;
            }
        } else {
            for (DmDictValueDTO child : currentDictValue.getChildren()) {
                boolean isAllSensor = true;
                List<QueryWord> list = HanLPUtil.getSatelliteWords(child, currentDictValue, imageType, groupId);
                for (QueryWord item : list) {
                    if (item.getWordType() == 1) continue;
                    isAllSensor = false;
                    break;
                }
                wordsList.addAll(list);
                if (isAllSensor && ListUtil.find(wordsList, queryWord -> queryWord.getWord().equals(currentDictValue.getName())) == null) {
                    QueryWord satelliteWordName = new QueryWord(currentDictValue.getName(), currentDictValue.getCode(), imageType, 0, currentDictValue.getCode(), groupId);
                    wordsList.add(satelliteWordName);
                    if (!currentDictValue.getName().equals(currentDictValue.getCode())) {
                        QueryWord satelliteWordCode = new QueryWord(currentDictValue.getCode(), currentDictValue.getCode(), imageType, 0, currentDictValue.getCode(), groupId);
                        wordsList.add(satelliteWordCode);
                    }
                    if (StringUtil.isNotEmpty((String)currentDictValue.getRemark())) {
                        wordsList.addAll(HanLPUtil.getFromRemark(currentDictValue, satelliteWordName.getNature(), imageType, 0, currentDictValue.getCode(), groupId));
                    }
                }
                if (parentDictValue == null || isAllSensor || ListUtil.find(wordsList, queryWord -> queryWord.getWord().equals(currentDictValue.getName())) != null) continue;
                QueryWord queryWordName = new QueryWord(currentDictValue.getName(), currentDictValue.getId() + "", imageType, 2, "", groupId);
                wordsList.add(queryWordName);
                if (!currentDictValue.getName().equals(currentDictValue.getCode())) {
                    QueryWord queryWordCode = new QueryWord(currentDictValue.getCode(), currentDictValue.getId() + "", imageType, 2, "", groupId);
                    wordsList.add(queryWordCode);
                }
                wordsList.addAll(HanLPUtil.getFromRemark(currentDictValue, queryWordName.getNature(), imageType, 2, "", groupId));
            }
        }
        return wordsList;
    }

    private static List<QueryWord> getChildSatelliteWords(List<String> groupIdList, Integer imageType) {
        ArrayList<QueryWord> satelliteWordsList = new ArrayList<QueryWord>();
        ArrayList<String> childGroupList = new ArrayList<String>();
        for (String groupId : groupIdList) {
            List<QueryWord> childWords = wordsGroupMap.get(groupId);
            for (QueryWord childWord : childWords) {
                if (!childWord.getImageType().equals(imageType)) continue;
                if (childWord.getWordType() == 0) {
                    satelliteWordsList.add(childWord);
                }
                if (childWord.getWordType() != 2) continue;
                childGroupList.add(childWord.getNature());
            }
        }
        if (childGroupList.size() > 0) {
            satelliteWordsList.addAll(HanLPUtil.getChildSatelliteWords(childGroupList, imageType));
        }
        return satelliteWordsList;
    }

    private static List<QueryWord> getFromRemark(DmDictValueDTO dictValueDTO, String nature, Integer imageType, Integer wordType, String satellite, String groupName) {
        String[] aliasNames;
        ArrayList<QueryWord> wordsList = new ArrayList<QueryWord>();
        if (StringUtil.isEmptyOrWhiteSpace((String)dictValueDTO.getRemark())) {
            return wordsList;
        }
        String remark = dictValueDTO.getRemark();
        if (remark.contains("|")) {
            remark = remark.replace("|", ",");
        }
        for (String aliasName : aliasNames = remark.split(",")) {
            if ("\u536b\u661f".equals(aliasName)) continue;
            QueryWord queryWord = new QueryWord(aliasName, nature, imageType, wordType, satellite, groupName);
            wordsList.add(queryWord);
        }
        return wordsList;
    }

    private static void loadCustomDictionaryFromTxt() {
        try {
            URL resource;
            File dictionaryFile = new File("hanlp/CustomDictionary.txt");
            if (dictionaryFile.exists() && dictionaryFile.isFile()) {
                log.info("\u8bfb\u53d6\u81ea\u5b9a\u4e49\u8bcd\u5178\uff1a" + dictionaryFile.getAbsolutePath());
                resource = dictionaryFile.toURI().toURL();
            } else {
                resource = ResourceUtil.getResource((String)"hanlp/CustomDictionary.txt");
                if (resource == null) {
                    log.error("\u81ea\u5b9a\u4e49\u8bcd\u5178\uff1aCustomDictionary.txt\u4e0d\u5b58\u5728");
                    return;
                }
            }
            List lines = FileUtil.readFileLines((String)resource.getPath());
            for (String line : lines) {
                String[] split = line.split(" ");
                if (split.length < 2) continue;
                String word = split[0];
                String nature = split[1];
                CustomDictionary.add((String)word, (String)nature);
            }
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u81ea\u5b9a\u4e49\u8bcd\u5178\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
    }
}

