/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.service.impl;

import cn.hutool.core.date.DateUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumFieldDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.imagedb.dataset.dao.ImgDatasetDao;
import com.geoway.imagedb.dataset.dto.ImgDatumTypeFieldDTO;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.event.ImageDataAfterDeleteEvent;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.service.ImageRecycleService;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class ImageDatasetServiceImpl
implements ImageDatasetService {
    private static final Logger log = LoggerFactory.getLogger(ImageDatasetServiceImpl.class);
    @Resource
    private ImgDatasetDao imgDatasetDao;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private ImageRecycleService imageRecycleService;
    private final String suffix = "_snapshot";
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    @CacheEvict(value={"AppCatalogRightCache"}, allEntries=true)
    public String addImageDataset(ImgDataset imgDataset) {
        this.imgDatasetDao.insert(imgDataset);
        return imgDataset.getDatasetId();
    }

    @Override
    @CacheEvict(value={"AppCatalogRightCache"}, allEntries=true)
    public void updateImageDataset(ImgDataset imgDataset) {
        this.imgDatasetDao.updateByPrimaryKey(imgDataset);
    }

    @Override
    @Cacheable(value={"ImageDatasetInfoCache"}, keyGenerator="customKeyGenerator")
    public ImgDataset getImgDataset(String datumDatasetId) {
        return this.imgDatasetDao.selectByPrimaryKey(datumDatasetId);
    }

    @Override
    public List<ImgDataset> getAllImageDatasetInfos() {
        return this.imgDatasetDao.selectAll();
    }

    @Override
    public ImgDataset getImgDatasetByGeoDatasetId(String geoDatasetId) {
        return this.imgDatasetDao.selectByGeoDatasetId(geoDatasetId);
    }

    @Override
    public List<ImgDataset> getImageDatasetByDatumTypeModelId(String datumTypeModelId) {
        return this.imgDatasetDao.selectByDatumTypeModelId(datumTypeModelId);
    }

    @Override
    public DatumFieldDTO convertDatumFieldDTO(ImgDatumTypeFieldDTO datumTypeField) {
        DatumFieldDTO datumField = new DatumFieldDTO();
        datumField.setName(datumTypeField.getName());
        datumField.setAliasName(datumTypeField.getAliasName());
        datumField.setFieldType(datumTypeField.getFieldType());
        datumField.setLength(datumTypeField.getLength());
        datumField.setDefaultValue(datumTypeField.getDefaultValue());
        datumField.setNullable(datumTypeField.getNullable());
        datumField.setDatumName(datumTypeField.getDatumName());
        datumField.setIdentify(datumTypeField.getIdentify());
        datumField.setSystemField(datumTypeField.getSystemField());
        return datumField;
    }

    @Override
    public String getSnapshotDatasetName(String datasetName) {
        return datasetName + "_snapshot";
    }

    @Override
    public String getSnapshotDatasetId(String datasetId) {
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
        return DatasetUtil.getDatasetId((String)nameInfo.getDsKey(), (DatasetTypeEnum)DatasetTypeEnum.MosaicDataset, (String)(nameInfo.getName() + "_snapshot"));
    }

    @Override
    public DataSourceDTO getBusinessSnapshotDataSource() {
        DatabaseDTO targetDatabase = this.dataSourceManager.getSystemDataSourceDetail();
        if (targetDatabase == null) {
            throw new RuntimeException("\u83b7\u53d6\u4e1a\u52a1\u5e93\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return targetDatabase;
    }

    @Override
    public String getBusinessSnapshotDatasetName() {
        return "tbimg_businesssnapshot";
    }

    @Override
    public String getBusinessSnapshotDatasetId() {
        DataSourceDTO targetDatabase = this.getBusinessSnapshotDataSource();
        return DatasetUtil.getDatasetId((String)targetDatabase.getKey(), (DatasetTypeEnum)DatasetTypeEnum.MosaicDataset, (String)"public.tbimg_businesssnapshot");
    }

    @Override
    public String getBusinessSnapshotCatDatasetId() {
        DataSourceDTO targetDatabase = this.getBusinessSnapshotDataSource();
        return DatasetUtil.getDatasetId((String)targetDatabase.getKey(), (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)"public.GWMD_tbimg_businesssnapshot_CAT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBusinessSnapshotByDatasetId(String imageDatasetId) {
        DataSourceDTO targetDatabase = this.getBusinessSnapshotDataSource();
        String sql = String.format("delete from %s where %s = '%s'", "GWMD_tbimg_businesssnapshot_CAT", "f_image_dataset_id", imageDatasetId);
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);){
            String querySql = String.format("select urihash from %s where %s = '%s'", "GWMD_tbimg_businesssnapshot_CAT", "f_image_dataset_id", imageDatasetId);
            this.deleteSnapshotFile(workspace, querySql);
            workspace.excuteSql(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycleBusinessSnapshotByDataId(List<String> dataIdList, int category) {
        if (dataIdList == null || dataIdList.size() == 0) {
            return;
        }
        List filters = ListUtil.convertAll(dataIdList, f -> String.format("%s = '%s'", "F_DATAID", f));
        String filter = String.join((CharSequence)" or ", filters);
        DataSourceDTO targetDatabase = this.getBusinessSnapshotDataSource();
        String sql = String.format("update %s set category = %s where %s", "GWMD_tbimg_businesssnapshot_CAT", category, filter);
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);){
            workspace.excuteSql(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBusinessSnapshotByDataId(List<String> dataIdList) {
        if (dataIdList == null || dataIdList.size() == 0) {
            return;
        }
        List filters = ListUtil.convertAll(dataIdList, f -> String.format("%s = '%s'", "F_DATAID", f));
        String filter = String.join((CharSequence)" or ", filters);
        DataSourceDTO targetDatabase = this.getBusinessSnapshotDataSource();
        String sql = String.format("delete from %s where %s", "GWMD_tbimg_businesssnapshot_CAT", filter);
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);){
            String querySql = String.format("select urihash from %s where %s", "GWMD_tbimg_businesssnapshot_CAT", filter);
            this.deleteSnapshotFile(workspace, querySql);
            workspace.excuteSql(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBusinessSnapshotByDataId(String dataId, Map<String, Object> editData) {
        String filter = String.format("%s = '%s'", "F_DATAID", dataId);
        DataSourceDTO targetDatabase = this.getBusinessSnapshotDataSource();
        ArrayList<String> setList = new ArrayList<String>();
        for (String fieldName : editData.keySet()) {
            switch (fieldName.toLowerCase(Locale.ROOT)) {
                case "f_satellite": 
                case "f_sensor": {
                    setList.add(String.format(" %s = '%s'", fieldName, editData.get(fieldName)));
                    break;
                }
                case "f_product_time": 
                case "f_time": {
                    if (editData.get(fieldName) == null || StringUtil.isEmptyOrWhiteSpace((String)editData.get(fieldName).toString())) {
                        setList.add(String.format(" %s = null", "f_product_time"));
                        break;
                    }
                    Date productTime = ImageDateUtil.parse(editData.get(fieldName).toString());
                    setList.add(String.format(" %s = '%s'", "f_product_time", DateUtil.format((Date)productTime, (String)"yyyy-MM-dd HH:mm:ss")));
                    break;
                }
                case "f_cloud": 
                case "f_resolution": {
                    setList.add(String.format(" %s = %s", fieldName, editData.get(fieldName)));
                    break;
                }
                case "f_classification": {
                    setList.add(String.format(" %s = '%s'", "f_satellite", editData.get(fieldName)));
                    break;
                }
            }
        }
        String sql = String.format("update %s set %s where %s", "GWMD_tbimg_businesssnapshot_CAT", String.join((CharSequence)",", setList), filter);
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);){
            workspace.excuteSql(sql);
        }
    }

    @Override
    public void deleteImgBusinessInfo(String datasetId) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ImageDataAfterDeleteEvent(this, null, datasetId, null));
        this.imageRecycleService.deleteImageRecycleByDatasetId(datasetId);
    }

    private void deleteSnapshotFile(IFeatureWorkspace workspace, String querySql) {
        List queryList = workspace.queryList(querySql, new Object[0]);
        ArrayList<String> snapshotUrlList = new ArrayList<String>();
        for (Map map : queryList) {
            for (Object urlPathObj : map.values()) {
                snapshotUrlList.add(urlPathObj == null ? null : urlPathObj.toString());
            }
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ImageDataAfterDeleteEvent(this, null, null, snapshotUrlList));
    }
}

