/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.util;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.multipart.MultipartFile;

public class FileReadUtil {
    public static List<String> readFileLines(MultipartFile file) {
        ArrayList<String> arrayList;
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = null;
        InputStream inputStream = null;
        String charset = FileReadUtil.getFileCharset(file);
        try {
            inputStream = file.getInputStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, charset));
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                list.add(tempString);
            }
            arrayList = list;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{inputStream, reader});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{inputStream, reader});
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileCharset(MultipartFile file) {
        try (InputStream fis = file.getInputStream();){
            byte[] dataBytes;
            int bytesLength = 128;
            byte[] firstBytes = new byte[bytesLength];
            int bytesRead = fis.read(firstBytes, 0, bytesLength);
            if (bytesRead < bytesLength) {
                dataBytes = new byte[bytesRead];
                System.arraycopy(firstBytes, 0, dataBytes, 0, bytesRead);
            } else {
                dataBytes = firstBytes;
            }
            String string = FileUtil.getFileCharset((byte[])dataBytes);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "UTF-8";
        }
    }

    public static String convertToAbsolutePath(String metaFile, String relativePath) {
        Path path = Paths.get(relativePath, new String[0]);
        if (path.isAbsolute()) {
            return path.normalize().toString();
        }
        Path resolvedPath = Paths.get(metaFile, new String[0]).getParent().resolve(relativePath);
        Path normalizedPath = resolvedPath.normalize();
        return normalizedPath.toString();
    }
}

