/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.service.impl;

import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumFieldDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.entity.DsDatum;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.impl.DatumDatabaseServiceImpl;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dto.ImgDatumTypeDTO;
import com.geoway.imagedb.dataset.dto.ImgDatumTypeFieldDTO;
import com.geoway.imagedb.dataset.dto.dataset.ImageGeoDatasetDTO;
import com.geoway.imagedb.dataset.dto.dataset.ImageMosaicDatasetDTO;
import com.geoway.imagedb.dataset.dto.query.ImageReturnField;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.entity.ImgRecycle;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.service.ImageRecycleService;
import com.geoway.imagedb.dataset.service.ImgDatumTypeService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class ImageDatumDatabaseServiceImpl
extends DatumDatabaseServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ImageDatumDatabaseServiceImpl.class);
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    private ImgDatumTypeService imgDatumTypeService;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private ImageRecycleService imageRecycleService;

    public DatumDatasetDTO getDatasetDetail(DataSourceDTO dataSourceDTO, String name) {
        DatumDatasetDTO datumDatasetDTO = super.getDatasetDetail(dataSourceDTO, name);
        ImgDataset imgDatasetInfo = this.imageDatasetService.getImgDataset(datumDatasetDTO.getId());
        if (imgDatasetInfo != null) {
            Object imageDataset;
            ImgDatumTypeDTO datumType = (ImgDatumTypeDTO)this.imgDatumTypeService.getDetail(imgDatasetInfo.getDatumTypeModelId());
            ImageDatasetTypeEnum imageDatasetTypeEnum = ImageDatasetTypeEnum.getByValue(imgDatasetInfo.getImageDatasetType());
            switch (imageDatasetTypeEnum) {
                case OriginalImageDataset: {
                    DatasetNameInfo geoNameInfo = new DatasetNameInfo(imgDatasetInfo.getGeoDatasetId());
                    if (geoNameInfo.getType().intValue() == DatasetTypeEnum.FeatureClass.getValue()) {
                        imageDataset = new ImageGeoDatasetDTO();
                        BeanUtils.copyProperties((Object)datumDatasetDTO, (Object)imageDataset);
                        ((ImageGeoDatasetDTO)((Object)imageDataset)).setDatumTypeModel(datumType);
                        String snapshotDatasetId = this.imageDatasetService.getSnapshotDatasetId(datumDatasetDTO.getGeoDatasetId());
                        ((ImageGeoDatasetDTO)((Object)imageDataset)).setSnapshotRender(this.dataSourceManager.getDatasetRender(snapshotDatasetId));
                        break;
                    }
                    if (geoNameInfo.getType().intValue() == DatasetTypeEnum.MosaicDataset.getValue()) {
                        ImageMosaicDatasetDTO mosaicImageDataset;
                        imageDataset = mosaicImageDataset = new ImageMosaicDatasetDTO();
                        BeanUtils.copyProperties((Object)datumDatasetDTO, (Object)imageDataset);
                        mosaicImageDataset.setDatumTypeModel(datumType);
                        mosaicImageDataset.setSnapshotRender(mosaicImageDataset.getRender());
                        mosaicImageDataset.setRender(mosaicImageDataset.getRangeRender());
                        break;
                    }
                    imageDataset = datumDatasetDTO;
                    break;
                }
                case ProcessedImageDataset: {
                    imageDataset = new ImageMosaicDatasetDTO();
                    BeanUtils.copyProperties((Object)datumDatasetDTO, (Object)imageDataset);
                    imageDataset.setDatumTypeModel(datumType);
                    break;
                }
                case ImageSampleImageDataset: 
                case TileSampleImageDataset: {
                    imageDataset = new ImageGeoDatasetDTO();
                    BeanUtils.copyProperties((Object)datumDatasetDTO, (Object)imageDataset);
                    ((ImageGeoDatasetDTO)((Object)imageDataset)).setDatumTypeModel(datumType);
                    if (imgDatasetInfo.getSubDatasetIds() == null) break;
                    HashMap<String, DatasetDTO> subsets = new HashMap<String, DatasetDTO>();
                    for (String typeKey : imgDatasetInfo.getSubDatasetIds().keySet()) {
                        subsets.put(typeKey, this.geoDatabaseService.getDatasetDetail(imgDatasetInfo.getSubDatasetIds().get(typeKey)));
                    }
                    ((ImageGeoDatasetDTO)((Object)imageDataset)).setSubsets(subsets);
                    break;
                }
                default: {
                    return datumDatasetDTO;
                }
            }
            imageDataset.setDatumType(imageDatasetTypeEnum.getValue());
            ArrayList<DatumFieldDTO> imageDatasetFields = new ArrayList<DatumFieldDTO>();
            List datumDatasetFields = datumDatasetDTO.getFields();
            for (ImgDatumTypeFieldDTO modelField : datumType.getFields()) {
                DatumFieldDTO field = this.imageDatasetService.convertDatumFieldDTO(modelField);
                DatumFieldDTO datasetFld = (DatumFieldDTO)ListUtil.find((List)datumDatasetFields, f -> f.getName().equalsIgnoreCase(modelField.getName()));
                if (datasetFld != null) {
                    field.setPhysicalName(datasetFld.getPhysicalName());
                }
                imageDatasetFields.add(field);
            }
            imageDataset.setFields(imageDatasetFields);
            return imageDataset;
        }
        return datumDatasetDTO;
    }

    public DataQueryResult queryGeoDataset(String datasetId, QueryFilterDTO queryFilterDTO) {
        this.alterFilter(datasetId, (QueryFilterBasicDTO)queryFilterDTO);
        DataQueryResult queryResult = super.queryGeoDataset(datasetId, queryFilterDTO);
        ReturnField returnField = (ReturnField)ListUtil.find((List)queryResult.getFields(), f -> f.getName().equalsIgnoreCase("f_flag"));
        if (returnField != null) {
            queryResult.getFields().remove(returnField);
        }
        ArrayList fields = new ArrayList();
        ImgDataset imgDataset = this.imageDatasetService.getImgDataset(datasetId);
        if (imgDataset != null) {
            ImgDatumTypeDTO datumType = (ImgDatumTypeDTO)this.imgDatumTypeService.getDetail(imgDataset.getDatumTypeModelId());
            queryResult.getFields().forEach(item -> {
                ImageReturnField imageReturnField = new ImageReturnField();
                imageReturnField.setName(item.getName());
                imageReturnField.setAlias(item.getAlias());
                imageReturnField.setCanEdit(false);
                imageReturnField.setFieldType(FieldType.String.getValue());
                imageReturnField.setNullable(true);
                ImgDatumTypeFieldDTO datumTypeField = (ImgDatumTypeFieldDTO)((Object)((Object)ListUtil.find(datumType.getFields(), f -> f.getName().equalsIgnoreCase(item.getName()))));
                if (datumTypeField != null) {
                    imageReturnField.setCanEdit(datumTypeField.getCanEdit());
                    imageReturnField.setFieldType(datumTypeField.getFieldType());
                    imageReturnField.setNullable(datumTypeField.getNullable());
                }
                fields.add(imageReturnField);
            });
            queryResult.setFields(ListUtil.convertAll(fields, f -> f));
        }
        return queryResult;
    }

    public long queryDataCount(String datasetId, QueryFilterBasicDTO queryFilterDTO) {
        this.alterFilter(datasetId, queryFilterDTO);
        return super.queryDataCount(datasetId, queryFilterDTO);
    }

    public List<Object> queryDataFieldUniqValues(String datasetId, QueryFilterBasicDTO queryFilterDTO, Integer limit) {
        this.alterFilter(datasetId, queryFilterDTO);
        return super.queryDataFieldUniqValues(datasetId, queryFilterDTO, limit);
    }

    protected SimpleDatasetDTO convertSimpleDatasetDTO(DsDatum dsDatum) {
        ImageDatasetTypeEnum imageDatasetTypeEnum;
        SimpleDatasetDTO simpleDatasetDTO = super.convertSimpleDatasetDTO(dsDatum);
        ImgDataset imgDataset = this.imageDatasetService.getImgDataset(simpleDatasetDTO.getId());
        if (imgDataset != null && (imageDatasetTypeEnum = ImageDatasetTypeEnum.getByValue(imgDataset.getImageDatasetType())) != null) {
            simpleDatasetDTO.setDatumType(Integer.valueOf(imageDatasetTypeEnum.getValue()));
        }
        return simpleDatasetDTO;
    }

    private void alterFilter(String datasetId, QueryFilterBasicDTO queryFilterDTO) {
        List<ImgRecycle> imgRecycleList = this.imageRecycleService.queryByDatasetId(datasetId);
        if (imgRecycleList != null && imgRecycleList.size() > 0) {
            if (StringUtil.isEmptyOrWhiteSpace((String)queryFilterDTO.getCondition())) {
                queryFilterDTO.setCondition(String.format("%s = 0", "f_flag"));
            } else {
                queryFilterDTO.setCondition(String.format("(%s) and %s = 0", queryFilterDTO.getCondition(), "f_flag"));
            }
        }
    }
}

