/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin.listener;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.imagedb.input.component.ImageImportScheduleTask;
import com.geoway.imagedb.input.entity.ImgScheduleTask;
import com.geoway.imagedb.input.plugin.ImageDatasetScheduleImportPlugin;
import com.geoway.imagedb.input.plugin.ImageGeoDatasetSettingParams;
import com.geoway.imagedb.input.plugin.ImageGeoDatasetTargetParams;
import com.geoway.webstore.input.dto.ImpSchemaDTO;
import com.geoway.webstore.input.entity.ImpTask;
import com.geoway.webstore.input.event.ImportTaskCreatedEvent;
import com.geoway.webstore.input.service.ImpSchemeService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ImportTaskCreatedEventListener
implements ApplicationListener<ImportTaskCreatedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ImportTaskCreatedEventListener.class);
    @Resource
    private ImpSchemeService impSchemeService;
    @Resource
    private LoginUserService loginUserService;
    @Resource
    private ImageImportScheduleTask imageImportScheduleTask;

    public void onApplicationEvent(ImportTaskCreatedEvent event) {
        ImpSchemaDTO impSchema = event.getImpSchema();
        if (impSchema != null && impSchema.getPlugin().getClassName().equals(ImageDatasetScheduleImportPlugin.class.getName())) {
            ImpTask impTask = event.getImpTask();
            String settingParamsStr = impTask.getSettingParams();
            if (StringUtil.isEmptyOrWhiteSpace((String)settingParamsStr)) {
                return;
            }
            JSONObject settingParamJson = JSONObject.parseObject((String)settingParamsStr);
            ImageGeoDatasetSettingParams settingParams = (ImageGeoDatasetSettingParams)JSONObject.parseObject((String)settingParamsStr, ImageGeoDatasetSettingParams.class);
            if (!Boolean.TRUE.equals(settingParams.autoTask)) {
                settingParamJson.putIfAbsent((Object)"autoTask", (Object)true);
                ImageGeoDatasetTargetParams targetParams = (ImageGeoDatasetTargetParams)JSONObject.parseObject((String)impSchema.getParamValues(), ImageGeoDatasetTargetParams.class);
                ImpSchemaDTO impSchemaDTO = this.impSchemeService.getSchemaDetail(impTask.getSchemaId());
                LoginUserInfo userInfo = this.loginUserService.getUserInfo(null);
                ImgScheduleTask scheduleTask = new ImgScheduleTask();
                scheduleTask.setName(impSchemaDTO.getName());
                if (userInfo == null) {
                    scheduleTask.setUser("admin");
                } else {
                    scheduleTask.setUser(userInfo.getUserName());
                }
                scheduleTask.setParam(JSONObject.toJSONString((Object)impTask));
                scheduleTask.setStartTime(targetParams.getStartTime());
                scheduleTask.setEndTime(targetParams.getEndTime());
                scheduleTask.setCreateTime(new Date());
                scheduleTask.setInterval(targetParams.interval.longValue());
                scheduleTask.setEnable(ConstantsValue.TRUE_VALUE);
                scheduleTask.setLastPerformTime(new Date());
                scheduleTask.setPerformTimes(0);
                scheduleTask.setImpTaskId(impTask.getId());
                this.imageImportScheduleTask.createScheduleTask(scheduleTask);
            }
        }
    }
}

