/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin;

import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.datasource.dto.datum.DatumFieldDTO;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import com.geoway.imagedb.input.plugin.ImageDatasetImportPlugin;
import com.geoway.imagedb.input.plugin.meta.ImageMetaDataReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class ImageDatasetGeneralImportPlugin
extends ImageDatasetImportPlugin {
    @Override
    protected void initMetaPlugin() {
    }

    @Override
    protected Map<String, Object> getMetaData(DmFileData fileData) {
        HashMap<String, Object> contents = new HashMap<String, Object>(0);
        try {
            IFileset metaFileset = null;
            String metaDataDir = this.settingParams.metaDataDir;
            if (!StringUtil.isEmptyOrWhiteSpace((String)metaDataDir)) {
                String[] extensions;
                for (String extension : extensions = new String[]{".txt", ".TXT"}) {
                    String metaDataFile = this.scanFileStorage.combinePaths(metaDataDir, new String[]{fileData.getDataName() + extension});
                    if (this.scanFileStorage.getFile(metaDataFile) != null && this.scanFileStorage.fileExist(metaDataFile)) {
                        metaFileset = this.scanFileStorage.getFile(metaDataFile);
                        break;
                    }
                    metaDataFile = this.scanFileStorage.combinePaths(metaDataDir, new String[]{fileData.getDataName(), fileData.getDataName() + extension});
                    if (this.scanFileStorage.getFile(metaDataFile) == null || !this.scanFileStorage.fileExist(metaDataFile)) continue;
                    metaFileset = this.scanFileStorage.getFile(metaDataFile);
                    break;
                }
            }
            if (metaFileset == null) {
                List lstFile = fileData.getFiles();
                FileDataUnit metaFile = (FileDataUnit)ListUtil.find((List)lstFile, f -> f.getProperties() != null && f.getProperties().contains("CKMetaFile"));
                if (metaFile == null) {
                    throw new RuntimeException("\u5143\u6570\u636e\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                metaFileset = this.scanFileStorage.getFile(metaFile.getFileSourceLocation());
            }
            Map<String, String> meta = ImageMetaDataReader.readMeta(metaFileset);
            Map<String, String> matchTable = this.readMatchTable();
            if (matchTable.size() > 0) {
                for (String key : matchTable.keySet()) {
                    if (!meta.containsKey(key)) continue;
                    meta.put(matchTable.get(key), meta.get(key));
                }
            }
            this.setExternalMetaValue(meta);
            this.currentDataGeometry = this.createGeometryFromMeta(meta);
            if (this.currentDataGeometry == null) {
                this.onImportDataLog("\u672a\u4ece\u5143\u6570\u636e\u89e3\u6790\u5230\u7a7a\u95f4\u8303\u56f4\uff01");
            }
            List fieldList = this.imageDataset.getFields();
            block7: for (String key : meta.keySet()) {
                String matchKey = key.replace(" ", "");
                String matchValue = meta.get(key) == null ? null : meta.get(key);
                for (DatumFieldDTO field : fieldList) {
                    if (!matchKey.equalsIgnoreCase(field.getName()) && !matchKey.equalsIgnoreCase(field.getAliasName())) continue;
                    FieldType type = FieldType.getByValue((Integer)field.getFieldType());
                    Object value = null;
                    if (!StringUtil.isEmptyOrWhiteSpace((String)matchValue)) {
                        switch (type) {
                            case DateTime: {
                                value = ImageDateUtil.parse((String)matchValue);
                                break;
                            }
                            default: {
                                value = matchValue;
                            }
                        }
                    }
                    contents.put(field.getName(), value);
                    continue block7;
                }
            }
        }
        catch (Exception e) {
            this.onImportDataLog("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25\uff01" + e.getMessage());
            throw new RuntimeException("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25!" + e.getMessage(), e);
        }
        return contents;
    }

    @Override
    protected String getSnapshotFile(DmFileData fileData) {
        try {
            List lstFile;
            FileDataUnit metaFile;
            String snapshotFile = "";
            String snapshotDir = this.settingParams.snapshotDir;
            if (!StringUtil.isEmptyOrWhiteSpace((String)snapshotDir)) {
                String[] extensions;
                for (String extension : extensions = new String[]{".tif", ".TIF", ".png", ".PNG", ".jpg", ".JPG"}) {
                    if (Paths.get(snapshotDir, fileData.getDataName() + extension).toFile().exists()) {
                        snapshotFile = Paths.get(snapshotDir, fileData.getDataName() + extension).toString();
                        break;
                    }
                    if (!Paths.get(snapshotDir, fileData.getDataName(), fileData.getDataName() + extension).toFile().exists()) continue;
                    snapshotFile = Paths.get(snapshotDir, fileData.getDataName(), fileData.getDataName() + extension).toString();
                    break;
                }
            }
            if (StringUtil.isEmptyOrWhiteSpace((String)snapshotFile) && (metaFile = (FileDataUnit)ListUtil.find((List)(lstFile = fileData.getFiles()), f -> f.getProperties() != null && f.getProperties().contains("Snapshot"))) != null) {
                snapshotFile = metaFile.getFileSourceLocation();
            }
            if (StringUtil.isEmptyOrWhiteSpace((String)snapshotFile) || !FileUtil.isFileExsit((String)snapshotFile).booleanValue()) {
                this.onImportDataLog("\u5feb\u89c6\u56fe\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            }
            return snapshotFile;
        }
        catch (Exception e) {
            this.onImportDataLog("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25\uff01" + e.getMessage());
            throw new RuntimeException("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25!" + e.getMessage(), e);
        }
    }

    private Map<String, String> readMatchTable() {
        IFileset file = this.scanFileStorage.getFile(this.settingParams.metaDataMatchFile);
        IFileset matchFile = null;
        if (file.getIsDirectory()) {
            List files = file.listFiles();
            if ((files = ListUtil.findAll((List)files, pathname -> pathname.getFullPath().toLowerCase(Locale.ROOT).endsWith(".txt"))) != null && files.size() > 0) {
                matchFile = (IFileset)files.get(0);
            }
        } else {
            if (file.getFullPath().toLowerCase(Locale.ROOT).endsWith(".txt")) {
                matchFile = file;
            }
            if (file.getFullPath().toLowerCase(Locale.ROOT).endsWith(".zip")) {
                File[] files;
                Path destFolderPath = Paths.get(UploadPathConfig.getUploadPath().toString(), UUID.randomUUID().toString().replace("-", ""));
                boolean createSuccess = destFolderPath.toFile().mkdirs();
                ImageDatasetGeneralImportPlugin.extractZip(file, destFolderPath.toString(), null);
                if (destFolderPath.toFile().exists() && (files = destFolderPath.toFile().listFiles(pathname -> pathname.getPath().toLowerCase(Locale.ROOT).endsWith(".txt"))) != null && files.length > 0) {
                    DirectoryFileStorage storage = new DirectoryFileStorage(destFolderPath.toString(), null, null);
                    matchFile = storage.getFile(files[0].getAbsolutePath());
                }
            }
        }
        if (matchFile == null) {
            this.onImportDataLog("\u65e0\u5143\u6570\u636e\u5339\u914d\u6587\u4ef6\u3002");
            return new HashMap<String, String>(0);
        }
        this.onImportDataLog("\u5143\u6570\u636e\u5339\u914d\u6587\u4ef6\uff1a" + matchFile.getFullPath());
        return ImageMetaDataReader.readMeta(matchFile);
    }

    /*
     * Loose catch block
     */
    private static boolean extractZip(IFileset targetFileFullName, String destFolderPath, String formatOption) {
        boolean bl;
        FileOutputStream out = null;
        ArrayList<String> formatList = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)formatOption)) {
            String[] formatArray;
            for (String format : formatArray = formatOption.split(" ")) {
                formatList.add(format.toLowerCase(Locale.ROOT));
            }
        }
        try {
            ZipEntry entry;
            ZipInputStream zIn = new ZipInputStream(targetFileFullName.openFileStream(), Charset.forName("GBK"));
            while ((entry = zIn.getNextEntry()) != null) {
                int len;
                if (entry.isDirectory()) continue;
                String zipEntryName = entry.getName();
                String filePath = Paths.get(destFolderPath, zipEntryName).toString();
                File file = new File(filePath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (file.isDirectory()) {
                    file.mkdirs();
                }
                String extension = FileUtil.getExtension((String)zipEntryName).toLowerCase(Locale.ROOT);
                if (formatList.size() != 0 && !formatList.contains(extension)) continue;
                out = new FileOutputStream(filePath);
                byte[] buf1 = new byte[1024];
                while ((len = zIn.read(buf1)) > 0) {
                    ((OutputStream)out).write(buf1, 0, len);
                }
                ((OutputStream)out).close();
            }
            zIn.close();
            bl = true;
        }
        catch (Exception e) {
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
            boolean entry = ImageDatasetGeneralImportPlugin.unZipFilesByZipArchiveInputStream(targetFileFullName, destFolderPath, formatOption);
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
            return entry;
            {
                catch (Exception ex) {
                    try {
                        throw new RuntimeException("\u89e3\u538b\u6570\u636e\u5931\u8d25\uff01" + e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
                        throw throwable;
                    }
                }
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
        return bl;
    }

    private static boolean unZipFilesByZipArchiveInputStream(IFileset targetFileFullName, String destFolderPath, String formatOption) {
        boolean bl;
        InputStream in = null;
        FileOutputStream out = null;
        ZipArchiveInputStream zipIn = null;
        ArrayList<String> formatList = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)formatOption)) {
            String[] formatArray;
            for (String format : formatArray = formatOption.split(" ")) {
                formatList.add(format.toLowerCase(Locale.ROOT));
            }
        }
        try {
            in = targetFileFullName.openFileStream();
            zipIn = new ZipArchiveInputStream(in, "GBK", true);
            ArchiveEntry archiveEntry = zipIn.getNextEntry();
            while (archiveEntry != null) {
                String entryFileName = archiveEntry.getName();
                if (!archiveEntry.isDirectory()) {
                    File entryFile;
                    String entryFilePath = Paths.get(destFolderPath, entryFileName).toString();
                    File file = new File(entryFilePath);
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    if (!(entryFile = new File(entryFilePath)).getParentFile().exists()) {
                        entryFile.getParentFile().mkdirs();
                    }
                    String extension = FileUtil.getExtension((String)entryFileName).toLowerCase(Locale.ROOT);
                    if (formatList.size() == 0 || formatList.contains(extension)) {
                        int len;
                        out = new FileOutputStream(entryFile);
                        byte[] buf1 = new byte[1024];
                        while ((len = zipIn.read(buf1)) > 0) {
                            ((OutputStream)out).write(buf1, 0, len);
                        }
                        ((OutputStream)out).close();
                    }
                }
                archiveEntry = zipIn.getNextEntry();
            }
            zipIn.close();
            in.close();
            bl = true;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u89e3\u538b\u6570\u636e\u5931\u8d25\uff01" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{zipIn, in, out});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{zipIn, in, out});
        return bl;
    }
}

