/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin;

import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.basic.util.XmlUtil;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dto.dataset.ImageGeoDatasetDTO;
import com.geoway.imagedb.dataset.util.FileReadUtil;
import com.geoway.imagedb.input.plugin.ImageDatasetImportPluginBase;
import com.geoway.webstore.input.plugin.model.ExecuteResult;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageSampleImportPlugin
extends ImageDatasetImportPluginBase {
    private ImageGeoDatasetDTO sampleDatasetDTO = null;
    private IMosaicDataset sampleMosaicDataset = null;
    private IFeatureClass lableFeatureClass = null;
    private IFeatureClass rangeFeatureClass = null;
    protected IFeatureClass businessFeatureClass;
    private ISpatialReferenceSystem srcSpatialReferenceSystem = null;
    private String imagePath = null;
    private String oldImagePath = null;
    private String lablShpPath = null;
    private String rangeShpPaeth = null;

    @Override
    public ExecuteResult prepareImport() {
        ExecuteResult result = super.prepareImport();
        if (result.getSuccess().booleanValue()) {
            this.sampleDatasetDTO = (ImageGeoDatasetDTO)this.imageDataset;
            if (this.sampleDatasetDTO.getSubsets() == null) {
                result.setSuccess(Boolean.valueOf(false));
                result.setErrorMessage("\u76ee\u6807\u5b50\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
                return result;
            }
            DatasetDTO imgDatasetDTO = (DatasetDTO)this.sampleDatasetDTO.getSubsets().get("img");
            if (imgDatasetDTO != null) {
                this.sampleMosaicDataset = this.targetWorkspace.openMosaicDataset(imgDatasetDTO.getName());
            }
            if (this.sampleMosaicDataset == null) {
                result.setSuccess(Boolean.valueOf(false));
                result.setErrorMessage("\u6837\u672c\u5f71\u50cf\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01");
                return result;
            }
            DatasetDTO labelDatasetDTO = (DatasetDTO)this.sampleDatasetDTO.getSubsets().get("label");
            if (labelDatasetDTO != null) {
                this.lableFeatureClass = this.targetWorkspace.openFeatureClass(labelDatasetDTO.getName());
            }
            if (this.lableFeatureClass == null) {
                result.setSuccess(Boolean.valueOf(false));
                result.setErrorMessage("\u6837\u672c\u6807\u7b7e\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01");
                return result;
            }
            DatasetDTO rangeDatasetDTO = (DatasetDTO)this.sampleDatasetDTO.getSubsets().get("range");
            if (rangeDatasetDTO != null) {
                this.rangeFeatureClass = this.targetWorkspace.openFeatureClass(rangeDatasetDTO.getName());
            }
            if (this.rangeFeatureClass == null) {
                result.setSuccess(Boolean.valueOf(false));
                result.setErrorMessage("\u6837\u672c\u8303\u56f4\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01");
                return result;
            }
            this.businessFeatureClass = this.businessSnapshotWorkspace.openFeatureClass("tb_sample_data");
            if (this.businessFeatureClass == null) {
                result.setSuccess(Boolean.valueOf(false));
                result.setErrorMessage("\u6253\u5f00\u4e1a\u52a1\u6837\u672c\u6570\u636e\u96c6\u5931\u8d25\uff01");
                return result;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map<String, Object> getMetaData(DmFileData fileData) {
        this.imagePath = null;
        this.oldImagePath = null;
        FileDataUnit dataUnit = (FileDataUnit)ListUtil.find((List)fileData.getFiles(), FileDataUnit::isMainFile);
        String metaFile = dataUnit.getFileLocation();
        IFileset metaFileset = this.scanFileStorage.getFile(metaFile);
        if (metaFileset == null) {
            throw new RuntimeException(metaFile + "\u4e3b\u6570\u636e\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        try (InputStream metadataFileStream = metaFileset.openFileStream();){
            String imagePath;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(metadataFileStream);
            Element root = document.getDocumentElement();
            NodeList imgInfoNodes = XmlUtil.findNodeList((Node)root, (String)"ImgInfos/ImgInfo");
            Element newImgInfoElement = null;
            Element oldImgInfoElement = null;
            if (imgInfoNodes.getLength() > 0) {
                for (int i = 0; i < imgInfoNodes.getLength(); ++i) {
                    Element tileInfoElement = (Element)imgInfoNodes.item(i);
                    Attr attr = tileInfoElement.getAttributeNode("type");
                    if (attr == null || "new".equals(attr.getValue())) {
                        newImgInfoElement = tileInfoElement;
                    }
                    if (attr == null || !"old".equals(attr.getValue())) continue;
                    oldImgInfoElement = tileInfoElement;
                }
            }
            if (newImgInfoElement == null) {
                throw new RuntimeException("\u6ca1\u6709\u5f71\u50cf\u4fe1\u606f");
            }
            Node geometryInfoNode = XmlUtil.findfirstNode(newImgInfoElement, (String)"GeometryInfo");
            if (geometryInfoNode != null) {
                String projection;
                NodeList geoPointNodes = XmlUtil.findNodeList((Node)geometryInfoNode, (String)"ValidRange/GeoPoint");
                if (geoPointNodes.getLength() >= 4) {
                    ArrayList<String> geoCoords = new ArrayList<String>();
                    for (int i = 0; i < geoPointNodes.getLength(); ++i) {
                        Element geoPointElement = (Element)geoPointNodes.item(i);
                        geoCoords.add(geoPointElement.getAttribute("X") + " " + geoPointElement.getAttribute("Y"));
                    }
                    geoCoords.add((String)geoCoords.get(0));
                    this.currentDataGeometry = GeometryFunc.createGeometry((String)String.format("POLYGON((%s))", String.join((CharSequence)",", geoCoords)));
                }
                if (StringUtil.isNotEmpty((String)(projection = XmlUtil.findfirstNodeStringValue((Node)geometryInfoNode, (String)"Projection")))) {
                    this.srcSpatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((String)projection);
                }
            }
            if (this.currentDataGeometry == null) {
                throw new RuntimeException("\u5143\u6570\u636e\u51e0\u4f55\u56fe\u5f62\u91c7\u96c6\u5931\u8d25");
            }
            String imageName = XmlUtil.findfirstNodeStringValue(newImgInfoElement, (String)"BaseInfo/ImageName");
            metaData.put("ImageName", imageName);
            metaData.put("BandNum", XmlUtil.findfirstNodeStringValue((Node)newImgInfoElement, (String)"BaseInfo/BandNum"));
            metaData.put("BandBits", XmlUtil.findfirstNodeStringValue((Node)newImgInfoElement, (String)"BaseInfo/BandBits"));
            metaData.put("SatelliteName", XmlUtil.findfirstNodeStringValue((Node)newImgInfoElement, (String)"BaseInfo/SatelliteName"));
            metaData.put("SensorType", XmlUtil.findfirstNodeStringValue((Node)newImgInfoElement, (String)"BaseInfo/SensorType"));
            metaData.put("ImageTime", XmlUtil.findfirstNodeStringValue((Node)newImgInfoElement, (String)"BaseInfo/ImageTime"));
            metaData.put("PixelSize", XmlUtil.findfirstNodeStringValue((Node)newImgInfoElement, (String)"BaseInfo/PixelSize"));
            Node imageSourceNode = XmlUtil.findfirstNode((Node)newImgInfoElement, (String)"ImageSource");
            if (imageSourceNode != null) {
                metaData.put("ImageSource", ((Element)imageSourceNode).getAttribute("Value"));
            }
            if (StringUtil.isNotEmpty((String)(imagePath = XmlUtil.findfirstNodeStringValue((Node)newImgInfoElement, (String)"Path")))) {
                imagePath = FileReadUtil.convertToAbsolutePath((String)metaFile, (String)imagePath);
            }
            if (!FileUtil.isFileExsit((String)imagePath).booleanValue()) {
                this.onImportDataLog("\u5f71\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + imagePath);
                imagePath = this.queryImageByName(imageName);
                if (imagePath == null) {
                    throw new RuntimeException("\u672a\u67e5\u627e\u5230\u5f71\u50cf\uff1a" + imageName);
                }
            }
            this.imagePath = imagePath;
            if (oldImgInfoElement != null) {
                String oldImagePath;
                String oldImageName = XmlUtil.findfirstNodeStringValue((Node)oldImgInfoElement, (String)"BaseInfo/ImageName");
                metaData.put("OldImageName", oldImageName);
                metaData.put("OldBandNum", XmlUtil.findfirstNodeStringValue((Node)oldImgInfoElement, (String)"BaseInfo/BandNum"));
                metaData.put("OldBandBits", XmlUtil.findfirstNodeStringValue((Node)oldImgInfoElement, (String)"BaseInfo/BandBits"));
                metaData.put("OldSatelliteName", XmlUtil.findfirstNodeStringValue((Node)oldImgInfoElement, (String)"BaseInfo/SatelliteName"));
                metaData.put("OldSensorType", XmlUtil.findfirstNodeStringValue((Node)oldImgInfoElement, (String)"BaseInfo/SensorType"));
                metaData.put("OldImageTime", XmlUtil.findfirstNodeStringValue((Node)oldImgInfoElement, (String)"BaseInfo/ImageTime"));
                metaData.put("OldPixelSize", XmlUtil.findfirstNodeStringValue((Node)oldImgInfoElement, (String)"BaseInfo/PixelSize"));
                Node oldImageSourceNode = XmlUtil.findfirstNode((Node)oldImgInfoElement, (String)"ImageSource");
                if (oldImageSourceNode != null) {
                    metaData.put("OldImageSource", ((Element)oldImageSourceNode).getAttribute("Value"));
                }
                if (StringUtil.isNotEmpty((String)(oldImagePath = XmlUtil.findfirstNodeStringValue((Node)oldImgInfoElement, (String)"Path")))) {
                    oldImagePath = FileReadUtil.convertToAbsolutePath((String)metaFile, (String)oldImagePath);
                }
                if (!FileUtil.isFileExsit((String)oldImagePath).booleanValue()) {
                    this.onImportDataLog("\u5f71\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + oldImagePath);
                    oldImagePath = this.queryImageByName(oldImageName);
                    if (oldImagePath == null) {
                        throw new RuntimeException("\u672a\u67e5\u627e\u5230\u524d\u4e00\u671f\u5f71\u50cf\uff1a" + oldImageName);
                    }
                }
                this.oldImagePath = oldImagePath;
            }
            Node classInfoNode = XmlUtil.findfirstNode((Node)root, (String)"SampleLabel/ClassInfo");
            StringBuilder classIds = new StringBuilder();
            if (classInfoNode != null && classInfoNode.hasChildNodes()) {
                NodeList classNodes = classInfoNode.getChildNodes();
                for (int i = 0; i < classNodes.getLength(); ++i) {
                    Node classNode = classNodes.item(i);
                    if (classNode.getNodeType() != 1) continue;
                    Element classElement = (Element)classNode;
                    classIds.append(classElement.getAttribute("ClassID")).append(",");
                }
            }
            metaData.put("ClassID", classIds.toString());
            this.lablShpPath = XmlUtil.findfirstNodeStringValue((Node)root, (String)"SampleLabel/Path");
            if (StringUtil.isNotEmpty((String)this.lablShpPath)) {
                this.lablShpPath = FileReadUtil.convertToAbsolutePath((String)metaFile, (String)this.lablShpPath);
            }
            this.rangeShpPaeth = XmlUtil.findfirstNodeStringValue((Node)root, (String)"SampleRegion/Path");
            if (StringUtil.isNotEmpty((String)this.rangeShpPaeth)) {
                this.rangeShpPaeth = FileReadUtil.convertToAbsolutePath((String)metaFile, (String)this.rangeShpPaeth);
            }
            metaData.put("SceneType", this.targetParams.sampleSceneType);
            metaData.put("SampleScheme", this.targetParams.sampleScheme);
            HashMap<String, Object> hashMap = metaData;
            return hashMap;
        }
        catch (Exception e) {
            throw new RuntimeException(fileData.getMainPath() + "\u5143\u6570\u636e\u6587\u4ef6\u89e3\u6790\u5931\u8d25:" + e.getMessage(), e);
        }
    }

    @Override
    protected String getSnapshotFile(DmFileData fileData) {
        return null;
    }

    @Override
    protected void addThumb(String dataId) {
    }

    @Override
    protected Boolean processRepeatedData(Map<String, Object> metaRow) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean writeMetaData(String dataId, Map<String, Object> metaRow, DmFileData fileData, RefObject<String> errorMsg) {
        this.currentDataId = dataId;
        this.currentFileData = fileData;
        boolean success = true;
        errorMsg.set((Object)"");
        try {
            IFeatureClass targetFc = (IFeatureClass)this.targetGeoDataset;
            IGeometry extentGeometry = this.currentDataGeometry;
            if (this.currentDataGeometry != null) {
                extentGeometry = this.currentDataGeometry.projectToCopy(this.srcSpatialReferenceSystem, targetFc.getSpatialReferenceSystem());
            }
            this.insertFeature(targetFc, metaRow, extentGeometry);
            IRasterDataset sourceRasterDataset = this.openRasterDataset(this.imagePath);
            try {
                if (sourceRasterDataset == null) {
                    errorMsg.set((Object)((String)errorMsg.get() + this.imagePath + " \u6253\u5f00\u5931\u8d25\uff01"));
                    boolean bl = false;
                    return bl;
                }
                HashMap<String, Object> imageValues = new HashMap<String, Object>();
                imageValues.put("ImageType", "new");
                imageValues.put("ImageName", metaRow.get("ImageName"));
                imageValues.put("BandNum", metaRow.get("BandNum"));
                imageValues.put("BandBits", metaRow.get("BandBits"));
                imageValues.put("SatelliteName", metaRow.get("SatelliteName"));
                imageValues.put("SensorType", metaRow.get("SensorType"));
                imageValues.put("ImageTime", metaRow.get("ImageTime"));
                imageValues.put("PixelSize", metaRow.get("PixelSize"));
                imageValues.put("ImageSource", metaRow.get("ImageSource"));
                imageValues.put("F_DATAID", dataId);
                this.insertRaster(this.sampleMosaicDataset, sourceRasterDataset, imageValues, null, null);
            }
            catch (Exception e) {
                this.log.error(this.imagePath + " \u5f53\u671f\u5f71\u50cf\u5199\u5165\u5931\u8d25", (Throwable)e);
                errorMsg.set((Object)((String)errorMsg.get() + this.imagePath + " \u5f53\u671f\u5f71\u50cf\u5199\u5165\u5931\u8d25\uff01"));
                boolean bl = false;
                return bl;
            }
            finally {
                sourceRasterDataset.closeRaster();
            }
            if (StringUtil.isNotEmpty((String)this.oldImagePath)) {
                IRasterDataset oldRasterDataset = this.openRasterDataset(this.oldImagePath);
                try {
                    if (oldRasterDataset == null) {
                        errorMsg.set((Object)((String)errorMsg.get() + this.oldImagePath + " \u6253\u5f00\u5931\u8d25\uff01"));
                        boolean bl = false;
                        return bl;
                    }
                    HashMap<String, Object> imageValues = new HashMap<String, Object>();
                    imageValues.put("ImageType", "old");
                    imageValues.put("ImageName", metaRow.get("OldImageName"));
                    imageValues.put("BandNum", metaRow.get("OldBandNum"));
                    imageValues.put("BandBits", metaRow.get("OldBandBits"));
                    imageValues.put("SatelliteName", metaRow.get("OldSatelliteName"));
                    imageValues.put("SensorType", metaRow.get("OldSensorType"));
                    imageValues.put("ImageTime", metaRow.get("OldImageTime"));
                    imageValues.put("PixelSize", metaRow.get("OldPixelSize"));
                    imageValues.put("ImageSource", metaRow.get("OldImageSource"));
                    imageValues.put("F_DATAID", dataId);
                    this.insertRaster(this.sampleMosaicDataset, oldRasterDataset, imageValues, null, null);
                }
                catch (Exception e) {
                    this.log.error(this.imagePath + " \u4e0a\u4e00\u671f\u5f71\u50cf\u5199\u5165\u5931\u8d25", (Throwable)e);
                    errorMsg.set((Object)((String)errorMsg.get() + this.imagePath + " \u4e0a\u4e00\u671f\u5f71\u50cf\u5199\u5165\u5931\u8d25\uff01"));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    oldRasterDataset.closeRaster();
                }
            }
            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
            defaultValues.put("F_DATAID", dataId);
            TransferResult labelResult = this.inputFeatureClass(this.lablShpPath, this.lableFeatureClass, defaultValues);
            if (!labelResult.isSuccess()) {
                errorMsg.set((Object)("\u6837\u672c\u6807\u7b7e\u5165\u5e93\u5931\u8d25!" + labelResult.getErrorMessage()));
                return false;
            }
            TransferResult rangeResult = this.inputFeatureClass(this.rangeShpPaeth, this.rangeFeatureClass, defaultValues);
            if (!rangeResult.isSuccess()) {
                errorMsg.set((Object)("\u6837\u672c\u6807\u7b7e\u5165\u5e93\u5931\u8d25!" + rangeResult.getErrorMessage()));
                return false;
            }
        }
        catch (Exception e) {
            this.log.error("\u5143\u6570\u636e\u63d2\u5165\u5931\u8d25", (Throwable)e);
            errorMsg.set((Object)e.getMessage());
            success = false;
        }
        if (!success) return success;
        try {
            Map<String, Object> businessValues = this.getBusinessValues(metaRow);
            IGeometry businessGeometry = this.currentDataGeometry.projectToCopy(this.srcSpatialReferenceSystem, this.businessFeatureClass.getSpatialReferenceSystem());
            this.insertFeature(this.businessFeatureClass, businessValues, businessGeometry);
            return success;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            errorMsg.set((Object)((String)errorMsg.get() + "\u6837\u672c\u6570\u636e\u5165\u5e93\u5931\u8d25\uff01" + e.getMessage()));
            this.onImportDataLog("\u6837\u672c\u6570\u636e\u5165\u5e93\u5931\u8d25\uff01" + e.getMessage());
            return false;
        }
    }

    @Override
    protected Map<String, Object> getBusinessValues(Map<String, Object> meta) {
        Map<String, Object> values = super.getBusinessValues(meta);
        for (Map.Entry<String, Object> entry : meta.entrySet()) {
            if (values.containsKey(entry.getKey())) continue;
            values.put(entry.getKey(), entry.getValue());
        }
        return values;
    }

    @Override
    protected void deleteMetaData(String dataId) {
        super.deleteMetaData(dataId);
        try {
            String sql = String.format("delete from %s where %s = '%s'", this.sampleMosaicDataset.getCatalog().getFullName(), "F_DATAID", dataId);
            this.targetWorkspace.excuteSql(sql);
            sql = String.format("delete from %s where %s = '%s'", this.lableFeatureClass.getFullName(), "F_DATAID", dataId);
            this.targetWorkspace.excuteSql(sql);
            sql = String.format("delete from %s where %s = '%s'", this.rangeFeatureClass.getFullName(), "F_DATAID", dataId);
            this.targetWorkspace.excuteSql(sql);
        }
        catch (Exception e) {
            this.log.error("\u5220\u9664\u5f71\u50cf\u5173\u8054\u6570\u636e\u5f02\u5e38", (Throwable)e);
            this.onImportDataLog("\u5220\u9664\u5f71\u50cf\u5173\u8054\u6570\u636e\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    @Override
    public void importFinised() {
        if (null == this.targetWorkspace) {
            return;
        }
        if (this.dataPackage != null) {
            this.dataPackage.getArchiveEnvironment().dispose();
        }
        try {
            this.dataSourceStatisticService.datasetStatistic(this.imageDataset.getId());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.targetGeoDataset != null) {
                IFeatureClass targetFc = (IFeatureClass)this.targetGeoDataset;
                targetFc.updateExtent();
                if (Boolean.TRUE.equals(this.sourceParams.getAutoCreateIndex())) {
                    DatasetDTO geoDataset;
                    this.publishVectorService(this.imageDataset.getGeoDatasetId(), this.imageDataset.getName(), targetFc);
                    if (this.lableFeatureClass != null) {
                        geoDataset = (DatasetDTO)this.sampleDatasetDTO.getSubsets().get("label");
                        this.publishVectorService(geoDataset.getId(), geoDataset.getName(), this.lableFeatureClass);
                    }
                    if (this.rangeFeatureClass != null) {
                        geoDataset = (DatasetDTO)this.sampleDatasetDTO.getSubsets().get("range");
                        this.publishVectorService(geoDataset.getId(), geoDataset.getName(), this.rangeFeatureClass);
                    }
                    if (this.sampleMosaicDataset != null) {
                        geoDataset = (DatasetDTO)this.sampleDatasetDTO.getSubsets().get("img");
                        this.publishMosaicService(geoDataset.getId(), geoDataset.getName(), false);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u5165\u5e93\u540e\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            this.onImportUnitLog(e.getMessage());
        }
    }

    protected TransferResult inputFeatureClass(String sourceFile, IFeatureClass targetFeatureClass, Map<String, Object> defaultValues) {
        IFeatureWorkspace srcWorkspace = null;
        Date startTime = new Date();
        try {
            srcWorkspace = this.fileStorageService.openFileLayerWorkspace(sourceFile);
            IFeatureClass srcFeatureClass = srcWorkspace.openFeatureClass(FileUtil.getFileNameWithoutExtension((String)sourceFile));
            if (srcFeatureClass == null) {
                TransferResult result = new TransferResult();
                result.setSuccess(false);
                result.setErrorMessage(sourceFile + "\u6253\u5f00\u5931\u8d25");
                return result;
            }
            VectorDataTransfer vectorDataTransfer = new VectorDataTransfer();
            vectorDataTransfer.setDefaultValues(defaultValues);
            RefObject errorMsg = new RefObject();
            vectorDataTransfer.setErrorCallback(msg -> {
                this.log.error(msg);
                this.onImportDataLog((String)msg);
                errorMsg.set(msg);
            });
            vectorDataTransfer.setCancelCallback(() -> super.isStopped());
            TransferResult result = vectorDataTransfer.copyFeature(srcFeatureClass, targetFeatureClass, null);
            if (StringUtil.isNotEmpty((String)((String)errorMsg.get())) && StringUtil.isEmptyOrWhiteSpace((String)result.getErrorMessage())) {
                result.setErrorMessage((String)errorMsg.get());
            }
            Date endTime = new Date();
            String text = DateTimeUtil.getTimeIntervalStr((Date)startTime, (Date)endTime);
            this.onImportDataLog(String.format("%s\u5165\u5e93[%s]%s\uff1a\u5171%s\u4e2a\uff0c\u6210\u529f%s\u4e2a\uff0c\u5931\u8d25%s\u4e2a\u3002\u603b\u8017\u65f6:%s", sourceFile, targetFeatureClass.getName(), result.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25", result.getTotalCount(), result.getSuccessCount(), result.getFailCount(), text));
            return result;
        }
        catch (Exception e) {
            this.log.error(sourceFile + "\u5165\u5e93\u5931\u8d25", (Throwable)e);
            TransferResult result = new TransferResult();
            result.setSuccess(false);
            result.setErrorMessage(sourceFile + "\u5165\u5e93\u5931\u8d25\uff1a" + e.getMessage());
            return result;
        }
    }

    private String queryImageByName(String imageName) {
        try {
            Object path = this.businessSnapshotWorkspace.queryScalar(String.format("select urihash from %s where %s='%s' and %s=%d", this.businessSnapshotDataset.getCatalog().getName(), "F_DATANAME", imageName, "f_image_type", ImageDatasetTypeEnum.ProcessedImageDataset.getValue()), new Object[0]);
            if (path != null && !path.toString().isEmpty()) {
                return path.toString();
            }
            return null;
        }
        catch (Exception e) {
            this.log.error(imageName + "\u67e5\u8be2\u5f71\u50cf\u5931\u8d25", (Throwable)e);
            this.onImportDataLog(imageName + "\u67e5\u8be2\u5f71\u50cf\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
    }
}

