/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin.meta.zy;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.imagedb.input.plugin.meta.MetaPluginManager;
import com.geoway.imagedb.input.plugin.meta.zy.ZY1EOriginData;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZY3FOriginData
extends ZY1EOriginData {
    private static final Logger log = LoggerFactory.getLogger(ZY3FOriginData.class);

    @Override
    protected Map<String, Object> readMetaDataAbstract(DmFileData fileData, IFileStorage scanFileStorage) {
        FileInputStream in;
        TarInputStream tarIn;
        block14: {
            String dataName = fileData.getDataName();
            FileDataUnit dataUnit = (FileDataUnit)ListUtil.find((List)fileData.getFiles(), FileDataUnit::isMainFile);
            String path = dataUnit.getFileSourceLocation();
            this.metaData = new HashMap(0);
            tarIn = null;
            FileOutputStream out = null;
            in = null;
            try {
                if (dataName.toLowerCase(Locale.ROOT).endsWith(".tar")) {
                    dataName = FileUtil.getFileNameWithoutExtension((String)dataName);
                }
                File tarGzFile = new File(path);
                tarIn = new TarInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(new FileInputStream(tarGzFile))), 2048);
                TarEntry entry = null;
                String guid = UUID.randomUUID().toString().replace("-", "");
                String snapshotDir = MetaPluginManager.getSnapshotUnZipDir().toString();
                this.tifTempDir = Paths.get(snapshotDir, guid).toString();
                File tempDir = new File(this.tifTempDir);
                tempDir.mkdirs();
                ArrayList<String> allFiles = new ArrayList<String>();
                while ((entry = tarIn.getNextEntry()) != null) {
                    int len;
                    String entryName = entry.getName();
                    String filePath = Paths.get(this.tifTempDir, entryName).toString();
                    if (entry.isDirectory()) {
                        new File(filePath).mkdirs();
                        continue;
                    }
                    if (!entryName.toLowerCase(Locale.ROOT).endsWith(".xml") && !entryName.toLowerCase(Locale.ROOT).endsWith(".jpg") || entryName.toLowerCase(Locale.ROOT).endsWith(".aux.xml") || entryName.toLowerCase(Locale.ROOT).endsWith("_thumb.jpg")) continue;
                    allFiles.add(filePath);
                    out = new FileOutputStream(filePath);
                    byte[] buf1 = new byte[2048];
                    while ((len = tarIn.read(buf1)) > 0) {
                        ((OutputStream)out).write(buf1, 0, len);
                    }
                    ((OutputStream)out).close();
                    out = null;
                }
                tarIn.close();
                tarIn = null;
                for (String filePath : allFiles) {
                    File metaFile;
                    if (!filePath.toLowerCase(Locale.ROOT).endsWith(".xml") || !Paths.get((metaFile = new File(filePath)).getParent(), FileUtil.getFileNameWithoutExtension((String)filePath) + ".jpg").toFile().exists()) continue;
                    in = new FileInputStream(filePath);
                    this.readMetaDataFromXML(in, FileUtil.getFileNameWithoutExtension((String)filePath));
                    ((InputStream)in).close();
                    in = null;
                    break;
                }
                if (out == null) break block14;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25\uff01" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
                    }
                    if (tarIn != null) {
                        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{tarIn});
                    }
                    if (in != null) {
                        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{in});
                    }
                    throw throwable;
                }
            }
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
        }
        if (tarIn != null) {
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{tarIn});
        }
        if (in != null) {
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{in});
        }
        return this.metaData;
    }
}

