/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin.meta.gf;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.imagedb.input.plugin.meta.ImageMetaDataPluginBase;
import com.geoway.imagedb.input.plugin.meta.MetaPluginManager;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GF7OriginData
extends ImageMetaDataPluginBase {
    private static final Logger log = LoggerFactory.getLogger(GF7OriginData.class);

    @Override
    protected Map<String, Object> readMetaDataAbstract(DmFileData fileData, IFileStorage scanFileStorage) {
        TarInputStream tarIn;
        block13: {
            String dataName = fileData.getDataName();
            FileDataUnit dataUnit = (FileDataUnit)ListUtil.find((List)fileData.getFiles(), FileDataUnit::isMainFile);
            String path = dataUnit.getFileSourceLocation();
            this.metaData = new HashMap(0);
            tarIn = null;
            OutputStream out = null;
            ByteArrayInputStream in = null;
            try {
                if (dataName.toLowerCase(Locale.ROOT).endsWith(".tar")) {
                    dataName = FileUtil.getFileNameWithoutExtension((String)dataName);
                }
                File tarGzFile = new File(path);
                tarIn = new TarInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(new FileInputStream(tarGzFile))), 2048);
                TarEntry entry = null;
                String guid = UUID.randomUUID().toString().replace("-", "");
                String snapshotDir = MetaPluginManager.getSnapshotUnZipDir().toString();
                this.tifTempDir = Paths.get(snapshotDir, guid).toString();
                File tempDir = new File(this.tifTempDir);
                tempDir.mkdirs();
                while ((entry = tarIn.getNextEntry()) != null) {
                    int len;
                    byte[] buf1;
                    String entryName = entry.getName();
                    String filePath = Paths.get(this.tifTempDir, entryName).toString();
                    if (entry.isDirectory()) {
                        new File(filePath).mkdirs();
                        continue;
                    }
                    if (entryName.equalsIgnoreCase(dataName + ".xml")) {
                        out = new ByteArrayOutputStream();
                        buf1 = new byte[2048];
                        while ((len = tarIn.read(buf1)) > 0) {
                            out.write(buf1, 0, len);
                        }
                        String content = out.toString();
                        content = content.replace("\u0000", "");
                        in = new ByteArrayInputStream(content.getBytes());
                        this.readMetaDataFromXML(in, FileUtil.getFileNameWithoutExtension((String)entryName));
                        out.close();
                        ((InputStream)in).close();
                        continue;
                    }
                    if (!entryName.equalsIgnoreCase(dataName + ".jpg")) continue;
                    out = new FileOutputStream(filePath);
                    buf1 = new byte[2048];
                    while ((len = tarIn.read(buf1)) > 0) {
                        out.write(buf1, 0, len);
                    }
                    out.close();
                    out = null;
                }
                tarIn.close();
                tarIn = null;
                if (out == null) break block13;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25\uff01" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
                    }
                    if (tarIn != null) {
                        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{tarIn});
                    }
                    throw throwable;
                }
            }
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
        }
        if (tarIn != null) {
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{tarIn});
        }
        return this.metaData;
    }
}

