/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseDTO;
import com.geoway.adf.dms.datasource.service.DatumDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.imagedb.input.plugin.ImageGeoDatasetSettingParams;
import com.geoway.imagedb.input.plugin.ImageGeoDatasetTargetParams;
import com.geoway.imagedb.input.service.ImageImportTaskCreateService;
import com.geoway.webstore.input.dto.ImpSchemaDTO;
import com.geoway.webstore.input.dto.ImpTaskCreateDTO;
import com.geoway.webstore.input.plugin.model.DataDuplicateStrategyEnum;
import com.geoway.webstore.input.plugin.params.ImportSourceParams;
import com.geoway.webstore.input.service.ImpSchemeService;
import com.geoway.webstore.input.service.ImpTaskService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImageImportTaskCreateServiceImpl
implements ImageImportTaskCreateService {
    private static final Logger log = LoggerFactory.getLogger(ImageImportTaskCreateServiceImpl.class);
    @Resource
    private ImpSchemeService impSchemeService;
    @Resource
    private ImpTaskService impTaskService;
    @Resource
    private DatumDatabaseService datumDatabaseService;
    @Resource
    private LoginUserService userInfoService;

    @Override
    public String createImportTask(String schemaName, String dataPath) {
        ImpSchemaDTO schemaDetail = this.impSchemeService.getSchemaDetailByName(schemaName);
        String targetParamsStr = schemaDetail.getParamValues();
        ImageGeoDatasetTargetParams targetParams = (ImageGeoDatasetTargetParams)JSONObject.parseObject((String)targetParamsStr, ImageGeoDatasetTargetParams.class);
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)targetParams.datasetId);
        DatumDatabaseDTO datumDatabaseDTO = this.datumDatabaseService.getDatumDatabaseDetail(nameInfo.getDsKey());
        List fileStorageList = datumDatabaseDTO.getFileStorage();
        DataSourceDTO fileStorage = (DataSourceDTO)fileStorageList.get(0);
        if (!dataPath.contains(fileStorage.getUrl())) {
            throw new RuntimeException("\u6570\u636e\u4f4d\u7f6e\u4e0e\u5b58\u50a8\u8282\u70b9\u4e0d\u5339\u914d\uff01");
        }
        ImpTaskCreateDTO createDTO = new ImpTaskCreateDTO();
        createDTO.setName(String.format("%s-%s", schemaName, DateTimeUtil.dateString((String)"yyyyMMddHH:mm")));
        createDTO.setSchemaId(schemaDetail.getId());
        LoginUserInfo userInfo = this.userInfoService.getUserInfo(null);
        String userName = userInfo.getUserName();
        createDTO.setCreateUser(userName);
        createDTO.setCreateUser("\u751f\u4ea7\u7cfb\u7edf");
        ImageGeoDatasetSettingParams settingParams = new ImageGeoDatasetSettingParams();
        settingParams.serviceId = fileStorage.getKey();
        settingParams.sourceFolderPath = dataPath;
        createDTO.setSettingParams(JSONObject.toJSONString((Object)settingParams));
        ImportSourceParams sourceParams = new ImportSourceParams();
        sourceParams.setAutoCreateIndex(Boolean.valueOf(true));
        sourceParams.setDataDuplicateStrategy(Integer.valueOf(DataDuplicateStrategyEnum.Delete.getValue()));
        createDTO.setSourceParams(JSONObject.toJSONString((Object)sourceParams));
        createDTO.setStartTask(Boolean.valueOf(true));
        Long taskId = this.impTaskService.createTask(createDTO);
        return taskId + "";
    }
}

