/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin.meta;

import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.imagedb.input.plugin.meta.IImageMetaDataPlugin;
import com.geoway.imagedb.input.plugin.meta.MetaPluginInfo;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaPluginManager {
    private static final Logger log = LoggerFactory.getLogger(MetaPluginManager.class);

    public static IImageMetaDataPlugin createImageMetaDataPlugin(MetaPluginInfo pluginInfo) throws Exception {
        Class<?> aClass = Class.forName(pluginInfo.getPluginClassName());
        IImageMetaDataPlugin imageMetaDataPlugin = (IImageMetaDataPlugin)aClass.newInstance();
        imageMetaDataPlugin.setConfigFile(pluginInfo.getConfigFile());
        return imageMetaDataPlugin;
    }

    public static Path getSnapshotUnZipDir() {
        Path snapshotPath = Paths.get(EnvironmentConfig.getProperty((String)"project.image-snapshot-unZip", (String)"snapshot"), new String[0]);
        try {
            File file = snapshotPath.toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception e) {
            log.error("\u5feb\u89c6\u56fe\u89e3\u538b\u76ee\u5f55\u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
        return snapshotPath;
    }
}

