/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.service.impl;

import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.imagedb.input.dto.automatic.AutomaticTaskSimpleDTO;
import com.geoway.imagedb.input.dto.automatic.ImageProductAutomaticDTO;
import com.geoway.imagedb.input.dto.automatic.ImageProductAutomaticTaskCreateDTO;
import com.geoway.imagedb.input.service.ImageAutomaticTaskService;
import com.geoway.imagedb.input.service.ImageImportTaskCreateService;
import com.geoway.webstore.input.dto.ImpSchemaDTO;
import com.geoway.webstore.input.dto.ImpTaskDTO;
import com.geoway.webstore.input.service.ImpSchemeService;
import com.github.pagehelper.PageInfo;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImageAutomaticTaskServiceImpl
implements ImageAutomaticTaskService {
    private static final Logger log = LoggerFactory.getLogger(ImageAutomaticTaskServiceImpl.class);
    @Resource
    private ImpSchemeService schemeService;
    @Resource
    private ImageImportTaskCreateService imageImportTaskCreateService;

    @Override
    public void updateProductStatus(ImageProductAutomaticDTO automaticDTO) {
    }

    @Override
    public List<AutomaticTaskSimpleDTO> createImportTask(ImageProductAutomaticTaskCreateDTO taskCreateDTO) {
        PageInfo pageInfo = this.schemeService.listSchema(0, 10000, taskCreateDTO.getImportSchemaGroupName(), null, Boolean.valueOf(false), Boolean.valueOf(false));
        List schemaList = pageInfo.getList();
        if (schemaList == null || schemaList.size() == 0) {
            log.error("\u5206\u7ec4\u4e0b[" + taskCreateDTO.getImportSchemaGroupName() + "]\u65e0\u5165\u5e93\u65b9\u6848");
            throw new RuntimeException("\u5206\u7ec4\u4e0b[" + taskCreateDTO.getImportSchemaGroupName() + "]\u65e0\u5165\u5e93\u65b9\u6848");
        }
        String scanDataPath = taskCreateDTO.getDataPath();
        if (Boolean.TRUE.equals(taskCreateDTO.getIsMigrateData())) {
            String migrateDir = EnvironmentConfig.getProperty((String)"project.automatic-image-migrate-path", (String)"");
            if (StringUtil.isEmptyOrWhiteSpace((String)migrateDir)) {
                log.info("automatic-image-migrate-path\u672a\u914d\u7f6e\uff0c\u4f7f\u7528./upload");
                migrateDir = UploadPathConfig.getUploadPath().toAbsolutePath().toString();
            }
            migrateDir = Paths.get(migrateDir, taskCreateDTO.getProductTaskId()).toAbsolutePath().toString();
            FileUtil.copy((String)taskCreateDTO.getDataPath(), (String)migrateDir);
            scanDataPath = migrateDir;
        }
        ArrayList<AutomaticTaskSimpleDTO> taskList = new ArrayList<AutomaticTaskSimpleDTO>();
        for (ImpSchemaDTO schemaDTO : schemaList) {
            try {
                ImpTaskDTO taskDTO = this.imageImportTaskCreateService.createImportTask(schemaDTO, scanDataPath, "\u65e0\u4eba\u503c\u5b88-");
                AutomaticTaskSimpleDTO simpleDTO = new AutomaticTaskSimpleDTO();
                simpleDTO.setImportTaskId(taskDTO.getId() + "");
                simpleDTO.setImportTaskName(taskDTO.getName());
                taskList.add(simpleDTO);
            }
            catch (Exception e) {
                log.error(schemaDTO.getName() + " \u521b\u5efa\u5165\u5e93\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            }
        }
        return taskList;
    }
}

