/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin.meta;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import com.geoway.imagedb.input.plugin.meta.ImageMetaDataPluginBase;
import com.geoway.imagedb.input.plugin.meta.ImageMetaDataReader;
import com.geoway.imagedb.input.plugin.meta.MetaPluginManager;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class CommonMetaDataPlugin
extends ImageMetaDataPluginBase {
    @Override
    protected Map<String, Object> readMetaDataAbstract(DmFileData fileData, IFileStorage scanFileStorage) {
        this.metaData = new HashMap(0);
        try {
            List lstFile = fileData.getFiles();
            List metaFiles = ListUtil.findAll((List)lstFile, f -> f.getProperties() != null && f.getProperties().contains("CKMetaFile"));
            if (metaFiles == null || metaFiles.size() == 0) {
                throw new RuntimeException("\u5143\u6570\u636e\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            ArrayList<String> extensionList = new ArrayList<String>();
            extensionList.add(".mat");
            extensionList.add(".mdb");
            extensionList.add(".txt");
            extensionList.add(".xls");
            extensionList.add(".xlsx");
            for (FileDataUnit metaFile : metaFiles) {
                IFileset fileset = null;
                String fileStorageUrl = scanFileStorage.getStorageUrl().replace("\\", "/");
                String metaFileUrl = metaFile.getFileSourceLocation().replace("\\", "/");
                if (metaFileUrl.startsWith(fileStorageUrl) && scanFileStorage.fileExist(metaFile.getFileSourceLocation())) {
                    fileset = scanFileStorage.getFile(metaFile.getFileSourceLocation());
                } else {
                    DirectoryFileStorage tempFileStorage = new DirectoryFileStorage(metaFile.getFileSourceLocation(), null, null);
                    fileset = tempFileStorage.getFile(metaFile.getFileSourceLocation());
                }
                if (fileset == null) {
                    throw new RuntimeException("\u5143\u6570\u636e\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
                }
                String extension = fileset.getExt();
                if (extension.equalsIgnoreCase(".xml") || extension.equalsIgnoreCase(".safe")) {
                    InputStream fis = fileset.openFileStream();
                    Object object = null;
                    try {
                        this.readMetaDataFromXML(fis, FileUtil.getFileNameWithoutExtension((String)fileset.getName()));
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fis != null) {
                            if (object != null) {
                                try {
                                    fis.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                fis.close();
                            }
                        }
                    }
                }
                if (extensionList.contains(extension.toLowerCase(Locale.ROOT))) {
                    Map<String, String> meta = ImageMetaDataReader.readMeta(fileset);
                    for (String fld : meta.keySet()) {
                        if (this.matchTable.containsKey(fld)) {
                            for (String targetField : (List)this.matchTable.get(fld)) {
                                this.metaData.put(targetField, meta.get(fld));
                            }
                            continue;
                        }
                        this.metaData.put(fld, meta.get(fld));
                    }
                }
                for (String fld : this.defaultValue.keySet()) {
                    if (this.metaData.containsKey(fld)) continue;
                    String value = (String)this.defaultValue.get(fld);
                    if (value.startsWith("${") && value.endsWith("}")) {
                        value = this.readMetaDataFromJs(value.substring(2, value.length() - 1), FileUtil.getFileNameWithoutExtension((String)fileset.getName()));
                    }
                    this.metaData.put(fld, value);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return this.metaData;
    }

    @Override
    public String createSnapshotFile(DmFileData fileData, IFileStorage scanFileStorage, boolean isProductImageData, Integer targetSrid) {
        IFileset tfwFile;
        List lstFile = fileData.getFiles();
        FileDataUnit sFileData = (FileDataUnit)ListUtil.find((List)lstFile, f -> f.getProperties() != null && f.getProperties().contains("Snapshot"));
        if (sFileData == null && !isProductImageData) {
            return null;
        }
        String guid = UUID.randomUUID().toString().replace("-", "");
        String snapshotDir = MetaPluginManager.getSnapshotUnZipDir().toString();
        this.tifTempDir = Paths.get(snapshotDir, guid).toString();
        FileUtil.mkdirs((String)this.tifTempDir);
        if (sFileData == null) {
            return this.createSnapshotFileByRasterFile(fileData, this.tifTempDir, targetSrid);
        }
        IFileStorage tempFileStorage = null;
        if (sFileData.getFileSourceLocation().replace("\\", "/").startsWith(scanFileStorage.getStorageUrl().replace("\\", "/"))) {
            tempFileStorage = scanFileStorage;
        } else {
            File tempFile = new File(sFileData.getFileSourceLocation());
            tempFileStorage = new DirectoryFileStorage(tempFile.getParent(), null, null);
        }
        IFileset snapshot = tempFileStorage.getFile(sFileData.getFileSourceLocation());
        File tempSnapshotFile = new File(this.tifTempDir, snapshot.getName());
        FileUtil.copyFile((InputStream)snapshot.openFileStream(), (String)tempSnapshotFile.getPath());
        String snapshotFile = tempSnapshotFile.getAbsolutePath();
        String ext = FileUtil.getExtension((String)snapshot.getName());
        boolean transformFileExist = false;
        if (ext.equalsIgnoreCase(".jpg")) {
            IFileset jgwFile = tempFileStorage.getFile(FileUtil.changeExtension((String)snapshot.getFullPath(), (String)"jgw"));
            if (jgwFile != null) {
                FileUtil.copyFile((InputStream)jgwFile.openFileStream(), (String)new File(this.tifTempDir, jgwFile.getName()).getPath());
                transformFileExist = true;
            }
        } else if (ext.equalsIgnoreCase(".png")) {
            IFileset pgwFile = tempFileStorage.getFile(FileUtil.changeExtension((String)snapshot.getFullPath(), (String)"pgw"));
            if (pgwFile != null) {
                FileUtil.copyFile((InputStream)pgwFile.openFileStream(), (String)new File(this.tifTempDir, pgwFile.getName()).getPath());
                transformFileExist = true;
            }
        } else if (ext.equalsIgnoreCase(".tif") && (tfwFile = tempFileStorage.getFile(FileUtil.changeExtension((String)snapshot.getFullPath(), (String)"tfw"))) != null) {
            FileUtil.copyFile((InputStream)tfwFile.openFileStream(), (String)new File(this.tifTempDir, tfwFile.getName()).getPath());
            transformFileExist = true;
        }
        if (!transformFileExist) {
            String srcJpg = snapshotFile;
            if (!srcJpg.equals(snapshotFile = this.createSnapshotFileBySourceImage(fileData, snapshotFile, isProductImageData, targetSrid))) {
                File tempFile = new File(srcJpg);
                boolean bl = tempFile.delete();
            }
            return snapshotFile;
        }
        return snapshotFile;
    }
}

