/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.PinyinUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.filepackage.create.FileDataCreateDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultDTO;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.DataCompactPackage;
import com.geoway.adf.dms.config.filemodel.DataPackage;
import com.geoway.adf.dms.config.filemodel.DatumModelDataObject;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.config.filemodel.ScanFileResultParam;
import com.geoway.adf.dms.config.filemodel.constant.FileModelNodeTypeEnum;
import com.geoway.adf.dms.config.service.FileModelService;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.adf.dms.datasource.dto.create.FieldsEditDTO;
import com.geoway.adf.dms.datasource.dto.create.MosaicDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumFieldDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.ThumbCreateDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.IMEServiceCreateDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceCreateDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DataSourceStatisticService;
import com.geoway.adf.dms.datasource.service.DatumDatabaseService;
import com.geoway.adf.dms.datasource.service.FileDataService;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.MosaicDatasetService;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.service.ThumbService;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.util.ImageDatasetRenderUtil;
import com.geoway.imagedb.input.plugin.ImageGeoDatasetSettingParams;
import com.geoway.imagedb.input.plugin.ImageGeoDatasetTargetParams;
import com.geoway.imagedb.input.plugin.meta.MetaPluginManager;
import com.geoway.webstore.input.plugin.ImportPluginBase;
import com.geoway.webstore.input.plugin.data.IImportData;
import com.geoway.webstore.input.plugin.data.IImportUnit;
import com.geoway.webstore.input.plugin.data.ImportDatum;
import com.geoway.webstore.input.plugin.data.ImportUnit;
import com.geoway.webstore.input.plugin.event.ImportScanUnitEventArgs;
import com.geoway.webstore.input.plugin.model.DataDuplicateStrategyEnum;
import com.geoway.webstore.input.plugin.model.ExecuteResult;
import com.geoway.webstore.input.plugin.model.ExecuteResultDetail;
import com.geoway.webstore.input.plugin.params.ImportSourceParams;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.TranslateOptions;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;

public abstract class ImageDatasetImportPluginBase
extends ImportPluginBase {
    protected DataSourceManager dataSourceManager = (DataSourceManager)SpringContextUtil.getBean(DataSourceManager.class);
    protected GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    protected RenderIndexService renderIndexService = (RenderIndexService)SpringContextUtil.getBean(RenderIndexService.class);
    protected FileModelService fileModelService = (FileModelService)SpringContextUtil.getBean(FileModelService.class);
    protected DatumDatabaseService datumDatabaseService = (DatumDatabaseService)SpringContextUtil.getBean(DatumDatabaseService.class);
    protected FileDataService fileDataService = (FileDataService)SpringContextUtil.getBean(FileDataService.class);
    protected DataSourceStatisticService dataSourceStatisticService = (DataSourceStatisticService)SpringContextUtil.getBean(DataSourceStatisticService.class);
    protected ThumbService thumbService = (ThumbService)SpringContextUtil.getBean(ThumbService.class);
    protected FileStorageService fileStorageService = (FileStorageService)SpringContextUtil.getBean(FileStorageService.class);
    protected ImageDatasetService imageDatasetService = (ImageDatasetService)SpringContextUtil.getBean(ImageDatasetService.class);
    protected MosaicDatasetService mosaicDatasetService = (MosaicDatasetService)SpringContextUtil.getBean(MosaicDatasetService.class);
    protected ImageGeoDatasetTargetParams targetParams;
    protected ImageGeoDatasetSettingParams settingParams;
    protected DataPackage dataPackage = null;
    protected boolean hasCompact = false;
    protected String dataPath = null;
    protected Boolean deleteRepeatedData;
    protected DataSourceDTO fileStorage = null;
    protected DatumDatasetDTO imageDataset = null;
    protected IFeatureWorkspace targetWorkspace = null;
    protected IGeoDataset targetGeoDataset = null;
    protected IMosaicDataset snapshotMosaicDataset;
    protected IFeatureWorkspace businessSnapshotWorkspace;
    protected IMosaicDataset businessSnapshotDataset;
    protected IGeometry currentDataGeometry;
    protected String snapshotFile;
    protected String currentDataId;
    protected DmFileData currentFileData;
    protected IFileStorage scanFileStorage;

    public void initialize(String sourceParamsStr, String targetParamsStr, String settingParamsStr) {
        this.sourceParams = (ImportSourceParams)JSONObject.parseObject((String)sourceParamsStr, ImportSourceParams.class);
        this.deleteRepeatedData = DataDuplicateStrategyEnum.getByValue((Integer)this.sourceParams.getDataDuplicateStrategy()) == DataDuplicateStrategyEnum.Delete;
        this.settingParams = (ImageGeoDatasetSettingParams)JSONObject.parseObject((String)settingParamsStr, ImageGeoDatasetSettingParams.class);
        this.targetParams = (ImageGeoDatasetTargetParams)JSONObject.parseObject((String)targetParamsStr, ImageGeoDatasetTargetParams.class);
        this.dataPackage = this.fileModelService.getDataPackage(this.targetParams.fileModelId);
        this.fileStorage = this.dataSourceManager.getDataSourceDetail(this.settingParams.serviceId);
        if (this.fileStorage == null) {
            throw new RuntimeException("\u83b7\u53d6\u5b58\u50a8\u8282\u70b9\u5931\u8d25\uff01");
        }
        if (!this.settingParams.sourceFolderPath.contains(this.fileStorage.getUrl())) {
            throw new RuntimeException("\u6570\u636e\u4f4d\u7f6e\u4e0e\u5b58\u50a8\u8282\u70b9\u4e0d\u5339\u914d\uff01");
        }
        this.scanFileStorage = this.fileStorageService.openFileStorage(this.fileStorage.getKey());
        this.dataPath = this.settingParams.sourceFolderPath;
    }

    public IImportData getImportData(Long dataId) {
        return ImportDatum.getImportData((Long)dataId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanData() {
        this.imageDataset = this.datumDatabaseService.getDatasetDetail(this.targetParams.datasetId);
        if (this.imageDataset == null) {
            throw new RuntimeException("\u6253\u5f00\u76ee\u6807\u6570\u636e\u96c6\u5931\u8d25\uff01");
        }
        if (this.dataPackage.getDataKeyObject().getNodeType().intValue() == FileModelNodeTypeEnum.CompactPackage.getValue()) {
            this.dataPackage.setUncompress(false);
            this.hasCompact = true;
        }
        IFileStorage fileStorage = this.fileStorageService.openFileStorage(this.fileStorage.getKey());
        IFileset dataFile = fileStorage.getFile(this.dataPath);
        try {
            ScanResultDTO scanResultDTO = this.dataPackage.scanFile(dataFile, Boolean.valueOf(false));
            if (scanResultDTO.getDataCount() == 0L) {
                throw new RuntimeException("\u6570\u636e\u7ec4\u7ec7\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        finally {
            if (this.hasCompact) {
                this.dataPackage.getArchiveEnvironment().dispose();
            }
        }
        ImportUnit importUnit = new ImportUnit();
        importUnit.setName(FileUtil.getFileNameWithoutExtension((String)this.dataPath));
        importUnit.setCode(FileUtil.getFileNameWithoutExtension((String)this.dataPath));
        importUnit.setPath(this.dataPath);
        ArrayList<ImportDatum> importDataList = new ArrayList<ImportDatum>();
        List scanFileResultParams = this.dataPackage.getScanFileResultParams();
        for (ScanFileResultParam resultItem : scanFileResultParams) {
            if (!this.hasCompact && !resultItem.getScanResult().booleanValue()) {
                this.onImportUnitLog(String.format("\u6570\u636e\u5305[%s]\u6709\u6548\u6027\u68c0\u67e5\u672a\u901a\u8fc7\u3002", resultItem.getMainFilePath()));
                continue;
            }
            DmFileData fileData = resultItem.getData();
            if (importDataList.stream().anyMatch(c -> c.getName().equals(fileData.getDataName()))) {
                this.log.error(String.format("\u6307\u5b9a\u6570\u636e\u76ee\u5f55\u4e0b\u6570\u636e\u5305[%s]\u5b58\u5728\u91cd\u590d\u3002", fileData.getDataName()));
                continue;
            }
            ImportDatum importDatum = new ImportDatum();
            importDatum.setName(fileData.getDataName());
            importDatum.setPath(resultItem.getMainFilePath());
            importDatum.setDatasetName(this.imageDataset.getName());
            importDatum.setFileData(JSONObject.toJSONString((Object)fileData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            importDataList.add(importDatum);
        }
        ImportScanUnitEventArgs args = new ImportScanUnitEventArgs((Object)this, (IImportUnit)importUnit, importDataList);
        this.onDataUnitScaned(args);
    }

    public ExecuteResult prepareImport() {
        try {
            ExecuteResult result = new ExecuteResult();
            String datasetId = this.targetParams.datasetId;
            this.imageDataset = this.datumDatabaseService.getDatasetDetail(datasetId);
            if (this.imageDataset == null) {
                result.setSuccess(Boolean.valueOf(false));
                result.setErrorMessage("\u6253\u5f00\u76ee\u6807\u6570\u636e\u96c6\u5931\u8d25\uff01");
                return result;
            }
            DatumDatabaseDTO dataSource = (DatumDatabaseDTO)this.imageDataset.getDataSource();
            DatabaseDTO geoDatabase = this.geoDatabaseService.getDatabaseDetail(dataSource.getGeoDatabase().getKey());
            this.targetWorkspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)geoDatabase);
            if (this.targetWorkspace == null) {
                result.setSuccess(Boolean.valueOf(false));
                result.setErrorMessage("\u6253\u5f00\u7a7a\u95f4\u6570\u636e\u5e93\u5931\u8d25\uff01");
                return result;
            }
            ImageDatasetTypeEnum datasetType = ImageDatasetTypeEnum.getByValue((Integer)this.imageDataset.getDatumType());
            switch (datasetType) {
                case OriginalImageDataset: {
                    this.targetGeoDataset = this.targetWorkspace.openGeoDataset(this.imageDataset.getName());
                    if (!(this.targetGeoDataset instanceof IFeatureClass)) break;
                    this.snapshotMosaicDataset = this.targetWorkspace.openMosaicDataset(this.imageDatasetService.getSnapshotDatasetName(this.imageDataset.getName()));
                    if (this.snapshotMosaicDataset != null) break;
                    result.setSuccess(Boolean.valueOf(false));
                    result.setErrorMessage("\u6253\u5f00\u5feb\u89c6\u56fe\u9576\u5d4c\u6570\u636e\u96c6\u5931\u8d25\uff01");
                    return result;
                }
                case ProcessedImageDataset: {
                    this.targetGeoDataset = this.targetWorkspace.openMosaicDataset(this.imageDataset.getName());
                    break;
                }
                case ImageSampleImageDataset: 
                case TileSampleImageDataset: {
                    this.targetGeoDataset = this.targetWorkspace.openFeatureClass(this.imageDataset.getName());
                    break;
                }
                default: {
                    result.setSuccess(Boolean.valueOf(false));
                    result.setErrorMessage("\u4e0d\u652f\u6301\u7684\u5f71\u50cf\u6570\u636e\u7c7b\u578b\uff1a");
                    return result;
                }
            }
            if (this.targetGeoDataset == null) {
                result.setSuccess(Boolean.valueOf(false));
                result.setErrorMessage(this.imageDataset.getName() + " \u7a7a\u95f4\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01");
                return result;
            }
            DataSourceDTO targetDatabase = this.imageDatasetService.getBusinessSnapshotDataSource();
            this.businessSnapshotWorkspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);
            this.businessSnapshotDataset = this.businessSnapshotWorkspace.openMosaicDataset(this.imageDatasetService.getBusinessSnapshotDatasetName());
            if (this.businessSnapshotDataset == null) {
                result.setSuccess(Boolean.valueOf(false));
                result.setErrorMessage("\u6253\u5f00\u5feb\u89c6\u56fe\u4e1a\u52a1\u9576\u5d4c\u6570\u636e\u96c6\u5931\u8d25\uff01");
                return result;
            }
            this.updateDatasetStructure();
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            return new ExecuteResult(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResultDetail executeImport(IImportData importData) {
        ExecuteResultDetail executeResultDetail;
        block28: {
            DataCompactPackage dataCompactPackage;
            IFileset keyPath;
            IFileset folder;
            ExecuteResultDetail resultDetail;
            block27: {
                Map<String, Object> metaRow;
                DmFileData fileData;
                block25: {
                    IFileStorage fileStorage;
                    block26: {
                        ImportDatum importDatum;
                        block21: {
                            ExecuteResultDetail executeResultDetail2;
                            block24: {
                                block22: {
                                    ExecuteResultDetail executeResultDetail3;
                                    block23: {
                                        this.currentImportData = importData;
                                        resultDetail = new ExecuteResultDetail();
                                        importDatum = ImportDatum.getImportData((Long)this.currentImportData.getId());
                                        if (importDatum == null || importDatum.getFileData() == null) {
                                            resultDetail.setSuccess(Boolean.valueOf(false));
                                            resultDetail.setErrorMessage("\u626b\u63cf\u7684\u6587\u4ef6\u5305\u4e3a\u7a7a\uff01");
                                            resultDetail.setFailCount(1L);
                                            resultDetail.setSuccessCount(0L);
                                            resultDetail.setTotalCount(1L);
                                            return resultDetail;
                                        }
                                        fileData = (DmFileData)JSONObject.parseObject((String)importDatum.getFileData(), DmFileData.class);
                                        folder = null;
                                        keyPath = null;
                                        dataCompactPackage = null;
                                        DatumModelDataObject keyObject = this.dataPackage.getDataKeyObject();
                                        if (keyObject.getNodeType().intValue() == FileModelNodeTypeEnum.CompactPackage.getValue()) {
                                            dataCompactPackage = (DataCompactPackage)keyObject;
                                            this.hasCompact = true;
                                        }
                                        try {
                                            if (!this.hasCompact) break block21;
                                            List datumFieldList = this.imageDataset.getFields();
                                            List identifyFields = ListUtil.findAll((List)datumFieldList, DatumFieldDTO::getIdentify);
                                            if (identifyFields.size() == 0) {
                                                throw new RuntimeException("\u672a\u8bbe\u7f6e\u6807\u8bc6\u5b57\u6bb5!");
                                            }
                                            if (identifyFields.size() != 1 || !((DatumFieldDTO)identifyFields.get(0)).getName().equalsIgnoreCase("F_DATANAME")) break block22;
                                            HashMap<String, Object> metaRow2 = new HashMap<String, Object>();
                                            metaRow2.putIfAbsent("F_DATANAME", fileData.getDataName());
                                            boolean isRepeated = this.processRepeatedData(metaRow2);
                                            if (!isRepeated || this.deleteRepeatedData.booleanValue()) break block22;
                                            resultDetail.setSuccess(Boolean.valueOf(true));
                                            this.onImportDataLog(String.format("\u3010%s\u3011\u6570\u636e\u91cd\u590d\uff0c\u5df2\u8df3\u8fc7", importDatum.getName()));
                                            resultDetail.setFailCount(0L);
                                            resultDetail.setSuccessCount(1L);
                                            resultDetail.setTotalCount(1L);
                                            executeResultDetail3 = resultDetail;
                                            if (keyPath == null || folder == null || dataCompactPackage == null) break block23;
                                        }
                                        catch (Throwable throwable) {
                                            if (keyPath != null && folder != null && dataCompactPackage != null) {
                                                this.dataPackage.getArchiveEnvironment().dispose(keyPath, folder, dataCompactPackage);
                                            }
                                            throw throwable;
                                        }
                                        this.dataPackage.getArchiveEnvironment().dispose(keyPath, folder, dataCompactPackage);
                                    }
                                    return executeResultDetail3;
                                }
                                fileStorage = this.fileStorageService.openFileStorage(this.fileStorage.getKey());
                                folder = fileStorage.getFile(fileData.getSrcMainPath());
                                keyPath = fileStorage.getFile(importDatum.getPath());
                                ArrayList<IFileset> compactFiles = new ArrayList<IFileset>();
                                compactFiles.add(keyPath);
                                this.dataPackage.setDataCompactPackageFiles(compactFiles);
                                ScanFileResultParam resultParam = this.dataPackage.scanFilesByMainFile(folder, keyPath);
                                fileData = resultParam.getData();
                                if (resultParam.getScanResult().booleanValue()) break block21;
                                resultDetail.setSuccess(Boolean.valueOf(false));
                                List errorMessageList = this.dataPackage.getScanErrorMessages();
                                List messageList = ListUtil.convertAll((List)errorMessageList, f -> String.format("[%s]%s", f.getDataObj().getName(), f.getErrorInfo()));
                                resultDetail.setErrorMessage(String.format("\u6570\u636e\u5305[%s]\u6709\u6548\u6027\u68c0\u67e5\u672a\u901a\u8fc7: %s", fileData.getDataName(), String.join((CharSequence)",", messageList)));
                                this.onImportDataLog(String.format("\u6570\u636e\u5305[%s]\u6709\u6548\u6027\u68c0\u67e5\u672a\u901a\u8fc7: %s", fileData.getDataName(), String.join((CharSequence)",", messageList)));
                                resultDetail.setFailCount(1L);
                                resultDetail.setSuccessCount(0L);
                                resultDetail.setTotalCount(1L);
                                executeResultDetail2 = resultDetail;
                                if (keyPath == null || folder == null || dataCompactPackage == null) break block24;
                                this.dataPackage.getArchiveEnvironment().dispose(keyPath, folder, dataCompactPackage);
                            }
                            return executeResultDetail2;
                        }
                        metaRow = this.getMetaData(fileData);
                        metaRow.putIfAbsent("F_SERVERID", this.fileStorage.getKey());
                        metaRow.putIfAbsent("F_DATANAME", fileData.getDataName());
                        metaRow.putIfAbsent("F_DATASIZE", fileData.getDataAmount());
                        metaRow.putIfAbsent("F_DATAUNIT", "B");
                        metaRow.putIfAbsent("F_SRCDATAPATH", fileData.getSrcMainPath().replace("\\", "/"));
                        metaRow.putIfAbsent("F_LOCATION", this.getFilePrePath(fileData).replace("\\", "/"));
                        metaRow.putIfAbsent("F_ISPUBLISH", ConstantsValue.FALSE_VALUE);
                        boolean isRepeated = this.processRepeatedData(metaRow);
                        if (!isRepeated || this.deleteRepeatedData.booleanValue()) break block25;
                        resultDetail.setSuccess(Boolean.valueOf(true));
                        this.onImportDataLog(String.format("\u3010%s\u3011\u6570\u636e\u91cd\u590d\uff0c\u5df2\u8df3\u8fc7", importDatum.getName()));
                        resultDetail.setFailCount(0L);
                        resultDetail.setSuccessCount(1L);
                        resultDetail.setTotalCount(1L);
                        fileStorage = resultDetail;
                        if (keyPath == null || folder == null || dataCompactPackage == null) break block26;
                        this.dataPackage.getArchiveEnvironment().dispose(keyPath, folder, dataCompactPackage);
                    }
                    return fileStorage;
                }
                try {
                    String dataId = this.insertFileData(fileData);
                    metaRow.put("F_DATAID", dataId);
                    metaRow.put("f_flag", 0);
                    metaRow.put("f_import_time", new Date());
                    LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
                    if (userInfo != null) {
                        metaRow.put("f_import_user", userInfo.getUserName());
                    } else {
                        metaRow.put("f_import_user", "admin");
                    }
                    boolean success = true;
                    this.onImportDataLog("\u5f00\u59cb\u5199\u5165\u5143\u6570\u636e....");
                    RefObject errorMsg = new RefObject();
                    success = this.writeMetaData(dataId, metaRow, fileData, (RefObject<String>)errorMsg);
                    if (!success) {
                        this.deleteMetaData(dataId);
                        this.onImportDataLog("\u5143\u6570\u636e\u5199\u5165\u5931\u8d25\uff1a" + (String)errorMsg.get());
                        resultDetail.setErrorMessage("\u5143\u6570\u636e\u5199\u5165\u5931\u8d25\uff1a" + (String)errorMsg.get());
                        resultDetail.setSuccess(Boolean.valueOf(false));
                        resultDetail.setFailCount(1L);
                        resultDetail.setSuccessCount(0L);
                        resultDetail.setTotalCount(1L);
                        break block27;
                    }
                    this.onImportDataLog("\u5143\u6570\u636e\u5199\u5165\u6210\u529f");
                    this.addThumb(dataId);
                    try {
                        if (!this.uploadFileData()) {
                            this.deleteMetaData(dataId);
                            this.onImportDataLog("\u8fc1\u79fb\u5f71\u50cf\u6570\u636e\u5931\u8d25\uff01");
                            success = false;
                        }
                    }
                    catch (Exception e) {
                        this.deleteMetaData(dataId);
                        this.log.error("\u8fc1\u79fb\u5f71\u50cf\u6570\u636e\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
                        this.onImportDataLog("\u8fc1\u79fb\u5f71\u50cf\u6570\u636e\u5931\u8d25\uff01" + e.getMessage());
                        success = false;
                    }
                    this.onImportDataLog("\u5199\u5165\u6570\u636e\u5b8c\u6210\uff01");
                    resultDetail.setTotalCount(1L);
                    if (success) {
                        resultDetail.setSuccess(Boolean.valueOf(true));
                        resultDetail.setFailCount(0L);
                        resultDetail.setSuccessCount(1L);
                    } else {
                        resultDetail.setSuccess(Boolean.valueOf(false));
                        resultDetail.setFailCount(1L);
                        resultDetail.setSuccessCount(0L);
                    }
                }
                catch (Exception e) {
                    this.log.error(this.currentImportData.getName() + "\u5165\u5e93\u5931\u8d25", (Throwable)e);
                    this.onImportDataLog(e.getMessage());
                    resultDetail.setSuccess(Boolean.valueOf(false));
                    resultDetail.setErrorMessage(e.getMessage());
                    resultDetail.setFailCount(1L);
                    resultDetail.setSuccessCount(0L);
                    resultDetail.setTotalCount(1L);
                    ExecuteResultDetail executeResultDetail4 = resultDetail;
                    if (keyPath != null && folder != null && dataCompactPackage != null) {
                        this.dataPackage.getArchiveEnvironment().dispose(keyPath, folder, dataCompactPackage);
                    }
                    return executeResultDetail4;
                }
            }
            this.onImportDataLog(this.currentImportData.getName() + "\u5165\u5e93\u5b8c\u6210\uff01");
            executeResultDetail = resultDetail;
            if (keyPath == null || folder == null || dataCompactPackage == null) break block28;
            this.dataPackage.getArchiveEnvironment().dispose(keyPath, folder, dataCompactPackage);
        }
        return executeResultDetail;
    }

    public void importFinised(IImportUnit importUnit) {
        if (this.dataPackage != null) {
            this.dataPackage.getArchiveEnvironment().dispose();
        }
    }

    public void importFinised() {
        if (null == this.targetWorkspace) {
            return;
        }
        if (this.dataPackage != null) {
            this.dataPackage.getArchiveEnvironment().dispose();
        }
        try {
            this.dataSourceStatisticService.datasetStatistic(this.imageDataset.getId());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.targetGeoDataset instanceof IFeatureClass) {
                IFeatureClass targetFc = (IFeatureClass)this.targetGeoDataset;
                targetFc.updateExtent();
                if (Boolean.TRUE.equals(this.sourceParams.getAutoCreateIndex())) {
                    this.publishVectorService(this.imageDataset.getGeoDatasetId(), this.imageDataset.getName(), targetFc);
                }
                if (this.snapshotMosaicDataset != null) {
                    this.snapshotMosaicDataset.changeExtent(targetFc.getExtent());
                    this.snapshotMosaicDataset.calculateCellSizeRanges();
                    String datasetId = this.imageDatasetService.getSnapshotDatasetId(this.imageDataset.getGeoDatasetId());
                    this.publishMosaicService(datasetId, this.snapshotMosaicDataset.getName(), false);
                }
            } else if (this.targetGeoDataset instanceof IMosaicDataset) {
                IMosaicDataset mosaicDataset = (IMosaicDataset)this.targetGeoDataset;
                mosaicDataset.updateExtent();
                if (Boolean.TRUE.equals(this.sourceParams.getAutoCreateIndex())) {
                    this.onImportUnitLog("\u5f00\u59cb\u521b\u5efa\u6e32\u67d3\u7d22\u5f15\uff01");
                    this.publishMosaicService(this.imageDataset.getGeoDatasetId(), this.imageDataset.getName(), true);
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u5165\u5e93\u540e\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            this.onImportUnitLog(e.getMessage());
        }
        try {
            if (this.businessSnapshotDataset != null) {
                this.businessSnapshotDataset.updateExtent();
                this.businessSnapshotDataset.calculateCellSizeRanges();
                this.publishBusinessSnapshotService();
            }
        }
        catch (Exception e) {
            this.log.error("\u5165\u5e93\u540e\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            this.onImportUnitLog(e.getMessage());
        }
    }

    public void dispose() {
        if (this.targetWorkspace != null) {
            this.targetWorkspace.close();
        }
        if (this.businessSnapshotWorkspace != null) {
            this.businessSnapshotWorkspace.close();
        }
    }

    protected abstract Map<String, Object> getMetaData(DmFileData var1);

    protected abstract String getSnapshotFile(DmFileData var1);

    protected IRasterDataset getRasterDataset(DmFileData fileData) {
        return null;
    }

    protected Map<String, Object> getBusinessValues(Map<String, Object> meta) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("F_DATAID", meta.get("F_DATAID"));
        values.put("F_DATASIZE", meta.get("F_DATASIZE"));
        values.put("F_DATANAME", meta.get("F_DATANAME"));
        values.put("f_image_dataset_id", this.targetParams.datasetId);
        values.put("f_image_type", this.imageDataset.getDatumType());
        values.put("f_import_time", meta.get("f_import_time"));
        values.put("f_import_user", meta.get("f_import_user"));
        values.put("f_is_push", 0);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeMetaData(String dataId, Map<String, Object> metaRow, DmFileData fileData, RefObject<String> errorMsg) {
        this.currentDataId = dataId;
        this.currentFileData = fileData;
        IRasterDataset snapshotFileRaster = null;
        ISpatialReferenceSystem snapshotSrs = null;
        boolean success = true;
        errorMsg.set((Object)"");
        ImageDatasetTypeEnum imageDatasetType = ImageDatasetTypeEnum.getByValue((Integer)this.imageDataset.getDatumType());
        try {
            this.snapshotFile = this.getSnapshotFile(fileData);
            if (StringUtil.isNotEmpty((String)this.snapshotFile)) {
                snapshotFileRaster = this.openRasterDataset(this.snapshotFile);
                if (snapshotFileRaster == null) {
                    errorMsg.set((Object)((String)errorMsg.get() + this.snapshotFile + " \u6253\u5f00\u5931\u8d25\uff01"));
                    return false;
                }
                snapshotSrs = snapshotFileRaster.getRasterInfo().getSpatialReferenceSystem();
            }
            switch (imageDatasetType) {
                case OriginalImageDataset: {
                    IGeometry extentGeometry;
                    if (this.targetGeoDataset.getType() == GeoDatasetType.Table) {
                        this.insertTableRow((ITable)this.targetGeoDataset, metaRow);
                        break;
                    }
                    if (this.targetGeoDataset.getType() == GeoDatasetType.FeatureClass) {
                        IFeatureClass targetFc = (IFeatureClass)this.targetGeoDataset;
                        extentGeometry = this.currentDataGeometry;
                        if (this.currentDataGeometry != null) {
                            extentGeometry = this.currentDataGeometry.projectToCopy(snapshotSrs, targetFc.getSpatialReferenceSystem());
                        }
                        this.insertFeature(targetFc, metaRow, extentGeometry);
                        if (this.snapshotMosaicDataset != null) {
                            IGeometry snapshotGeometry = null;
                            if (this.currentDataGeometry != null) {
                                snapshotGeometry = this.currentDataGeometry.projectToCopy(snapshotSrs, this.snapshotMosaicDataset.getSpatialReferenceSystem());
                            }
                            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
                            defaultValues.put("F_DATAID", dataId);
                            this.insertRaster(this.snapshotMosaicDataset, snapshotFileRaster, defaultValues, snapshotGeometry, null);
                        }
                        break;
                    }
                    if (this.targetGeoDataset.getType() != GeoDatasetType.MosaicDataset) break;
                    IMosaicDataset mosaicDataset = (IMosaicDataset)this.targetGeoDataset;
                    extentGeometry = this.currentDataGeometry;
                    if (this.currentDataGeometry != null) {
                        extentGeometry = this.currentDataGeometry.projectToCopy(snapshotSrs, mosaicDataset.getSpatialReferenceSystem());
                    }
                    this.insertRaster((IMosaicDataset)this.targetGeoDataset, snapshotFileRaster, metaRow, extentGeometry, null);
                    break;
                }
                case ProcessedImageDataset: {
                    IRasterDataset sourceRasterDataset = this.getRasterDataset(fileData);
                    try {
                        if (sourceRasterDataset == null) {
                            errorMsg.set((Object)"\u5f71\u50cf\u6570\u636e\u6253\u5f00\u5931\u8d25");
                            success = false;
                        }
                        this.insertRaster((IMosaicDataset)this.targetGeoDataset, sourceRasterDataset, metaRow, null, false);
                        break;
                    }
                    finally {
                        if (sourceRasterDataset != null) {
                            sourceRasterDataset.closeRaster();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u5143\u6570\u636e\u63d2\u5165\u5931\u8d25", (Throwable)e);
            errorMsg.set((Object)e.getMessage());
            success = false;
        }
        if (success) {
            try {
                Map<String, Object> businessValues = this.getBusinessValues(metaRow);
                IGeometry businessSnapshotGeometry = null;
                if (this.currentDataGeometry != null) {
                    businessSnapshotGeometry = this.currentDataGeometry.projectToCopy(snapshotSrs, this.businessSnapshotDataset.getSpatialReferenceSystem());
                }
                this.insertRaster(this.businessSnapshotDataset, snapshotFileRaster, businessValues, businessSnapshotGeometry, null);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                errorMsg.set((Object)((String)errorMsg.get() + "\u5feb\u89c6\u56fe\u5165\u5e93\u5931\u8d25\uff01" + e.getMessage()));
                this.onImportDataLog("\u5feb\u89c6\u56fe\u5165\u5e93\u5931\u8d25\uff01" + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (snapshotFileRaster != null) {
                    snapshotFileRaster.closeRaster();
                }
            }
        }
        return success;
    }

    protected Boolean processRepeatedData(Map<String, Object> metaRow) {
        String sql;
        Map queryResult;
        List datumFieldList = this.imageDataset.getFields();
        List identifyFields = ListUtil.findAll((List)datumFieldList, DatumFieldDTO::getIdentify);
        if (identifyFields.size() == 0) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u6807\u8bc6\u5b57\u6bb5!");
        }
        ArrayList<String> whereClauses = new ArrayList<String>();
        for (DatumFieldDTO item : identifyFields) {
            Object value = this.getMetaValueByField(metaRow, item);
            if (value == null || value.toString().length() == 0) {
                throw new RuntimeException(String.format("\u6807\u8bc6\u5b57\u6bb5[%s]\u7684\u503c\u4e3a\u7a7a", item.getName()));
            }
            FieldType fieldType = FieldType.getByValue((Integer)item.getFieldType());
            String valueString = String.format("'%s'", value.toString());
            switch (fieldType) {
                case OID: 
                case Decimal: 
                case Double: 
                case Short: 
                case Int: 
                case Long: 
                case Float: {
                    valueString = value.toString();
                    break;
                }
                default: {
                    valueString = String.format("'%s'", value.toString());
                }
            }
            whereClauses.add(String.format("%s = %s", item.getName(), valueString));
        }
        String whereClause = String.join((CharSequence)" And ", whereClauses);
        String tableName = this.imageDataset.getName();
        if (this.targetGeoDataset instanceof IMosaicDataset) {
            tableName = ((IMosaicDataset)this.targetGeoDataset).getCatalog().getName();
        }
        if ((queryResult = this.targetWorkspace.queryOne(sql = String.format("select %s as id from %s where %s", "F_DATAID", tableName, whereClause), new Object[0])) != null && this.deleteRepeatedData.booleanValue()) {
            this.deleteMetaData(queryResult.get("id").toString());
            this.onImportDataLog(String.format("\u4e0e\u3010%s\u3011\u6570\u636e\u91cd\u590d\uff0c\u5df2\u5220\u9664\u91cd\u590d\u6570\u636e", queryResult.get("id").toString()));
            return true;
        }
        return queryResult != null && queryResult.size() > 0;
    }

    protected boolean uploadFileData() {
        return true;
    }

    protected void deleteMetaData(String dataId) {
        try {
            this.fileDataService.deleteFileData(dataId);
            String tableName = this.targetGeoDataset.getName();
            if (this.targetGeoDataset instanceof IMosaicDataset) {
                tableName = ((IMosaicDataset)this.targetGeoDataset).getCatalog().getName();
            }
            String sql = String.format("delete from %s where %s = '%s'", tableName, "F_DATAID", dataId);
            this.targetWorkspace.excuteSql(sql);
            if (this.snapshotMosaicDataset != null) {
                String snapshotSql = String.format("delete from %s where %s = '%s'", this.snapshotMosaicDataset.getCatalog().getName(), "F_DATAID", dataId);
                this.targetWorkspace.excuteSql(snapshotSql);
            }
            this.businessSnapshotWorkspace.excuteSql(String.format("delete from %s where %s = '%s'", this.businessSnapshotDataset.getCatalog().getName(), "F_DATAID", dataId));
        }
        catch (Exception e) {
            this.log.error("\u5220\u9664\u5f71\u50cf\u6570\u636e\u5f02\u5e38", (Throwable)e);
            this.onImportDataLog("\u5220\u9664\u5f71\u50cf\u6570\u636e\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    protected String insertFileData(DmFileData fileData) {
        FileDataCreateDTO createDTO = new FileDataCreateDTO();
        createDTO.setDataName(fileData.getDataName());
        createDTO.setDatatype(fileData.getDatatype());
        createDTO.setDatumDatasetId(this.imageDataset.getId());
        createDTO.setServerId(this.fileStorage.getKey());
        createDTO.setRegisterUser(this.sourceParams.getImportUser());
        createDTO.setDataAmount(fileData.getDataAmount());
        createDTO.setFileModelId(this.dataPackage.getId());
        createDTO.setRealPkgName(fileData.getRealPkgName());
        createDTO.setMainPath(this.getFilePrePath(fileData).replace("\\", "/"));
        createDTO.setIsOnServer(Boolean.valueOf(true));
        createDTO.setSrcMainPath(fileData.getSrcMainPath().replace("\\", "/"));
        for (FileDataUnit unit : fileData.getFiles()) {
            String serviceAddress = this.fileStorage.getUrl();
            String fileLocation = unit.getFileLocation().substring(serviceAddress.length());
            unit.setFileLocation(fileLocation);
        }
        createDTO.setFiles(fileData.getFiles());
        String dataId = this.fileDataService.addFileData(createDTO);
        fileData.setDataId(dataId);
        return dataId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertTableRow(ITable targetTable, Map<String, Object> metaRow) {
        ICursor insertCursor = null;
        try {
            insertCursor = targetTable.insertRow();
            IRow trgBuffer = targetTable.createRow();
            int index = -1;
            for (String fieldName : metaRow.keySet()) {
                index = targetTable.getFields().findFieldIndex(fieldName);
                if (index < 0) continue;
                trgBuffer.setValue(index, metaRow.get(fieldName));
            }
            boolean success = insertCursor.insertRow(trgBuffer);
            if (!success) {
                throw new RuntimeException("\u6570\u636e\u5199\u5165\u5931\u8d25\uff01");
            }
        }
        finally {
            if (insertCursor != null) {
                insertCursor.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertFeature(IFeatureClass targetFc, Map<String, Object> metaRow, IGeometry geometry) {
        IFeatureCursor curInsert = null;
        try {
            curInsert = targetFc.insertFeature();
            IFeature trgBuffer = targetFc.createFeature();
            if (geometry != null) {
                trgBuffer.setGeometry(geometry);
            }
            int index = -1;
            for (String fieldName : metaRow.keySet()) {
                index = targetFc.getFields().findFieldIndex(fieldName);
                IField fld = targetFc.getFields().getField(index);
                if (fld == null) continue;
                trgBuffer.setValue(index, metaRow.get(fieldName));
            }
            boolean success = curInsert.insertFeature(trgBuffer);
            if (!success) {
                throw new RuntimeException("\u6570\u636e\u5199\u5165\u5931\u8d25\uff01");
            }
        }
        finally {
            if (curInsert != null) {
                curInsert.release();
            }
        }
    }

    protected void insertRaster(IMosaicDataset mosaicDataset, IRasterDataset sourceRasterDataset, Map<String, Object> metaRow, IGeometry extentGeometry, Boolean overwrite) {
        int resultOID;
        String srcRasterPath;
        String string = srcRasterPath = sourceRasterDataset == null ? "" : sourceRasterDataset.getRasterInfo().getRasterPath();
        if (Boolean.FALSE.equals(overwrite)) {
            IFeatureClass pFeatureClass = mosaicDataset.getCatalog();
            String whereClause = "urihash = '" + srcRasterPath + "'";
            QueryFilter filterProp = new QueryFilter();
            filterProp.setWhereClause(whereClause);
            if (pFeatureClass.featureCount((IQueryFilter)filterProp) > 0L) {
                throw new RuntimeException("\u5b58\u5728\u91cd\u590d\u5f71\u50cf\uff1a" + srcRasterPath);
            }
        }
        if ((resultOID = mosaicDataset.addRaster(sourceRasterDataset, extentGeometry, metaRow, overwrite)) < 0) {
            throw new RuntimeException("\u5199\u5165\u6805\u683c\u6570\u636e\u5931\u8d25\uff01");
        }
    }

    protected IRasterDataset openRasterDataset(String rasterFileFullName) {
        try {
            String rasterFolder = FileUtil.getDirectoryName((String)rasterFileFullName);
            RasterFileWorkspace rasterWorkspace = new RasterFileWorkspace(rasterFolder);
            IRasterDataset rasterDataset = rasterWorkspace.openRasterDataset(rasterFileFullName);
            if (rasterDataset != null) {
                return rasterDataset;
            }
        }
        catch (Exception e) {
            this.log.error(rasterFileFullName + "\u6253\u5f00\u5931\u8d25\uff01", (Throwable)e);
        }
        return null;
    }

    protected String getFilePrePath(DmFileData catalogData) {
        String serviceAddress = this.fileStorage.getUrl();
        if (catalogData.getContainsRootFolder() != null && catalogData.getContainsRootFolder().equals(ConstantsValue.TRUE_VALUE.longValue())) {
            IFileStorage fileStorage = this.fileStorageService.openFileStorage(catalogData.getServerId());
            IFileset fileset = fileStorage.getFile(catalogData.getSrcMainPath());
            return fileset.getParentFile().getFullPath().substring(serviceAddress.length());
        }
        return catalogData.getSrcMainPath().substring(serviceAddress.length());
    }

    protected Object getMetaValueByField(Map<String, Object> metaRow, DatumFieldDTO fieldDTO) {
        if (metaRow.containsKey(fieldDTO.getName())) {
            return metaRow.get(fieldDTO.getName());
        }
        if (metaRow.containsKey(fieldDTO.getAliasName())) {
            return metaRow.get(fieldDTO.getAliasName());
        }
        return null;
    }

    protected DatasetRenderDTO publishVectorService(String geoDatasetId, String datasetName, IFeatureClass targetFc) {
        try {
            String serviceName = PinyinUtil.convertToPinYin((String)datasetName);
            if (serviceName.length() > 60) {
                serviceName = serviceName.substring(0, 60);
            }
            this.onImportUnitLog("\u5f00\u59cb\u521b\u5efa\u6e32\u67d3\u7d22\u5f15\uff1a" + serviceName);
            VTileServiceCreateDTO serviceCreateDTO = new VTileServiceCreateDTO();
            serviceCreateDTO.setServiceName(serviceName);
            serviceCreateDTO.setDatasetId(geoDatasetId);
            DatasetRenderDTO render = this.dataSourceManager.getDatasetRender(serviceCreateDTO.getDatasetId());
            if (render != null) {
                serviceCreateDTO.setServiceName(render.getServiceName());
            }
            String styleJsonStr = ImageDatasetRenderUtil.getImageDatasetVTileRender((String)serviceCreateDTO.getServiceName(), (Integer)targetFc.getFeatureType().getValue());
            serviceCreateDTO.setStyleJson(styleJsonStr);
            DatasetRenderDTO renderDTO = this.renderIndexService.createVectorRenderIndex(serviceCreateDTO);
            this.onImportUnitLog(datasetName + "\u77e2\u91cf\u6e32\u67d3\u7d22\u5f15\u521b\u5efa\u6210\u529f");
            return renderDTO;
        }
        catch (Exception ex) {
            this.log.error(datasetName + "\u77e2\u91cf\u670d\u52a1\u53d1\u5e03\u5931\u8d25", (Throwable)ex);
            this.onImportUnitLog(datasetName + "\u77e2\u91cf\u6e32\u67d3\u7d22\u5f15\u521b\u5efa\u5931\u8d25\uff0c" + ex.getMessage());
            return null;
        }
    }

    protected void publishMosaicService(String geoDatasetId, String datasetName, boolean withCatalogRenderIndex) {
        try {
            String serviceName = PinyinUtil.convertToPinYin((String)datasetName);
            if (serviceName.length() > 60) {
                serviceName = serviceName.substring(0, 60);
            }
            IMEServiceCreateDTO serviceCreateDTO = new IMEServiceCreateDTO();
            serviceCreateDTO.setServiceName(serviceName);
            serviceCreateDTO.setDatasetId(geoDatasetId);
            DatasetRenderDTO render = this.dataSourceManager.getDatasetRender(serviceCreateDTO.getDatasetId());
            if (render != null) {
                serviceCreateDTO.setServiceName(render.getServiceName());
            }
            String styleJsonStr = null;
            if (withCatalogRenderIndex) {
                styleJsonStr = ImageDatasetRenderUtil.getSnapshotVTileRender((String)serviceCreateDTO.getServiceName(), (Integer)FeatureType.Polygon.getValue());
                serviceCreateDTO.setCatalogStyleJson(styleJsonStr);
            }
            this.renderIndexService.createRasterRenderIndex(serviceCreateDTO, Boolean.valueOf(withCatalogRenderIndex));
        }
        catch (Exception e) {
            this.log.error(datasetName + "\u5feb\u89c6\u56fe\u6805\u683c\u670d\u52a1\u53d1\u5e03\u5931\u8d25", (Throwable)e);
            this.onImportUnitLog(datasetName + "\u5feb\u89c6\u56fe\u6805\u683c\u6e32\u67d3\u7d22\u5f15\u521b\u5efa\u5931\u8d25\uff0c" + e.getMessage());
        }
    }

    protected void publishBusinessSnapshotService() {
        try {
            IMEServiceCreateDTO businessSnapshotServiceCreateDTO = new IMEServiceCreateDTO();
            businessSnapshotServiceCreateDTO.setServiceName(this.imageDatasetService.getBusinessSnapshotDatasetName());
            businessSnapshotServiceCreateDTO.setDatasetId(this.imageDatasetService.getBusinessSnapshotDatasetId());
            DatasetRenderDTO businessSnapshotRender = this.dataSourceManager.getDatasetRender(this.imageDatasetService.getBusinessSnapshotDatasetId());
            if (businessSnapshotRender != null) {
                businessSnapshotServiceCreateDTO.setServiceName(businessSnapshotRender.getServiceName());
            }
            String styleJsonStr = ImageDatasetRenderUtil.getSnapshotVTileRender((String)businessSnapshotServiceCreateDTO.getServiceName(), (Integer)FeatureType.Polygon.getValue());
            businessSnapshotServiceCreateDTO.setCatalogStyleJson(styleJsonStr);
            this.renderIndexService.createRasterRenderIndex(businessSnapshotServiceCreateDTO, Boolean.valueOf(true));
        }
        catch (Exception e) {
            this.log.error(this.imageDatasetService.getBusinessSnapshotDatasetName() + "\u5feb\u89c6\u56fe\u6805\u683c\u670d\u52a1\u53d1\u5e03\u5931\u8d25", (Throwable)e);
        }
    }

    protected void addThumb(String dataId) {
        if (StringUtil.isEmptyOrWhiteSpace((String)this.snapshotFile)) {
            this.onImportDataLog("\u65e0\u5feb\u89c6\u56fe\u6587\u4ef6\uff0c\u4e0d\u91c7\u96c6\u62c7\u6307\u56fe");
            return;
        }
        if (this.snapshotFile.toLowerCase(Locale.ROOT).endsWith(".jpg") || this.snapshotFile.toLowerCase(Locale.ROOT).endsWith(".png")) {
            this.addThumbByImageIO(this.snapshotFile, dataId);
            return;
        }
        String guid = UUID.randomUUID().toString().replace("-", "");
        String snapshotDir = MetaPluginManager.getSnapshotUnZipDir().toString();
        String targetTempPath = Paths.get(snapshotDir, guid + ".png").toString();
        try {
            TranslateOptions options;
            Dataset thumbDataset;
            Dataset dataset = gdal.Open((String)this.snapshotFile, (int)gdalconstConstants.GA_ReadOnly);
            if (dataset == null) {
                throw new RuntimeException("\u6805\u683c\u8bfb\u53d6\u5931\u8d25\uff01");
            }
            int xSize = dataset.getRasterXSize();
            if (xSize > 256) {
                xSize = 256;
            }
            Vector vector = gdal.ParseCommandLine((String)String.format("-of PNG -outsize %d %d -ot Byte -scale", xSize, 0));
            if (dataset.GetRasterCount() >= 4) {
                vector = gdal.ParseCommandLine((String)String.format("-of PNG -outsize %d %d -ot Byte -b 1 -b 2 -b 3 -scale", xSize, 0));
            }
            if ((thumbDataset = gdal.Translate((String)targetTempPath, (Dataset)dataset, (TranslateOptions)(options = new TranslateOptions(vector)))) != null) {
                thumbDataset.delete();
            }
            dataset.delete();
            this.addThumbByImageIO(targetTempPath, dataId);
            boolean s = Paths.get(snapshotDir, guid + ".png").toFile().delete();
            File tempFileAux = new File(targetTempPath + ".aux.xml");
            tempFileAux.delete();
        }
        catch (Exception e) {
            this.log.error(dataId + "\u62c7\u6307\u56fe\u91c7\u96c6\u5931\u8d25\uff01", (Throwable)e);
            this.onImportDataLog(dataId + "\u62c7\u6307\u56fe\u91c7\u96c6\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    protected void addThumbByImageIO(String picturePath, String dataId) {
        int[] sizeArray = new int[]{64, 128, 256};
        try {
            File srcFile = new File(picturePath);
            BufferedImage srcImage = ImageIO.read(srcFile);
            for (int size : sizeArray) {
                ThumbCreateDTO createDTO = new ThumbCreateDTO();
                createDTO.setSize(Integer.valueOf(size));
                createDTO.setDataId(dataId);
                BufferedImage thumb = new BufferedImage(size, size, 2);
                thumb.getGraphics().drawImage(srcImage.getScaledInstance(size, size, 4), 0, 0, null);
                int rgb = new Color(0, 0, 0, 0).getRGB();
                for (int i = 0; i < size; ++i) {
                    for (int j = 0; j < size; ++j) {
                        Color color = new Color(thumb.getRGB(i, j));
                        if (color.getRed() != 0 || color.getGreen() != 0 || color.getBlue() != 0) continue;
                        thumb.setRGB(i, j, rgb);
                    }
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)thumb, "png", outputStream);
                createDTO.setImage(outputStream.toByteArray());
                outputStream.close();
                this.thumbService.insertThumb(createDTO);
            }
        }
        catch (Exception e) {
            this.log.error(dataId + "\u62c7\u6307\u56fe\u91c7\u96c6\u5931\u8d25\uff01");
            this.onImportDataLog(dataId + "\u62c7\u6307\u56fe\u91c7\u96c6\u5931\u8d25\uff01");
        }
    }

    protected boolean createGeoDatasetIndex(ITable targetTale, String fieldName) {
        try {
            Map frameIndexResult = targetTale.getWorkspace().queryOne(String.format("select * from pg_indexes where indexname = '%s_%s_idx'", targetTale.getName().toLowerCase(), fieldName.toLowerCase()), new Object[0]);
            if (frameIndexResult == null || frameIndexResult.size() == 0) {
                String frameSql = String.format("create index %s_%s_idx on %s(%s)", targetTale.getName(), fieldName, targetTale.getName(), fieldName);
                targetTale.getWorkspace().excuteSql(frameSql);
            }
            return true;
        }
        catch (Exception e) {
            this.log.error(targetTale.getName() + "." + fieldName + " \u7d22\u5f15\u521b\u5efa\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDatasetStructure() {
        IField dataIdFld;
        IField dataIdField;
        IField newField;
        ITable targetTable = null;
        if (this.targetGeoDataset instanceof IMosaicDataset) {
            targetTable = (ITable)((IMosaicDataset)this.targetGeoDataset).getCatalog();
        } else if (this.targetGeoDataset instanceof ITable) {
            targetTable = (ITable)this.targetGeoDataset;
        }
        if (targetTable != null) {
            IField dataIdField2;
            int flagFieldIndex = targetTable.getFields().findFieldIndex("f_flag");
            if (flagFieldIndex < 0) {
                targetTable.addField((IField)new Field("f_flag", "\u6807\u5fd7", FieldType.Int, 32, 0, false, (Object)0));
                this.createGeoDatasetIndex(targetTable, "f_flag");
                this.renderIndexService.deleteDatasetRender(this.targetParams.datasetId);
            }
            if ((dataIdField2 = targetTable.getFields().findField("F_DATAID")) != null && dataIdField2.getFieldType() != FieldType.String) {
                newField = dataIdField2.clone();
                newField.setFieldType(FieldType.String);
                newField.setLength(Integer.valueOf(32));
                targetTable.alterField(dataIdField2.getName(), newField);
            }
        }
        if (this.businessSnapshotDataset.getCatalog().getFields().findFieldIndex("f_rollviewangle") < 0) {
            FieldDTO rollViewAngleFld = new FieldDTO();
            rollViewAngleFld.setName("f_rollviewangle");
            rollViewAngleFld.setAliasName("\u4fa7\u6446\u89d2");
            rollViewAngleFld.setFieldType(Integer.valueOf(FieldType.Double.getValue()));
            MosaicDatasetEditDTO editDTO = new MosaicDatasetEditDTO();
            editDTO.setId(this.imageDatasetService.getBusinessSnapshotDatasetId());
            editDTO.setAliasName("\u5feb\u89c6\u56fe");
            editDTO.setInvalidValue(Double.valueOf(0.0));
            FieldsEditDTO fieldsEditDTO = new FieldsEditDTO();
            ArrayList<FieldDTO> addFields = new ArrayList<FieldDTO>();
            addFields.add(rollViewAngleFld);
            fieldsEditDTO.setAddFields(addFields);
            editDTO.setFields(fieldsEditDTO);
            this.mosaicDatasetService.updateMosaicDataset(editDTO);
        }
        if (this.businessSnapshotDataset.getCatalog().getFields().findFieldIndex("f_resolution") < 0) {
            MosaicDatasetEditDTO editDTO = new MosaicDatasetEditDTO();
            editDTO.setId(this.imageDatasetService.getBusinessSnapshotDatasetId());
            editDTO.setAliasName("\u5feb\u89c6\u56fe");
            editDTO.setInvalidValue(Double.valueOf(0.0));
            FieldsEditDTO fieldsEditDTO = new FieldsEditDTO();
            ArrayList<FieldDTO> addFields = new ArrayList<FieldDTO>();
            FieldDTO resolutionFld = new FieldDTO();
            resolutionFld.setName("f_resolution");
            resolutionFld.setAliasName("\u5206\u8fa8\u7387");
            resolutionFld.setFieldType(Integer.valueOf(FieldType.Double.getValue()));
            addFields.add(resolutionFld);
            FieldDTO imageTypeFld = new FieldDTO();
            imageTypeFld.setName("f_image_type");
            imageTypeFld.setAliasName("\u5f71\u50cf\u7c7b\u578b");
            imageTypeFld.setFieldType(Integer.valueOf(FieldType.Int.getValue()));
            addFields.add(imageTypeFld);
            fieldsEditDTO.setAddFields(addFields);
            editDTO.setFields(fieldsEditDTO);
            this.mosaicDatasetService.updateMosaicDataset(editDTO);
            this.businessSnapshotDataset = this.businessSnapshotWorkspace.openMosaicDataset(this.imageDatasetService.getBusinessSnapshotDatasetName());
            IFeatureCursor updateCursor = null;
            try {
                List allImageDatasets = this.imageDatasetService.getAllImageDatasetInfos();
                Map<String, ImgDataset> imageDatasetIdMap = allImageDatasets.stream().collect(Collectors.toMap(ImgDataset::getDatasetId, v -> v));
                updateCursor = this.businessSnapshotDataset.getCatalog().updateFeature(null);
                IFeature feature = null;
                while ((feature = updateCursor.nextFeature()) != null) {
                    String imageDatasetId = feature.getValue("f_image_dataset_id").toString();
                    if (!imageDatasetIdMap.containsKey(imageDatasetId)) continue;
                    Integer imageType = imageDatasetIdMap.get(imageDatasetId).getImageDatasetType();
                    feature.setValue("f_image_type", (Object)imageType);
                    if (21 == imageType) {
                        Object resolutionObj = feature.getValue("f_sensor");
                        if (resolutionObj != null) {
                            try {
                                Double resolution = Double.parseDouble(resolutionObj.toString());
                                feature.setValue("f_resolution", (Object)resolution);
                            }
                            catch (Exception ex) {
                                this.log.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                        feature.setValue("f_sensor", null);
                    }
                    updateCursor.updateFeature(feature);
                }
            }
            finally {
                if (updateCursor != null) {
                    updateCursor.release();
                }
            }
        }
        if ((dataIdField = this.businessSnapshotDataset.getCatalog().getFields().findField("F_DATAID")) != null && dataIdField.getFieldType() != FieldType.String) {
            IField newField2 = dataIdField.clone();
            newField2.setFieldType(FieldType.String);
            newField2.setLength(Integer.valueOf(32));
            this.businessSnapshotDataset.getCatalog().alterField(dataIdField.getName(), newField2);
            this.businessSnapshotDataset = this.businessSnapshotWorkspace.openMosaicDataset(this.imageDatasetService.getBusinessSnapshotDatasetName());
        }
        if (this.snapshotMosaicDataset != null && (dataIdFld = this.snapshotMosaicDataset.getCatalog().getFields().findField("F_DATAID")) != null && dataIdFld.getFieldType() != FieldType.String) {
            newField = dataIdFld.clone();
            newField.setFieldType(FieldType.String);
            newField.setLength(Integer.valueOf(32));
            this.snapshotMosaicDataset.getCatalog().alterField(dataIdFld.getName(), newField);
        }
    }
}

